/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptVariableTable;
import org.mozilla.javascript.optimizer.StmtNodeIterator;

public class Optimizer {
    private static final boolean DEBUG_OPTIMIZER = false;
    private static final boolean DO_CONSTANT_FOLDING = true;
    static int blockCount = 0;
    boolean inDirectCallFunction;
    boolean parameterUsedInNumberContext;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;
    int itsOptLevel;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    void optimizeFunction(OptFunctionNode optFunctionNode) {
        if (optFunctionNode.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = optFunctionNode.isTargetOfDirectCall();
        Node[] nodeArray = this.buildStatementList(optFunctionNode);
        Block[] blockArray = Block.buildBlocks(nodeArray);
        Object var4_4 = null;
        try {
            block7: {
                try {
                    OptVariableTable optVariableTable = (OptVariableTable)optFunctionNode.getVariableTable();
                    if (optVariableTable == null) break block7;
                    optVariableTable.establishIndices();
                    int n = 0;
                    while (n < nodeArray.length) {
                        this.replaceVariableAccess(nodeArray[n], optVariableTable);
                        ++n;
                    }
                    this.foldConstants(optFunctionNode, null);
                    this.reachingDefDataFlow(optVariableTable, blockArray);
                    this.typeFlow(optVariableTable, blockArray);
                    this.findSinglyTypedVars(optVariableTable, blockArray);
                    this.localCSE(blockArray, optFunctionNode);
                    if (optFunctionNode.requiresActivation()) break block7;
                    this.parameterUsedInNumberContext = false;
                    int n2 = 0;
                    while (n2 < nodeArray.length) {
                        this.rewriteForNumberVariables(nodeArray[n2]);
                        ++n2;
                    }
                    optFunctionNode.setParameterNumberContext(this.parameterUsedInNumberContext);
                }
                catch (IOException iOException) {
                    Object var9_10 = null;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    public void optimize(Node node, int n) {
        Node node2;
        this.itsOptLevel = n;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            OptFunctionNode optFunctionNode;
            if (node2.getType() != 110 || (optFunctionNode = (OptFunctionNode)node2.getProp(5)) == null) continue;
            this.optimizeFunction(optFunctionNode);
        }
    }

    void findSinglyTypedVars(VariableTable variableTable, Block[] blockArray) {
        int n = 0;
        while (n < variableTable.size()) {
            int n2;
            OptLocalVariable optLocalVariable = (OptLocalVariable)variableTable.getVariable(n);
            if (!optLocalVariable.isParameter() && (n2 = optLocalVariable.getTypeUnion()) == 1) {
                optLocalVariable.setIsNumber();
            }
            ++n;
        }
    }

    void doBlockLocalCSE(Block[] blockArray, Block block, Hashtable hashtable, boolean[] blArray, OptFunctionNode optFunctionNode) {
        if (!blArray[block.getBlockID()]) {
            blArray[block.getBlockID()] = true;
            hashtable = block.localCSE(hashtable, optFunctionNode);
            Block[] blockArray2 = blockArray[block.getBlockID()].getSuccessorList();
            if (blockArray2 != null) {
                int n = 0;
                while (n < blockArray2.length) {
                    int n2 = blockArray2[n].getBlockID();
                    Block[] blockArray3 = blockArray[n2].getPredecessorList();
                    if (blockArray3.length == 1) {
                        this.doBlockLocalCSE(blockArray, blockArray2[n], (Hashtable)hashtable.clone(), blArray, optFunctionNode);
                    }
                    ++n;
                }
            }
        }
    }

    void localCSE(Block[] blockArray, OptFunctionNode optFunctionNode) {
        boolean[] blArray = new boolean[blockArray.length];
        this.doBlockLocalCSE(blockArray, blockArray[0], null, blArray, optFunctionNode);
        int n = 0;
        while (n < blockArray.length) {
            if (!blArray[n]) {
                blockArray[n].localCSE(null, optFunctionNode);
            }
            ++n;
        }
    }

    void typeFlow(VariableTable variableTable, Block[] blockArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = 0;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doTypeFlow() && (blockArray2 = blockArray[n].getSuccessorList()) != null) {
                    int n2 = 0;
                    while (n2 < blockArray2.length) {
                        int n3 = blockArray2[n2].getBlockID();
                        blArray[n3] = true;
                        bl |= n3 < n;
                        ++n2;
                    }
                }
            }
            if (n == blockArray.length - 1) {
                if (!bl) break;
                n = 0;
                bl = false;
                continue;
            }
            ++n;
        }
    }

    void reachingDefDataFlow(VariableTable variableTable, Block[] blockArray) {
        int n = 0;
        while (n < blockArray.length) {
            blockArray[n].initLiveOnEntrySets(variableTable);
            ++n;
        }
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n2 = blockArray.length - 1;
        boolean bl = false;
        blArray[n2] = true;
        while (true) {
            if (blArray[n2] || !blArray2[n2]) {
                Block[] blockArray2;
                blArray2[n2] = true;
                blArray[n2] = false;
                if (blockArray[n2].doReachedUseDataFlow() && (blockArray2 = blockArray[n2].getPredecessorList()) != null) {
                    int n3 = 0;
                    while (n3 < blockArray2.length) {
                        int n4 = blockArray2[n3].getBlockID();
                        blArray[n4] = true;
                        bl |= n4 > n2;
                        ++n3;
                    }
                }
            }
            if (n2 == 0) {
                if (!bl) break;
                n2 = blockArray.length - 1;
                bl = false;
                continue;
            }
            --n2;
        }
        int n5 = 0;
        while (n5 < blockArray.length) {
            blockArray[n5].markVolatileVariables(variableTable);
            ++n5;
        }
        blockArray[0].markAnyTypeVariables(variableTable);
    }

    void markDCPNumberContext(Node node) {
        OptLocalVariable optLocalVariable;
        if (this.inDirectCallFunction && node.getType() == 72 && (optLocalVariable = (OptLocalVariable)node.getProp(24)) != null && optLocalVariable.isParameter()) {
            this.parameterUsedInNumberContext = true;
        }
    }

    boolean convertParameter(Node node) {
        OptLocalVariable optLocalVariable;
        if (this.inDirectCallFunction && node.getType() == 72 && (optLocalVariable = (OptLocalVariable)node.getProp(24)) != null && optLocalVariable.isParameter()) {
            node.removeProp(26);
            return true;
        }
        return false;
    }

    int rewriteForNumberVariables(Node node) {
        Node node2;
        switch (node.getType()) {
            case 57: {
                Node node3 = node.getFirstChild();
                int n = this.rewriteForNumberVariables(node3);
                if (n == 1) {
                    node.putIntProp(26, 0);
                }
                return 0;
            }
            case 45: {
                node.putIntProp(26, 0);
                return 1;
            }
            case 72: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (optLocalVariable != null) {
                    if (this.inDirectCallFunction && optLocalVariable.isParameter()) {
                        node.putIntProp(26, 0);
                        return 1;
                    }
                    if (optLocalVariable.isNumber()) {
                        node.putIntProp(26, 0);
                        return 1;
                    }
                }
                return 0;
            }
            case 106: 
            case 107: {
                Node node4 = node.getFirstChild();
                if (node4.getType() == 72) {
                    OptLocalVariable optLocalVariable = (OptLocalVariable)node4.getProp(24);
                    if (optLocalVariable != null && optLocalVariable.isNumber()) {
                        node.putIntProp(26, 0);
                        this.markDCPNumberContext(node4);
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 73: {
                Node node5 = node.getFirstChild();
                Node node6 = node5.getNextSibling();
                int n = this.rewriteForNumberVariables(node6);
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (this.inDirectCallFunction && optLocalVariable.isParameter()) {
                    if (n == 1) {
                        if (!this.convertParameter(node6)) {
                            node.putIntProp(26, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(node6);
                        return 0;
                    }
                    return n;
                }
                if (optLocalVariable != null && optLocalVariable.isNumber()) {
                    if (n != 1) {
                        node.removeChild(node6);
                        Node node7 = new Node(142, node6);
                        node7.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        node.addChildToBack(node7);
                    }
                    node.putIntProp(26, 0);
                    this.markDCPNumberContext(node6);
                    return 1;
                }
                if (n == 1 && !this.convertParameter(node6)) {
                    node.removeChild(node6);
                    Node node8 = new Node(142, node6);
                    node8.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    node.addChildToBack(node8);
                }
                return 0;
            }
            case 103: {
                Node node9 = node.getFirstChild();
                Node node10 = node9.getNextSibling();
                int n = this.rewriteForNumberVariables(node9);
                int n2 = this.rewriteForNumberVariables(node10);
                this.markDCPNumberContext(node9);
                this.markDCPNumberContext(node10);
                if (node.getInt() == 64 || node.getInt() == 63) {
                    Node node11;
                    if (n == 1 && !this.convertParameter(node9)) {
                        node.removeChild(node9);
                        node11 = new Node(142, node9);
                        node11.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                        node.addChildToFront(node11);
                    }
                    if (n2 == 1 && !this.convertParameter(node10)) {
                        node.removeChild(node10);
                        node11 = new Node(142, node10);
                        node11.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                        node.addChildToBack(node11);
                    }
                } else if (this.convertParameter(node9)) {
                    if (this.convertParameter(node10)) {
                        return 0;
                    }
                    if (n2 == 1) {
                        node.putIntProp(26, 2);
                    }
                } else if (this.convertParameter(node10)) {
                    if (n == 1) {
                        node.putIntProp(26, 1);
                    }
                } else if (n == 1) {
                    if (n2 == 1) {
                        node.putIntProp(26, 0);
                    } else {
                        node.putIntProp(26, 1);
                    }
                } else if (n2 == 1) {
                    node.putIntProp(26, 2);
                }
                return 0;
            }
            case 23: {
                Node node12 = node.getFirstChild();
                Node node13 = node12.getNextSibling();
                int n = this.rewriteForNumberVariables(node12);
                int n3 = this.rewriteForNumberVariables(node13);
                if (this.convertParameter(node12)) {
                    if (this.convertParameter(node13)) {
                        return 0;
                    }
                    if (n3 == 1) {
                        node.putIntProp(26, 2);
                    }
                } else if (this.convertParameter(node13)) {
                    if (n == 1) {
                        node.putIntProp(26, 1);
                    }
                } else if (n == 1) {
                    if (n3 == 1) {
                        node.putIntProp(26, 0);
                        return 1;
                    }
                    node.putIntProp(26, 1);
                } else if (n3 == 1) {
                    node.putIntProp(26, 2);
                }
                return 0;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                Node node14;
                Node node15 = node.getFirstChild();
                Node node16 = node15.getNextSibling();
                int n = this.rewriteForNumberVariables(node15);
                int n4 = this.rewriteForNumberVariables(node16);
                this.markDCPNumberContext(node15);
                this.markDCPNumberContext(node16);
                if (n == 1) {
                    if (n4 == 1) {
                        node.putIntProp(26, 0);
                        return 1;
                    }
                    if (!this.convertParameter(node16)) {
                        node.removeChild(node16);
                        Node node17 = new Node(142, node16);
                        node17.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        node.addChildToBack(node17);
                        node.putIntProp(26, 0);
                    }
                    return 1;
                }
                if (n4 == 1) {
                    if (!this.convertParameter(node15)) {
                        node.removeChild(node15);
                        Node node18 = new Node(142, node15);
                        node18.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        node.addChildToFront(node18);
                        node.putIntProp(26, 0);
                    }
                    return 1;
                }
                if (!this.convertParameter(node15)) {
                    node.removeChild(node15);
                    node14 = new Node(142, node15);
                    node14.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                    node.addChildToFront(node14);
                }
                if (!this.convertParameter(node16)) {
                    node.removeChild(node16);
                    node14 = new Node(142, node16);
                    node14.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                    node.addChildToBack(node14);
                }
                node.putIntProp(26, 0);
                return 1;
            }
            case 42: {
                int n;
                int n5;
                Node node19 = node.getFirstChild();
                Node node20 = node19.getNextSibling();
                Node node21 = node20.getNextSibling();
                int n6 = this.rewriteForNumberVariables(node19);
                if (n6 == 1 && !this.convertParameter(node19)) {
                    node.removeChild(node19);
                    Node node22 = new Node(142, node19);
                    node22.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    node.addChildToFront(node22);
                }
                if ((n5 = this.rewriteForNumberVariables(node20)) == 1) {
                    node.putIntProp(26, 1);
                    this.markDCPNumberContext(node20);
                }
                if ((n = this.rewriteForNumberVariables(node21)) == 1 && !this.convertParameter(node21)) {
                    node.removeChild(node21);
                    Node node23 = new Node(142, node21);
                    node23.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    node.addChildToBack(node23);
                }
                return 0;
            }
            case 41: {
                int n;
                Node node24 = node.getFirstChild();
                Node node25 = node24.getNextSibling();
                int n7 = this.rewriteForNumberVariables(node24);
                if (n7 == 1 && !this.convertParameter(node24)) {
                    node.removeChild(node24);
                    Node node26 = new Node(142, node24);
                    node26.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    node.addChildToFront(node26);
                }
                if ((n = this.rewriteForNumberVariables(node25)) == 1) {
                    node.putIntProp(26, 2);
                    this.markDCPNumberContext(node25);
                }
                return 0;
            }
            case 43: {
                node2 = (FunctionNode)node.getProp(27);
                if (node2 == null) break;
                Node node27 = node.getFirstChild();
                this.rewriteForNumberVariables(node27);
                node27 = node27.getNextSibling();
                this.rewriteForNumberVariables(node27);
                node27 = node27.getNextSibling();
                while (node27 != null) {
                    int n = this.rewriteForNumberVariables(node27);
                    if (n == 1) {
                        this.markDCPNumberContext(node27);
                    }
                    node27 = node27.getNextSibling();
                }
                return 0;
            }
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            Node node28 = node2.getNextSibling();
            int n = this.rewriteForNumberVariables(node2);
            if (n == 1 && !this.convertParameter(node2)) {
                node.removeChild(node2);
                Node node29 = new Node(142, node2);
                node29.putProp(18, class$java$lang$Object == null ? Optimizer.class$("java.lang.Object") : class$java$lang$Object);
                if (node28 == null) {
                    node.addChildToBack(node29);
                } else {
                    node.addChildBefore(node29, node28);
                }
            }
            node2 = node28;
        }
        return 0;
    }

    void foldConstants(Node node, Node node2) {
        Node node3 = null;
        Node node4 = node.getFirstChild();
        if (node4 == null) {
            return;
        }
        node3 = node4.getNextSibling();
        if (node3 == null) {
            this.foldConstants(node4, node);
            return;
        }
        this.foldConstants(node4, node);
        this.foldConstants(node3, node);
        Node node5 = node3.getNextSibling();
        while (node5 != null) {
            this.foldConstants(node5, node);
            node5 = node5.getNextSibling();
        }
        node4 = node.getFirstChild();
        if (node4 == null) {
            return;
        }
        node3 = node4.getNextSibling();
        if (node3 == null) {
            return;
        }
        int n = node4.getType();
        int n2 = node3.getType();
        Node node6 = null;
        switch (node.getType()) {
            case 23: {
                if (n == 45 && n2 == 45) {
                    node6 = new Node(45, node4.getDouble() + node3.getDouble());
                    break;
                }
                if (n == 46 && n2 == 46) {
                    node6 = new Node(46, node4.getString() + node3.getString());
                    break;
                }
                if (n == 46 && n2 == 45) {
                    node6 = new Node(46, node4.getString() + ScriptRuntime.numberToString(node3.getDouble(), 10));
                    break;
                }
                if (n != 45 || n2 != 46) break;
                node6 = new Node(46, ScriptRuntime.numberToString(node4.getDouble(), 10) + node3.getString());
                break;
            }
            case 24: {
                if (n == 45 && n2 == 45) {
                    node6 = new Node(45, node4.getDouble() - node3.getDouble());
                    break;
                }
                if (n == 45 && node4.getDouble() == 0.0) {
                    node6 = new Node(105, node3, 24);
                    break;
                }
                if (n2 != 45 || node3.getDouble() != 0.0) break;
                node6 = new Node(105, node4, 23);
                break;
            }
            case 25: {
                if (n == 45 && n2 == 45) {
                    node6 = new Node(45, node4.getDouble() * node3.getDouble());
                    break;
                }
                if (n == 45 && node4.getDouble() == 1.0) {
                    node6 = new Node(105, node3, 23);
                    break;
                }
                if (n2 != 45 || node3.getDouble() != 1.0) break;
                node6 = new Node(105, node4, 23);
                break;
            }
            case 26: {
                if (n == 45 && n2 == 45) {
                    node6 = new Node(45, node4.getDouble() / node3.getDouble());
                    break;
                }
                if (n2 != 45 || node3.getDouble() != 1.0) break;
                node6 = new Node(105, node4, 23);
                break;
            }
            case 101: {
                int n3;
                int n4 = Optimizer.isAlwaysDefinedBoolean(node4);
                if (n4 == -1 && !IRFactory.hasSideEffects(node3)) {
                    node6 = new Node(109, 51);
                }
                if ((n3 = Optimizer.isAlwaysDefinedBoolean(node3)) == -1) {
                    if (!IRFactory.hasSideEffects(node4)) {
                        node6 = new Node(109, 51);
                    }
                } else if (n3 == 1) {
                    node6 = node4;
                }
                if (n4 != 1) break;
                node6 = node3;
                break;
            }
            case 100: {
                int n5;
                int n6 = Optimizer.isAlwaysDefinedBoolean(node4);
                if (n6 == 1 && !IRFactory.hasSideEffects(node3)) {
                    node6 = new Node(109, 52);
                }
                if ((n5 = Optimizer.isAlwaysDefinedBoolean(node3)) == 1) {
                    if (!IRFactory.hasSideEffects(node4)) {
                        node6 = new Node(109, 52);
                    }
                } else if (n5 == -1) {
                    node6 = node4;
                }
                if (n6 != -1) break;
                node6 = node3;
                break;
            }
            case 133: {
                if (node4.getType() != 8) break;
                Node node7 = node4.getFirstChild();
                int n7 = Optimizer.isAlwaysDefinedBoolean(node7);
                if (n7 == -1) {
                    Node node8;
                    Node node9;
                    Node node10;
                    Node node11 = node3.getNextSibling();
                    if (node11 == null || (node10 = node11.getNextSibling()) == null || (node9 = node10.getNextSibling()) == null || (node8 = node9.getFirstChild()) == null) break;
                    node6 = node8;
                    break;
                }
                if (n7 != 1 || node3.getType() != 133) break;
                node6 = node3.getFirstChild();
            }
        }
        if (node6 != null) {
            node2.replaceChild(node, node6);
        }
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        int n = 0;
        int n2 = node.getType();
        if (n2 == 109) {
            int n3 = node.getInt();
            if (n3 == 51 || n3 == 49 || n3 == 74) {
                n = -1;
            } else if (n3 == 52) {
                n = 1;
            }
        } else if (n2 == 45) {
            double d = node.getDouble();
            if (d == 0.0) {
                if (1.0 / d > 0.0) {
                    n = -1;
                }
            } else {
                n = 1;
            }
        }
        return n;
    }

    void replaceVariableAccess(Node node, VariableTable variableTable) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.replaceVariableAccess(node2, variableTable);
            node2 = node2.getNextSibling();
        }
        switch (node.getType()) {
            case 73: {
                String string = node.getFirstChild().getString();
                OptLocalVariable optLocalVariable = (OptLocalVariable)variableTable.getVariable(string);
                if (optLocalVariable == null) break;
                node.putProp(24, optLocalVariable);
                break;
            }
            case 72: {
                String string = node.getString();
                OptLocalVariable optLocalVariable = (OptLocalVariable)variableTable.getVariable(string);
                if (optLocalVariable == null) break;
                node.putProp(24, optLocalVariable);
                break;
            }
        }
    }

    private Node[] buildStatementList(FunctionNode functionNode) {
        Vector<Node> vector = new Vector<Node>();
        StmtNodeIterator stmtNodeIterator = new StmtNodeIterator(functionNode);
        Node node = stmtNodeIterator.nextNode();
        while (node != null) {
            vector.addElement(node);
            node = stmtNodeIterator.nextNode();
        }
        Node[] nodeArray = new Node[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            nodeArray[n] = (Node)vector.elementAt(n);
            ++n;
        }
        return nodeArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

