/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Chris Lord.
 * Portions created by the Initial Developer are Copyright (C) 2009 Intel.
 * All Rights Reserved.
 *
 * Contributor(s):
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "HeadlessAppInfo.h"
#include "moz-headless-private.h"

HeadlessAppInfo::HeadlessAppInfo(void)
{
}

HeadlessAppInfo::~HeadlessAppInfo()
{
  if (sHeadlessAppInfo == this)
    sHeadlessAppInfo = nsnull;
}

HeadlessAppInfo *HeadlessAppInfo::sHeadlessAppInfo = nsnull;

HeadlessAppInfo *
HeadlessAppInfo::GetSingleton(void)
{
  if (!sHeadlessAppInfo) {
    // FIXME: Figure out if we're doign the right thing re refs here
    sHeadlessAppInfo = new HeadlessAppInfo ();
  }

  NS_IF_ADDREF(sHeadlessAppInfo);

  return sHeadlessAppInfo;
}

NS_IMPL_ISUPPORTS3(HeadlessAppInfo,
                   nsIXULAppInfo,
                   nsIXULRuntime,
                   nsISupportsWeakReference)

NS_IMETHODIMP
HeadlessAppInfo::GetVendor(nsACString &aVendor)
{
  if (moz_headless_app_vendor)
    aVendor = moz_headless_app_vendor;
  else
    aVendor.AssignLiteral ("Unknown");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetName(nsACString &aName)
{
  if (moz_headless_app_name)
    aName = moz_headless_app_name;
  else
    aName.AssignLiteral ("Mozilla Headless");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetID(nsACString &aID)
{
  if (moz_headless_app_name)
    aID = moz_headless_app_id;
  else
    aID.AssignLiteral ("Unknown");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetVersion(nsACString &aVersion)
{
  if (moz_headless_app_version)
    aVersion = moz_headless_app_version;
  else
    aVersion.AssignLiteral ("");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetAppBuildID(nsACString &aAppBuildID)
{
  if (moz_headless_app_build_id)
    aAppBuildID = moz_headless_app_build_id;
  else
    aAppBuildID.AssignLiteral ("");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetPlatformVersion(nsACString &aPlatformVersion)
{
  if (moz_headless_app_platform_version)
    aPlatformVersion = moz_headless_app_platform_version;
  else
    aPlatformVersion.AssignLiteral ("");

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetPlatformBuildID(nsACString &aPlatformBuildID)
{
  if (moz_headless_app_platform_build_id)
    aPlatformBuildID = moz_headless_app_platform_build_id;
  else
    aPlatformBuildID.AssignLiteral (BUILD_DATE);

  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetInSafeMode(PRBool *aInSafeMode)
{
  *aInSafeMode = PR_FALSE;
  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetLogConsoleErrors(PRBool *aLogConsoleErrors)
{
  *aLogConsoleErrors = PR_FALSE;
  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::SetLogConsoleErrors(PRBool aLogConsoleErrors)
{
  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetOS(nsACString &aOS)
{
  aOS.AssignLiteral(OS_TARGET);
  return NS_OK;
}

NS_IMETHODIMP
HeadlessAppInfo::GetXPCOMABI(nsACString &aXPCOMABI)
{
#ifdef TARGET_XPCOM_ABI
  aXPCOMABI.AssignLiteral(TARGET_XPCOM_ABI);
  return NS_OK;
#else
  return NS_ERROR_NOT_AVAILABLE;
#endif
}

NS_IMETHODIMP
HeadlessAppInfo::GetWidgetToolkit(nsACString &aWidgetToolkit)
{
  aWidgetToolkit.AssignLiteral(MOZ_WIDGET_TOOLKIT);
  return NS_OK;
}

