/*
 * Copyright 2007-2008 Gabriel Mansi.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef _TIMING_H_
#define _TIMING_H_

#include "xf86.h"

/* Aspect ratio not CVT standard */
#define TIMING_CVT_WARN_ASPECT_RATIO 1 << 0

/* Error allocating memory */
#define TIMING_ERR_BAD_ALLOC 1 << 1

/* Refresh rate not CVT standard */
#define TIMING_CVT_WARN_REFRESH_RATE 1 << 2

/* Refresh rate not valid for reducing blanking */
#define TIMING_CVT_WARN_REFRESH_RATE_NOT_RB 1 << 3

/**
 * Geneartes a CVT modeline
 * mode must not be null, if mode->name is null a new char* will be allocated. 
 * 
 */
int viaTimingCvt(DisplayModePtr mode, int width, int height, float refresh, Bool interlaced, Bool reducedBlanking);

int viaTimingGtf(DisplayModePtr mode, int width, int height, float refresh, Bool interlaced) ;

#endif /*_TIMING_H_*/
