.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
fluidballs - the physics of bouncing balls.
.SH SYNOPSIS
.B fluidballs
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-count \fInumber\fP]
[\-size \fInumber\fP]
[\-gravity \fInumber\fP]
[\-wind \fInumber\fP]
[\-elasticity \fInumber\fP]
[\-delay \fInumber\fP]
[\-nonrandom]
[\-no-shake]
[\-fps]
.SH DESCRIPTION
Models the physics of bouncing balls, or of particles in a gas or fluid,
depending on the settings. If "Shake Box" is selected, then every now and
then, the box will be rotated, changing which direction is down (in order
to keep the settled balls in motion.) 
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-count \fInumber\fP
How many balls to display.  Default: 300.
.TP 8
.B \-size \fInumber\fP
Maximum size of each ball.  Default: 25.
.TP 8
.B \-gravity \fInumber\fP
Coefficient of gravity.  Useful values are < 0.1.  Default: 0.01.
.TP 8
.B \-wind \fInumber\fP
Wind.  Useful values are < 0.1.  Default: 0.00.
.TP 8
.B \-elasticity \fInumber\fP
Coefficient of elasticity.  Useful values are 0.2 to 1.0.  Default: 0.97.
Lower numbers make less bouncy balls.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 10000 (0.01 seconds.).
.TP 8
.B \-nonrandom
Make all balls be the same size.
.TP 8
.B \-no-nonrandom
Make the balls be random sizes.  Default.
.TP 8
.B \-shake | \-no-shake
Whether to shake the box if the system seems to have settled down.
"Shake" means "change the direction of Down."
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2002 by Peter Birtles and Jamie Zawinski.  Permission to
use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.
.SH AUTHOR
Peter Birtles, Jamie Zawinski, and Steven Barker.

