var webdeveloper_editHTMLIntervalId      = null;
var webdeveloper_editHTMLOldHTML         = null;
var webdeveloper_editHTMLSelectedTab     = 0;
var webdeveloper_editHTMLUpdateFrequency = 500;

// Applies the HTML
function webdeveloper_applyHTML()
{
    var contentBody = webdeveloper_getDocumentBodyElement(webdeveloper_getContentDocument());
    var newHTML     = document.getElementById("webdeveloper-edit-html-text-box").value;

    // If the content body is set and the new HTML is not the same as the old HTML
    if(contentBody && newHTML != webdeveloper_editHTMLOldHTML)
    {
        contentBody.innerHTML        = newHTML;
        webdeveloper_editHTMLOldHTML = newHTML;
    }
}

// Clear the HTML
function webdeveloper_clearHTML()
{
    document.getElementById("webdeveloper-edit-html-text-box").value = "";
}

// Reinitializes the dashboard when the page changes
function webdeveloper_editHTMLPageLoad(event)
{
    // If the content document is set
    if(webdeveloper_getPageLoadEventContentDocument(event))
    {
        // If the page is generated
        if(event.originalTarget.documentURI == "about:blank")
        {
            window.clearInterval(webdeveloper_editHTMLIntervalId);
            window.setTimeout(webdeveloper_retrieveHTML, 1000);
            window.setTimeout(webdeveloper_updateHTML, 1000);
        }
        else
        {
            webdeveloper_retrieveHTML();
        }
    }
}

// Handles a browser tab being selected
function webdeveloper_editHTMLTabSelect(event)
{
    var browser     = window.top.getBrowser();
    var selectedTab = browser.mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_editHTMLSelectedTab)
    {
        browser.browsers[webdeveloper_editHTMLSelectedTab].contentDocument.location.reload(false);

        webdeveloper_editHTMLSelectedTab = selectedTab;

        webdeveloper_retrieveHTML();
    }
}

// Initializes the edit HTML dashboard
function webdeveloper_initializeEditHTML()
{
    var windowContent = window.top.getBrowser();

    // If the window content is set
    if(windowContent)
    {
        var tabBox       = windowContent.mTabBox;
        var textBox      = document.getElementById("webdeveloper-edit-html-text-box");
        var textBoxStyle = "";
    
        webdeveloper_editHTMLSelectedTab     = tabBox.selectedIndex;
        webdeveloper_editHTMLUpdateFrequency = webdeveloper_getIntegerPreference("webdeveloper.edit.update.frequency", true);
    
        document.getElementById("webdeveloper-search-dashboard-text").addEventListener("keypress", webdeveloper_searchTextKeyPress, false);
        
        windowContent.addEventListener("load", webdeveloper_editHTMLPageLoad, true);

        // If the tab box is set
        if(tabBox)
        {
            tabBox.addEventListener("select", webdeveloper_editHTMLTabSelect, false);
        }

        // If the edit background color preference is set
        if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.background"))
        {
            textBoxStyle += "background-color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.background", true) + " !important; ";
        }
    
        // If the edit text color preference is set
        if(webdeveloper_isPreferenceSet("webdeveloper.edit.color.text"))
        {
            textBoxStyle += "color: " + webdeveloper_getStringPreference("webdeveloper.edit.color.text", true) + " !important; ";
        }
    
        // If the edit CSS font preference is set
        if(webdeveloper_isPreferenceSet("webdeveloper.edit.font.size"))
        {
            textBoxStyle += "font-size: " + webdeveloper_getIntegerPreference("webdeveloper.edit.font.size", true) + "px !important; ";
        }
    
        textBox.setAttribute("style", textBoxStyle.trim());
    
        webdeveloper_retrieveHTML();
        webdeveloper_updateHTML();
    }
}

// Resets the edited HTML
function webdeveloper_resetHTML()
{
    window.top.BrowserReload();
}

// Retrieves the HTML
function webdeveloper_retrieveHTML()
{
    var contentBody = webdeveloper_getDocumentBodyElement(webdeveloper_getContentDocument());
    var textBox     = document.getElementById("webdeveloper-edit-html-text-box");

    // If the content body is set
    if(contentBody)
    {
        textBox.value = contentBody.innerHTML;
    }

    webdeveloper_applyHTML();
}

// Saves the HTML
function webdeveloper_saveHTML()
{
    var contentDocument = webdeveloper_getContentDocument();
    var filePicker      = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var result          = null;
    var stringBundle    = document.getElementById("webdeveloper-string-bundle");
    var url             = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);

    url.spec                    = contentDocument.documentURI;
    filePicker.defaultExtension = url.fileExtension;
    filePicker.defaultString    = url.fileName;

    filePicker.init(window, stringBundle.getString("webdeveloper_saveHTML"), filePicker.modeSave);

    result = filePicker.show();

    // If the user selected a file
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        var file                       = filePicker.file;
        var webBrowserPersistInterface = Components.interfaces.nsIWebBrowserPersist;
        var webBrowserPersist          = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(webBrowserPersistInterface);

        webBrowserPersist.persistFlags = webBrowserPersistInterface.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION | webBrowserPersistInterface.PERSIST_FLAGS_FROM_CACHE | webBrowserPersistInterface.PERSIST_FLAGS_REPLACE_EXISTING_FILES;

        // If the file does not exist
        if(!file.exists())
        {
            file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 00644);
        }

        webBrowserPersist.saveDocument(contentDocument, file, null, contentDocument.contentType, webBrowserPersistInterface.ENCODE_FLAGS_ENCODE_BASIC_ENTITIES, 0);
    }
}

// Searches the HTML
function webdeveloper_searchHTML()
{
    var searchText = document.getElementById("webdeveloper-search-dashboard-text").value;

    // If the search text is set
    if(searchText)
    {
        document.getElementById("webdeveloper-edit-html-text-box").focus();

        // If the search failed to find a match
        if(!window.find(searchText, false, false, true, false, false, false))
        {
            document.getElementById("webdeveloper-edit-html-text-box").setSelectionRange(0, 0);
            window.find(searchText, false, false, true, false, false, false);
        }
    }
}

// Searches the HTML when the enter key is pressed
function webdeveloper_searchTextKeyPress(event)
{
    var keyCode = event.keyCode;

    // If the key code is set and is 13
    if(keyCode && keyCode == 13)
    {
        webdeveloper_searchHTML();
    }
}

// Uninitializes edit HTML
function webdeveloper_uninitializeEditHTML()
{
    var windowContent = window.top.getBrowser();

    webdeveloper_editHTMLOldHTML = null;

    window.clearInterval(webdeveloper_editHTMLIntervalId);

    // Try to remove the event listener
    try
    {
        document.getElementById("webdeveloper-search-dashboard-text").removeEventListener("keypress", webdeveloper_searchTextKeyPress, false);
    }
    catch(exception)
    {
        // Do nothing
    }

    // If the window content is set
    if(windowContent)
    {
        var tabBox = windowContent.mTabBox;
            
        // Try to remove the event listener
        try
        {
            windowContent.removeEventListener("load", webdeveloper_editHTMLPageLoad, true);
        }
        catch(exception)
        {
            // Do nothing
        }

        // If the tab box is set
        if(tabBox)
        {
            // Try to remove the event listener
            try
            {
                tabBox.removeEventListener("select", webdeveloper_editHTMLTabSelect, false);
            }
            catch(exception)
            {
                // Do nothing
            }
        }
    }

    window.top.BrowserReload();
}

// Updates the HTML
function webdeveloper_updateHTML()
{
    // If the update frequency is greater than 0
    if(webdeveloper_editHTMLUpdateFrequency > 0)
    {
        webdeveloper_editHTMLIntervalId = window.setInterval(webdeveloper_applyHTML, webdeveloper_editHTMLUpdateFrequency);
    }
}