#!/bin/sh

OEMLIB=${OEMLIB:-'/usr/share/volatile'}
. $OEMLIB/common.sh

set -x

exec >> /var/log/package_helper-volatile.log

install_by_usb_id()
{
    if check_usbid "$1"; then
        apt_install "$2"
    fi
}

install_by_pci_id()
{
    if check_pciid "$1"; then
        apt_install "$2"
    fi
}

case $1 in
    "pciid")
        echo "install pciid: $2 package: $3"
        install_by_pciid_id $2 $3
    ;;
    "usbid")
        echo "install usbid: $2 package: $3"
        install_by_usbid_id $2 $3
    ;;
esac
