#!/bin/bash
# WDT is HP pre-loading tool.
# The OSChanger is matained by HP team.
set -x -e

if [ -d "/isodevice" ]; then
    RP="/isodevice"
else
    RP="/cdrom"
fi

[ ! -f $RP/factory.flg ] && exit 0

errnumber=$1
message=$2

[ -z "$errnumber" ] && errnumber=0
[ -z "$message" ] && message="ubuntu installation is finished, tansfer the control to WDT."


OSCHANGER=/cdrom/SYSTEM.SAV/WDT/OSChangerL_m64

if [ -e "${OSCHANGER}" ]; then
    export LC_ALL=C
    export LANG=C #LP: #1311536
    sudo mount -o remount,rw /cdrom
    arguments="--wdt --message=$message --errornumber=$errnumber"
    eval "$OSCHANGER" "$arguments"
    sudo mount -o remount,r /cdrom
fi

exit 0
