#!/bin/sh
#
# This is where Stella project add their common use functions.
#

_apt_install()
{
    local PLATFORM="$(compatibilityChecker -p)"
    local packages="$*"

    for p in $packages; do
        python /usr/share/volatile/aptInstall --debug -p "${p}" -s "${PLATFORM}" -a "${APT_OPTIONS}"
    done
}

check_eng_build()
{
    grep -qE "\-eng\-" /etc/buildstamp 2> /dev/null
}

get_project_parent()
{
    local project_parent=$(grep -o -E "($cnb_PROJECT_PARENT|$vdt_PROJECT_PARENT)" /etc/buildstamp)

    echo "$project_parent"
}

setup_stella_config()
{
    #apt_install_oobe stella-$PROJECT-config
    apt_install "stella-$PROJECT-config"
    setup_public_source
}

setup_public_source()
{
    local PROJECT=$(get_project_parent)
    local CODENAME="$(lsb_release -cs)"

    cat > /etc/apt/sources.list.d/"$CODENAME-stella-$PROJECT".volatile << ENDLINE
deb http://hp.archive.canonical.com/updates $CODENAME-stella-$PROJECT public
deb-src http://hp.archive.canonical.com/updates $CODENAME-stella-$PROJECT public
ENDLINE
}

setup_stella_base_config()
{
    local CODENAME="$(lsb_release -cs)"
    
    apt_install_oobe stella-base-config
    cat > /etc/apt/sources.list.d/"$CODENAME"-stella.volatile << ENDLINE
deb http://hp.archive.canonical.com/updates $CODENAME-stella public
deb-src http://hp.archive.canonical.com/updates $CODENAME-stella public
ENDLINE
}

get_product()
{
    local sys_product_name="/sys/class/dmi/id/product_name"
    cat $sys_product_name
}

workaround_amdconfig()
{
    return # no fglrx support in 16.04 yet
cat > /etc/X11/xorg.conf <<ENDFILE
Section "ServerLayout"
    Identifier     "aticonfig Layout"
    Screen      0  "aticonfig-Screen[0]-0" 0 0
EndSection

Section "Module"
EndSection

Section "Monitor"
    Identifier   "aticonfig-Monitor[0]-0"
    Option      "VendorName" "ATI Proprietary Driver"
    Option      "ModelName" "Generic Autodetecting Monitor"
    Option      "DPMS" "true"
EndSection

Section "Device"
    Identifier  "aticonfig-Device[0]-0"
    Driver      "fglrx"
    BusID       "PCI:1:0:0"
EndSection

Section "Screen"
    Identifier "aticonfig-Screen[0]-0"
    Device     "aticonfig-Device[0]-0"
    Monitor    "aticonfig-Monitor[0]-0"
    DefaultDepth     24
    SubSection "Display"
        Viewport   0 0  
        Depth     24    
    EndSubSection       
EndSection
ENDFILE
}
