#!/bin/sh
# -*- coding: utf-8; indent-tabs-mode: nil; tab-width: 4; c-basic-offset: 4; -*-
# vim:fileencodings=utf-8:expandtab:tabstop=4:shiftwidth=4:softtabstop=4

set -e -x

if [ -d "/isodevice" ]; then
    RP="/isodevice"
else
    RP="/cdrom"
fi

[ ! -f $RP/factory.flg ] && exit 0

if [ -f $RP/factory.sh ]; then
    sh $RP/factory.sh pre-$*
fi

case $1 in
    ('early')
        echo "no action in early stage"
        ;;
    ('late')
        case $2 in
            (success)
                # transfer the control to WDT to start logout process.
                message="3PP_PHASE"
                /usr/share/ubuntu/scripts/transfer_control_to_wdt.sh 0 $message
                rm $RP/factory.flg
                ;;
            (fail)
                # For HP factory process (LP: #1044713) (LP: 1045677)
                message="errors"
                /usr/share/ubuntu/scripts/transfer_control_to_wdt.sh 940 $message
                rm $RP/factory.flg
                if [ ! -e /sys/firmware/efi ]; then
                    echo -en "\xFF\xFF" | dd of=/dev/sda bs=1c seek=32017
                fi
                ;;
        esac
        ;;
esac

if [ -f $RP/factory.sh ]; then
    sh $RP/factory.sh post-$*
fi

exit 0
