/**
 * @file geis_instance.h @brief Interface for the GEIS XCB Instance module.
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_INSTANCE_H_
#define GEIS_INSTANCE_H_

#include "geis_config.h"
#include <geis/geis.h>
#include "geis_xcb.h"

struct _GeisInstance
{
  uint32_t          window_id;
  GeisGestureFuncs *gesture_funcs;
  void             *gesture_cookie;
};

/** @brief Constructs a GeisInstance. */
GeisInstance geis_instance_new(uint32_t win_info);


/** @brief Indicates if the GeisInstance is valid. */
int geis_instance_is_valid(GeisInstance instance);

/** @brief Subscribe to gestures. */
GeisStatus geis_instance_subscribe(GeisInstance         instance,
                                   GeisXcb              xcb,
                                   GeisInputDeviceId   *input_list,
                                   const char*         *gesture_list,
                                   GeisGestureFuncs    *funcs,
                                   void                *cookie);

uint32_t geis_instance_get_window_id(GeisInstance instance);

/** @brief Tears down the GeisInstance. */
void geis_instance_free(GeisInstance instance);

#endif /* GEIS_INSTANCE_H_ */
