/* places-default-renderer-tiles.c generated by valac 0.10.0, the Vala compiler
 * generated from places-default-renderer-tiles.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <unity.h>


#define UNITY_PLACES_TYPE_BUTTON (unity_places_button_get_type ())
#define UNITY_PLACES_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_BUTTON, UnityPlacesButton))
#define UNITY_PLACES_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_BUTTON, UnityPlacesButtonClass))
#define UNITY_PLACES_IS_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_BUTTON))
#define UNITY_PLACES_IS_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_BUTTON))
#define UNITY_PLACES_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_BUTTON, UnityPlacesButtonClass))

typedef struct _UnityPlacesButton UnityPlacesButton;
typedef struct _UnityPlacesButtonClass UnityPlacesButtonClass;
typedef struct _UnityPlacesButtonPrivate UnityPlacesButtonPrivate;

#define UNITY_PLACES_TYPE_TILE (unity_places_tile_get_type ())
#define UNITY_PLACES_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_TILE, UnityPlacesTile))
#define UNITY_PLACES_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_TILE, UnityPlacesTileClass))
#define UNITY_PLACES_IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_TILE))
#define UNITY_PLACES_IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_TILE))
#define UNITY_PLACES_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_TILE, UnityPlacesTileClass))

typedef struct _UnityPlacesTile UnityPlacesTile;
typedef struct _UnityPlacesTileClass UnityPlacesTileClass;
typedef struct _UnityPlacesTilePrivate UnityPlacesTilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_PLACES_TYPE_FILE_INFO_TILE (unity_places_file_info_tile_get_type ())
#define UNITY_PLACES_FILE_INFO_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_FILE_INFO_TILE, UnityPlacesFileInfoTile))
#define UNITY_PLACES_FILE_INFO_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_FILE_INFO_TILE, UnityPlacesFileInfoTileClass))
#define UNITY_PLACES_IS_FILE_INFO_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_FILE_INFO_TILE))
#define UNITY_PLACES_IS_FILE_INFO_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_FILE_INFO_TILE))
#define UNITY_PLACES_FILE_INFO_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_FILE_INFO_TILE, UnityPlacesFileInfoTileClass))

typedef struct _UnityPlacesFileInfoTile UnityPlacesFileInfoTile;
typedef struct _UnityPlacesFileInfoTileClass UnityPlacesFileInfoTileClass;
typedef struct _UnityPlacesFileInfoTilePrivate UnityPlacesFileInfoTilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_PLACES_BUTTON_TYPE_PRELIGHT_STATE (unity_places_button_prelight_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define UNITY_PLACES_TYPE_SHOWCASE_TILE (unity_places_showcase_tile_get_type ())
#define UNITY_PLACES_SHOWCASE_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_SHOWCASE_TILE, UnityPlacesShowcaseTile))
#define UNITY_PLACES_SHOWCASE_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_SHOWCASE_TILE, UnityPlacesShowcaseTileClass))
#define UNITY_PLACES_IS_SHOWCASE_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_SHOWCASE_TILE))
#define UNITY_PLACES_IS_SHOWCASE_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_SHOWCASE_TILE))
#define UNITY_PLACES_SHOWCASE_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_SHOWCASE_TILE, UnityPlacesShowcaseTileClass))

typedef struct _UnityPlacesShowcaseTile UnityPlacesShowcaseTile;
typedef struct _UnityPlacesShowcaseTileClass UnityPlacesShowcaseTileClass;
typedef struct _UnityPlacesShowcaseTilePrivate UnityPlacesShowcaseTilePrivate;

#define UNITY_PLACES_TYPE_DEFAULT_TILE (unity_places_default_tile_get_type ())
#define UNITY_PLACES_DEFAULT_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_DEFAULT_TILE, UnityPlacesDefaultTile))
#define UNITY_PLACES_DEFAULT_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_DEFAULT_TILE, UnityPlacesDefaultTileClass))
#define UNITY_PLACES_IS_DEFAULT_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_DEFAULT_TILE))
#define UNITY_PLACES_IS_DEFAULT_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_DEFAULT_TILE))
#define UNITY_PLACES_DEFAULT_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_DEFAULT_TILE, UnityPlacesDefaultTileClass))

typedef struct _UnityPlacesDefaultTile UnityPlacesDefaultTile;
typedef struct _UnityPlacesDefaultTileClass UnityPlacesDefaultTileClass;
typedef struct _UnityPlacesDefaultTilePrivate UnityPlacesDefaultTilePrivate;

typedef void (*UnityPlacesButtonButtonOutlineFunc) (cairo_t* cr, gint width, gint height, void* user_data);
struct _UnityPlacesButton {
	CtkButton parent_instance;
	UnityPlacesButtonPrivate * priv;
	UnityPlacesButtonButtonOutlineFunc outline_func;
	gpointer outline_func_target;
	GDestroyNotify outline_func_target_destroy_notify;
};

struct _UnityPlacesButtonClass {
	CtkButtonClass parent_class;
};

struct _UnityPlacesTile {
	UnityPlacesButton parent_instance;
	UnityPlacesTilePrivate * priv;
};

struct _UnityPlacesTileClass {
	UnityPlacesButtonClass parent_class;
	void (*about_to_show) (UnityPlacesTile* self);
	void (*update_details) (UnityPlacesTile* self, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
};

struct _UnityPlacesTilePrivate {
	DeeModelIter* _iter;
	char* _display_name;
	char* _icon_hint;
	char* _uri;
	char* _mimetype;
	char* _comment;
};

struct _UnityPlacesFileInfoTile {
	UnityPlacesTile parent_instance;
	UnityPlacesFileInfoTilePrivate * priv;
};

struct _UnityPlacesFileInfoTileClass {
	UnityPlacesTileClass parent_class;
};

struct _UnityPlacesFileInfoTilePrivate {
	gboolean shown;
	CtkImage* icon;
	CtkText* leaf;
	UnityPlacesButton* folder_button;
	CtkText* folder;
	CtkText* time;
};

typedef enum  {
	UNITY_PLACES_BUTTON_PRELIGHT_STATE_NONE,
	UNITY_PLACES_BUTTON_PRELIGHT_STATE_STRIPED,
	UNITY_PLACES_BUTTON_PRELIGHT_STATE_UNDERLINE
} UnityPlacesButtonPrelightState;

struct _Block1Data {
	int _ref_count_;
	UnityPlacesFileInfoTile * self;
	GFile* parent;
};

struct _UnityPlacesShowcaseTile {
	UnityPlacesTile parent_instance;
	UnityPlacesShowcaseTilePrivate * priv;
};

struct _UnityPlacesShowcaseTileClass {
	UnityPlacesTileClass parent_class;
};

struct _UnityPlacesShowcaseTilePrivate {
	gboolean shown;
};

struct _UnityPlacesDefaultTile {
	UnityPlacesTile parent_instance;
	UnityPlacesDefaultTilePrivate * priv;
};

struct _UnityPlacesDefaultTileClass {
	UnityPlacesTileClass parent_class;
};

struct _UnityPlacesDefaultTilePrivate {
	gboolean shown;
};


static gpointer unity_places_tile_parent_class = NULL;
static gpointer unity_places_file_info_tile_parent_class = NULL;
static gpointer unity_places_showcase_tile_parent_class = NULL;
static gpointer unity_places_default_tile_parent_class = NULL;

GType unity_places_button_get_type (void) G_GNUC_CONST;
GType unity_places_tile_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_TILE, UnityPlacesTilePrivate))
enum  {
	UNITY_PLACES_TILE_DUMMY_PROPERTY,
	UNITY_PLACES_TILE_ITER,
	UNITY_PLACES_TILE_DISPLAY_NAME,
	UNITY_PLACES_TILE_ICON_HINT,
	UNITY_PLACES_TILE_URI,
	UNITY_PLACES_TILE_MIMETYPE,
	UNITY_PLACES_TILE_COMMENT
};
#define UNITY_PLACES_TILE_DEFAULT_ICON "text-x-preview"
void unity_places_tile_about_to_show (UnityPlacesTile* self);
static void unity_places_tile_real_about_to_show (UnityPlacesTile* self);
void unity_places_tile_update_details (UnityPlacesTile* self, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_tile_real_update_details (UnityPlacesTile* self, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
UnityPlacesTile* unity_places_tile_construct (GType object_type);
UnityPlacesButton* unity_places_button_new (void);
UnityPlacesButton* unity_places_button_construct (GType object_type);
DeeModelIter* unity_places_tile_get_iter (UnityPlacesTile* self);
void unity_places_tile_set_iter (UnityPlacesTile* self, DeeModelIter* value);
const char* unity_places_tile_get_display_name (UnityPlacesTile* self);
void unity_places_tile_set_display_name (UnityPlacesTile* self, const char* value);
const char* unity_places_tile_get_icon_hint (UnityPlacesTile* self);
void unity_places_tile_set_icon_hint (UnityPlacesTile* self, const char* value);
const char* unity_places_tile_get_uri (UnityPlacesTile* self);
void unity_places_tile_set_uri (UnityPlacesTile* self, const char* value);
const char* unity_places_tile_get_mimetype (UnityPlacesTile* self);
void unity_places_tile_set_mimetype (UnityPlacesTile* self, const char* value);
const char* unity_places_tile_get_comment (UnityPlacesTile* self);
void unity_places_tile_set_comment (UnityPlacesTile* self, const char* value);
static void unity_places_tile_finalize (GObject* obj);
static void unity_places_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_places_file_info_tile_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_FILE_INFO_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_FILE_INFO_TILE, UnityPlacesFileInfoTilePrivate))
enum  {
	UNITY_PLACES_FILE_INFO_TILE_DUMMY_PROPERTY
};
#define UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH 56
#define UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT 48
#define UNITY_PLACES_FILE_INFO_TILE_LINE_PADDING 0.0f
#define UNITY_PLACES_FILE_INFO_TILE_HPADDING 4.0f
#define UNITY_PLACES_FILE_INFO_TILE_VPADDING 4.0f
UnityPlacesFileInfoTile* unity_places_file_info_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
UnityPlacesFileInfoTile* unity_places_file_info_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_file_info_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth);
static void unity_places_file_info_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static gboolean unity_places_file_info_tile_update_details_real (UnityPlacesFileInfoTile* self);
static void unity_places_file_info_tile_real_about_to_show (UnityPlacesTile* base);
GType unity_places_button_prelight_state_get_type (void) G_GNUC_CONST;
void unity_places_button_set_prelight_state (UnityPlacesButton* self, UnityPlacesButtonPrelightState value);
static void _lambda48_ (UnityPlacesFileInfoTile* self);
static void __lambda48__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _unity_places_file_info_tile_update_details_real_gsource_func (gpointer self);
static void _lambda47_ (Block1Data* _data1_);
static void __lambda47__ctk_button_clicked (CtkButton* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void unity_places_file_info_tile_set_icon (UnityPlacesFileInfoTile* self);
static void unity_places_file_info_tile_real_clicked (CtkButton* base);
static void unity_places_file_info_tile_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
static void unity_places_file_info_tile_real_get_preferred_height (ClutterActor* base, float for_width, float* mheight, float* nheight);
static void unity_places_file_info_tile_real_paint (ClutterActor* base);
static void unity_places_file_info_tile_real_pick (ClutterActor* base, const ClutterColor* color);
static void unity_places_file_info_tile_real_map (ClutterActor* base);
static void unity_places_file_info_tile_real_unmap (ClutterActor* base);
static GObject * unity_places_file_info_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_file_info_tile_finalize (GObject* obj);
GType unity_places_showcase_tile_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_SHOWCASE_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_SHOWCASE_TILE, UnityPlacesShowcaseTilePrivate))
enum  {
	UNITY_PLACES_SHOWCASE_TILE_DUMMY_PROPERTY
};
#define UNITY_PLACES_SHOWCASE_TILE_ICON_SIZE 64
#define UNITY_PLACES_SHOWCASE_TILE_PADDING 4.0f
UnityPlacesShowcaseTile* unity_places_showcase_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
UnityPlacesShowcaseTile* unity_places_showcase_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_showcase_tile_real_about_to_show (UnityPlacesTile* base);
static gboolean _lambda50_ (UnityPlacesShowcaseTile* self);
static void unity_places_showcase_tile_set_icon (UnityPlacesShowcaseTile* self);
static gboolean __lambda50__gsource_func (gpointer self);
static void unity_places_showcase_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_showcase_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth);
static void unity_places_showcase_tile_real_clicked (CtkButton* base);
static GObject * unity_places_showcase_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_showcase_tile_finalize (GObject* obj);
GType unity_places_default_tile_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_DEFAULT_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_DEFAULT_TILE, UnityPlacesDefaultTilePrivate))
enum  {
	UNITY_PLACES_DEFAULT_TILE_DUMMY_PROPERTY
};
#define UNITY_PLACES_DEFAULT_TILE_ICON_SIZE 48
#define UNITY_PLACES_DEFAULT_TILE_PADDING 4.0f
UnityPlacesDefaultTile* unity_places_default_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
UnityPlacesDefaultTile* unity_places_default_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_default_tile_real_about_to_show (UnityPlacesTile* base);
static gboolean _lambda52_ (UnityPlacesDefaultTile* self);
static void unity_places_default_tile_set_icon (UnityPlacesDefaultTile* self);
static gboolean __lambda52__gsource_func (gpointer self);
static void unity_places_default_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment);
static void unity_places_default_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth);
static void unity_places_default_tile_real_clicked (CtkButton* base);
static GObject * unity_places_default_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_default_tile_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void unity_places_tile_real_about_to_show (UnityPlacesTile* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_places_tile_about_to_show'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_places_tile_about_to_show (UnityPlacesTile* self) {
	UNITY_PLACES_TILE_GET_CLASS (self)->about_to_show (self);
}


static void unity_places_tile_real_update_details (UnityPlacesTile* self, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_places_tile_update_details'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_places_tile_update_details (UnityPlacesTile* self, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UNITY_PLACES_TILE_GET_CLASS (self)->update_details (self, uri, icon_hint, mimetype, display_name, comment);
}


UnityPlacesTile* unity_places_tile_construct (GType object_type) {
	UnityPlacesTile * self;
	self = (UnityPlacesTile*) unity_places_button_construct (object_type);
	return self;
}


DeeModelIter* unity_places_tile_get_iter (UnityPlacesTile* self) {
	DeeModelIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_iter;
	return result;
}


void unity_places_tile_set_iter (UnityPlacesTile* self, DeeModelIter* value) {
	g_return_if_fail (self != NULL);
	self->priv->_iter = value;
	g_object_notify ((GObject *) self, "iter");
}


const char* unity_places_tile_get_display_name (UnityPlacesTile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_name;
	return result;
}


void unity_places_tile_set_display_name (UnityPlacesTile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_display_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_display_name), _tmp0_);
	g_object_notify ((GObject *) self, "display-name");
}


const char* unity_places_tile_get_icon_hint (UnityPlacesTile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_hint;
	return result;
}


void unity_places_tile_set_icon_hint (UnityPlacesTile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_icon_hint = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_hint), _tmp0_);
	g_object_notify ((GObject *) self, "icon-hint");
}


const char* unity_places_tile_get_uri (UnityPlacesTile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uri;
	return result;
}


void unity_places_tile_set_uri (UnityPlacesTile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_uri = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_uri), _tmp0_);
	g_object_notify ((GObject *) self, "uri");
}


const char* unity_places_tile_get_mimetype (UnityPlacesTile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mimetype;
	return result;
}


void unity_places_tile_set_mimetype (UnityPlacesTile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_mimetype = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mimetype), _tmp0_);
	g_object_notify ((GObject *) self, "mimetype");
}


const char* unity_places_tile_get_comment (UnityPlacesTile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_comment;
	return result;
}


void unity_places_tile_set_comment (UnityPlacesTile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_comment = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_comment), _tmp0_);
	g_object_notify ((GObject *) self, "comment");
}


static void unity_places_tile_class_init (UnityPlacesTileClass * klass) {
	unity_places_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesTilePrivate));
	UNITY_PLACES_TILE_CLASS (klass)->about_to_show = unity_places_tile_real_about_to_show;
	UNITY_PLACES_TILE_CLASS (klass)->update_details = unity_places_tile_real_update_details;
	G_OBJECT_CLASS (klass)->get_property = unity_places_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_tile_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_places_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_ITER, g_param_spec_pointer ("iter", "iter", "iter", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_ICON_HINT, g_param_spec_string ("icon-hint", "icon-hint", "icon-hint", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_TILE_COMMENT, g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("activated", UNITY_PLACES_TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void unity_places_tile_instance_init (UnityPlacesTile * self) {
	self->priv = UNITY_PLACES_TILE_GET_PRIVATE (self);
}


static void unity_places_tile_finalize (GObject* obj) {
	UnityPlacesTile * self;
	self = UNITY_PLACES_TILE (obj);
	{
	}
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_icon_hint);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mimetype);
	_g_free0 (self->priv->_comment);
	G_OBJECT_CLASS (unity_places_tile_parent_class)->finalize (obj);
}


GType unity_places_tile_get_type (void) {
	static volatile gsize unity_places_tile_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesTile), 0, (GInstanceInitFunc) unity_places_tile_instance_init, NULL };
		GType unity_places_tile_type_id;
		unity_places_tile_type_id = g_type_register_static (UNITY_PLACES_TYPE_BUTTON, "UnityPlacesTile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&unity_places_tile_type_id__volatile, unity_places_tile_type_id);
	}
	return unity_places_tile_type_id__volatile;
}


static void unity_places_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesTile * self;
	self = UNITY_PLACES_TILE (object);
	switch (property_id) {
		case UNITY_PLACES_TILE_ITER:
		g_value_set_pointer (value, unity_places_tile_get_iter (self));
		break;
		case UNITY_PLACES_TILE_DISPLAY_NAME:
		g_value_set_string (value, unity_places_tile_get_display_name (self));
		break;
		case UNITY_PLACES_TILE_ICON_HINT:
		g_value_set_string (value, unity_places_tile_get_icon_hint (self));
		break;
		case UNITY_PLACES_TILE_URI:
		g_value_set_string (value, unity_places_tile_get_uri (self));
		break;
		case UNITY_PLACES_TILE_MIMETYPE:
		g_value_set_string (value, unity_places_tile_get_mimetype (self));
		break;
		case UNITY_PLACES_TILE_COMMENT:
		g_value_set_string (value, unity_places_tile_get_comment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesTile * self;
	self = UNITY_PLACES_TILE (object);
	switch (property_id) {
		case UNITY_PLACES_TILE_ITER:
		unity_places_tile_set_iter (self, g_value_get_pointer (value));
		break;
		case UNITY_PLACES_TILE_DISPLAY_NAME:
		unity_places_tile_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_PLACES_TILE_ICON_HINT:
		unity_places_tile_set_icon_hint (self, g_value_get_string (value));
		break;
		case UNITY_PLACES_TILE_URI:
		unity_places_tile_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_PLACES_TILE_MIMETYPE:
		unity_places_tile_set_mimetype (self, g_value_get_string (value));
		break;
		case UNITY_PLACES_TILE_COMMENT:
		unity_places_tile_set_comment (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlacesFileInfoTile* unity_places_file_info_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesFileInfoTile * self;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityPlacesFileInfoTile*) g_object_new (object_type, "orientation", CTK_ORIENTATION_HORIZONTAL, "iter", iter, "display-name", display_name, "icon-hint", icon_hint, "uri", uri, "mimetype", mimetype, "comment", comment, NULL);
	return self;
}


UnityPlacesFileInfoTile* unity_places_file_info_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	return unity_places_file_info_tile_construct (UNITY_PLACES_TYPE_FILE_INFO_TILE, iter, uri, icon_hint, mimetype, display_name, comment);
}


static void unity_places_file_info_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	*mwidth = 210.0f;
	*nwidth = 210.0f;
}


static void unity_places_file_info_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (display_name != NULL);
	unity_places_tile_set_display_name ((UnityPlacesTile*) self, display_name);
	unity_places_tile_set_icon_hint ((UnityPlacesTile*) self, icon_hint);
	unity_places_tile_set_uri ((UnityPlacesTile*) self, uri);
	unity_places_tile_set_mimetype ((UnityPlacesTile*) self, mimetype);
	unity_places_tile_set_comment ((UnityPlacesTile*) self, comment);
	if (self->priv->shown == FALSE) {
		return;
	}
	unity_places_file_info_tile_update_details_real (self);
}


static void _lambda48_ (UnityPlacesFileInfoTile* self) {
	gboolean _tmp0_ = FALSE;
	if (ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_NORMAL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_PRELIGHT;
	}
	if (_tmp0_) {
		ClutterColor _tmp1_ = {0};
		ClutterColor _tmp2_;
		ClutterColor _tmp3_ = {0};
		ClutterColor _tmp4_;
		ClutterColor _tmp5_ = {0};
		ClutterColor _tmp6_;
		clutter_text_set_color ((ClutterText*) self->priv->leaf, (_tmp2_ = (_tmp1_.red = (guint8) 255, _tmp1_.green = (guint8) 255, _tmp1_.blue = (guint8) 255, _tmp1_.alpha = (guint8) 255, _tmp1_), &_tmp2_));
		clutter_text_set_color ((ClutterText*) self->priv->folder, (_tmp4_ = (_tmp3_.red = (guint8) 255, _tmp3_.green = (guint8) 255, _tmp3_.blue = (guint8) 255, _tmp3_.alpha = (guint8) 100, _tmp3_), &_tmp4_));
		clutter_text_set_color ((ClutterText*) self->priv->time, (_tmp6_ = (_tmp5_.red = (guint8) 255, _tmp5_.green = (guint8) 255, _tmp5_.blue = (guint8) 255, _tmp5_.alpha = (guint8) 255, _tmp5_), &_tmp6_));
	} else {
		ClutterColor _tmp7_ = {0};
		ClutterColor _tmp8_;
		ClutterColor _tmp9_ = {0};
		ClutterColor _tmp10_;
		ClutterColor _tmp11_ = {0};
		ClutterColor _tmp12_;
		clutter_text_set_color ((ClutterText*) self->priv->leaf, (_tmp8_ = (_tmp7_.red = (guint8) 50, _tmp7_.green = (guint8) 50, _tmp7_.blue = (guint8) 50, _tmp7_.alpha = (guint8) 200, _tmp7_), &_tmp8_));
		clutter_text_set_color ((ClutterText*) self->priv->folder, (_tmp10_ = (_tmp9_.red = (guint8) 50, _tmp9_.green = (guint8) 50, _tmp9_.blue = (guint8) 50, _tmp9_.alpha = (guint8) 100, _tmp9_), &_tmp10_));
		clutter_text_set_color ((ClutterText*) self->priv->time, (_tmp12_ = (_tmp11_.red = (guint8) 50, _tmp11_.green = (guint8) 50, _tmp11_.blue = (guint8) 50, _tmp11_.alpha = (guint8) 200, _tmp11_), &_tmp12_));
	}
}


static void __lambda48__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda48_ (self);
}


static gboolean _unity_places_file_info_tile_update_details_real_gsource_func (gpointer self) {
	gboolean result;
	result = unity_places_file_info_tile_update_details_real (self);
	return result;
}


static void unity_places_file_info_tile_real_about_to_show (UnityPlacesTile* base) {
	UnityPlacesFileInfoTile * self;
	CtkImage* _tmp0_;
	CtkText* _tmp1_;
	UnityPlacesButton* _tmp2_;
	CtkPadding _tmp3_ = {0};
	CtkPadding _tmp4_;
	CtkText* _tmp5_;
	ClutterColor _tmp6_ = {0};
	ClutterColor _tmp7_;
	const char* _tmp8_;
	CtkText* _tmp9_;
	self = (UnityPlacesFileInfoTile*) base;
	if (self->priv->shown) {
		return;
	}
	self->priv->shown = TRUE;
	self->priv->icon = (_tmp0_ = g_object_ref_sink ((CtkImage*) ctk_image_new ((guint) UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT)), _g_object_unref0 (self->priv->icon), _tmp0_);
	clutter_actor_set_parent ((ClutterActor*) self->priv->icon, (ClutterActor*) self);
	clutter_actor_show ((ClutterActor*) self->priv->icon);
	self->priv->leaf = (_tmp1_ = g_object_ref_sink ((CtkText*) ctk_text_new (" ")), _g_object_unref0 (self->priv->leaf), _tmp1_);
	clutter_text_set_ellipsize ((ClutterText*) self->priv->leaf, PANGO_ELLIPSIZE_MIDDLE);
	clutter_actor_set_parent ((ClutterActor*) self->priv->leaf, (ClutterActor*) self);
	clutter_actor_show ((ClutterActor*) self->priv->leaf);
	self->priv->folder_button = (_tmp2_ = g_object_ref_sink (unity_places_button_new ()), _g_object_unref0 (self->priv->folder_button), _tmp2_);
	unity_places_button_set_prelight_state (self->priv->folder_button, UNITY_PLACES_BUTTON_PRELIGHT_STATE_UNDERLINE);
	clutter_actor_set_parent ((ClutterActor*) self->priv->folder_button, (ClutterActor*) self);
	clutter_actor_show ((ClutterActor*) self->priv->folder_button);
	ctk_actor_set_padding ((CtkActor*) self->priv->folder_button, (_tmp4_ = (_tmp3_.top = 1.0f, _tmp3_.right = 0.0f, _tmp3_.bottom = 0.0f, _tmp3_.left = 0.0f, _tmp3_), &_tmp4_));
	self->priv->folder = (_tmp5_ = g_object_ref_sink ((CtkText*) ctk_text_new ("")), _g_object_unref0 (self->priv->folder), _tmp5_);
	clutter_text_set_ellipsize ((ClutterText*) self->priv->folder, PANGO_ELLIPSIZE_MIDDLE);
	clutter_container_add_actor ((ClutterContainer*) self->priv->folder_button, (ClutterActor*) self->priv->folder);
	clutter_text_set_color ((ClutterText*) self->priv->folder, (_tmp7_ = (_tmp6_.red = (guint8) 255, _tmp6_.green = (guint8) 255, _tmp6_.blue = (guint8) 255, _tmp6_.alpha = (guint8) 100, _tmp6_), &_tmp7_));
	clutter_actor_show ((ClutterActor*) self->priv->folder);
	_tmp8_ = NULL;
	if (_vala_strcmp0 (unity_places_tile_get_uri ((UnityPlacesTile*) self), unity_places_tile_get_comment ((UnityPlacesTile*) self)) == 0) {
		_tmp8_ = "";
	} else {
		_tmp8_ = unity_places_tile_get_comment ((UnityPlacesTile*) self);
	}
	self->priv->time = (_tmp9_ = g_object_ref_sink ((CtkText*) ctk_text_new (_tmp8_)), _g_object_unref0 (self->priv->time), _tmp9_);
	clutter_text_set_ellipsize ((ClutterText*) self->priv->time, PANGO_ELLIPSIZE_MIDDLE);
	clutter_actor_set_parent ((ClutterActor*) self->priv->time, (ClutterActor*) self);
	clutter_actor_show ((ClutterActor*) self->priv->time);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) __lambda48__g_object_notify, self, 0);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_places_file_info_tile_update_details_real_gsource_func, g_object_ref (self), g_object_unref);
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _lambda47_ (Block1Data* _data1_) {
	UnityPlacesFileInfoTile * self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	{
		char* _tmp0_;
		g_signal_emit_by_name ((UnityPlacesTile*) self, "activated", _tmp0_ = g_file_get_uri (_data1_->parent), "inode/directory");
		_g_free0 (_tmp0_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp1_;
			g_warning ("places-default-renderer-tiles.vala:188: %s", _tmp1_ = g_strconcat ("Unable to launch parent folder: ", string_to_string (e->message), NULL));
			_g_free0 (_tmp1_);
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda47__ctk_button_clicked (CtkButton* _sender, gpointer self) {
	_lambda47_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->parent);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean unity_places_file_info_tile_update_details_real (UnityPlacesFileInfoTile* self) {
	gboolean result = FALSE;
	GFile* file;
	g_return_val_if_fail (self != NULL, FALSE);
	clutter_text_set_text ((ClutterText*) self->priv->leaf, unity_places_tile_get_display_name ((UnityPlacesTile*) self));
	file = g_file_new_for_uri (unity_places_tile_get_uri ((UnityPlacesTile*) self));
	if (G_IS_FILE (file)) {
		Block1Data* _data1_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_data1_->parent = g_file_get_parent (file);
		if (G_IS_FILE (_data1_->parent)) {
			char* _tmp0_;
			clutter_text_set_text ((ClutterText*) self->priv->folder, _tmp0_ = g_file_get_basename (_data1_->parent));
			_g_free0 (_tmp0_);
			g_signal_connect_data ((CtkButton*) self->priv->folder_button, "clicked", (GCallback) __lambda47__ctk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		} else {
			clutter_text_set_text ((ClutterText*) self->priv->folder, "");
		}
		block1_data_unref (_data1_);
	} else {
		clutter_text_set_text ((ClutterText*) self->priv->folder, "");
	}
	unity_places_file_info_tile_set_icon (self);
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}


static void unity_places_file_info_tile_real_clicked (CtkButton* base) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	g_signal_emit_by_name ((UnityPlacesTile*) self, "activated", unity_places_tile_get_uri ((UnityPlacesTile*) self), unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
}


static void unity_places_file_info_tile_set_icon (UnityPlacesFileInfoTile* self) {
	UnityPixbufCache* cache;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	cache = unity_pixbuf_cache_get_default ();
	if (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self) != NULL) {
		_tmp0_ = _vala_strcmp0 (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		unity_pixbuf_cache_set_image_from_gicon_string (cache, self->priv->icon, unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT);
	} else {
		gboolean _tmp1_ = FALSE;
		if (unity_places_tile_get_mimetype ((UnityPlacesTile*) self) != NULL) {
			_tmp1_ = _vala_strcmp0 (unity_places_tile_get_mimetype ((UnityPlacesTile*) self), "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GIcon* icon;
			char* _tmp2_;
			icon = g_content_type_get_icon (unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
			unity_pixbuf_cache_set_image_from_gicon_string (cache, self->priv->icon, _tmp2_ = g_icon_to_string (icon), UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT);
			_g_free0 (_tmp2_);
			_g_object_unref0 (icon);
		} else {
			unity_pixbuf_cache_set_image_from_icon_name (cache, self->priv->icon, UNITY_PLACES_TILE_DEFAULT_ICON, UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT);
		}
	}
	_g_object_unref0 (cache);
}


static void unity_places_file_info_tile_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesFileInfoTile * self;
	float width;
	float height;
	ClutterActorBox child_box = {0};
	float mh = 0.0F;
	float text_block;
	float y;
	float icon_text_pad;
	float mw = 0.0F;
	self = (UnityPlacesFileInfoTile*) base;
	CLUTTER_ACTOR_CLASS (unity_places_file_info_tile_parent_class)->allocate ((ClutterActor*) UNITY_PLACES_TILE (self), box, flags);
	if (CTK_IS_IMAGE (self->priv->icon) == FALSE) {
		return;
	}
	width = (*box).x2 - (*box).x1;
	height = (*box).y2 - (*box).y1;
	memset (&child_box, 0, sizeof (ClutterActorBox));
	child_box.x1 = 0.0f;
	child_box.x2 = (float) UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH;
	child_box.y1 = (height / 2.0f) - (UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT / 2.0f);
	child_box.y2 = child_box.y1 + UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT;
	clutter_actor_allocate ((ClutterActor*) self->priv->icon, &child_box, flags);
	clutter_actor_get_preferred_height ((ClutterActor*) self->priv->leaf, width - UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH, &mh, NULL);
	text_block = (mh * 3.0f) + (UNITY_PLACES_FILE_INFO_TILE_LINE_PADDING * 2.0f);
	y = (height / 2.0f) - (text_block / 2.0f);
	icon_text_pad = 12.0f;
	child_box.x1 = UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH + icon_text_pad;
	child_box.x2 = width;
	child_box.y1 = y;
	child_box.y2 = y + mh;
	clutter_actor_allocate ((ClutterActor*) self->priv->leaf, &child_box, flags);
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->folder_button, mh, NULL, &mw);
	mw = fminf (mw, ((*box).x2 - UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH) - icon_text_pad);
	y = y + (UNITY_PLACES_FILE_INFO_TILE_LINE_PADDING + mh);
	child_box.x2 = child_box.x1 + mw;
	child_box.y1 = y;
	child_box.y2 = y + mh;
	clutter_actor_allocate ((ClutterActor*) self->priv->folder_button, &child_box, flags);
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->time, mh, NULL, &mw);
	mw = fminf (mw, ((*box).x2 - UNITY_PLACES_FILE_INFO_TILE_ICON_WIDTH) - icon_text_pad);
	y = y + (UNITY_PLACES_FILE_INFO_TILE_LINE_PADDING + mh);
	child_box.x2 = child_box.x1 + mw;
	child_box.y1 = y;
	child_box.y2 = y + mh;
	clutter_actor_allocate ((ClutterActor*) self->priv->time, &child_box, flags);
}


static void unity_places_file_info_tile_real_get_preferred_height (ClutterActor* base, float for_width, float* mheight, float* nheight) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	if (CTK_IS_IMAGE (self->priv->icon)) {
		float mh = 0.0F;
		clutter_actor_get_preferred_height ((ClutterActor*) self->priv->leaf, for_width, &mh, NULL);
		*mheight = fmaxf (UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT + (UNITY_PLACES_FILE_INFO_TILE_VPADDING * 2.0f), ((mh * 3.0f) + (UNITY_PLACES_FILE_INFO_TILE_LINE_PADDING * 2.0f)) + (UNITY_PLACES_FILE_INFO_TILE_VPADDING * 2.0f));
		*nheight = *mheight;
	} else {
		*mheight = UNITY_PLACES_FILE_INFO_TILE_ICON_HEIGHT + (UNITY_PLACES_FILE_INFO_TILE_VPADDING * 2.0f);
		*nheight = *mheight;
	}
}


static void unity_places_file_info_tile_real_paint (ClutterActor* base) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	CLUTTER_ACTOR_CLASS (unity_places_file_info_tile_parent_class)->paint ((ClutterActor*) UNITY_PLACES_TILE (self));
	if (CTK_IS_IMAGE (self->priv->icon)) {
		clutter_actor_paint ((ClutterActor*) self->priv->icon);
		clutter_actor_paint ((ClutterActor*) self->priv->leaf);
		clutter_actor_paint ((ClutterActor*) self->priv->folder_button);
		clutter_actor_paint ((ClutterActor*) self->priv->time);
	}
}


static void unity_places_file_info_tile_real_pick (ClutterActor* base, const ClutterColor* color) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	CLUTTER_ACTOR_CLASS (unity_places_file_info_tile_parent_class)->pick ((ClutterActor*) UNITY_PLACES_TILE (self), color);
	if (CTK_IS_IMAGE (self->priv->icon)) {
		clutter_actor_paint ((ClutterActor*) self->priv->icon);
		clutter_actor_paint ((ClutterActor*) self->priv->leaf);
		clutter_actor_paint ((ClutterActor*) self->priv->folder_button);
		clutter_actor_paint ((ClutterActor*) self->priv->time);
	}
}


static void unity_places_file_info_tile_real_map (ClutterActor* base) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	CLUTTER_ACTOR_CLASS (unity_places_file_info_tile_parent_class)->map ((ClutterActor*) UNITY_PLACES_TILE (self));
	if (CTK_IS_IMAGE (self->priv->icon)) {
		clutter_actor_map ((ClutterActor*) self->priv->icon);
		clutter_actor_map ((ClutterActor*) self->priv->leaf);
		clutter_actor_map ((ClutterActor*) self->priv->folder_button);
		clutter_actor_map ((ClutterActor*) self->priv->time);
	}
}


static void unity_places_file_info_tile_real_unmap (ClutterActor* base) {
	UnityPlacesFileInfoTile * self;
	self = (UnityPlacesFileInfoTile*) base;
	if (CTK_IS_IMAGE (self->priv->icon)) {
		clutter_actor_unmap ((ClutterActor*) self->priv->icon);
		clutter_actor_unmap ((ClutterActor*) self->priv->leaf);
		clutter_actor_unmap ((ClutterActor*) self->priv->folder_button);
		clutter_actor_unmap ((ClutterActor*) self->priv->time);
	}
	CLUTTER_ACTOR_CLASS (unity_places_file_info_tile_parent_class)->unmap ((ClutterActor*) UNITY_PLACES_TILE (self));
}


static GObject * unity_places_file_info_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesFileInfoTile * self;
	parent_class = G_OBJECT_CLASS (unity_places_file_info_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_FILE_INFO_TILE (obj);
	{
	}
	return obj;
}


static void unity_places_file_info_tile_class_init (UnityPlacesFileInfoTileClass * klass) {
	unity_places_file_info_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesFileInfoTilePrivate));
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_places_file_info_tile_real_get_preferred_width;
	UNITY_PLACES_TILE_CLASS (klass)->update_details = unity_places_file_info_tile_real_update_details;
	UNITY_PLACES_TILE_CLASS (klass)->about_to_show = unity_places_file_info_tile_real_about_to_show;
	CTK_BUTTON_CLASS (klass)->clicked = unity_places_file_info_tile_real_clicked;
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_file_info_tile_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_places_file_info_tile_real_get_preferred_height;
	CLUTTER_ACTOR_CLASS (klass)->paint = unity_places_file_info_tile_real_paint;
	CLUTTER_ACTOR_CLASS (klass)->pick = unity_places_file_info_tile_real_pick;
	CLUTTER_ACTOR_CLASS (klass)->map = unity_places_file_info_tile_real_map;
	CLUTTER_ACTOR_CLASS (klass)->unmap = unity_places_file_info_tile_real_unmap;
	G_OBJECT_CLASS (klass)->constructor = unity_places_file_info_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_file_info_tile_finalize;
}


static void unity_places_file_info_tile_instance_init (UnityPlacesFileInfoTile * self) {
	self->priv = UNITY_PLACES_FILE_INFO_TILE_GET_PRIVATE (self);
	self->priv->shown = FALSE;
}


static void unity_places_file_info_tile_finalize (GObject* obj) {
	UnityPlacesFileInfoTile * self;
	self = UNITY_PLACES_FILE_INFO_TILE (obj);
	{
		clutter_actor_unparent ((ClutterActor*) self->priv->icon);
		clutter_actor_unparent ((ClutterActor*) self->priv->leaf);
		clutter_actor_unparent ((ClutterActor*) self->priv->folder_button);
		clutter_actor_unparent ((ClutterActor*) self->priv->time);
	}
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->leaf);
	_g_object_unref0 (self->priv->folder_button);
	_g_object_unref0 (self->priv->folder);
	_g_object_unref0 (self->priv->time);
	G_OBJECT_CLASS (unity_places_file_info_tile_parent_class)->finalize (obj);
}


GType unity_places_file_info_tile_get_type (void) {
	static volatile gsize unity_places_file_info_tile_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_file_info_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesFileInfoTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_file_info_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesFileInfoTile), 0, (GInstanceInitFunc) unity_places_file_info_tile_instance_init, NULL };
		GType unity_places_file_info_tile_type_id;
		unity_places_file_info_tile_type_id = g_type_register_static (UNITY_PLACES_TYPE_TILE, "UnityPlacesFileInfoTile", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_file_info_tile_type_id__volatile, unity_places_file_info_tile_type_id);
	}
	return unity_places_file_info_tile_type_id__volatile;
}


UnityPlacesShowcaseTile* unity_places_showcase_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesShowcaseTile * self;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityPlacesShowcaseTile*) g_object_new (object_type, "orientation", CTK_ORIENTATION_VERTICAL, "iter", iter, "display-name", display_name, "icon-hint", icon_hint, "uri", uri, "mimetype", mimetype, "comment", comment, NULL);
	return self;
}


UnityPlacesShowcaseTile* unity_places_showcase_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	return unity_places_showcase_tile_construct (UNITY_PLACES_TYPE_SHOWCASE_TILE, iter, uri, icon_hint, mimetype, display_name, comment);
}


static gboolean _lambda50_ (UnityPlacesShowcaseTile* self) {
	gboolean result = FALSE;
	ctk_button_set_label ((CtkButton*) self, unity_places_tile_get_display_name ((UnityPlacesTile*) self));
	unity_places_showcase_tile_set_icon (self);
	result = FALSE;
	return result;
}


static gboolean __lambda50__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda50_ (self);
	return result;
}


static void unity_places_showcase_tile_real_about_to_show (UnityPlacesTile* base) {
	UnityPlacesShowcaseTile * self;
	self = (UnityPlacesShowcaseTile*) base;
	if (self->priv->shown) {
		return;
	}
	self->priv->shown = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda50__gsource_func, g_object_ref (self), g_object_unref);
}


static void unity_places_showcase_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesShowcaseTile * self;
	self = (UnityPlacesShowcaseTile*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (display_name != NULL);
	unity_places_tile_set_display_name ((UnityPlacesTile*) self, display_name);
	unity_places_tile_set_icon_hint ((UnityPlacesTile*) self, icon_hint);
	unity_places_tile_set_uri ((UnityPlacesTile*) self, uri);
	unity_places_tile_set_mimetype ((UnityPlacesTile*) self, mimetype);
	unity_places_tile_set_comment ((UnityPlacesTile*) self, comment);
	if (self->priv->shown == FALSE) {
		return;
	}
	ctk_button_set_label ((CtkButton*) self, display_name);
	unity_places_showcase_tile_set_icon (self);
}


static void unity_places_showcase_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth) {
	UnityPlacesShowcaseTile * self;
	self = (UnityPlacesShowcaseTile*) base;
	*mwidth = 160.0f;
	*nwidth = 160.0f;
}


static void unity_places_showcase_tile_real_clicked (CtkButton* base) {
	UnityPlacesShowcaseTile * self;
	self = (UnityPlacesShowcaseTile*) base;
	g_signal_emit_by_name ((UnityPlacesTile*) self, "activated", unity_places_tile_get_uri ((UnityPlacesTile*) self), unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
}


static void unity_places_showcase_tile_set_icon (UnityPlacesShowcaseTile* self) {
	UnityPixbufCache* cache;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	ctk_image_set_size (ctk_button_get_image ((CtkButton*) self), UNITY_PLACES_SHOWCASE_TILE_ICON_SIZE);
	cache = unity_pixbuf_cache_get_default ();
	if (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self) != NULL) {
		_tmp0_ = _vala_strcmp0 (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		unity_pixbuf_cache_set_image_from_gicon_string (cache, ctk_button_get_image ((CtkButton*) self), unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), UNITY_PLACES_SHOWCASE_TILE_ICON_SIZE);
	} else {
		gboolean _tmp1_ = FALSE;
		if (unity_places_tile_get_mimetype ((UnityPlacesTile*) self) != NULL) {
			_tmp1_ = _vala_strcmp0 (unity_places_tile_get_mimetype ((UnityPlacesTile*) self), "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GIcon* icon;
			char* _tmp2_;
			icon = g_content_type_get_icon (unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
			unity_pixbuf_cache_set_image_from_gicon_string (cache, ctk_button_get_image ((CtkButton*) self), _tmp2_ = g_icon_to_string (icon), UNITY_PLACES_SHOWCASE_TILE_ICON_SIZE);
			_g_free0 (_tmp2_);
			_g_object_unref0 (icon);
		} else {
			unity_pixbuf_cache_set_image_from_icon_name (cache, ctk_button_get_image ((CtkButton*) self), UNITY_PLACES_TILE_DEFAULT_ICON, UNITY_PLACES_SHOWCASE_TILE_ICON_SIZE);
		}
	}
	_g_object_unref0 (cache);
}


static GObject * unity_places_showcase_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesShowcaseTile * self;
	parent_class = G_OBJECT_CLASS (unity_places_showcase_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_SHOWCASE_TILE (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		CtkText* text;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = UNITY_PLACES_SHOWCASE_TILE_PADDING, _tmp0_.right = UNITY_PLACES_SHOWCASE_TILE_PADDING, _tmp0_.bottom = UNITY_PLACES_SHOWCASE_TILE_PADDING, _tmp0_.left = UNITY_PLACES_SHOWCASE_TILE_PADDING, _tmp0_), &_tmp1_));
		text = ctk_button_get_text ((CtkButton*) self);
		clutter_text_set_ellipsize ((ClutterText*) text, PANGO_ELLIPSIZE_MIDDLE);
	}
	return obj;
}


static void unity_places_showcase_tile_class_init (UnityPlacesShowcaseTileClass * klass) {
	unity_places_showcase_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesShowcaseTilePrivate));
	UNITY_PLACES_TILE_CLASS (klass)->about_to_show = unity_places_showcase_tile_real_about_to_show;
	UNITY_PLACES_TILE_CLASS (klass)->update_details = unity_places_showcase_tile_real_update_details;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_places_showcase_tile_real_get_preferred_width;
	CTK_BUTTON_CLASS (klass)->clicked = unity_places_showcase_tile_real_clicked;
	G_OBJECT_CLASS (klass)->constructor = unity_places_showcase_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_showcase_tile_finalize;
}


static void unity_places_showcase_tile_instance_init (UnityPlacesShowcaseTile * self) {
	self->priv = UNITY_PLACES_SHOWCASE_TILE_GET_PRIVATE (self);
	self->priv->shown = FALSE;
}


static void unity_places_showcase_tile_finalize (GObject* obj) {
	UnityPlacesShowcaseTile * self;
	self = UNITY_PLACES_SHOWCASE_TILE (obj);
	G_OBJECT_CLASS (unity_places_showcase_tile_parent_class)->finalize (obj);
}


GType unity_places_showcase_tile_get_type (void) {
	static volatile gsize unity_places_showcase_tile_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_showcase_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesShowcaseTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_showcase_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesShowcaseTile), 0, (GInstanceInitFunc) unity_places_showcase_tile_instance_init, NULL };
		GType unity_places_showcase_tile_type_id;
		unity_places_showcase_tile_type_id = g_type_register_static (UNITY_PLACES_TYPE_TILE, "UnityPlacesShowcaseTile", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_showcase_tile_type_id__volatile, unity_places_showcase_tile_type_id);
	}
	return unity_places_showcase_tile_type_id__volatile;
}


UnityPlacesDefaultTile* unity_places_default_tile_construct (GType object_type, DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesDefaultTile * self;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityPlacesDefaultTile*) g_object_new (object_type, "orientation", CTK_ORIENTATION_VERTICAL, "iter", iter, "display-name", display_name, "icon-hint", icon_hint, "uri", uri, "mimetype", mimetype, "comment", comment, NULL);
	return self;
}


UnityPlacesDefaultTile* unity_places_default_tile_new (DeeModelIter* iter, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	return unity_places_default_tile_construct (UNITY_PLACES_TYPE_DEFAULT_TILE, iter, uri, icon_hint, mimetype, display_name, comment);
}


static gboolean _lambda52_ (UnityPlacesDefaultTile* self) {
	gboolean result = FALSE;
	ctk_button_set_label ((CtkButton*) self, unity_places_tile_get_display_name ((UnityPlacesTile*) self));
	unity_places_default_tile_set_icon (self);
	result = FALSE;
	return result;
}


static gboolean __lambda52__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda52_ (self);
	return result;
}


static void unity_places_default_tile_real_about_to_show (UnityPlacesTile* base) {
	UnityPlacesDefaultTile * self;
	self = (UnityPlacesDefaultTile*) base;
	if (self->priv->shown) {
		return;
	}
	self->priv->shown = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda52__gsource_func, g_object_ref (self), g_object_unref);
}


static void unity_places_default_tile_real_update_details (UnityPlacesTile* base, const char* uri, const char* icon_hint, const char* mimetype, const char* display_name, const char* comment) {
	UnityPlacesDefaultTile * self;
	self = (UnityPlacesDefaultTile*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (display_name != NULL);
	unity_places_tile_set_display_name ((UnityPlacesTile*) self, display_name);
	unity_places_tile_set_icon_hint ((UnityPlacesTile*) self, icon_hint);
	unity_places_tile_set_uri ((UnityPlacesTile*) self, uri);
	unity_places_tile_set_mimetype ((UnityPlacesTile*) self, mimetype);
	unity_places_tile_set_comment ((UnityPlacesTile*) self, comment);
	if (self->priv->shown == FALSE) {
		return;
	}
	ctk_button_set_label ((CtkButton*) self, display_name);
	unity_places_default_tile_set_icon (self);
}


static void unity_places_default_tile_real_get_preferred_width (ClutterActor* base, float for_height, float* mwidth, float* nwidth) {
	UnityPlacesDefaultTile * self;
	self = (UnityPlacesDefaultTile*) base;
	*mwidth = 160.0f;
	*nwidth = 160.0f;
}


static void unity_places_default_tile_real_clicked (CtkButton* base) {
	UnityPlacesDefaultTile * self;
	self = (UnityPlacesDefaultTile*) base;
	g_signal_emit_by_name ((UnityPlacesTile*) self, "activated", unity_places_tile_get_uri ((UnityPlacesTile*) self), unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
}


static void unity_places_default_tile_set_icon (UnityPlacesDefaultTile* self) {
	UnityPixbufCache* cache;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	cache = unity_pixbuf_cache_get_default ();
	if (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self) != NULL) {
		_tmp0_ = _vala_strcmp0 (unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		unity_pixbuf_cache_set_image_from_gicon_string (cache, ctk_button_get_image ((CtkButton*) self), unity_places_tile_get_icon_hint ((UnityPlacesTile*) self), UNITY_PLACES_DEFAULT_TILE_ICON_SIZE);
	} else {
		gboolean _tmp1_ = FALSE;
		if (unity_places_tile_get_mimetype ((UnityPlacesTile*) self) != NULL) {
			_tmp1_ = _vala_strcmp0 (unity_places_tile_get_mimetype ((UnityPlacesTile*) self), "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GIcon* icon;
			char* _tmp2_;
			icon = g_content_type_get_icon (unity_places_tile_get_mimetype ((UnityPlacesTile*) self));
			unity_pixbuf_cache_set_image_from_gicon_string (cache, ctk_button_get_image ((CtkButton*) self), _tmp2_ = g_icon_to_string (icon), UNITY_PLACES_DEFAULT_TILE_ICON_SIZE);
			_g_free0 (_tmp2_);
			_g_object_unref0 (icon);
		} else {
			unity_pixbuf_cache_set_image_from_icon_name (cache, ctk_button_get_image ((CtkButton*) self), UNITY_PLACES_TILE_DEFAULT_ICON, UNITY_PLACES_DEFAULT_TILE_ICON_SIZE);
		}
	}
	_g_object_unref0 (cache);
}


static GObject * unity_places_default_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesDefaultTile * self;
	parent_class = G_OBJECT_CLASS (unity_places_default_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_DEFAULT_TILE (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		CtkText* text;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = UNITY_PLACES_DEFAULT_TILE_PADDING, _tmp0_.right = UNITY_PLACES_DEFAULT_TILE_PADDING, _tmp0_.bottom = UNITY_PLACES_DEFAULT_TILE_PADDING, _tmp0_.left = UNITY_PLACES_DEFAULT_TILE_PADDING, _tmp0_), &_tmp1_));
		text = ctk_button_get_text ((CtkButton*) self);
		clutter_text_set_ellipsize ((ClutterText*) text, PANGO_ELLIPSIZE_MIDDLE);
	}
	return obj;
}


static void unity_places_default_tile_class_init (UnityPlacesDefaultTileClass * klass) {
	unity_places_default_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesDefaultTilePrivate));
	UNITY_PLACES_TILE_CLASS (klass)->about_to_show = unity_places_default_tile_real_about_to_show;
	UNITY_PLACES_TILE_CLASS (klass)->update_details = unity_places_default_tile_real_update_details;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_places_default_tile_real_get_preferred_width;
	CTK_BUTTON_CLASS (klass)->clicked = unity_places_default_tile_real_clicked;
	G_OBJECT_CLASS (klass)->constructor = unity_places_default_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_default_tile_finalize;
}


static void unity_places_default_tile_instance_init (UnityPlacesDefaultTile * self) {
	self->priv = UNITY_PLACES_DEFAULT_TILE_GET_PRIVATE (self);
	self->priv->shown = FALSE;
}


static void unity_places_default_tile_finalize (GObject* obj) {
	UnityPlacesDefaultTile * self;
	self = UNITY_PLACES_DEFAULT_TILE (obj);
	G_OBJECT_CLASS (unity_places_default_tile_parent_class)->finalize (obj);
}


GType unity_places_default_tile_get_type (void) {
	static volatile gsize unity_places_default_tile_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_default_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesDefaultTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_default_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesDefaultTile), 0, (GInstanceInitFunc) unity_places_default_tile_instance_init, NULL };
		GType unity_places_default_tile_type_id;
		unity_places_default_tile_type_id = g_type_register_static (UNITY_PLACES_TYPE_TILE, "UnityPlacesDefaultTile", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_default_tile_type_id__volatile, unity_places_default_tile_type_id);
	}
	return unity_places_default_tile_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}



