/* daemon.c generated by valac, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <zeitgeist.h>
#include <dee.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <glib/gstdio.h>
#include <dbus/dbus.h>
#include <gobject/gvaluecollector.h>


#define UNITY_FILES_PLACE_TYPE_BROWSING_STATE (unity_files_place_browsing_state_get_type ())
#define UNITY_FILES_PLACE_BROWSING_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_PLACE_TYPE_BROWSING_STATE, UnityFilesPlaceBrowsingState))
#define UNITY_FILES_PLACE_BROWSING_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_PLACE_TYPE_BROWSING_STATE, UnityFilesPlaceBrowsingStateClass))
#define UNITY_FILES_PLACE_IS_BROWSING_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_PLACE_TYPE_BROWSING_STATE))
#define UNITY_FILES_PLACE_IS_BROWSING_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_PLACE_TYPE_BROWSING_STATE))
#define UNITY_FILES_PLACE_BROWSING_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_PLACE_TYPE_BROWSING_STATE, UnityFilesPlaceBrowsingStateClass))

typedef struct _UnityFilesPlaceBrowsingState UnityFilesPlaceBrowsingState;
typedef struct _UnityFilesPlaceBrowsingStateClass UnityFilesPlaceBrowsingStateClass;
typedef struct _UnityFilesPlaceBrowsingStatePrivate UnityFilesPlaceBrowsingStatePrivate;

#define UNITY_FILES_PLACE_TYPE_SECTION (unity_files_place_section_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityFilesPlaceParamSpecBrowsingState UnityFilesPlaceParamSpecBrowsingState;

#define UNITY_FILES_PLACE_TYPE_DAEMON (unity_files_place_daemon_get_type ())
#define UNITY_FILES_PLACE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_PLACE_TYPE_DAEMON, UnityFilesPlaceDaemon))
#define UNITY_FILES_PLACE_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_PLACE_TYPE_DAEMON, UnityFilesPlaceDaemonClass))
#define UNITY_FILES_PLACE_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_PLACE_TYPE_DAEMON))
#define UNITY_FILES_PLACE_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_PLACE_TYPE_DAEMON))
#define UNITY_FILES_PLACE_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_PLACE_TYPE_DAEMON, UnityFilesPlaceDaemonClass))

typedef struct _UnityFilesPlaceDaemon UnityFilesPlaceDaemon;
typedef struct _UnityFilesPlaceDaemonClass UnityFilesPlaceDaemonClass;
typedef struct _UnityFilesPlaceDaemonPrivate UnityFilesPlaceDaemonPrivate;

#define UNITY_FILES_PLACE_TYPE_SECTIONS_COLUMN (unity_files_place_sections_column_get_type ())

#define UNITY_FILES_PLACE_TYPE_GROUP (unity_files_place_group_get_type ())

#define UNITY_FILES_PLACE_TYPE_GROUPS_COLUMN (unity_files_place_groups_column_get_type ())
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityFilesPlaceDaemonUpdateSearchAsyncData UnityFilesPlaceDaemonUpdateSearchAsyncData;
typedef struct _UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData;

#define UNITY_FILES_PLACE_TYPE_RESULTS_COLUMN (unity_files_place_results_column_get_type ())
typedef struct _UnityFilesPlaceDaemonUpdateFavoritesAsyncData UnityFilesPlaceDaemonUpdateFavoritesAsyncData;
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
typedef struct _UnityFilesPlaceDaemonUpdateDownloadsAsyncData UnityFilesPlaceDaemonUpdateDownloadsAsyncData;
#define _unity_files_place_browsing_state_unref0(var) ((var == NULL) ? NULL : (var = (unity_files_place_browsing_state_unref (var), NULL)))
typedef struct _UnityFilesPlaceDaemonActivateData UnityFilesPlaceDaemonActivateData;
typedef struct _UnityFilesPlaceDaemonBrowseFolderData UnityFilesPlaceDaemonBrowseFolderData;
typedef struct _UnityFilesPlaceDaemonUpdatePathbarModelData UnityFilesPlaceDaemonUpdatePathbarModelData;
typedef struct _DBusObjectVTable _DBusObjectVTable;

typedef enum  {
	UNITY_FILES_PLACE_SECTION_ALL_FILES = 0,
	UNITY_FILES_PLACE_SECTION_DOCUMENTS,
	UNITY_FILES_PLACE_SECTION_FOLDERS,
	UNITY_FILES_PLACE_SECTION_IMAGES,
	UNITY_FILES_PLACE_SECTION_AUDIO,
	UNITY_FILES_PLACE_SECTION_VIDEOS,
	UNITY_FILES_PLACE_SECTION_PRESENTATIONS,
	UNITY_FILES_PLACE_SECTION_OTHER,
	UNITY_FILES_PLACE_SECTION_LAST_SECTION
} UnityFilesPlaceSection;

struct _UnityFilesPlaceBrowsingState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityFilesPlaceBrowsingStatePrivate * priv;
	UnityFilesPlaceSection section;
	UnityPlaceSearch* search;
	char* uri;
};

struct _UnityFilesPlaceBrowsingStateClass {
	GTypeClass parent_class;
	void (*finalize) (UnityFilesPlaceBrowsingState *self);
};

struct _UnityFilesPlaceParamSpecBrowsingState {
	GParamSpec parent_instance;
};

struct _UnityFilesPlaceDaemon {
	GObject parent_instance;
	UnityFilesPlaceDaemonPrivate * priv;
};

struct _UnityFilesPlaceDaemonClass {
	GObjectClass parent_class;
};

struct _UnityFilesPlaceDaemonPrivate {
	ZeitgeistLog* log;
	ZeitgeistIndex* index;
	ZeitgeistMonitor* monitor;
	UnityPlaceController* control;
	UnityPlaceEntryInfo* files;
	UnityPlaceBrowser* browser;
	DeeSharedModel* sections_model;
	DeeSharedModel* pathbar_model;
	char* browsing_uri;
	UnityFilesPlaceSection browsing_root;
	GeeList* section_templates;
	GeeList* months;
	UnityPlaceSearch* previous_search;
	guint previous_active_section;
	gboolean is_dirty;
	DeeIndex* entry_results_by_group;
	DeeIndex* global_results_by_group;
};

typedef enum  {
	UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME = 0,
	UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT
} UnityFilesPlaceSectionsColumn;

typedef enum  {
	UNITY_FILES_PLACE_GROUP_TOP_RESULTS,
	UNITY_FILES_PLACE_GROUP_RECENT,
	UNITY_FILES_PLACE_GROUP_DOWNLOADS,
	UNITY_FILES_PLACE_GROUP_FAVORITE_FOLDERS,
	UNITY_FILES_PLACE_GROUP_FILES,
	UNITY_FILES_PLACE_GROUP_EMPTY_SEARCH,
	UNITY_FILES_PLACE_GROUP_EMPTY_SECTION,
	UNITY_FILES_PLACE_GROUP_TODAY,
	UNITY_FILES_PLACE_GROUP_YESTERDAY,
	UNITY_FILES_PLACE_GROUP_THIS_WEEK,
	UNITY_FILES_PLACE_GROUP_LAST_WEEK,
	UNITY_FILES_PLACE_GROUP_THIS_MONTH,
	UNITY_FILES_PLACE_GROUP_PAST_SIX_MONTHS,
	UNITY_FILES_PLACE_GROUP_THIS_YEAR,
	UNITY_FILES_PLACE_GROUP_LAST_YEAR
} UnityFilesPlaceGroup;

typedef enum  {
	UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER = 0,
	UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME,
	UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT
} UnityFilesPlaceGroupsColumn;

struct _UnityFilesPlaceDaemonUpdateSearchAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	UnityPlaceSearch* search;
	UnityFilesPlaceSection section;
	DeeModel* results_model;
	DeeModel* groups_model;
	gboolean is_filter_search;
	DeeIndex* results_by_group;
	gint group_override;
	char* search_string;
	GPtrArray* templates;
	GTimer* timer;
	ZeitgeistResultSet* results;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	guint group;
	DeeResultSet* top_results;
	char* _tmp2_;
	DeeResultSet* _tmp3_;
	DeeResultSet* _row_it;
	DeeModelIter* row;
	ZeitgeistResultType _tmp4_;
	ZeitgeistResultType result_type;
	GTimer* _tmp5_;
	ZeitgeistResultSet* _tmp8_;
	ZeitgeistTimeRange* _tmp6_;
	ZeitgeistResultSet* _tmp7_;
	ZeitgeistResultSet* _tmp9_;
	GeeSet* uris_;
	guint n_groups;
	guint group_;
	gboolean _tmp10_;
	DeeResultSet* _tmp12_;
	char* _tmp11_;
	char* _tmp13_;
	GError * e;
	GError * _inner_error_;
};

struct _UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	UnityFilesPlaceSection section;
	DeeModel* results_model;
	DeeModel* groups_model;
	gint group_override;
	gboolean active_section_hint_new;
	GFile* folder;
	char* _tmp0_;
	char* _tmp1_;
	GError * ee;
	char* _tmp2_;
	GEnumValue* _tmp3_;
	gboolean _tmp4_;
	char* _tmp5_;
	gboolean _tmp6_;
	DeeModel* sections_model;
	GPtrArray* templates;
	ZeitgeistResultType _tmp7_;
	ZeitgeistResultType result_type;
	GTimer* timer;
	ZeitgeistResultSet* events;
	ZeitgeistTimeRange* _tmp8_;
	ZeitgeistResultSet* _tmp9_;
	GError * e;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_PLACE_RESULTS_COLUMN_URI = 0,
	UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT,
	UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID,
	UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE,
	UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT
} UnityFilesPlaceResultsColumn;

struct _UnityFilesPlaceDaemonUpdateFavoritesAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	DeeModel* results_model;
	DeeModel* groups_model;
	char* contents;
	char* favorites_file;
	char* _tmp1_;
	char* _tmp0_;
	GError * e;
	char** favorites;
	char** _tmp2_;
	char** _tmp3_;
	gint _favorites_size_;
	gint favorites_length1;
	char* mimetype;
	char** parts;
	char** _tmp4_;
	char** _tmp5_;
	gint _parts_size_;
	gint parts_length1;
	char* display_name;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* icon;
	char** uri_collection;
	int uri_collection_length1;
	int uri_it;
	char* uri;
	GError * _inner_error_;
};

struct _UnityFilesPlaceDaemonUpdateDownloadsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	DeeModel* results_model;
	DeeModel* groups_model;
	const char* download_path;
	GFile* download_dir;
	GSList* downloads;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GError * e;
	char* uri;
	GFile* _tmp2_;
	char* _tmp3_;
	char* mimetype;
	char* icon_hint;
	GSList* info_collection;
	GSList* info_it;
	GFileInfo* info;
	GError * _inner_error_;
};

struct _UnityFilesPlaceDaemonActivateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	char* uri;
	guint32 result;
	GFile* f;
	UnityFilesPlaceBrowsingState* state;
	UnityPlaceSearch* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
};

struct _UnityFilesPlaceDaemonBrowseFolderData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	GFile* folder;
	DeeModel* results_model;
	GSList* file_infos;
	GSList* _tmp0_;
	GSList* _tmp1_;
	char* _tmp2_;
	GError * err;
	gboolean _tmp3_;
	char* uri;
	GFile* _tmp4_;
	char* _tmp5_;
	char* mimetype;
	char* icon_hint;
	GSList* info_collection;
	GSList* info_it;
	GFileInfo* info;
	GError * _inner_error_;
};

struct _UnityFilesPlaceDaemonUpdatePathbarModelData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityFilesPlaceDaemon* self;
	GFile* folder;
	char* home_path;
	GFile* parent;
	GFileInfo* finfo;
	gboolean _tmp0_;
	GFile* _tmp1_;
	char* _tmp2_;
	gboolean _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	GError * e;
	char* section_name;
	GError * _inner_error_;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer unity_files_place_browsing_state_parent_class = NULL;
static gpointer unity_files_place_daemon_parent_class = NULL;
static UnityPlaceActivationIface* unity_files_place_daemon_unity_place_activation_parent_iface = NULL;

#define UNITY_FILES_PLACE_ACTIVE_SECTION_HINT "UnityActiveSection"
#define UNITY_FILES_PLACE_EXTRA_ACTION_HINT "UnityExtraAction"
#define CONFIG_DATADIR "/usr/share"
#define UNITY_FILES_PLACE_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
gpointer unity_files_place_browsing_state_ref (gpointer instance);
void unity_files_place_browsing_state_unref (gpointer instance);
GParamSpec* unity_files_place_param_spec_browsing_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_files_place_value_set_browsing_state (GValue* value, gpointer v_object);
void unity_files_place_value_take_browsing_state (GValue* value, gpointer v_object);
gpointer unity_files_place_value_get_browsing_state (const GValue* value);
GType unity_files_place_browsing_state_get_type (void) G_GNUC_CONST;
GType unity_files_place_section_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_FILES_PLACE_BROWSING_STATE_DUMMY_PROPERTY
};
UnityFilesPlaceBrowsingState* unity_files_place_browsing_state_new (void);
UnityFilesPlaceBrowsingState* unity_files_place_browsing_state_construct (GType object_type);
static void unity_files_place_browsing_state_finalize (UnityFilesPlaceBrowsingState* obj);
GType unity_files_place_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_PLACE_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_PLACE_TYPE_DAEMON, UnityFilesPlaceDaemonPrivate))
enum  {
	UNITY_FILES_PLACE_DAEMON_DUMMY_PROPERTY
};
GType unity_files_place_sections_column_get_type (void) G_GNUC_CONST;
static void unity_files_place_daemon_populate_sections (UnityFilesPlaceDaemon* self);
GType unity_files_place_group_get_type (void) G_GNUC_CONST;
GType unity_files_place_groups_column_get_type (void) G_GNUC_CONST;
char* unity_files_place_utils_get_month_name (GDateMonth month);
static void unity_files_place_daemon_populate_groups (UnityFilesPlaceDaemon* self);
static void unity_files_place_daemon_prepare_section_templates (UnityFilesPlaceDaemon* self);
static gboolean unity_files_place_daemon_search_is_invalid (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search);
static void unity_files_place_daemon_on_events_inserted (UnityFilesPlaceDaemon* self, ZeitgeistMonitor* mon, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events);
static void _unity_files_place_daemon_on_events_inserted_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self);
void unity_files_place_daemon_on_results_model_ready (UnityFilesPlaceDaemon* self, DeeSharedModel* model);
static char* unity_files_place_daemon_prepare_search_string (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search);
static void unity_files_place_daemon_update_search_async_data_free (gpointer _data);
static void unity_files_place_daemon_update_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_files_place_daemon_update_without_search_async (UnityFilesPlaceDaemon* self, UnityFilesPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gint group_override, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_update_without_search_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
void unity_files_place_append_events_sorted (ZeitgeistResultSet* events, DeeModel* results, DeeModel* groups, UnityFilesPlaceSection section, gint group_override);
GeeSet* unity_files_place_utils_get_uri_set (ZeitgeistResultSet* results);
void unity_files_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
void unity_files_place_daemon_check_empty_search (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model);
static void unity_files_place_daemon_update_search_async (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search, UnityFilesPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gboolean is_filter_search, DeeIndex* results_by_group, gint group_override, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_update_search_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_files_place_daemon_update_search_async_co (UnityFilesPlaceDaemonUpdateSearchAsyncData* data);
static void unity_files_place_daemon_update_without_search_async_data_free (gpointer _data);
static void unity_files_place_daemon_update_without_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GFile* unity_files_place_daemon_get_folder_for_pathbar_section (UnityFilesPlaceDaemon* self, guint path_element);
static void unity_files_place_daemon_reset_browsing_state (UnityFilesPlaceDaemon* self);
static void unity_files_place_daemon_update_favorites_async (UnityFilesPlaceDaemon* self, DeeModel* results_model, DeeModel* groups_model, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_update_favorites_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
static void unity_files_place_daemon_update_downloads_async (UnityFilesPlaceDaemon* self, DeeModel* results_model, DeeModel* groups_model, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_update_downloads_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
void unity_files_place_daemon_check_empty_section (UnityFilesPlaceDaemon* self, UnityFilesPlaceSection section, DeeModel* results_model);
static gboolean unity_files_place_daemon_update_without_search_async_co (UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* data);
static void unity_files_place_daemon_update_favorites_async_data_free (gpointer _data);
static void unity_files_place_daemon_update_favorites_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
char* unity_files_place_utils_get_icon_for_uri (const char* uri, const char* mimetype);
GType unity_files_place_results_column_get_type (void) G_GNUC_CONST;
static gboolean unity_files_place_daemon_update_favorites_async_co (UnityFilesPlaceDaemonUpdateFavoritesAsyncData* data);
static void unity_files_place_daemon_update_downloads_async_data_free (gpointer _data);
static void unity_files_place_daemon_update_downloads_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_files_place_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_place_utils_list_dir_finish (GAsyncResult* _res_, GError** error);
static void _g_slist_free_g_object_unref (GSList* self);
gint unity_files_place_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2);
char* unity_files_place_utils_check_icon_string (const char* uri, const char* mimetype, GFileInfo* info);
static gboolean unity_files_place_daemon_update_downloads_async_co (UnityFilesPlaceDaemonUpdateDownloadsAsyncData* data);
guint unity_files_place_utils_get_time_group (ZeitgeistEvent* event, DeeModel* groups_model, char** comment);
static void unity_files_place_daemon_real_activate_data_free (gpointer _data);
static void unity_files_place_daemon_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_files_place_daemon_browse_current_folder_in_nautilus (UnityFilesPlaceDaemon* self);
static void unity_files_place_daemon_browse_folder (UnityFilesPlaceDaemon* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_browse_folder_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_files_place_daemon_real_activate_co (UnityFilesPlaceDaemonActivateData* data);
static void unity_files_place_daemon_browse_folder_data_free (gpointer _data);
static void unity_files_place_daemon_browse_folder_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_files_place_daemon_update_pathbar_model (UnityFilesPlaceDaemon* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_files_place_daemon_update_pathbar_model_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_files_place_daemon_browse_folder_co (UnityFilesPlaceDaemonBrowseFolderData* data);
static void unity_files_place_daemon_update_pathbar_model_data_free (gpointer _data);
static void unity_files_place_daemon_update_pathbar_model_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define UNITY_FILES_PLACE_UTILS_file_attribs G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_TIME_ACCESS
static gboolean unity_files_place_daemon_update_pathbar_model_co (UnityFilesPlaceDaemonUpdatePathbarModelData* data);
UnityFilesPlaceDaemon* unity_files_place_daemon_new (void);
UnityFilesPlaceDaemon* unity_files_place_daemon_construct (GType object_type);
#define CONFIG_PREFIX "/usr"
static void _lambda1_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean unity_files_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
gboolean unity_files_place_utils_check_is_filter_search (UnityPlaceSearch* new_search, UnityPlaceSearch* old_search);
static void _lambda2_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self);
static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_files_place_daemon_on_results_model_ready_dee_shared_model_ready (DeeSharedModel* _sender, gpointer self);
static void _lambda5_ (UnityPlaceBrowser* browser, gconstpointer state, const char* comment, UnityFilesPlaceDaemon* self);
static void __lambda5__unity_place_browser_back (UnityPlaceBrowser* _sender, gconstpointer state, const char* comment, gpointer self);
static void _lambda6_ (UnityPlaceBrowser* browser, gconstpointer state, const char* comment, UnityFilesPlaceDaemon* self);
static void __lambda6__unity_place_browser_forward (UnityPlaceBrowser* _sender, gconstpointer state, const char* comment, gpointer self);
static GObject * unity_files_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void unity_files_place_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_files_place_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_files_place_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_files_place_daemon_introspect (UnityFilesPlaceDaemon* self, DBusConnection* connection, DBusMessage* message);
static void unity_files_place_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _unity_files_place_daemon_dbus_path_vtable = {_unity_files_place_daemon_dbus_unregister, unity_files_place_daemon_dbus_message};
static const _DBusObjectVTable _unity_files_place_daemon_dbus_vtable = {unity_files_place_daemon_dbus_register_object};


UnityFilesPlaceBrowsingState* unity_files_place_browsing_state_construct (GType object_type) {
	UnityFilesPlaceBrowsingState* self;
	self = (UnityFilesPlaceBrowsingState*) g_type_create_instance (object_type);
	return self;
}


UnityFilesPlaceBrowsingState* unity_files_place_browsing_state_new (void) {
	return unity_files_place_browsing_state_construct (UNITY_FILES_PLACE_TYPE_BROWSING_STATE);
}


static void unity_files_place_value_browsing_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_files_place_value_browsing_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_files_place_browsing_state_unref (value->data[0].v_pointer);
	}
}


static void unity_files_place_value_browsing_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_files_place_browsing_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_files_place_value_browsing_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_files_place_value_browsing_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityFilesPlaceBrowsingState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_files_place_browsing_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_files_place_value_browsing_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityFilesPlaceBrowsingState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_files_place_browsing_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_files_place_param_spec_browsing_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityFilesPlaceParamSpecBrowsingState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_FILES_PLACE_TYPE_BROWSING_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_files_place_value_get_browsing_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_FILES_PLACE_TYPE_BROWSING_STATE), NULL);
	return value->data[0].v_pointer;
}


void unity_files_place_value_set_browsing_state (GValue* value, gpointer v_object) {
	UnityFilesPlaceBrowsingState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_FILES_PLACE_TYPE_BROWSING_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_FILES_PLACE_TYPE_BROWSING_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_files_place_browsing_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_files_place_browsing_state_unref (old);
	}
}


void unity_files_place_value_take_browsing_state (GValue* value, gpointer v_object) {
	UnityFilesPlaceBrowsingState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_FILES_PLACE_TYPE_BROWSING_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_FILES_PLACE_TYPE_BROWSING_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_files_place_browsing_state_unref (old);
	}
}


static void unity_files_place_browsing_state_class_init (UnityFilesPlaceBrowsingStateClass * klass) {
	unity_files_place_browsing_state_parent_class = g_type_class_peek_parent (klass);
	UNITY_FILES_PLACE_BROWSING_STATE_CLASS (klass)->finalize = unity_files_place_browsing_state_finalize;
}


static void unity_files_place_browsing_state_instance_init (UnityFilesPlaceBrowsingState * self) {
	self->ref_count = 1;
}


static void unity_files_place_browsing_state_finalize (UnityFilesPlaceBrowsingState* obj) {
	UnityFilesPlaceBrowsingState * self;
	self = UNITY_FILES_PLACE_BROWSING_STATE (obj);
	_g_object_unref0 (self->search);
	_g_free0 (self->uri);
}


GType unity_files_place_browsing_state_get_type (void) {
	static volatile gsize unity_files_place_browsing_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_place_browsing_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_files_place_value_browsing_state_init, unity_files_place_value_browsing_state_free_value, unity_files_place_value_browsing_state_copy_value, unity_files_place_value_browsing_state_peek_pointer, "p", unity_files_place_value_browsing_state_collect_value, "p", unity_files_place_value_browsing_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesPlaceBrowsingStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_place_browsing_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesPlaceBrowsingState), 0, (GInstanceInitFunc) unity_files_place_browsing_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_files_place_browsing_state_type_id;
		unity_files_place_browsing_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityFilesPlaceBrowsingState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_files_place_browsing_state_type_id__volatile, unity_files_place_browsing_state_type_id);
	}
	return unity_files_place_browsing_state_type_id__volatile;
}


gpointer unity_files_place_browsing_state_ref (gpointer instance) {
	UnityFilesPlaceBrowsingState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_files_place_browsing_state_unref (gpointer instance) {
	UnityFilesPlaceBrowsingState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_FILES_PLACE_BROWSING_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_files_place_daemon_populate_sections (UnityFilesPlaceDaemon* self) {
	DeeModel* sections;
	g_return_if_fail (self != NULL);
	sections = _g_object_ref0 (unity_place_entry_info_get_sections_model (self->priv->files));
	if (dee_model_get_n_rows (sections) != 0) {
		g_critical ("daemon.vala:307: The sections model should be empty before initial pop" \
"ulation");
		dee_model_clear (sections);
	}
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("All Files"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Documents"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Folders"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Images"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Audio"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Videos"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Presentations"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (sections, UNITY_FILES_PLACE_SECTIONS_COLUMN_DISPLAY_NAME, _ ("Other"), UNITY_FILES_PLACE_SECTIONS_COLUMN_ICON_HINT, "", -1, NULL);
	_g_object_unref0 (sections);
}


static void unity_files_place_daemon_populate_groups (UnityFilesPlaceDaemon* self) {
	DeeModel* groups;
	char* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	groups = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	if (dee_model_get_n_rows (groups) != 0) {
		g_critical ("daemon.vala:335: The groups model should be empty before initial popul" \
"ation");
		dee_model_clear (groups);
	}
	unity_place_renderer_info_set_hint (unity_place_entry_info_get_entry_renderer_info (self->priv->files), "ExpandedGroups", _tmp0_ = g_strdup_printf ("%u", (guint) UNITY_FILES_PLACE_GROUP_FAVORITE_FOLDERS));
	_g_free0 (_tmp0_);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Top Results"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-mostused.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Recent"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-recent.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Downloads"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-downloads.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Favorite Folders"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-favoritefolders.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityDefaultRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Files"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-recent.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityEmptySearchRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, "No search results", UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityEmptySectionRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, "Empty section", UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, "", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Today"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Yesterday"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("This week"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Last Week"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("This Month"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Past Six Months"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("This Year"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _ ("Last Year"), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL);
	self->priv->months = (_tmp1_ = (GeeList*) gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL), _g_object_unref0 (self->priv->months), _tmp1_);
	gee_collection_add ((GeeCollection*) self->priv->months, NULL);
	{
		guint i;
		i = (guint) 1;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* _tmp3_;
				DeeModelIter* _tmp4_;
				DeeModelIter* iter;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i <= G_DATE_DECEMBER)) {
					break;
				}
				iter = (_tmp4_ = dee_model_append (groups, UNITY_FILES_PLACE_GROUPS_COLUMN_RENDERER, "UnityFileInfoRenderer", UNITY_FILES_PLACE_GROUPS_COLUMN_DISPLAY_NAME, _tmp3_ = unity_files_place_utils_get_month_name ((GDateMonth) i), UNITY_FILES_PLACE_GROUPS_COLUMN_ICON_HINT, UNITY_FILES_PLACE_ICON_PATH "group-daterange.svg", -1, NULL), _g_free0 (_tmp3_), _tmp4_);
				gee_collection_add ((GeeCollection*) self->priv->months, iter);
			}
		}
	}
	_g_object_unref0 (groups);
}


static void unity_files_place_daemon_prepare_section_templates (UnityFilesPlaceDaemon* self) {
	GPtrArray* templates;
	ZeitgeistEvent* event;
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistEvent* _tmp3_;
	GPtrArray* _tmp4_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistSubject* _tmp5_;
	ZeitgeistEvent* _tmp7_;
	GPtrArray* _tmp8_;
	ZeitgeistEvent* _tmp10_;
	ZeitgeistSubject* _tmp9_;
	ZeitgeistEvent* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistSubject* _tmp13_;
	ZeitgeistEvent* _tmp15_;
	GPtrArray* _tmp16_;
	ZeitgeistEvent* _tmp18_;
	ZeitgeistSubject* _tmp17_;
	ZeitgeistEvent* _tmp19_;
	GPtrArray* _tmp20_;
	ZeitgeistEvent* _tmp22_;
	ZeitgeistSubject* _tmp21_;
	ZeitgeistEvent* _tmp23_;
	GPtrArray* _tmp24_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistSubject* _tmp25_;
	ZeitgeistEvent* _tmp27_;
	GPtrArray* _tmp28_;
	ZeitgeistEvent* _tmp29_;
	ZeitgeistSubject* _tmp30_;
	ZeitgeistSubject* _tmp31_;
	ZeitgeistSubject* _tmp32_;
	ZeitgeistSubject* _tmp33_;
	ZeitgeistSubject* _tmp34_;
	ZeitgeistEvent* _tmp35_;
	g_return_if_fail (self != NULL);
	templates = NULL;
	event = NULL;
	templates = (_tmp0_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp0_);
	event = (_tmp2_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp1_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", "", "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp2_);
	_g_object_unref0 (_tmp1_);
	g_ptr_array_add (templates, g_object_ref ((_tmp3_ = event, G_IS_OBJECT (_tmp3_) ? ((GObject*) _tmp3_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp4_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp4_);
	event = (_tmp6_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp5_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", ZEITGEIST_NFO_DOCUMENT, "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp6_);
	_g_object_unref0 (_tmp5_);
	g_ptr_array_add (templates, g_object_ref ((_tmp7_ = event, G_IS_OBJECT (_tmp7_) ? ((GObject*) _tmp7_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp8_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp8_);
	event = (_tmp10_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp9_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", "", "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp10_);
	_g_object_unref0 (_tmp9_);
	g_ptr_array_add (templates, g_object_ref ((_tmp11_ = event, G_IS_OBJECT (_tmp11_) ? ((GObject*) _tmp11_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp12_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp12_);
	event = (_tmp14_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp13_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", ZEITGEIST_NFO_IMAGE, "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp14_);
	_g_object_unref0 (_tmp13_);
	g_ptr_array_add (templates, g_object_ref ((_tmp15_ = event, G_IS_OBJECT (_tmp15_) ? ((GObject*) _tmp15_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp16_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp16_);
	event = (_tmp18_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp17_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", ZEITGEIST_NFO_AUDIO, "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp18_);
	_g_object_unref0 (_tmp17_);
	g_ptr_array_add (templates, g_object_ref ((_tmp19_ = event, G_IS_OBJECT (_tmp19_) ? ((GObject*) _tmp19_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp20_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp20_);
	event = (_tmp22_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp21_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", ZEITGEIST_NFO_VIDEO, "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp22_);
	_g_object_unref0 (_tmp21_);
	g_ptr_array_add (templates, g_object_ref ((_tmp23_ = event, G_IS_OBJECT (_tmp23_) ? ((GObject*) _tmp23_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp24_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp24_);
	event = (_tmp26_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp25_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", ZEITGEIST_NFO_PRESENTATION, "", "", "", "", "")), NULL)), _g_object_unref0 (event), _tmp26_);
	_g_object_unref0 (_tmp25_);
	g_ptr_array_add (templates, g_object_ref ((_tmp27_ = event, G_IS_OBJECT (_tmp27_) ? ((GObject*) _tmp27_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	templates = (_tmp28_ = g_ptr_array_sized_new ((guint) 1), _g_ptr_array_unref0 (templates), _tmp28_);
	event = (_tmp29_ = g_object_ref_sink (zeitgeist_event_new_full ("", ZEITGEIST_ZG_USER_ACTIVITY, "", NULL)), _g_object_unref0 (event), _tmp29_);
	zeitgeist_event_add_subject (event, _tmp30_ = g_object_ref_sink (zeitgeist_subject_new_full ("file:*", "!" ZEITGEIST_NFO_DOCUMENT, "", "", "", "", "")));
	_g_object_unref0 (_tmp30_);
	zeitgeist_event_add_subject (event, _tmp31_ = g_object_ref_sink (zeitgeist_subject_new_full ("", "!" ZEITGEIST_NFO_IMAGE, "", "", "", "", "")));
	_g_object_unref0 (_tmp31_);
	zeitgeist_event_add_subject (event, _tmp32_ = g_object_ref_sink (zeitgeist_subject_new_full ("", "!" ZEITGEIST_NFO_AUDIO, "", "", "", "", "")));
	_g_object_unref0 (_tmp32_);
	zeitgeist_event_add_subject (event, _tmp33_ = g_object_ref_sink (zeitgeist_subject_new_full ("", "!" ZEITGEIST_NFO_VIDEO, "", "", "", "", "")));
	_g_object_unref0 (_tmp33_);
	zeitgeist_event_add_subject (event, _tmp34_ = g_object_ref_sink (zeitgeist_subject_new_full ("", "!" ZEITGEIST_NFO_PRESENTATION, "", "", "", "", "")));
	_g_object_unref0 (_tmp34_);
	g_ptr_array_add (templates, g_object_ref ((_tmp35_ = event, G_IS_OBJECT (_tmp35_) ? ((GObject*) _tmp35_) : NULL)));
	gee_collection_add ((GeeCollection*) self->priv->section_templates, templates);
	_g_object_unref0 (event);
	_g_ptr_array_unref0 (templates);
}


static gboolean unity_files_place_daemon_search_is_invalid (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search) {
	gboolean result = FALSE;
	char* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (search == NULL) {
		result = TRUE;
		return result;
	} else {
		char* _tmp0_;
		gboolean _tmp1_;
		if ((_tmp1_ = (_tmp0_ = unity_place_search_get_search_string (search)) == NULL, _g_free0 (_tmp0_), _tmp1_)) {
			result = TRUE;
			return result;
		}
	}
	result = (_tmp3_ = _vala_strcmp0 (_tmp2_ = unity_place_search_get_search_string (search), "") == 0, _g_free0 (_tmp2_), _tmp3_);
	return result;
}


static void _unity_files_place_daemon_on_events_inserted_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self) {
	unity_files_place_daemon_on_events_inserted (self, _sender, time_range, events);
}


void unity_files_place_daemon_on_results_model_ready (UnityFilesPlaceDaemon* self, DeeSharedModel* model) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_signal_connect_object (self->priv->monitor, "events-inserted", (GCallback) _unity_files_place_daemon_on_events_inserted_zeitgeist_monitor_events_inserted, self, 0);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static char* unity_files_place_daemon_prepare_search_string (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search) {
	char* result = NULL;
	char* s;
	g_return_val_if_fail (self != NULL, NULL);
	s = unity_place_search_get_search_string (search);
	if (g_str_has_suffix (s, " ")) {
		char* _tmp0_;
		s = (_tmp0_ = string_strip (s), _g_free0 (s), _tmp0_);
	}
	if (!g_str_has_suffix (s, "*")) {
		char* _tmp1_;
		s = (_tmp1_ = g_strconcat (s, "*", NULL), _g_free0 (s), _tmp1_);
	}
	result = s;
	return result;
}


static void unity_files_place_daemon_update_search_async_data_free (gpointer _data) {
	UnityFilesPlaceDaemonUpdateSearchAsyncData* data;
	data = _data;
	_g_object_unref0 (data->search);
	_g_object_unref0 (data->results_model);
	_g_object_unref0 (data->groups_model);
	_g_object_unref0 (data->results_by_group);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonUpdateSearchAsyncData, data);
}


static void unity_files_place_daemon_update_search_async (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search, UnityFilesPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gboolean is_filter_search, DeeIndex* results_by_group, gint group_override, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateSearchAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonUpdateSearchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_update_search_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_update_search_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->search = _g_object_ref0 (search);
	_data_->section = section;
	_data_->results_model = _g_object_ref0 (results_model);
	_data_->groups_model = _g_object_ref0 (groups_model);
	_data_->is_filter_search = is_filter_search;
	_data_->results_by_group = _g_object_ref0 (results_by_group);
	_data_->group_override = group_override;
	unity_files_place_daemon_update_search_async_co (_data_);
}


static void unity_files_place_daemon_update_search_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonUpdateSearchAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_update_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateSearchAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_update_search_async_co (data);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gboolean unity_files_place_daemon_update_search_async_co (UnityFilesPlaceDaemonUpdateSearchAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (unity_place_entry_info_get_browser (data->self->priv->files) != NULL) {
			g_warning ("daemon.vala:552: In-folder searching not implemented yet");
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		if (unity_files_place_daemon_search_is_invalid (data->self, data->search)) {
			unity_files_place_daemon_update_without_search_async (data->self, data->section, data->results_model, data->groups_model, -1, NULL, NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->search_string = unity_files_place_daemon_prepare_search_string (data->self, data->search);
		data->templates = (GPtrArray*) gee_list_get (data->self->priv->section_templates, (gint) data->section);
		{
			data->timer = g_timer_new ();
			data->_state_ = 1;
			zeitgeist_index_search (data->self->priv->index, data->search_string, data->_tmp0_ = g_object_ref_sink (zeitgeist_time_range_new_anytime ()), _g_ptr_array_ref0 (data->templates), (guint32) ZEITGEIST_STORAGE_STATE_ANY, (guint32) 50, ZEITGEIST_RESULT_TYPE_RELEVANCY, NULL, unity_files_place_daemon_update_search_async_ready, data);
			return FALSE;
			_state_1:
			data->results = (data->_tmp1_ = zeitgeist_index_search_finish (data->self->priv->index, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp0_), data->_tmp1_);
			if (data->_inner_error_ != NULL) {
				_g_timer_destroy0 (data->timer);
				goto __catch0_g_error;
			}
			g_timer_stop (data->timer);
			g_debug ("daemon.vala:579: Found %u/%u Top Results for search '%s' in %fms", zeitgeist_result_set_size (data->results), zeitgeist_result_set_estimated_matches (data->results), data->search_string, g_timer_elapsed (data->timer, NULL) * 1000);
			if (!data->is_filter_search) {
				dee_model_clear (data->results_model);
			} else {
				data->group = (guint) UNITY_FILES_PLACE_GROUP_TOP_RESULTS;
				data->top_results = (data->_tmp3_ = dee_index_lookup (data->results_by_group, data->_tmp2_ = g_strdup_printf ("%u", data->group), DEE_TERM_MATCH_EXACT), _g_free0 (data->_tmp2_), data->_tmp3_);
				{
					data->_row_it = _vala_dee_result_set_iterator (data->top_results);
					while (TRUE) {
						if (!((data->row = _vala_dee_result_set_next_value (data->_row_it)) != NULL)) {
							break;
						}
						dee_model_remove (data->results_model, data->row);
					}
					_g_object_unref0 (data->_row_it);
				}
				_g_object_unref0 (data->top_results);
			}
			unity_files_place_append_events_sorted (data->results, data->results_model, data->groups_model, data->section, (gint) UNITY_FILES_PLACE_GROUP_TOP_RESULTS);
			if (data->section == UNITY_FILES_PLACE_SECTION_FOLDERS) {
				data->_tmp4_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN;
			} else {
				data->_tmp4_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS;
			}
			data->result_type = data->_tmp4_;
			data->timer = (data->_tmp5_ = g_timer_new (), _g_timer_destroy0 (data->timer), data->_tmp5_);
			data->_state_ = 2;
			zeitgeist_index_search (data->self->priv->index, data->search_string, data->_tmp6_ = g_object_ref_sink (zeitgeist_time_range_new_anytime ()), _g_ptr_array_ref0 (data->templates), (guint32) ZEITGEIST_STORAGE_STATE_ANY, (guint32) 100, data->result_type, NULL, unity_files_place_daemon_update_search_async_ready, data);
			return FALSE;
			_state_2:
			data->_tmp8_ = (data->_tmp7_ = zeitgeist_index_search_finish (data->self->priv->index, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp6_), data->_tmp7_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->results);
				_g_timer_destroy0 (data->timer);
				goto __catch0_g_error;
			}
			data->results = (data->_tmp9_ = data->_tmp8_, _g_object_unref0 (data->results), data->_tmp9_);
			g_timer_stop (data->timer);
			g_debug ("daemon.vala:619: Found %u/%u time grouped results for search '%s' in %" \
"fms", zeitgeist_result_set_size (data->results), zeitgeist_result_set_estimated_matches (data->results), data->search_string, g_timer_elapsed (data->timer, NULL) * 1000);
			if (!data->is_filter_search) {
				unity_files_place_append_events_sorted (data->results, data->results_model, data->groups_model, data->section, data->group_override);
			} else {
				data->uris_ = unity_files_place_utils_get_uri_set (data->results);
				data->n_groups = dee_model_get_n_rows (data->groups_model);
				{
					data->group_ = (guint) UNITY_FILES_PLACE_GROUP_RECENT;
					{
						data->_tmp10_ = TRUE;
						while (TRUE) {
							if (!data->_tmp10_) {
								data->group_++;
							}
							data->_tmp10_ = FALSE;
							if (!(data->group_ < data->n_groups)) {
								break;
							}
							unity_files_place_utils_apply_uri_filter (data->uris_, data->_tmp12_ = dee_index_lookup (data->results_by_group, data->_tmp11_ = g_strdup_printf ("%u", data->group_), DEE_TERM_MATCH_EXACT));
							_g_object_unref0 (data->_tmp12_);
							_g_free0 (data->_tmp11_);
						}
					}
				}
				_g_object_unref0 (data->uris_);
			}
			_g_object_unref0 (data->results);
			_g_timer_destroy0 (data->timer);
		}
		goto __finally0;
		__catch0_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:644: Error performing search '%s': %s", data->_tmp13_ = unity_place_search_get_search_string (data->search), data->e->message);
				_g_free0 (data->_tmp13_);
				_g_error_free0 (data->e);
			}
		}
		__finally0:
		if (data->_inner_error_ != NULL) {
			_g_ptr_array_unref0 (data->templates);
			_g_free0 (data->search_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		unity_files_place_daemon_check_empty_search (data->self, data->search, data->results_model);
		_g_ptr_array_unref0 (data->templates);
		_g_free0 (data->search_string);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_update_without_search_async_data_free (gpointer _data) {
	UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* data;
	data = _data;
	_g_object_unref0 (data->results_model);
	_g_object_unref0 (data->groups_model);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData, data);
}


static void unity_files_place_daemon_update_without_search_async (UnityFilesPlaceDaemon* self, UnityFilesPlaceSection section, DeeModel* results_model, DeeModel* groups_model, gint group_override, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_update_without_search_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_update_without_search_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->section = section;
	_data_->results_model = _g_object_ref0 (results_model);
	_data_->groups_model = _g_object_ref0 (groups_model);
	_data_->group_override = group_override;
	unity_files_place_daemon_update_without_search_async_co (_data_);
}


static void unity_files_place_daemon_update_without_search_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_update_without_search_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_update_without_search_async_co (data);
}


static gboolean unity_files_place_daemon_update_without_search_async_co (UnityFilesPlaceDaemonUpdateWithoutSearchAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->active_section_hint_new = FALSE;
		if (unity_place_entry_info_get_browser (data->self->priv->files) != NULL) {
			if (data->section != 0) {
				data->folder = unity_files_place_daemon_get_folder_for_pathbar_section (data->self, (guint) data->section);
				{
					data->_state_ = 3;
					unity_place_activation_activate ((UnityPlaceActivation*) data->self, data->_tmp0_ = g_file_get_uri (data->folder), unity_files_place_daemon_update_without_search_async_ready, data);
					return FALSE;
					_state_3:
					unity_place_activation_activate_finish ((UnityPlaceActivation*) data->self, data->_res_, &data->_inner_error_);
					_g_free0 (data->_tmp0_);
					if (data->_inner_error_ != NULL) {
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch1_dbus_gerror;
						}
						_g_object_unref0 (data->folder);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				}
				goto __finally1;
				__catch1_dbus_gerror:
				{
					data->ee = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
						g_warning ("daemon.vala:666: Failed to activate URI '%s': %s", data->_tmp1_ = g_file_get_uri (data->folder), data->ee->message);
						_g_free0 (data->_tmp1_);
						_g_error_free0 (data->ee);
					}
				}
				__finally1:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->folder);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				g_debug ("daemon.vala:669: Browsed %s from path bar", data->_tmp2_ = g_file_get_uri (data->folder));
				_g_free0 (data->_tmp2_);
				_g_object_unref0 (data->folder);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_object_unref0 (data->folder);
			} else {
				g_debug ("daemon.vala:676: Root section of pathbar activated. Leaving browsing m" \
"ode");
				unity_files_place_daemon_reset_browsing_state (data->self);
				unity_place_entry_info_set_active_section (data->self->priv->files, (guint) data->self->priv->browsing_root);
				unity_place_entry_info_set_hint (data->self->priv->files, UNITY_FILES_PLACE_ACTIVE_SECTION_HINT, (data->_tmp3_ = g_enum_get_value (g_type_class_ref (UNITY_FILES_PLACE_TYPE_SECTION), (int) data->self->priv->browsing_root), (data->_tmp3_ != NULL) ? data->_tmp3_->value_name : NULL));
				data->section = data->self->priv->browsing_root;
				data->active_section_hint_new = TRUE;
			}
		}
		if ((data->_tmp6_ = (data->_tmp5_ = unity_place_entry_info_get_hint (data->self->priv->files, UNITY_FILES_PLACE_ACTIVE_SECTION_HINT)) != NULL, _g_free0 (data->_tmp5_), data->_tmp6_)) {
			data->_tmp4_ = !data->active_section_hint_new;
		} else {
			data->_tmp4_ = FALSE;
		}
		if (data->_tmp4_) {
			unity_place_entry_info_clear_hint (data->self->priv->files, UNITY_FILES_PLACE_ACTIVE_SECTION_HINT);
			g_object_notify ((GObject*) data->self->priv->files, "active-section");
			g_debug ("daemon.vala:694: Clearing active section hint");
		}
		data->sections_model = _g_object_ref0 (unity_place_entry_info_get_sections_model (data->self->priv->files));
		if (UNITY_FILES_PLACE_SECTION_LAST_SECTION != dee_model_get_n_rows (data->sections_model)) {
			g_critical ("daemon.vala:701: Section model malformed");
			_g_object_unref0 (data->sections_model);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		if (data->section > UNITY_FILES_PLACE_SECTION_LAST_SECTION) {
			g_critical ("daemon.vala:707: Active section out of bounds: %u", (guint) data->section);
			_g_object_unref0 (data->sections_model);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->templates = (GPtrArray*) gee_list_get (data->self->priv->section_templates, (gint) data->section);
		if (data->section == UNITY_FILES_PLACE_SECTION_FOLDERS) {
			data->_tmp7_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN;
		} else {
			data->_tmp7_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS;
		}
		data->result_type = data->_tmp7_;
		{
			data->timer = g_timer_new ();
			data->_state_ = 4;
			zeitgeist_log_find_events (data->self->priv->log, data->_tmp8_ = g_object_ref_sink (zeitgeist_time_range_new_anytime ()), _g_ptr_array_ref0 (data->templates), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 100, data->result_type, NULL, unity_files_place_daemon_update_without_search_async_ready, data);
			return FALSE;
			_state_4:
			data->events = (data->_tmp9_ = zeitgeist_log_find_events_finish (data->self->priv->log, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp8_), data->_tmp9_);
			if (data->_inner_error_ != NULL) {
				_g_timer_destroy0 (data->timer);
				goto __catch2_g_error;
			}
			g_timer_stop (data->timer);
			g_debug ("daemon.vala:726: Got %u events for section %u in %fms", zeitgeist_result_set_size (data->events), (guint) data->section, g_timer_elapsed (data->timer, NULL) * 1000);
			dee_model_clear (data->results_model);
			if (data->section == UNITY_FILES_PLACE_SECTION_ALL_FILES) {
				data->_state_ = 5;
				unity_files_place_daemon_update_favorites_async (data->self, data->results_model, data->groups_model, unity_files_place_daemon_update_without_search_async_ready, data);
				return FALSE;
				_state_5:
				unity_files_place_daemon_update_favorites_finish (data->self, data->_res_);
				data->_state_ = 6;
				unity_files_place_daemon_update_downloads_async (data->self, data->results_model, data->groups_model, unity_files_place_daemon_update_without_search_async_ready, data);
				return FALSE;
				_state_6:
				unity_files_place_daemon_update_downloads_finish (data->self, data->_res_);
			}
			unity_files_place_append_events_sorted (data->events, data->results_model, data->groups_model, data->section, data->group_override);
			_g_object_unref0 (data->events);
			_g_timer_destroy0 (data->timer);
		}
		goto __finally2;
		__catch2_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:743: Error fetching recetnly used files: %s", data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally2:
		if (data->_inner_error_ != NULL) {
			_g_ptr_array_unref0 (data->templates);
			_g_object_unref0 (data->sections_model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		unity_files_place_daemon_check_empty_section (data->self, data->section, data->results_model);
		_g_ptr_array_unref0 (data->templates);
		_g_object_unref0 (data->sections_model);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_update_favorites_async_data_free (gpointer _data) {
	UnityFilesPlaceDaemonUpdateFavoritesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->results_model);
	_g_object_unref0 (data->groups_model);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonUpdateFavoritesAsyncData, data);
}


static void unity_files_place_daemon_update_favorites_async (UnityFilesPlaceDaemon* self, DeeModel* results_model, DeeModel* groups_model, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateFavoritesAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonUpdateFavoritesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_update_favorites_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_update_favorites_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->results_model = _g_object_ref0 (results_model);
	_data_->groups_model = _g_object_ref0 (groups_model);
	unity_files_place_daemon_update_favorites_async_co (_data_);
}


static void unity_files_place_daemon_update_favorites_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonUpdateFavoritesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_update_favorites_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateFavoritesAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_update_favorites_async_co (data);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean unity_files_place_daemon_update_favorites_async_co (UnityFilesPlaceDaemonUpdateFavoritesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->favorites_file = g_strconcat (string_to_string (g_get_home_dir ()), "/.gtk-bookmarks", NULL);
			data->_tmp0_ = NULL;
			g_file_get_contents (data->favorites_file, &data->_tmp0_, NULL, &data->_inner_error_);
			data->contents = (data->_tmp1_ = data->_tmp0_, _g_free0 (data->contents), data->_tmp1_);
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->favorites_file);
				if (data->_inner_error_->domain == G_FILE_ERROR) {
					goto __catch3_g_file_error;
				}
				_g_free0 (data->favorites_file);
				_g_free0 (data->contents);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			_g_free0 (data->favorites_file);
		}
		goto __finally3;
		__catch3_g_file_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:760: Failed to read favorites: %s", data->e->message);
				_g_error_free0 (data->e);
				_g_free0 (data->contents);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally3:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->favorites = (data->_tmp3_ = data->_tmp2_ = g_strsplit (data->contents, "\n", 0), data->favorites_length1 = _vala_array_length (data->_tmp2_), data->_favorites_size_ = data->favorites_length1, data->_tmp3_);
		data->mimetype = g_strdup ("inode/directory");
		{
			data->uri_collection = data->favorites;
			data->uri_collection_length1 = data->favorites_length1;
			for (data->uri_it = 0; data->uri_it < data->favorites_length1; data->uri_it = data->uri_it + 1) {
				data->uri = g_strdup (data->uri_collection[data->uri_it]);
				{
					if (_vala_strcmp0 (data->uri, "") == 0) {
						_g_free0 (data->uri);
						continue;
					}
					data->parts = (data->_tmp5_ = data->_tmp4_ = g_strsplit (data->uri, " ", 2), data->parts_length1 = _vala_array_length (data->_tmp4_), data->_parts_size_ = data->parts_length1, data->_tmp5_);
					if (data->parts_length1 == 1) {
						data->display_name = (data->_tmp6_ = g_uri_unescape_string (data->uri, NULL), _g_free0 (data->display_name), data->_tmp6_);
						data->display_name = (data->_tmp7_ = g_filename_display_basename (data->display_name), _g_free0 (data->display_name), data->_tmp7_);
					} else {
						if (data->parts_length1 == 2) {
							data->uri = (data->_tmp8_ = g_strdup (data->parts[0]), _g_free0 (data->uri), data->_tmp8_);
							data->display_name = (data->_tmp9_ = g_strdup (data->parts[1]), _g_free0 (data->display_name), data->_tmp9_);
						} else {
							g_warning ("daemon.vala:787: Internal error computing display name for favorite '%" \
"s'", data->uri);
							data->display_name = (data->_tmp10_ = g_strdup (data->uri), _g_free0 (data->display_name), data->_tmp10_);
						}
					}
					data->icon = unity_files_place_utils_get_icon_for_uri (data->uri, data->mimetype);
					dee_model_append (data->results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, data->uri, UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, data->icon, UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_FILES_PLACE_GROUP_FAVORITE_FOLDERS, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, data->mimetype, UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, data->display_name, UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, data->uri, -1, NULL);
					_g_free0 (data->icon);
					_g_free0 (data->display_name);
					data->parts = (_vala_array_free (data->parts, data->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (data->uri);
				}
			}
		}
		_g_free0 (data->mimetype);
		data->favorites = (_vala_array_free (data->favorites, data->favorites_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data->contents);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_update_downloads_async_data_free (gpointer _data) {
	UnityFilesPlaceDaemonUpdateDownloadsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->results_model);
	_g_object_unref0 (data->groups_model);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonUpdateDownloadsAsyncData, data);
}


static void unity_files_place_daemon_update_downloads_async (UnityFilesPlaceDaemon* self, DeeModel* results_model, DeeModel* groups_model, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateDownloadsAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonUpdateDownloadsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_update_downloads_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_update_downloads_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->results_model = _g_object_ref0 (results_model);
	_data_->groups_model = _g_object_ref0 (groups_model);
	unity_files_place_daemon_update_downloads_async_co (_data_);
}


static void unity_files_place_daemon_update_downloads_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonUpdateDownloadsAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_update_downloads_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdateDownloadsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_update_downloads_async_co (data);
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static gboolean unity_files_place_daemon_update_downloads_async_co (UnityFilesPlaceDaemonUpdateDownloadsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->download_path = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
		data->download_dir = g_file_new_for_path (data->download_path);
		{
			data->_state_ = 7;
			unity_files_place_utils_list_dir (data->download_dir, unity_files_place_daemon_update_downloads_async_ready, data);
			return FALSE;
			_state_7:
			data->_tmp0_ = unity_files_place_utils_list_dir_finish (data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			data->downloads = (data->_tmp1_ = data->_tmp0_, __g_slist_free_g_object_unref0 (data->downloads), data->_tmp1_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:816: Failed to list downloads from directory '%s': %s", data->download_path, data->e->message);
				_g_error_free0 (data->e);
				__g_slist_free_g_object_unref0 (data->downloads);
				_g_object_unref0 (data->download_dir);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			__g_slist_free_g_object_unref0 (data->downloads);
			_g_object_unref0 (data->download_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->downloads = g_slist_sort (data->downloads, (GCompareFunc) unity_files_place_utils_cmp_file_info_by_mtime);
		{
			data->info_collection = data->downloads;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				{
					data->uri = (data->_tmp3_ = g_file_get_uri (data->_tmp2_ = g_file_get_child (data->download_dir, g_file_info_get_name (data->info))), _g_object_unref0 (data->_tmp2_), data->_tmp3_);
					data->mimetype = g_strdup (g_file_info_get_content_type (data->info));
					data->icon_hint = unity_files_place_utils_check_icon_string (data->uri, data->mimetype, data->info);
					dee_model_append (data->results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, data->uri, UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, data->icon_hint, UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_FILES_PLACE_GROUP_DOWNLOADS, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, data->mimetype, UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, g_file_info_get_display_name (data->info), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, data->uri, -1, NULL);
					_g_free0 (data->icon_hint);
					_g_free0 (data->mimetype);
					_g_free0 (data->uri);
					_g_object_unref0 (data->info);
				}
			}
		}
		__g_slist_free_g_object_unref0 (data->downloads);
		_g_object_unref0 (data->download_dir);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_on_events_inserted (UnityFilesPlaceDaemon* self, ZeitgeistMonitor* mon, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events) {
	DeeModel* results_model;
	DeeModel* groups_model;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mon != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (events != NULL);
	results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	{
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev;
		_ev_it = _vala_zeitgeist_result_set_iterator (events);
		ev = NULL;
		while (TRUE) {
			if (!((ev = _vala_zeitgeist_result_set_next_value (_ev_it)) != NULL)) {
				break;
			}
			if (zeitgeist_event_num_subjects (ev) > 0) {
				ZeitgeistSubject* su;
				GFile* _tmp0_;
				gboolean _tmp1_;
				su = _g_object_ref0 (zeitgeist_event_get_subject (ev, 0));
				if ((_tmp1_ = g_file_query_exists (_tmp0_ = g_file_new_for_uri (zeitgeist_subject_get_uri (su)), NULL) == TRUE, _g_object_unref0 (_tmp0_), _tmp1_)) {
					char* icon;
					guint group_id;
					icon = unity_files_place_utils_get_icon_for_uri (zeitgeist_subject_get_uri (su), zeitgeist_subject_get_mimetype (su));
					group_id = unity_files_place_utils_get_time_group (ev, groups_model, NULL);
					g_debug ("daemon.vala:863: Notify %s, %s, %u", zeitgeist_subject_get_uri (su), zeitgeist_subject_get_mimetype (su), group_id);
					dee_model_prepend (results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, zeitgeist_subject_get_uri (su), UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, icon, UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, group_id, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, zeitgeist_subject_get_mimetype (su), UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, zeitgeist_subject_get_text (su), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, zeitgeist_subject_get_uri (su), -1, NULL);
					_g_free0 (icon);
				}
				_g_object_unref0 (su);
			}
		}
		_g_object_unref0 (_ev_it);
	}
	_g_object_unref0 (groups_model);
	_g_object_unref0 (results_model);
}


static void unity_files_place_daemon_reset_browsing_state (UnityFilesPlaceDaemon* self) {
	g_return_if_fail (self != NULL);
	if (unity_place_entry_info_get_browser (self->priv->files) != NULL) {
		unity_place_entry_info_set_browser (self->priv->files, NULL);
	}
	if (unity_place_entry_info_get_sections_model (self->priv->files) != self->priv->sections_model) {
		unity_place_entry_info_set_sections_model (self->priv->files, (DeeModel*) self->priv->sections_model);
	}
	unity_place_entry_info_clear_hints (self->priv->files);
	self->priv->is_dirty = TRUE;
}


static void unity_files_place_daemon_real_activate_data_free (gpointer _data) {
	UnityFilesPlaceDaemonActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonActivateData, data);
}


static void unity_files_place_daemon_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemon * self;
	UnityFilesPlaceDaemonActivateData* _data_;
	self = (UnityFilesPlaceDaemon*) base;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_real_activate_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	unity_files_place_daemon_real_activate_co (_data_);
}


static guint32 unity_files_place_daemon_real_activate_finish (UnityPlaceActivation* base, GAsyncResult* _res_, GError** error) {
	guint32 result;
	UnityFilesPlaceDaemonActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void unity_files_place_daemon_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonActivateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_real_activate_co (data);
}


static gboolean unity_files_place_daemon_real_activate_co (UnityFilesPlaceDaemonActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (_vala_strcmp0 (".", data->uri) == 0) {
			unity_files_place_daemon_browse_current_folder_in_nautilus (data->self);
			data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->f = g_file_new_for_uri (data->uri);
		if (g_file_query_file_type (data->f, 0, NULL) != G_FILE_TYPE_DIRECTORY) {
			g_debug ("daemon.vala:915: Declined activation of URI '%s': Not a directory", data->uri);
			data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED;
			_g_object_unref0 (data->f);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		g_debug ("daemon.vala:919: Browsing folder: %s", data->uri);
		data->state = unity_files_place_browsing_state_new ();
		data->state->search = (data->_tmp0_ = _g_object_ref0 (unity_place_entry_info_get_active_search (data->self->priv->files)), _g_object_unref0 (data->state->search), data->_tmp0_);
		data->state->section = (UnityFilesPlaceSection) unity_place_entry_info_get_active_section (data->self->priv->files);
		data->state->uri = (data->_tmp1_ = g_strdup (data->uri), _g_free0 (data->state->uri), data->_tmp1_);
		unity_place_browser_record_state (data->self->priv->browser, data->state, data->uri);
		data->self->priv->browsing_uri = (data->_tmp2_ = g_strdup (data->uri), _g_free0 (data->self->priv->browsing_uri), data->_tmp2_);
		data->self->priv->is_dirty = TRUE;
		if (unity_place_entry_info_get_browser (data->self->priv->files) == NULL) {
			data->self->priv->browsing_root = (UnityFilesPlaceSection) unity_place_entry_info_get_active_section (data->self->priv->files);
			unity_place_entry_info_set_hint (data->self->priv->files, UNITY_FILES_PLACE_EXTRA_ACTION_HINT, UNITY_FILES_PLACE_ICON_PATH "open-folder.svg");
		}
		unity_place_entry_info_set_browser (data->self->priv->files, data->self->priv->browser);
		unity_place_entry_info_set_sections_model (data->self->priv->files, (DeeModel*) data->self->priv->pathbar_model);
		unity_files_place_daemon_browse_folder (data->self, data->f, NULL, NULL);
		data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH;
		_unity_files_place_browsing_state_unref0 (data->state);
		_g_object_unref0 (data->f);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_unity_files_place_browsing_state_unref0 (data->state);
		_g_object_unref0 (data->f);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_browse_folder_data_free (gpointer _data) {
	UnityFilesPlaceDaemonBrowseFolderData* data;
	data = _data;
	_g_object_unref0 (data->folder);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonBrowseFolderData, data);
}


static void unity_files_place_daemon_browse_folder (UnityFilesPlaceDaemon* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonBrowseFolderData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonBrowseFolderData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_browse_folder);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_browse_folder_data_free);
	_data_->self = g_object_ref (self);
	_data_->folder = _g_object_ref0 (folder);
	unity_files_place_daemon_browse_folder_co (_data_);
}


static void unity_files_place_daemon_browse_folder_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonBrowseFolderData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_browse_folder_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonBrowseFolderData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_browse_folder_co (data);
}


static gboolean unity_files_place_daemon_browse_folder_co (UnityFilesPlaceDaemonBrowseFolderData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (data->self->priv->files)));
		{
			data->_state_ = 8;
			unity_files_place_utils_list_dir (data->folder, unity_files_place_daemon_browse_folder_ready, data);
			return FALSE;
			_state_8:
			data->_tmp0_ = unity_files_place_utils_list_dir_finish (data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			data->file_infos = (data->_tmp1_ = data->_tmp0_, __g_slist_free_g_object_unref0 (data->file_infos), data->_tmp1_);
		}
		goto __finally5;
		__catch5_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("daemon.vala:971: Failed to browse folder '%s': %s", data->_tmp2_ = g_file_get_uri (data->folder), data->err->message);
				_g_free0 (data->_tmp2_);
				_g_error_free0 (data->err);
				__g_slist_free_g_object_unref0 (data->file_infos);
				_g_object_unref0 (data->results_model);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->err);
			}
		}
		__finally5:
		if (data->_inner_error_ != NULL) {
			__g_slist_free_g_object_unref0 (data->file_infos);
			_g_object_unref0 (data->results_model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		dee_model_clear (data->results_model);
		{
			data->info_collection = data->file_infos;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				{
					if (g_file_info_get_is_hidden (data->info)) {
						data->_tmp3_ = TRUE;
					} else {
						data->_tmp3_ = g_file_info_get_is_backup (data->info);
					}
					if (data->_tmp3_) {
						_g_object_unref0 (data->info);
						continue;
					}
					data->uri = (data->_tmp5_ = g_file_get_uri (data->_tmp4_ = g_file_get_child (data->folder, g_file_info_get_name (data->info))), _g_object_unref0 (data->_tmp4_), data->_tmp5_);
					data->mimetype = g_strdup (g_file_info_get_content_type (data->info));
					data->icon_hint = unity_files_place_utils_check_icon_string (data->uri, data->mimetype, data->info);
					g_debug ("daemon.vala:984: Found child: %s", data->uri);
					dee_model_append (data->results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, data->uri, UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, data->icon_hint, UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, 0, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, data->mimetype, UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, g_file_info_get_display_name (data->info), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, data->uri, -1, NULL);
					_g_free0 (data->icon_hint);
					_g_free0 (data->mimetype);
					_g_free0 (data->uri);
					_g_object_unref0 (data->info);
				}
			}
		}
		data->_state_ = 9;
		unity_files_place_daemon_update_pathbar_model (data->self, data->folder, unity_files_place_daemon_browse_folder_ready, data);
		return FALSE;
		_state_9:
		unity_files_place_daemon_update_pathbar_model_finish (data->self, data->_res_);
		__g_slist_free_g_object_unref0 (data->file_infos);
		_g_object_unref0 (data->results_model);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void unity_files_place_daemon_update_pathbar_model_data_free (gpointer _data) {
	UnityFilesPlaceDaemonUpdatePathbarModelData* data;
	data = _data;
	_g_object_unref0 (data->folder);
	g_object_unref (data->self);
	g_slice_free (UnityFilesPlaceDaemonUpdatePathbarModelData, data);
}


static void unity_files_place_daemon_update_pathbar_model (UnityFilesPlaceDaemon* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdatePathbarModelData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceDaemonUpdatePathbarModelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_files_place_daemon_update_pathbar_model);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_daemon_update_pathbar_model_data_free);
	_data_->self = g_object_ref (self);
	_data_->folder = _g_object_ref0 (folder);
	unity_files_place_daemon_update_pathbar_model_co (_data_);
}


static void unity_files_place_daemon_update_pathbar_model_finish (UnityFilesPlaceDaemon* self, GAsyncResult* _res_) {
	UnityFilesPlaceDaemonUpdatePathbarModelData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_files_place_daemon_update_pathbar_model_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceDaemonUpdatePathbarModelData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_files_place_daemon_update_pathbar_model_co (data);
}


static gboolean unity_files_place_daemon_update_pathbar_model_co (UnityFilesPlaceDaemonUpdatePathbarModelData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		dee_model_clear ((DeeModel*) data->self->priv->pathbar_model);
		data->home_path = g_strdup (g_get_home_dir ());
		data->parent = _g_object_ref0 (data->folder);
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					if (!((data->parent = (data->_tmp1_ = g_file_get_parent (data->parent), _g_object_unref0 (data->parent), data->_tmp1_)) != NULL)) {
						break;
					}
				}
				data->_tmp0_ = FALSE;
				{
					if ((data->_tmp3_ = _vala_strcmp0 (data->_tmp2_ = g_file_get_path (data->parent), data->home_path) == 0, _g_free0 (data->_tmp2_), data->_tmp3_)) {
						break;
					}
					data->_tmp4_ = g_file_query_info (data->parent, UNITY_FILES_PLACE_UTILS_file_attribs, G_FILE_QUERY_INFO_NONE, NULL, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						goto __catch6_g_error;
					}
					data->finfo = (data->_tmp5_ = data->_tmp4_, _g_object_unref0 (data->finfo), data->_tmp5_);
				}
				goto __finally6;
				__catch6_g_error:
				{
					data->e = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
						g_warning ("daemon.vala:1014: Failed to compute breadcrumb path: %s", data->e->message);
						_g_error_free0 (data->e);
						break;
					}
				}
				__finally6:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->finfo);
					_g_object_unref0 (data->parent);
					_g_free0 (data->home_path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				dee_model_prepend ((DeeModel*) data->self->priv->pathbar_model, 0, g_file_info_get_display_name (data->finfo), 1, "", -1, NULL);
			}
		}
		data->section_name = g_strdup (dee_model_get_string ((DeeModel*) data->self->priv->sections_model, dee_model_get_iter_at_row ((DeeModel*) data->self->priv->sections_model, (guint) data->self->priv->browsing_root), (guint) 0));
		dee_model_prepend ((DeeModel*) data->self->priv->pathbar_model, 0, data->section_name, -1, NULL);
		_g_free0 (data->section_name);
		_g_object_unref0 (data->finfo);
		_g_object_unref0 (data->parent);
		_g_free0 (data->home_path);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GFile* unity_files_place_daemon_get_folder_for_pathbar_section (UnityFilesPlaceDaemon* self, guint path_element) {
	GFile* result = NULL;
	guint n_path_sections;
	guint to_remove;
	GFile* uri;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	n_path_sections = dee_model_get_n_rows ((DeeModel*) self->priv->pathbar_model);
	if (path_element >= (n_path_sections - 1)) {
		g_warning ("daemon.vala:1030: Path section out of bounds: %u (of %u)", path_element, n_path_sections);
		result = g_file_new_for_path (g_get_home_dir ());
		return result;
	}
	to_remove = (n_path_sections - path_element) - 1;
	uri = g_file_new_for_uri (self->priv->browsing_uri);
	while (TRUE) {
		GFile* _tmp0_;
		if (!(to_remove > 0)) {
			break;
		}
		uri = (_tmp0_ = g_file_get_parent (uri), _g_object_unref0 (uri), _tmp0_);
		to_remove--;
	}
	g_debug ("daemon.vala:1044: For section %u found: %s", path_element, _tmp1_ = g_file_get_uri (uri));
	_g_free0 (_tmp1_);
	result = uri;
	return result;
}


static void unity_files_place_daemon_browse_current_folder_in_nautilus (UnityFilesPlaceDaemon* self) {
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->browsing_uri == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (self->priv->browsing_uri, "") == 0;
	}
	if (_tmp0_) {
		g_warning ("daemon.vala:1053: %s", "Unable to open current folder in file manager. " "We don't have a current folder!");
		return;
	}
	g_debug ("daemon.vala:1058: Opening folder current folder '%s' in file manager", self->priv->browsing_uri);
	{
		g_app_info_launch_default_for_uri (self->priv->browsing_uri, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("daemon.vala:1064: Failed to open current folder '%s' in file manager: " \
"%s", self->priv->browsing_uri, e->message);
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void unity_files_place_daemon_check_empty_search (UnityFilesPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	if (dee_model_get_n_rows (results_model) > 0) {
		return;
	}
	if (unity_files_place_daemon_search_is_invalid (self, search)) {
		return;
	}
	dee_model_append (results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, "", UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_FILES_PLACE_GROUP_EMPTY_SEARCH, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _ ("Your search did not match any files"), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	dee_model_append (results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, _tmp1_ = g_strconcat ("http://google.com/#q=", string_to_string (_tmp0_ = unity_place_search_get_search_string (search)), NULL), UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_FILES_PLACE_GROUP_EMPTY_SEARCH, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _ ("Search the web"), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


void unity_files_place_daemon_check_empty_section (UnityFilesPlaceDaemon* self, UnityFilesPlaceSection section, DeeModel* results_model) {
	char* section_name;
	char* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	if (dee_model_get_n_rows (results_model) > 0) {
		return;
	}
	section_name = NULL;
	switch (section) {
		case UNITY_FILES_PLACE_SECTION_ALL_FILES:
		{
			char* _tmp0_;
			section_name = (_tmp0_ = g_strdup (_ ("files")), _g_free0 (section_name), _tmp0_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_DOCUMENTS:
		{
			char* _tmp1_;
			section_name = (_tmp1_ = g_strdup (_ ("documents")), _g_free0 (section_name), _tmp1_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_FOLDERS:
		{
			char* _tmp2_;
			section_name = (_tmp2_ = g_strdup (_ ("folders")), _g_free0 (section_name), _tmp2_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_IMAGES:
		{
			char* _tmp3_;
			section_name = (_tmp3_ = g_strdup (_ ("images")), _g_free0 (section_name), _tmp3_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_AUDIO:
		{
			char* _tmp4_;
			section_name = (_tmp4_ = g_strdup (_ ("audio files")), _g_free0 (section_name), _tmp4_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_VIDEOS:
		{
			char* _tmp5_;
			section_name = (_tmp5_ = g_strdup (_ ("videos")), _g_free0 (section_name), _tmp5_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_PRESENTATIONS:
		{
			char* _tmp6_;
			section_name = (_tmp6_ = g_strdup (_ ("presentations")), _g_free0 (section_name), _tmp6_);
			break;
		}
		case UNITY_FILES_PLACE_SECTION_OTHER:
		{
			char* _tmp7_;
			section_name = (_tmp7_ = g_strdup (_ ("other files")), _g_free0 (section_name), _tmp7_);
			break;
		}
		default:
		{
			char* _tmp8_;
			g_warning ("daemon.vala:1132: Unknown section number: %u", (guint) section);
			section_name = (_tmp8_ = g_strdup (_ ("files")), _g_free0 (section_name), _tmp8_);
			break;
		}
	}
	dee_model_append (results_model, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, "", UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, "", UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, UNITY_FILES_PLACE_GROUP_EMPTY_SECTION, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, "", UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, _tmp9_ = g_strdup_printf (_ ("There are no %s in your Home folder"), section_name), UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, "", -1, NULL);
	_g_free0 (_tmp9_);
	_g_free0 (section_name);
}


UnityFilesPlaceDaemon* unity_files_place_daemon_construct (GType object_type) {
	UnityFilesPlaceDaemon * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


UnityFilesPlaceDaemon* unity_files_place_daemon_new (void) {
	return unity_files_place_daemon_construct (UNITY_FILES_PLACE_TYPE_DAEMON);
}


static void _lambda1_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self) {
	gboolean _tmp0_ = FALSE;
	UnityFilesPlaceSection section;
	DeeModel* _results_model;
	DeeModel* _groups_model;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (!unity_place_entry_info_get_active (self->priv->files)) {
		return;
	}
	if (self->priv->is_dirty) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->previous_active_section != unity_place_entry_info_get_active_section (self->priv->files);
	}
	if (!_tmp0_) {
		return;
	}
	self->priv->is_dirty = FALSE;
	section = (UnityFilesPlaceSection) unity_place_entry_info_get_active_section (self->priv->files);
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	if (unity_files_place_daemon_search_is_invalid (self, unity_place_entry_info_get_active_search (self->priv->files))) {
		gint _tmp1_ = 0;
		gint group_override;
		if (section == UNITY_FILES_PLACE_SECTION_ALL_FILES) {
			_tmp1_ = (gint) UNITY_FILES_PLACE_GROUP_RECENT;
		} else {
			_tmp1_ = -1;
		}
		group_override = _tmp1_;
		unity_files_place_daemon_update_without_search_async (self, section, _results_model, _groups_model, group_override, NULL, NULL);
	} else {
		unity_files_place_daemon_update_search_async (self, unity_place_entry_info_get_active_search (self->priv->files), section, _results_model, _groups_model, FALSE, self->priv->entry_results_by_group, -1, NULL, NULL);
	}
	self->priv->previous_active_section = unity_place_entry_info_get_active_section (self->priv->files);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (_sender, pspec, self);
}


static void _lambda2_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self) {
	UnityPlaceSearch* search;
	gboolean _tmp0_ = FALSE;
	DeeModel* _results_model;
	DeeModel* _groups_model;
	UnityFilesPlaceSection section;
	UnityPlaceSearch* _tmp2_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	search = _g_object_ref0 (unity_place_entry_info_get_active_search (self->priv->files));
	if (!unity_place_entry_info_get_active (self->priv->files)) {
		_g_object_unref0 (search);
		return;
	}
	if (unity_files_place_utils_search_has_really_changed (self->priv->previous_search, search)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->is_dirty;
	}
	if (!_tmp0_) {
		_g_object_unref0 (search);
		return;
	}
	self->priv->is_dirty = FALSE;
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files)));
	section = (UnityFilesPlaceSection) unity_place_entry_info_get_active_section (self->priv->files);
	if (unity_files_place_daemon_search_is_invalid (self, unity_place_entry_info_get_active_search (self->priv->files))) {
		gint _tmp1_ = 0;
		gint group_override;
		if (section == UNITY_FILES_PLACE_SECTION_ALL_FILES) {
			_tmp1_ = (gint) UNITY_FILES_PLACE_GROUP_RECENT;
		} else {
			_tmp1_ = -1;
		}
		group_override = _tmp1_;
		unity_files_place_daemon_update_without_search_async (self, section, _results_model, _groups_model, group_override, NULL, NULL);
	} else {
		unity_files_place_daemon_update_search_async (self, search, section, _results_model, _groups_model, unity_files_place_utils_check_is_filter_search (search, self->priv->previous_search), self->priv->entry_results_by_group, -1, NULL, NULL);
	}
	self->priv->previous_search = (_tmp2_ = _g_object_ref0 (search), _g_object_unref0 (self->priv->previous_search), _tmp2_);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
	_g_object_unref0 (search);
}


static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda2_ (_sender, pspec, self);
}


static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self) {
	UnityPlaceSearch* search;
	DeeModel* _results_model;
	DeeModel* _groups_model;
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	search = _g_object_ref0 (unity_place_entry_info_get_active_global_search (self->priv->files));
	if (!unity_files_place_utils_search_has_really_changed (self->priv->previous_search, search)) {
		_g_object_unref0 (search);
		return;
	}
	_results_model = _g_object_ref0 (unity_place_renderer_info_get_results_model (unity_place_entry_info_get_global_renderer_info (self->priv->files)));
	_groups_model = _g_object_ref0 (unity_place_renderer_info_get_groups_model (unity_place_entry_info_get_global_renderer_info (self->priv->files)));
	unity_files_place_daemon_update_search_async (self, search, UNITY_FILES_PLACE_SECTION_ALL_FILES, _results_model, _groups_model, unity_files_place_utils_check_is_filter_search (search, self->priv->previous_search), self->priv->global_results_by_group, (gint) UNITY_FILES_PLACE_GROUP_FILES, NULL, NULL);
	self->priv->previous_search = (_tmp0_ = _g_object_ref0 (search), _g_object_unref0 (self->priv->previous_search), _tmp0_);
	_g_object_unref0 (_groups_model);
	_g_object_unref0 (_results_model);
	_g_object_unref0 (search);
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (_sender, pspec, self);
}


static void _lambda4_ (GObject* obj, GParamSpec* pspec, UnityFilesPlaceDaemon* self) {
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_debug ("daemon.vala:246: Activated: %i", (gint) unity_place_entry_info_get_active (self->priv->files));
	self->priv->is_dirty = TRUE;
	if (!unity_place_entry_info_get_active (self->priv->files)) {
		unity_files_place_daemon_reset_browsing_state (self);
	}
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (_sender, pspec, self);
}


static void _unity_files_place_daemon_on_results_model_ready_dee_shared_model_ready (DeeSharedModel* _sender, gpointer self) {
	unity_files_place_daemon_on_results_model_ready (self, _sender);
}


static void _lambda5_ (UnityPlaceBrowser* browser, gconstpointer state, const char* comment, UnityFilesPlaceDaemon* self) {
	gpointer _tmp0_;
	gpointer _tmp1_;
	GFile* f;
	g_return_if_fail (browser != NULL);
	g_return_if_fail (comment != NULL);
	g_debug ("daemon.vala:286: Go back to: %s", (_tmp0_ = state, UNITY_FILES_PLACE_IS_BROWSING_STATE (_tmp0_) ? ((UnityFilesPlaceBrowsingState*) _tmp0_) : NULL)->uri);
	f = g_file_new_for_uri ((_tmp1_ = state, UNITY_FILES_PLACE_IS_BROWSING_STATE (_tmp1_) ? ((UnityFilesPlaceBrowsingState*) _tmp1_) : NULL)->uri);
	unity_files_place_daemon_browse_folder (self, f, NULL, NULL);
	_g_object_unref0 (f);
}


static void __lambda5__unity_place_browser_back (UnityPlaceBrowser* _sender, gconstpointer state, const char* comment, gpointer self) {
	_lambda5_ (_sender, state, comment, self);
}


static void _lambda6_ (UnityPlaceBrowser* browser, gconstpointer state, const char* comment, UnityFilesPlaceDaemon* self) {
	gpointer _tmp0_;
	gpointer _tmp1_;
	GFile* f;
	g_return_if_fail (browser != NULL);
	g_return_if_fail (comment != NULL);
	g_debug ("daemon.vala:294: Go forward to: %s", (_tmp0_ = state, UNITY_FILES_PLACE_IS_BROWSING_STATE (_tmp0_) ? ((UnityFilesPlaceBrowsingState*) _tmp0_) : NULL)->uri);
	f = g_file_new_for_uri ((_tmp1_ = state, UNITY_FILES_PLACE_IS_BROWSING_STATE (_tmp1_) ? ((UnityFilesPlaceBrowsingState*) _tmp1_) : NULL)->uri);
	unity_files_place_daemon_browse_folder (self, f, NULL, NULL);
	_g_object_unref0 (f);
}


static void __lambda6__unity_place_browser_forward (UnityPlaceBrowser* _sender, gconstpointer state, const char* comment, gpointer self) {
	_lambda6_ (_sender, state, comment, self);
}


static GObject * unity_files_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityFilesPlaceDaemon * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_files_place_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_FILES_PLACE_DAEMON (obj);
	_inner_error_ = NULL;
	{
		DeeSharedModel* _tmp0_;
		DeeSharedModel* _tmp1_;
		DeeSharedModel* groups_model;
		DeeSharedModel* global_groups_model;
		DeeSharedModel* results_model;
		DeeSharedModel* global_results_model;
		GeeList* _tmp2_;
		UnityPlaceEntryInfo* _tmp3_;
		char* _tmp4_;
		UnityPlaceSearch* _tmp5_;
		DeeAnalyzer* analyzer;
		DeeIndex* _tmp6_;
		DeeIndex* _tmp7_;
		GPtrArray* templates;
		ZeitgeistEvent* event;
		ZeitgeistMonitor* _tmp10_;
		GPtrArray* _tmp9_;
		ZeitgeistTimeRange* _tmp8_;
		ZeitgeistLog* _tmp11_;
		ZeitgeistIndex* _tmp12_;
		UnityPlaceController* _tmp13_;
		UnityPlaceBrowser* _tmp14_;
		self->priv->sections_model = (_tmp0_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.SectionsModel", (guint) 2, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->sections_model), _tmp0_);
		self->priv->pathbar_model = (_tmp1_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.PathBarModel", (guint) 2, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->pathbar_model), _tmp1_);
		groups_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.GroupsModel", (guint) 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		global_groups_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.GlobalGroupsModel", (guint) 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		results_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.ResultsModel", (guint) 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		global_results_model = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.FilesPlace.GlobalResultsModel", (guint) 6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
		self->priv->section_templates = (_tmp2_ = (GeeList*) gee_array_list_new (G_TYPE_PTR_ARRAY, (GBoxedCopyFunc) g_ptr_array_ref, g_ptr_array_unref, NULL), _g_object_unref0 (self->priv->section_templates), _tmp2_);
		unity_files_place_daemon_prepare_section_templates (self);
		self->priv->files = (_tmp3_ = unity_place_entry_info_new ("/com/canonical/unity/filesplace/files"), _g_object_unref0 (self->priv->files), _tmp3_);
		unity_place_entry_info_set_sections_model (self->priv->files, (DeeModel*) self->priv->sections_model);
		unity_place_renderer_info_set_groups_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files), (DeeModel*) groups_model);
		unity_place_renderer_info_set_results_model (unity_place_entry_info_get_entry_renderer_info (self->priv->files), (DeeModel*) results_model);
		unity_place_renderer_info_set_groups_model (unity_place_entry_info_get_global_renderer_info (self->priv->files), (DeeModel*) global_groups_model);
		unity_place_renderer_info_set_results_model (unity_place_entry_info_get_global_renderer_info (self->priv->files), (DeeModel*) global_results_model);
		unity_files_place_daemon_populate_sections (self);
		unity_files_place_daemon_populate_groups (self);
		unity_place_entry_info_set_icon (self->priv->files, _tmp4_ = g_strconcat (string_to_string (CONFIG_PREFIX), "/share/unity/files.png", NULL));
		_g_free0 (_tmp4_);
		self->priv->previous_search = (_tmp5_ = NULL, _g_object_unref0 (self->priv->previous_search), _tmp5_);
		self->priv->previous_active_section = (guint) UNITY_FILES_PLACE_SECTION_LAST_SECTION;
		self->priv->is_dirty = TRUE;
		analyzer = dee_analyzer_new_for_uint_column ((guint) UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID);
		self->priv->entry_results_by_group = (_tmp6_ = (DeeIndex*) dee_hash_index_new ((DeeModel*) results_model, analyzer), _g_object_unref0 (self->priv->entry_results_by_group), _tmp6_);
		self->priv->global_results_by_group = (_tmp7_ = (DeeIndex*) dee_hash_index_new ((DeeModel*) global_results_model, analyzer), _g_object_unref0 (self->priv->global_results_by_group), _tmp7_);
		templates = g_ptr_array_new ();
		event = g_object_ref_sink (zeitgeist_event_new ());
		g_ptr_array_add (templates, event);
		self->priv->monitor = (_tmp10_ = zeitgeist_monitor_new (_tmp8_ = g_object_ref_sink (zeitgeist_time_range_new_from_now ()), (_tmp9_ = templates, templates = NULL, _tmp9_)), _g_object_unref0 (self->priv->monitor), _tmp10_);
		_g_object_unref0 (_tmp8_);
		self->priv->log = (_tmp11_ = zeitgeist_log_new (), _g_object_unref0 (self->priv->log), _tmp11_);
		self->priv->index = (_tmp12_ = zeitgeist_index_new (), _g_object_unref0 (self->priv->index), _tmp12_);
		g_signal_connect_object ((GObject*) self->priv->files, "notify::active-section", (GCallback) __lambda1__g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->files, "notify::active-search", (GCallback) __lambda2__g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->files, "notify::active-global-search", (GCallback) __lambda3__g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self->priv->files, "notify::active", (GCallback) __lambda4__g_object_notify, self, 0);
		g_signal_connect_object (results_model, "ready", (GCallback) _unity_files_place_daemon_on_results_model_ready_dee_shared_model_ready, self, 0);
		dee_shared_model_connect (self->priv->sections_model);
		dee_shared_model_connect (self->priv->pathbar_model);
		dee_shared_model_connect (groups_model);
		dee_shared_model_connect (global_groups_model);
		dee_shared_model_connect (results_model);
		dee_shared_model_connect (global_results_model);
		self->priv->control = (_tmp13_ = unity_place_controller_new ("/com/canonical/unity/filesplace"), _g_object_unref0 (self->priv->control), _tmp13_);
		unity_place_controller_add_entry (self->priv->control, self->priv->files);
		unity_place_controller_set_activation (self->priv->control, (UnityPlaceActivation*) self);
		{
			unity_place_controller_export (self->priv->control, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch8_dbus_gerror;
				}
				_g_object_unref0 (event);
				_g_ptr_array_unref0 (templates);
				_g_free0 (analyzer);
				_g_object_unref0 (global_results_model);
				_g_object_unref0 (results_model);
				_g_object_unref0 (global_groups_model);
				_g_object_unref0 (groups_model);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		goto __finally8;
		__catch8_dbus_gerror:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("daemon.vala:273: Failed to export DBus service for '%s': %s", unity_place_controller_get_dbus_path (self->priv->control), _error_->message);
				_g_error_free0 (_error_);
			}
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (event);
			_g_ptr_array_unref0 (templates);
			_g_free0 (analyzer);
			_g_object_unref0 (global_results_model);
			_g_object_unref0 (results_model);
			_g_object_unref0 (global_groups_model);
			_g_object_unref0 (groups_model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->browser = (_tmp14_ = unity_place_browser_new (UNITY_FILES_PLACE_TYPE_BROWSING_STATE, (GBoxedCopyFunc) unity_files_place_browsing_state_ref, unity_files_place_browsing_state_unref, "/com/canonical/unity/filesplace/browser"), _g_object_unref0 (self->priv->browser), _tmp14_);
		g_signal_connect_object (self->priv->browser, "back", (GCallback) __lambda5__unity_place_browser_back, self, 0);
		g_signal_connect_object (self->priv->browser, "forward", (GCallback) __lambda6__unity_place_browser_forward, self, 0);
		_g_object_unref0 (event);
		_g_ptr_array_unref0 (templates);
		_g_free0 (analyzer);
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
	}
	return obj;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _unity_files_place_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_files_place_daemon_introspect (UnityFilesPlaceDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.Activation\">\n  <method name=\"Activate\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_files_place_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_files_place_daemon_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (unity_place_activation_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void unity_files_place_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_files_place_daemon_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	unity_place_activation_dbus_register_object (connection, path, object);
}


static void unity_files_place_daemon_class_init (UnityFilesPlaceDaemonClass * klass) {
	unity_files_place_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesPlaceDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_files_place_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_files_place_daemon_finalize;
	g_type_set_qdata (UNITY_FILES_PLACE_TYPE_DAEMON, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_files_place_daemon_dbus_vtable));
}


static void unity_files_place_daemon_unity_place_activation_interface_init (UnityPlaceActivationIface * iface) {
	unity_files_place_daemon_unity_place_activation_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = unity_files_place_daemon_real_activate;
	iface->activate_finish = unity_files_place_daemon_real_activate_finish;
}


static void unity_files_place_daemon_instance_init (UnityFilesPlaceDaemon * self) {
	self->priv = UNITY_FILES_PLACE_DAEMON_GET_PRIVATE (self);
	self->priv->browsing_uri = NULL;
}


static void unity_files_place_daemon_finalize (GObject* obj) {
	UnityFilesPlaceDaemon * self;
	self = UNITY_FILES_PLACE_DAEMON (obj);
	_g_object_unref0 (self->priv->log);
	_g_object_unref0 (self->priv->index);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->control);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->browser);
	_g_object_unref0 (self->priv->sections_model);
	_g_object_unref0 (self->priv->pathbar_model);
	_g_free0 (self->priv->browsing_uri);
	_g_object_unref0 (self->priv->section_templates);
	_g_object_unref0 (self->priv->months);
	_g_object_unref0 (self->priv->previous_search);
	_g_object_unref0 (self->priv->entry_results_by_group);
	_g_object_unref0 (self->priv->global_results_by_group);
	G_OBJECT_CLASS (unity_files_place_daemon_parent_class)->finalize (obj);
}


GType unity_files_place_daemon_get_type (void) {
	static volatile gsize unity_files_place_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_place_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesPlaceDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_place_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesPlaceDaemon), 0, (GInstanceInitFunc) unity_files_place_daemon_instance_init, NULL };
		static const GInterfaceInfo unity_place_activation_info = { (GInterfaceInitFunc) unity_files_place_daemon_unity_place_activation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_files_place_daemon_type_id;
		unity_files_place_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesPlaceDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (unity_files_place_daemon_type_id, UNITY_PLACE_TYPE_ACTIVATION, &unity_place_activation_info);
		g_once_init_leave (&unity_files_place_daemon_type_id__volatile, unity_files_place_daemon_type_id);
	}
	return unity_files_place_daemon_type_id__volatile;
}


void unity_files_place_append_events_sorted (ZeitgeistResultSet* events, DeeModel* results, DeeModel* groups, UnityFilesPlaceSection section, gint group_override) {
	GError * _inner_error_;
	GeeSet* seen_uris;
	g_return_if_fail (events != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (groups != NULL);
	_inner_error_ = NULL;
	seen_uris = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, NULL);
	{
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev;
		_ev_it = _vala_zeitgeist_result_set_iterator (events);
		ev = NULL;
		while (TRUE) {
			if (!((ev = _vala_zeitgeist_result_set_next_value (_ev_it)) != NULL)) {
				break;
			}
			if (zeitgeist_event_num_subjects (ev) > 0) {
				ZeitgeistSubject* su;
				char* uri;
				char* display_name;
				char* mimetype;
				GFile* _tmp0_;
				gboolean _tmp1_;
				su = _g_object_ref0 (zeitgeist_event_get_subject (ev, 0));
				uri = g_strdup (zeitgeist_subject_get_uri (su));
				display_name = g_strdup (zeitgeist_subject_get_text (su));
				mimetype = g_strdup (zeitgeist_subject_get_mimetype (su));
				if (gee_collection_contains ((GeeCollection*) seen_uris, uri)) {
					_g_free0 (mimetype);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (su);
					continue;
				}
				gee_collection_add ((GeeCollection*) seen_uris, uri);
				if ((_tmp1_ = g_file_query_exists (_tmp0_ = g_file_new_for_uri (zeitgeist_subject_get_uri (su)), NULL) == TRUE, _g_object_unref0 (_tmp0_), _tmp1_)) {
					char* icon;
					guint group_id = 0U;
					char* comment;
					char* _tmp10_;
					guint _tmp9_;
					char* _tmp8_ = NULL;
					if (section == UNITY_FILES_PLACE_SECTION_FOLDERS) {
						GFile* _tmp2_;
						GFile* _tmp3_;
						GFile* dir;
						char* _tmp4_;
						char* _tmp7_;
						dir = (_tmp3_ = g_file_get_parent (_tmp2_ = g_file_new_for_uri (uri)), _g_object_unref0 (_tmp2_), _tmp3_);
						uri = (_tmp4_ = g_file_get_uri (dir), _g_free0 (uri), _tmp4_);
						{
							GFileInfo* info;
							char* _tmp5_;
							info = g_file_query_info (dir, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch9_g_error;
							}
							display_name = (_tmp5_ = g_strdup (g_file_info_get_display_name (info)), _g_free0 (display_name), _tmp5_);
							_g_object_unref0 (info);
						}
						goto __finally9;
						__catch9_g_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							{
								char* _tmp6_;
								g_warning ("daemon.vala:1190: Unable to get display name for %s", uri);
								display_name = (_tmp6_ = g_file_get_basename (dir), _g_free0 (display_name), _tmp6_);
								_g_error_free0 (e);
							}
						}
						__finally9:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (dir);
							_g_free0 (mimetype);
							_g_free0 (display_name);
							_g_free0 (uri);
							_g_object_unref0 (su);
							_g_object_unref0 (_ev_it);
							_g_object_unref0 (seen_uris);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						mimetype = (_tmp7_ = g_strdup ("inode/directory"), _g_free0 (mimetype), _tmp7_);
						_g_object_unref0 (dir);
					}
					icon = unity_files_place_utils_get_icon_for_uri (uri, mimetype);
					comment = g_strdup ("");
					group_id = (_tmp9_ = unity_files_place_utils_get_time_group (ev, groups, &_tmp8_), comment = (_tmp10_ = _tmp8_, _g_free0 (comment), _tmp10_), _tmp9_);
					if (group_override >= 0) {
						group_id = (guint) group_override;
					}
					dee_model_append (results, UNITY_FILES_PLACE_RESULTS_COLUMN_URI, uri, UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT, icon, UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID, group_id, UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE, mimetype, UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME, display_name, UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT, comment, -1, NULL);
					_g_free0 (comment);
					_g_free0 (icon);
				}
				_g_free0 (mimetype);
				_g_free0 (display_name);
				_g_free0 (uri);
				_g_object_unref0 (su);
			}
		}
		_g_object_unref0 (_ev_it);
	}
	_g_object_unref0 (seen_uris);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




