import Qt 4.7
import gconf 1.0
/* Necessary to access the blended image provider and CacheEffect */
import Unity2d 1.0

Item {
    property string overlay_color
    property real overlay_alpha

    /* Avoid redraw at rendering */
    effect: CacheEffect {}

    GConfItem {
        id: primary_color
        key: "/desktop/gnome/background/primary_color"
    }

    GConfItem {
        id: picture_filename
        key: "/desktop/gnome/background/picture_filename"
    }

    GConfItem {
        id: picture_options
        key: "/desktop/gnome/background/picture_options"
    }

    Rectangle {
        Rectangle {
            anchors.fill: parent
            opacity: overlay_alpha
            color: overlay_color
        }

        anchors.fill: parent
        color: primary_color.value
    }

    Image {
        id: picture

        visible: picture_filename.value
        source: {
            var filename = picture_filename.value

            if(overlay_alpha > 0.0)
                return "image://blended/%1color=%2alpha=%3".arg(filename).arg(overlay_color).arg(overlay_alpha)
            else
                return filename
        }
        width: screen.geometry.width
        height: screen.geometry.height
        y: - screen.availableGeometry.y

        smooth: true

        /* Possible modes are:
            - "wallpaper"
            - "centered" (NOT IMPLEMENTED)
            - "scaled"
            - "stretched"
            - "zoom"
            - "spanned" (NOT IMPLEMENTED)
        */
        fillMode: {
            if(picture_options.value == "wallpaper")
                return Image.Tile
            else if(picture_options.value == "scaled")
                return Image.PreserveAspectFit
            else if(picture_options.value == "stretched")
                return Image.Stretch
            else if(picture_options.value == "zoom")
                return Image.PreserveAspectCrop
            else return Image.PreserveAspectFit
        }
    }
}
