/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_WM_H_
#define _LAUNCHER_WM_H_

#include <glib-object.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>

#define LAUNCHER_TYPE_WM (launcher_wm_get_type ())

#define LAUNCHER_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_WM, LauncherWm))

#define LAUNCHER_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_WM, LauncherWmClass))

#define LAUNCHER_IS_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_WM))

#define LAUNCHER_IS_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_WM))

#define LAUNCHER_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_WM, LauncherWmClass))

typedef struct _LauncherWm        LauncherWm;
typedef struct _LauncherWmClass   LauncherWmClass;
typedef struct _LauncherWmPrivate LauncherWmPrivate;
 
struct _LauncherWm
{
  GObject        parent;	

  LauncherWmPrivate *priv;
};

struct _LauncherWmClass
{
  GObjectClass   parent_class;

  /*< signals />*/
  void (*show_windec) (LauncherWm *wm, WnckWindow *window);
  void (*hide_windec) (LauncherWm *wm);
};

GType launcher_wm_get_type (void) G_GNUC_CONST;

LauncherWm * launcher_wm_get_default (void);


#endif /* _LAUNCHER_WM_H_ */

