/* UDisks daemon D-BUS interfaces
 *
 * (C) 2010 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

using DBus;

namespace UDisks {

    [DBus (name = "org.freedesktop.UDisks")]
    interface Daemon: DBus.Object {
	public abstract ObjectPath[] enumerate_devices() throws DBus.Error;
	public abstract string[] enumerate_device_files() throws DBus.Error;

	public signal void device_added(ObjectPath device);
	public signal void device_removed(ObjectPath device);
	public signal void device_changed(ObjectPath device);

	public abstract string daemon_version { owned get; }
    }

    [DBus (name = "org.freedesktop.UDisks.Device")]
    interface Device: DBus.Object {
	public abstract async string filesystem_mount(string filesystem_type, string[] options) throws DBus.Error;
	public abstract async void filesystem_unmount(string[] options) throws DBus.Error;

	public abstract string device_file { owned get; }
	public abstract string id_usage { owned get; }
	public abstract bool device_is_mounted { owned get; }
	public abstract bool device_is_partition { owned get; }
	public abstract bool device_is_removable { owned get; }
	public abstract bool device_is_system_internal { owned get; }
	public abstract bool device_presentation_hide { owned get; }
	public abstract bool device_presentation_nopolicy { owned get; }
    }
}
