#!/bin/sh

enter_anti_failure_mode ()
{
    device="$(grub-probe -t device / | cut -c -8)"
    if [ -e /proc/efi -o -e /sys/firmware/efi ]; then # for UEFI BIOS
        /usr/share/ubuntu/scripts/uefi_helper.sh remove ubuntu
    else # for legacy BIOS
        sfdisk $device -A 1
    fi
}

leave_anti_failure_mode ()
{
    device="$(grub-probe -t device / | cut -c -8)"
    if [ -e /proc/efi -o -e /sys/firmware/efi ]; then # for UEFI BIOS
        grub-install
    else # for legacy BIOS
        sfdisk $device -A 2
    fi
}

early_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        enter_anti_failure_mode
    fi
}

late_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        leave_anti_failure_mode
        device="$(grub-probe -t device / | cut -c -8)"
        while ! mount | grep cdrom; do sleep 1; done # Waiting for /cdrom ready
        if mount -rw -o remount ${device}1 /cdrom; then
            if [ -f /cdrom/boot/grub/grubenv ]; then
                grub-editenv /cdrom/boot/grub/grubenv set rectype=hdd
                # Unset 'ondiskrec' flag while the whole recovery process is finished. (LP: #1054250)
                if grub-editenv /cdrom/boot/grub/grubenv list | grep ondiskrec; then
                    grub-editenv /cdrom/boot/grub/grubenv unset ondiskrec
                fi
            fi
            mount -r -o remount ${device}1 /cdrom
        fi
        rm /usr/share/ubuntu/anti-failure
    fi
}

reboot_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        leave_anti_failure_mode
    fi
    reboot
}

force_reboot_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        leave_anti_failure_mode
    fi
    reboot -f
}

poweroff_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        leave_anti_failure_mode
    fi
    poweroff
}

force_poweroff_task ()
{
    if [ -e /usr/share/ubuntu/anti-failure ]; then
        leave_anti_failure_mode
    fi
    poweroff -f
}

case $1 in
    (early)
        early_task
        ;;
    (late)
        late_task
        ;;
    (reboot)
        reboot_task
        ;;
    (force-reboot)
        force_reboot_task
        ;;
    (poweroff)
        poweroff_task
        ;;
    (force-poweroff)
        force_poweroff_task
        ;;
esac
