import os

from urecovery import DataObj

class GrubMenuEntry(DataObj):

    #{{{attrdefs = {
    attrdefs = {
        'ver': 2,
        'title': None,
        'disk_id': 0,
        'part_id': 0,
        'kopts':[],
        'chainload':False
    }
    #}}}

    #{{{def __repr__(self):
    def __repr__(self):
        return self.genStr()
    #}}}

    #{{{def check(self):
    def check(self):
        assert self.title is not None, "please give tile of menuentry"
        assert self.ver in (1,2), "wrong grub version: %s" % self.ver
    #}}}

    #{{{def genStr(self):
    def genStr(self):
        _str = ['menuentry "%s" {' % self.title]
        _str.append( '\t' + self.genLineRoot())
        if self.chainload:
            _str.append('\tchainload+1')
        else:
            _str.append( '\t' + self.genLineKern())
            _str.append( '\t' + "initrd  /casper/initrd.lz")
        _str.append('}')
        return "\n".join(_str)
    #}}}

    #{{{def genLineRoot(self):
    def genLineRoot(self):
        if self.ver == 2:
            _part_id = self.part_id + 1
        else:
            _part_id = self.part_id 
        return "set root='(hd%s, %s)'" % (self.disk_id, _part_id)
    #}}}

    #{{{def genLineKern(self):
    def genLineKern(self):
        "generate kernel line"
        line = []
        if self.ver == 1:
            line.append('kern')
        elif self.ver == 2:
            line.append('linux')
        else:
            raise Exception("Wrong grub version")
        line.append('/casper/vmlinuz')         
        if self.kopts:
            line.extend(self.kopts)
        return ' '.join(line)
    #}}}
pass

class GrubCfg(object):

    entries = []
    ver = 2

    #{{{def name(self):
    @property
    def name(self):
        if  self.ver == 2:
            return "grub.cfg"
        else:
            return "menu.lst"
    #}}}

    #{{{def addEntry(self, entry):
    def addEntry(self, entry):
        entry.check()
        self.entries.append(entry)
    #}}}

   #{{{def genStr(self):
    def genStr(self):
        for e in self.entries:
            e.ver = self.ver
        return "\n".join(self.genHeader() + ["%s" % e for e in self.entries])
    #}}}

    #{{{def genHeader(self):
    def genHeader(self):
        if self.ver == 2:
            return ['set timeout=-1',
                    'set default=0',
                    '']
        else:
            return []
    #}}}

    #{{{def saveToDir(self, path):
    def saveToDir(self, path):
        fullpath = os.path.join(path, self.name)
        with open(fullpath, 'w') as f:
            f.write(self.genStr())
    #}}}
pass
