/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1

QtObject {
    property url source
    property int tab
    property bool loaded: telephony.viewLoader != undefined && String(telephony.viewLoader.source).indexOf(source) != -1

    function load() {
        // select the correct tab for the view
        if (telephony.currentTab != tab) {
            telephony.currentTab = tab;
        }

        // To keep this simple we rely on the fact that setting source to a
        // local file will immediately make the item available.
        telephony.viewLoader.source = source
    }
}
