/*
 * tube-dbus.h - Header for GabbleTubeDBus
 * Copyright (C) 2007 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GABBLE_TUBE_DBUS_H__
#define __GABBLE_TUBE_DBUS_H__

#include <glib-object.h>

#include <telepathy-glib/enums.h>
#include <telepathy-glib/group-mixin.h>
#include <telepathy-glib/interfaces.h>
#include <telepathy-glib/base-channel.h>

#include "connection.h"
#include "bytestream-iface.h"
#include "extensions/extensions.h"
#include "muc-channel.h"

G_BEGIN_DECLS

typedef struct _GabbleTubeDBus GabbleTubeDBus;
typedef struct _GabbleTubeDBusClass GabbleTubeDBusClass;
typedef struct _GabbleTubeDBusPrivate GabbleTubeDBusPrivate;

struct _GabbleTubeDBusClass {
  TpBaseChannelClass parent_class;

  TpDBusPropertiesMixinClass dbus_props_class;
  TpGroupMixinClass group_class;
};

struct _GabbleTubeDBus {
  TpBaseChannel parent;
  TpGroupMixin group;

  GabbleTubeDBusPrivate *priv;
};

GType gabble_tube_dbus_get_type (void);

/* TYPE MACROS */
#define GABBLE_TYPE_TUBE_DBUS \
  (gabble_tube_dbus_get_type ())
#define GABBLE_TUBE_DBUS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_TUBE_DBUS, GabbleTubeDBus))
#define GABBLE_TUBE_DBUS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), GABBLE_TYPE_TUBE_DBUS,\
                           GabbleTubeDBusClass))
#define GABBLE_IS_TUBE_DBUS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_TUBE_DBUS))
#define GABBLE_IS_TUBE_DBUS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), GABBLE_TYPE_TUBE_DBUS))
#define GABBLE_TUBE_DBUS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), GABBLE_TYPE_TUBE_DBUS,\
                              GabbleTubeDBusClass))

GabbleTubeDBus *gabble_tube_dbus_new (GabbleConnection *conn, TpHandle handle,
    TpHandleType handle_type, TpHandle self_handle, TpHandle initiator,
    const gchar *service, GHashTable *parameters, const gchar *stream_id,
    guint id, GabbleBytestreamIface *bytestream, GabbleMucChannel *muc,
    gboolean requested);

gboolean gabble_tube_dbus_add_name (GabbleTubeDBus *tube, TpHandle handle,
    const gchar *name);

gboolean gabble_tube_dbus_remove_name (GabbleTubeDBus *tube, TpHandle handle);

gboolean gabble_tube_dbus_handle_in_names (GabbleTubeDBus *tube,
    TpHandle handle);

gboolean gabble_tube_dbus_offer (GabbleTubeDBus *tube, GError **error);

const gchar * const * gabble_tube_dbus_channel_get_allowed_properties (void);

/* Only extern for the benefit of tests/test-dtube-unique-names.c */
gchar *_gabble_generate_dbus_unique_name (const gchar *nick);

G_END_DECLS

#endif /* #ifndef __GABBLE_TUBE_DBUS_H__ */
