#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#define UIO_DEV "/dev/uio0"
#define IOP_MAGIC       'v'
//#define UIO_VMETA_SUSPEND_SET         _IO(IOP_MAGIC, 13)
//#define UIO_VMETA_SUSPEND_CHECK  _IOR(IOP_MAGIC, 11, int)

#define VMETA_CMD_SUSPEND_SET           _IO(IOP_MAGIC, 11)
#define VMETA_CMD_SUSPEND_CHECK         _IOR(IOP_MAGIC, 9, int)
int main()
{
  int suspend_check = 0;
  int uiofd = open(UIO_DEV, O_RDWR);
  if(uiofd < 0) 
  {
      printf("open device error \n");     
      return -1;
  }  

//  ioctl(uiofd, UIO_VMETA_SUSPEND_SET);
  ioctl(uiofd, VMETA_CMD_SUSPEND_SET);
  printf("set suspend down \n");
  while(! suspend_check )
  {
    ioctl(uiofd, VMETA_CMD_SUSPEND_CHECK, &suspend_check);
    usleep(10);
  }
  
  
  return 0;
}
