// Global vars
var globalPrefs = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial.");
var cacheService = Components.classes["@uworks.net/speeddialcache;1"].getService().wrappedJSObject;
var RELOAD_FLAGS = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE;
var RELOAD_SKIP_CACHE_FLAGS = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_BYPASS_PROXY | Components.interfaces.nsIWebNavigation.LOAD_FLAGS_BYPASS_CACHE;

var speedDialBundle;

// Configuration parameters
var thumbnailTooltipTitle = true;
var thumbnailTooltipURL = true;
var showThumbnailOpenButton = true;
var showThumbnailReloadButton = true;
var showThumbnailDeassignButton = true;
var showThumbnailNewTabButton = true;
var showThumbnailBackgroundTabButton = true;
var showThumbnailNewWindowButton = true;
var showThumbnailEditButton = true;
var wheelScrollAmount = 10;
var enableCache = true;
var hideThumbnailNumbers;
var enableGroups = false;
var numGroups = 1;
var thumbnailDragDropExclude;
var thumbnailSequentialUpdate;
var screenColumns = 3;
var imageFormat = "png";
var defaultMinimumWidth;
var defaultMaximumWidth;
var defaultWidthModifier;
var defaultWidthModifierType;
var defaultMinimumHeight;
var defaultMaximumHeight;
var defaultHeightModifier;
var defaultHeightModifierType;
var rightClickAction;
var oldResampling = false;
var colorizeTabs = false;
var rememberTabLastGroup = false;
var ignoreFileDrops = true;
var flexibleTabBar = false;
var canvasBoxWidth = 10;
var canvasBoxHeight = 10;
var rememberLastGroup = false;

// Global vars
//var thumbnailCanvasWidth = 0;
//var thumbnailCanvasHeight = 0;
var updateTimer = null;
var updateItems = new Array(9);
var updateLayout = false;
var boardWidth;
var boardHeight;
var isFirefox3 = false;
var isFirefox31 = false;
var currentGroup = 1;
var topWindow = null;

function speeddialStartup() {
  // Load bundle
  speedDialBundle = document.getElementById("bundle_speeddial");
  topWindow = SpeedDialUtils.getTopWindow();

  cacheService.addInstance();

  // Detect version
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                        .getService(Components.interfaces.nsIXULAppInfo)
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Components.interfaces.nsIVersionComparator);
  // only if the platform version is 1.9 or greater
  if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
    isFirefox3 = true;
    if (versionChecker.compare(appInfo.platformVersion, "1.9.1a1") >= 0) {
      isFirefox31 = true;
    }
  }
  
  // Load settings
  thumbnailTooltipTitle = gPref.getBoolPref("thumbnailTooltipTitle");
  thumbnailTooltipURL = gPref.getBoolPref("thumbnailTooltipURL");
  thumbnailDragDropExclude = gPref.getBoolPref("thumbnailDragDropExclude");
  thumbnailSequentialUpdate = gPref.getBoolPref("thumbnailSequentialUpdate");
  showThumbnailReloadButton = gPref.getBoolPref("showThumbnailReloadButton");
  showThumbnailDeassignButton = gPref.getBoolPref("showThumbnailDeassignButton");
  showThumbnailNewTabButton = gPref.getBoolPref("showThumbnailNewTabButton");
  showThumbnailNewWindowButton = gPref.getBoolPref("showThumbnailNewWindowButton");
  showThumbnailOpenButton = gPref.getBoolPref("showThumbnailOpenButton");
  showThumbnailBackgroundTabButton = gPref.getBoolPref("showThumbnailBackgroundTabButton");
  showThumbnailEditButton = gPref.getBoolPref("showThumbnailEditButton");
  enableCache = gPref.getBoolPref("enableCache");
  wheelScrollAmount = gPref.getIntPref("wheelScrollAmount");
  screenColumns = gPref.getIntPref("columns");
  defaultMinimumWidth = gPref.getIntPref("minimumWidth");
  defaultWidthModifier = gPref.getIntPref("widthModifier");
  defaultWidthModifierType = gPref.getIntPref("widthModifierType");
  defaultMaximumWidth = gPref.getIntPref("maximumWidth");
  defaultMinimumHeight = gPref.getIntPref("minimumHeight");
  defaultHeightModifier = gPref.getIntPref("heightModifier");
  defaultHeightModifierType = gPref.getIntPref("heightModifierType");
  defaultMaximumHeight = gPref.getIntPref("maximumHeight");
  defaultMaximumHeight = gPref.getIntPref("maximumHeight");
  rightClickAction = gPref.getIntPref("rightClickAction");
  hideThumbnailNumbers = gPref.getBoolPref("hideThumbnailNumbers");
  enableGroups = gPref.getBoolPref("enableGroups");
  imageFormat = gPref.getCharPref("imageFormat");
  ignoreFileDrops = gPref.getBoolPref("ignoreFileDrops");
  flexibleTabBar = gPref.getBoolPref("flexibleTabBar");
  if (enableGroups) {
    numGroups = gPref.getIntPref("numGroups");
    colorizeTabs = gPref.getBoolPref("colorizeTabs");
    rememberTabLastGroup = gPref.getBoolPref("rememberTabLastGroup");
    rememberLastGroup = gPref.getBoolPref("rememberLastGroup");
    // Show tab strip
    document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", false);
  }
  
  if (numGroups < 1) numGroups = 1;
  if (currentGroup >= numGroups) {
    currentGroup = numGroups;
  }
  
  if (!isFirefox3) {
    oldResampling = gPref.getBoolPref("oldResampling");
  }
  
  if (gPref.getBoolPref("mouseOverThumbnailButtons")) {
    document.getElementById("speeddialTabbox").setAttribute("hideThumbButtons", "true");
  }
  
  if (gPref.getBoolPref("mouseOverThumbnailButtonsHighlight")) {
    document.getElementById("speeddialTabbox").setAttribute("hoverThumbButtons", "true");
  } else {
    document.getElementById("speeddialTabbox").setAttribute("hoverThumbButtons", "false");
  }
  
  if (gPref.getBoolPref("hideThumbnailIcons")) {
    document.getElementById("speeddialTabbox").setAttribute("hideThumbIcons", "true");
  }
  
  if (enableGroups) {
    var speedDialTab = null;
    
    if (rememberTabLastGroup) {
      if (topWindow != null) {
        try {
          if (SpeedDialUtils.isFennec()) {
            var tabbrowser = topWindow.Browser;
            for (var i = 0; (i < tabbrowser._tabs.length) && !speedDialTab; i++) {
              var tab = tabbrowser._tabs[i];
              if (tab.browser.contentWindow == window) {
                speedDialTab = tab;
              }
            }
          } else {
            var tabbrowser = topWindow.getBrowser();
            for (var i = 0; (i < tabbrowser.mTabContainer.childNodes.length) && !speedDialTab; i++) {
              var tab = tabbrowser.mTabContainer.childNodes[i];
              if (tab.linkedBrowser.contentWindow == window) {
                speedDialTab = tab;
              }
            }
          }
        } catch(e) {
          alert(e);
        }
      }
    }
    var forceGroup = false;
    if (rememberLastGroup) {
      forceGroup = true;
      currentGroup = gPref.getIntPref("lastGroup");
      if (currentGroup >= numGroups) {
        currentGroup = numGroups;
      } else if (currentGroup < 1) {
        currentGroup = 1;
      }
    }
    // Retrieve current group if necessary
    if (window.location.search) {
      var groupParameter = window.location.search.substr("?group=".length, window.location.search.length);
      currentGroup = parseInt(groupParameter);
      if (currentGroup > 0) {
        forceGroup = true;
        if (currentGroup >= numGroups) {
          currentGroup = numGroups;
        }
      } else {
        currentGroup = 1;
      }
    }
    if (SpeedDialUtils.isFennec()) {
      if ((!forceGroup) && (speedDialTab) && (speedDialTab.speedDialLastGroup)) {
        currentGroup = speedDialTab.speedDialLastGroup;
      }
    } else {
      if ((!forceGroup) && (speedDialTab) && (speedDialTab.hasAttribute("speedDialLastGroup"))) {
        currentGroup = parseInt(speedDialTab.getAttribute("speedDialLastGroup"));
      }
    }
  }
  
  // Generate content
  try {
  generateContent();
  } catch (e) { alert(e); }

  calculateBoardSize();
  
  restoreCanvasSize(false);

  // Register observers
  SpeedDialPrefObserver.addPrefObserver();
  window.addEventListener("resize", sizeChanged, false);
  window.addEventListener("mousedown", windowMouseDown, true);

  /*
  if (gPref.getBoolPref("clearURLBarOnLoad")) {
    // Save selection ranges
    var parentWindow = getParentWindow();
    var urlBar = parentWindow.document.getElementById("urlbar");
    selectionStart = urlBar.selectionStart;
    selectionEnd = urlBar.selectionEnd;
  }
  */
  
  //setTimeout(speeddialAfterLoad, 0);
}
/*
function speeddialAfterLoad() {
  var parentWindow = getParentWindow();
  var urlBar = parentWindow.document.getElementById("urlbar");

  if (gPref.getBoolPref("clearURLBarOnLoad")) {
    urlBar.editor.undo(2);
    // Restore selection ranges
    urlBar.setSelectionRange(selectionStart, selectionEnd);
  }

  if (gPref.getBoolPref("focusURLBarOnLoad")) {
    setTimeout(speeddialFocusURLBar, 0);
  }
}
*/

function tabDragOverEvent(event) {
  var found = false;
  var foundNode = null;
  var currentNode = event.target;
  
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
      foundNode = currentNode;
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    if (currentGroup != foundNode.getAttribute("group")) {
      var tabContainer = document.getElementById("speeddialTabbox-tabs");
      tabContainer.selectedItem = foundNode;
    }
  }
}

function generateContent() {
  var tabContainer = document.getElementById("speeddialTabbox-tabs");
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");
  var selectedPanel = null;
  for (var b=1; b<=numGroups; b++) {
    // Create tab
    var newTab = document.createElement("tab");
    var newTabPanel = document.createElement("tabpanel");
    
    newTab.setAttribute("group", b);
    newTab.setAttribute("crop", "end");
    if (gPref.prefHasUserValue("group-" + b + "-title")) {
      newTab.setAttribute("label", gPref.getComplexValue("group-" + b + "-title", Components.interfaces.nsISupportsString).data);
    } else {
      newTab.setAttribute("label", speedDialBundle.getFormattedString("untitledGroup.label", [b]));
    }
    
    newTab.setAttribute("id", "speedDialTab" + b);
    newTab.setAttribute("ondragover", "tabDragOverEvent(event);");
    
    var newGrid = document.createElement("grid");
    var chromedir = document.getElementById("chromedir").value;
    newGrid.setAttribute("chromedir", chromedir);
    newGrid.setAttribute("class", "grid");
    newGrid.setAttribute("flex", 1);
    
    var columns = document.createElement("columns");
    var column = document.createElement("column");
    var rows = document.createElement("rows");

    column.setAttribute("flex", 1);
    newTab.linkedPanel = "speedDialPanel" + b;
    newTabPanel.setAttribute("id", newTab.linkedPanel);
    newTabPanel.setAttribute("group", b);
    newTabPanel.setAttribute("context", "groupMenu");
    newTabPanel.setAttribute("onpopupshowing", "return showingThumbnailTooltip(event);");
    rows.setAttribute("id", newTab.linkedPanel + "-rows");

    columns.appendChild(column);
    newGrid.appendChild(columns);
    newGrid.appendChild(rows);
    newTabPanel.appendChild(newGrid);
    panelContainer.appendChild(newTabPanel);
    tabContainer.appendChild(newTab);

    if (b == currentGroup) {
      newTab.setAttribute("selected", "true");
      selectedPanel = newTabPanel;
    }

    colorizeTab(newTab, newTabPanel, b);
  }

  // Generate cells
  generateTabCells(currentGroup);
  
  // Select new panel
  panelContainer.selectedPanel = selectedPanel;
}

function colorizeTab(targetTab, targetTabPanel, targetGroup) {
  var colorTab = false;
  var colorTabPanel = false;
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-backgroundColor")) {
    targetTabPanel.style.setProperty("background-color", gPref.getCharPref("group-" + targetGroup + "-backgroundColor"), '');
    targetTabPanel.style.setProperty("background-image", "none", '');
    colorTabPanel = true;
    if (colorizeTabs) {
      targetTab.style.setProperty("background-color", gPref.getCharPref("group-" + targetGroup + "-backgroundColor"), '');
      targetTab.style.setProperty("background-image", "none", '');
      colorTab = true;
    }
  }
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-hideUnused")) {
    if (gPref.getBoolPref("group-" + targetGroup + "-hideUnused")) {
      targetTabPanel.setAttribute("hideUnused", "true");
    }
  }
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-textColor")) {
    targetTabPanel.style.setProperty('color', gPref.getCharPref("group-" + targetGroup + "-textColor"), '');
    colorTabPanel = true;
    if (colorizeTabs) {
      targetTab.style.setProperty('color', gPref.getCharPref("group-" + targetGroup + "-textColor"), '');
      colorTab = true;
    }
  }
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-font")) {
    var fontStyle = gPref.getCharPref("group-" + targetGroup + "-font");
    var styleParts = fontStyle.split('#');

    targetTabPanel.style.setProperty("font-family", styleParts[0], '');
    targetTabPanel.style.setProperty("font-size", "" + styleParts[1] + '%', '');
    if (styleParts[2] > 0) {
      targetTabPanel.style.setProperty("font-weight", "bold", '');
    } else {
      targetTabPanel.style.setProperty("font-weight", "normal", '');
    }
    if (styleParts[3] > 0) {
      targetTabPanel.style.setProperty("font-style", "italic", '');
    } else {
      targetTabPanel.style.setProperty("font-style", "normal", '');
    }
    
    colorTabPanel = true;
  }
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-backImage")) {
    var backgroundImageStyle = gPref.getCharPref("group-" + targetGroup + "-backImage");
    var styleParts = backgroundImageStyle.split('#');
    
    targetTabPanel.style.setProperty("background-image", 'url(' + styleParts[0] + ')', '');
    
    var backPosition = '';
    
    if (styleParts[2] == 't') {
      backPosition = 'top';
    } else if (styleParts[2] == 'b') {
      backPosition = 'bottom';
    } else {
      backPosition = 'center';
    }
    
    backPosition += ' ';
    
    if (styleParts[1] == 'l') {
      backPosition += 'left';
    } else if (styleParts[1] == 'r') {
      backPosition += 'right';
    } else {
      backPosition += 'center';
    }

    targetTabPanel.style.setProperty("background-position", backPosition, '');
    
    targetTabPanel.style.setProperty("background-image", styleParts[0], '');
    
    if (styleParts[3] == 'h') {
      targetTabPanel.style.setProperty("background-repeat", 'repeat-x', '');
    } else if (styleParts[3] == 'v') {
      targetTabPanel.style.setProperty("background-repeat", 'repeat-y', '');
    } else if (styleParts[3] == 'b') {
      targetTabPanel.style.setProperty("background-repeat", 'repeat', '');
    } else {
      targetTabPanel.style.setProperty("background-repeat", 'no-repeat', '');
    }
    colorTabPanel = true;
  }
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-style")) {
    var advancedStyles = gPref.getCharPref("group-" + targetGroup + "-style").split(/[;\n]/);
    for (var c=0;c<advancedStyles.length;c++) {
      if (advancedStyles[c].indexOf(':') > -1) {
        var currentStyleParts = advancedStyles[c].split(':');
        var cssKey = SpeedDialUtils.trim(currentStyleParts[0]);
        var cssValue = SpeedDialUtils.trim(currentStyleParts[1]);
        if (cssKey.length > 0) {
          targetTabPanel.style.setProperty(cssKey, cssValue, '');
        }
      }
    }
    colorTabPanel = true;
  }
  
  if (colorTabPanel) {
    targetTabPanel.style.setProperty('-moz-appearance', "none", '');
  }

  if (colorTab) {
    targetTab.style.setProperty('-moz-appearance', "none", '');
  }
}

function generateTabCells(selectedGroup) {
  var targetPanelRows = document.getElementById("speedDialPanel" + selectedGroup + "-rows");
  var screenRows;
  var screenColumns;
  var currentDial = SpeedDialUtils.getGroupFirstDialNumber(selectedGroup);
  
  if (gPref.prefHasUserValue("group-" + selectedGroup + "-rows")) {
    screenRows = gPref.getIntPref("group-" + selectedGroup + "-rows");
  } else {
    screenRows = gPref.getIntPref("rows");
  }
  if (gPref.prefHasUserValue("group-" + selectedGroup + "-columns")) {
    screenColumns = gPref.getIntPref("group-" + selectedGroup + "-columns");
  } else {
    screenColumns = gPref.getIntPref("columns");
  }
  
  var cellMaxWidth = Math.floor(100/screenColumns);

  for (var c=1; c<=screenRows; c++) {
    var newRow = document.createElement("row");
    newRow.setAttribute("flex", 1);
    var newRowBox = document.createElement("hbox");
    newRowBox.setAttribute("flex", 1);
    for (var d=1; d<=screenColumns; d++) {
      var newCell = document.createElement("box");
      newCell.setAttribute("id", "speeddial" + currentDial);
      newCell.setAttribute("speeddial", currentDial);
      newCell.setAttribute("class", "speeddialThumb");
      if (rightClickAction == 6) {
        newCell.setAttribute("context", "thumbMenu");
      }
      newCell.style.maxWidth = cellMaxWidth + "%";
      newCell.style.width = newCell.style.maxWidth;
      newCell.style.minWidth = newCell.style.maxWidth;
      newRowBox.appendChild(newCell);
      currentDial++;
    }
    newRow.appendChild(newRowBox);
    targetPanelRows.appendChild(newRow);
  }
  document.getElementById("speedDialPanel" + selectedGroup).setAttribute("initiated", true);
}

function checkSelectedPanel() {
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");
  
  if (currentGroup != (panelContainer.selectedIndex + 1)) {
    currentGroup = panelContainer.selectedIndex + 1;
    
    if (rememberLastGroup) {
      gPref.setIntPref("lastGroup", currentGroup);
    }

    if (!panelContainer.selectedPanel.hasAttribute("initiated")) {
      generateTabCells(currentGroup);
    }
    sizeChanged();
  }
  /*
  var initialDial = currentGroup * screenRows * screenColumns + 1;
  // Update thumbnails
  for (var c=initialDial; c<=(initialDial + screenRows * screenColumns); c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail) {
      currentThumbnail.updateThumbnail();
    }
    updateItems[c] = false;
  }
  */
}

function destroyContent() {
  var tabContainer = document.getElementById("speeddialTabbox-tabs");
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");

  for (var c=tabContainer.childNodes.length-1; c>=0; c--) {
    var currentElement = tabContainer.childNodes[c];
    if (currentElement.localName == "tab") {
      var targetPanel = document.getElementById(currentElement.linkedPanel);
      
      // Take out tab
      panelContainer.removeChild(targetPanel);
      tabContainer.removeChild(currentElement);
    }
  }
}

function checkThumbnailDragDropExcludeCanvas(event) {
  if (thumbnailDragDropExclude) {
    event.stopPropagation();
  }
}

function speeddialFocusURLBar() {
  var parentWindow = getParentWindow();
  var urlBar = parentWindow.document.getElementById("urlbar");
  urlBar.focus();
  urlBar.select();
}

function speeddialUnload() {
  // Unregister observers
  SpeedDialPrefObserver.removePrefObserver();
  window.removeEventListener("resize", sizeChanged, false);
  window.removeEventListener("mousedown", windowMouseDown, true);

  cacheService.removeInstance();
  if (!enableCache) {
    if (cacheService.getNumberInstances() <= 0) {
      // Nullify cache
      var totalDials = SpeedDialUtils.getTotalDials();
      for (var c=0; c<totalDials; c++) {
        cacheService.setImage(null, c);
      }
    }
  }
  
  if (rememberTabLastGroup) {
    // Remember current group
    if (SpeedDialUtils.isFennec()) {
      var tabbrowser = topWindow.Browser;
      var foundTab = false;
      for (var i = 0; (i < tabbrowser._tabs.length) && !foundTab; i++) {
        var tab = tabbrowser._tabs[i];
        if (tab.browser.contentWindow == window) {
          tab.speedDialLastGroup = currentGroup;
          foundTab = true;
        }
      }
    } else {
      var tabbrowser = topWindow.getBrowser();
      var foundTab = false;
      for (var i = 0; (i < tabbrowser.mTabContainer.childNodes.length) && !foundTab; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.contentWindow == window) {
          tab.setAttribute("speedDialLastGroup", currentGroup);
          foundTab = true;
        }
      }
    }
  }
}

function restoreCanvasSize(sequentialUpdate) {
  var screenRows;
  var screenColumns;
  
  if (gPref.prefHasUserValue("group-" + currentGroup + "-rows")) {
    screenRows = gPref.getIntPref("group-" + currentGroup + "-rows");
  } else {
    screenRows = gPref.getIntPref("rows");
  }
  if (gPref.prefHasUserValue("group-" + currentGroup + "-columns")) {
    screenColumns = gPref.getIntPref("group-" + currentGroup + "-columns");
  } else {
    screenColumns = gPref.getIntPref("columns");
  }

//  if (marginHorizontal < 0) {
  // Update thumbnails for current group
  var initialDial = SpeedDialUtils.getGroupFirstDialNumber(currentGroup);
  var initialCell = document.getElementById("speeddial" + initialDial);

  var canvasBox = initialCell.getCanvasBox();
  var canvasBoxStyle = document.defaultView.getComputedStyle(canvasBox,null);
  canvasBoxWidth = parseFloat(canvasBoxStyle.getPropertyValue("width"));
  canvasBoxHeight = parseFloat(canvasBoxStyle.getPropertyValue("height"));
  
//  var canvasBox = document.getBoxObjectFor(initialCell.getCanvasBox());
//    thumbnailCanvasWidth = canvasBox.width - 2;
//    thumbnailCanvasHeight = canvasBox.height - 2;
//  }

//  if (thumbnailCanvasWidth < 0) {
//    thumbnailCanvasWidth = Math.floor((boardWidth - marginHorizontal) / screenColumns);
//    thumbnailCanvasHeight = Math.floor((boardHeight - marginVertical) / screenRows);
//  }

  // Update thumbnails
  for (var c=initialDial; c<(initialDial + screenRows * screenColumns); c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail)
      currentThumbnail.updateThumbnail();
    updateItems[c] = false;
  }
}

function getCanvasBoxWidth() {
  return canvasBoxWidth;
}

function getCanvasBoxHeight() {
  return canvasBoxHeight;
}

function nullifyCanvasSize() {
  var totalDials = SpeedDialUtils.getTotalDials();

  for (var c=1; c<=totalDials; c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail) {
      currentThumbnail.nullifyCanvas();
    }
  }
}

function updatePendingItems() {
  var totalDials = SpeedDialUtils.getTotalDials();

  for (var c=1; c<=totalDials; c++) {
    if (updateItems[c]) {
      var currentThumbnail = document.getElementById("speeddial" + c);
      if (currentThumbnail) {
        currentThumbnail.updateThumbnail();
      }
      updateItems[c] = false;
    }
  }
}

function openURL(targetUrl, number, where) {
  if (!targetUrl) return;

  var parentWindow = getParentWindow();
/*
  if (where == "current") {
    document.location = url;
  } else {
    parentWindow.openUILinkIn(url, where);
  }
*/
  if (SpeedDialUtils.stringStartsWith(targetUrl, "weather:")) {
      var weatherLocation = '';
      if (gPref.prefHasUserValue("thumbnail-" + number + "-extra")) {
        var thumbnailExtras =  gPref.getCharPref("thumbnail-" + number + "-extra").split('#');
        if ((thumbnailExtras[0]) && (thumbnailExtras[0] != '')) {
          weatherLocation = decodeURI(thumbnailExtras[0]);
        }
      }
      if (weatherLocation == '') {
        weatherLocation = targetUrl.substr("weather:".length);
        if (weatherLocation.indexOf('#') > -1) {
          weatherLocation = weatherLocation.substring(0, weatherLocation.indexOf('#'));
        }
      }
      if (weatherLocation != '') {
        targetUrl = 'http://www.actuweather.com/report/?poi=' + encodeURI(weatherLocation);
      } else {
        targetUrl = 'http://www.actuweather.com/';
      }
  } else if (SpeedDialUtils.stringStartsWith(targetUrl, "javascript:")) {
    parentWindow.SpeedDial.evaluateString(targetUrl.substr("javascript:".length));
    return;
  } else if (SpeedDialUtils.stringStartsWith(targetUrl, "launch:")) {
    SpeedDialUtils.launch(targetUrl.substr("launch:".length));
    return;
  } else if (SpeedDialUtils.stringStartsWith(targetUrl, "plugin:")) {
    targetUrl = targetUrl.substr("plugin:".length);
  } else if (SpeedDialUtils.stringStartsWith(targetUrl, "nothing:")) {
    return;
  }
  
  var urls;

  // openUILinkIn doesn't handle loading multiple pages
  switch (where) {
    case "save":
      urls = SpeedDialUtils.getDistinctUrls(targetUrl);
      parentWindow.saveURL(urls[0], null, null, true);  // only save the first page
      break;
    case "current":
      // If opening group dial and trying to open while in Speed Dial tab, select group directly
      if (SpeedDialUtils.stringStartsWith(targetUrl, "chrome://speeddial/content/speeddial.xul?group=")) {
        var targetGroup = parseInt(targetUrl.substring("chrome://speeddial/content/speeddial.xul?group=".length));
        document.getElementById("speeddialTabbox").selectedIndex = targetGroup;
      } else {
        parentWindow.SpeedDial.loadOneOrMoreURIs(targetUrl);
      }
      break;
    case "tabshifted":
    case "tab":
      urls = SpeedDialUtils.getDistinctUrls(targetUrl);
      parentWindow.getBrowser().loadTabs(urls, (where == "tabshifted"));
      break;
    case "window":
      var newWindow = parentWindow.OpenBrowserWindow();
      newWindow.addEventListener("DOMContentLoaded", function() { newWindow.arguments[0] = targetUrl; }, false);
      break;
  }
}

function contextEditGroup() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if ((currentNode.localName == "tab") ||
        (currentNode.localName == "tabpanel")) {
      found = true;
      foundIndex = currentNode.getAttribute("group");
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ foundIndex ]);
  }
}

function contextOpenGroupInTabs() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if ((currentNode.localName == "tab") ||
        (currentNode.localName == "tabpanel")) {
      found = true;
      foundIndex = currentNode.getAttribute("group");
    }
    currentNode = currentNode.parentNode;
  }

  if (found) {
    var screenRows;
    var screenColumns;
    
    if (gPref.prefHasUserValue("group-" + foundIndex + "-rows")) {
      screenRows = gPref.getIntPref("group-" + foundIndex + "-rows");
    } else {
      screenRows = gPref.getIntPref("rows");
    }
    if (gPref.prefHasUserValue("group-" + foundIndex + "-columns")) {
      screenColumns = gPref.getIntPref("group-" + foundIndex + "-columns");
    } else {
      screenColumns = gPref.getIntPref("columns");
    }
  
    var initialDial = SpeedDialUtils.getGroupFirstDialNumber(foundIndex);
    var openedFirst = false;
    for (var c=initialDial; c<(initialDial + screenRows * screenColumns); c++) {
      if (gPref.prefHasUserValue("thumbnail-" + c + "-url")) {
        var url = gPref.getCharPref("thumbnail-" + c + "-url");
        if (!openedFirst) {
          openURL(url, c, "tab");
          openedFirst = true;
        } else {
          openURL(url, c, "tabshifted");
        }
      }
    }
  }
}

function contextOrganizeGroups() {
  openDialog("chrome://speeddial/content/organizeGroups.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent");
}

function contextAddGroup() {
  openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ -1 ]);
}

function contextRemoveGroup() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
      foundIndex = parseInt(currentNode.getAttribute("group"));
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    SpeedDialUtils.removeGroup(foundIndex, true);
    var totalGroups = gPref.getIntPref("numGroups");
    if (currentGroup > totalGroups) {
      currentGroup--;
    }
  }
}

function editThumbnail(thumbNumber) {
  // Determine mode
  var editUrl = "chrome://speeddial/content/editDial.xul";
  if (gPref.prefHasUserValue("thumbnail-" + thumbNumber + "-url")) {
    var targetUrl = gPref.getCharPref("thumbnail-" + thumbNumber + "-url");
    if (SpeedDialUtils.stringStartsWith(targetUrl, "weather:")) {
      editUrl = "chrome://speeddial/content/editWeatherDial.xul";
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "launch:")) {
      editUrl = "chrome://speeddial/content/editLaunchDial.xul";
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "plugin:")) {
      editUrl = "chrome://speeddial/content/editPluginDial.xul";
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "chrome://speeddial/content/speeddial.xul?group=")) {
      editUrl = "chrome://speeddial/content/editGroupDial.xul";
    }
  }
  
  openDialog(editUrl, "",
             "centerscreen,chrome,dialog,resizable,dependent", [ thumbNumber ]);
}

function refreshThumbnail(thumbNumber) {
  // Clear extra information
  if (gPref.prefHasUserValue("thumbnail-" + thumbNumber + "-extra")) {
    gPref.setCharPref("thumbnail-" + thumbNumber + "-extra", "");
  }
  gPref.setBoolPref("thumbnail-" + thumbNumber + "-manualrefresh", true);
}

function refreshGroupThumbnails(targetGroup) {
  var firstDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup);
  var targetTotal = SpeedDialUtils.getGroupTotalDials(targetGroup);
  
  
  for (var c=firstDial; c<(firstDial + targetTotal); c++) {
    if (gPref.prefHasUserValue("thumbnail-" + c + "-url")) {
      // Clear extra information
      if (gPref.prefHasUserValue("thumbnail-" + c + "-extra")) {
        gPref.clearUserPref("thumbnail-" + c + "-extra");
      }
      gPref.setBoolPref("thumbnail-" + c + "-manualrefresh", true);
    }
  }
}

function refreshCurrentGroupThumbnails() {
  refreshGroupThumbnails(currentGroup);
}

function contextRefreshAll() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if ((currentNode.localName == "tab") ||
        (currentNode.localName == "tabpanel")) {
      found = true;
      foundIndex = currentNode.getAttribute("group");
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    refreshGroupThumbnails(foundIndex);
  }
}

function contextSettings() {
  SpeedDialUtils.showOptions();
}

function showingThumbnailTooltip(event) {
  event.stopPropagation();

  var currentTitle = document.getElementById("thumbnailTooltipTitle");
  var currentURL = document.getElementById("thumbnailTooltipURL");
  var showTooltip = false;

  var targetNode = document.tooltipNode;
  while (targetNode && (!targetNode.parentThumbnail)) {
    targetNode = targetNode.parentNode;
  }
  if (targetNode.parentThumbnail)
    targetNode = targetNode.parentThumbnail;

  if (thumbnailTooltipTitle && targetNode.hasAttribute("thumbnailTitle")) {
    currentTitle.removeAttribute("hidden");
    currentTitle.value = targetNode.getAttribute("thumbnailTitle");
    showTooltip = true;
  } else {
    currentTitle.setAttribute("hidden", true);
  }

  if (thumbnailTooltipURL && targetNode.hasAttribute("thumbnailURL")) {
    currentURL.removeAttribute("hidden");
    currentURL.value = targetNode.getAttribute("thumbnailURL");
    showTooltip = true;
  } else {
    currentURL.setAttribute("hidden", true);
  }
  return showTooltip;
}

function getParentWindow() {
  return topWindow;
}

function getThumbnailImageURL(thumbnailNumber) {
  var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
  var fileExtension = imageFormat;
  if (gPref.prefHasUserValue("thumbnail-" + thumbnailNumber + "-format")) {
    fileExtension = gPref.getCharPref("thumbnail-" + thumbnailNumber + "-format");
  }
  file.append(SpeedDialUtils.thumbFolder);
  if (!gPref.prefHasUserValue("thumbnail-" + thumbnailNumber + "-lastsaved")) {
    file.append("thumbnail-" + thumbnailNumber + "." + fileExtension);
  } else {
    file.append("thumbnail-" + thumbnailNumber + "-" + gPref.getCharPref("thumbnail-" + thumbnailNumber + "-lastsaved") + "." + fileExtension);
  }
  if (file.exists() && !file.isDirectory()) {
    return SpeedDialUtils.ioService.newFileURI(file).spec;
  } else {
    return null;
  }
}


//function getThumbnailCanvasWidth() {
//  return thumbnailCanvasWidth;
//}

//function getThumbnailCanvasHeight() {
//  return thumbnailCanvasHeight;
//}

function checkShouldShowContextMenu(thumbNumber) {
  var thumbMenu = document.getElementById("thumbMenu");
  var showItems;
  
  if (gPref.prefHasUserValue("thumbnail-" + thumbNumber + "-url")) {
    showItems = true;
  } else {
    showItems = false;
  }
  
  for (var c=0; c<thumbMenu.childNodes.length; c++) {
    if ((thumbMenu.childNodes[c].getAttribute("id") != "context-edit") &&
        (thumbMenu.childNodes[c].getAttribute("id") != "context-refreshall")) {
      if ((thumbMenu.childNodes[c].getAttribute("id") == "context-movetogroup") && showItems) {
        thumbMenu.childNodes[c].setAttribute("hidden", (numGroups < 2));
      } else {
        thumbMenu.childNodes[c].setAttribute("hidden", !showItems);
      }
    }
  }
  
  return true;
}

function moveToGroupPopupShowing(event) {
  var menu = event.target;
  var addedMenuEntries = false;
  
  // Empty current
  while (menu.firstChild)
    menu.removeChild(menu.firstChild);
  
  for (var c=1; c<=numGroups; c++) {
    if (c != currentGroup) {
      var initialDial = SpeedDialUtils.getGroupFirstDialNumber(c);
      var screenRows;
      var screenColumns;
      var foundFreeDial = false;
      
      if (gPref.prefHasUserValue("group-" + c + "-rows")) {
        screenRows = gPref.getIntPref("group-" + c + "-rows");
      } else {
        screenRows = gPref.getIntPref("rows");
      }
      if (gPref.prefHasUserValue("group-" + c + "-columns")) {
        screenColumns = gPref.getIntPref("group-" + c + "-columns");
      } else {
        screenColumns = gPref.getIntPref("columns");
      }
      
      for (var d=(initialDial + screenRows * screenColumns - 1); (d>=initialDial) && !foundFreeDial; d--) {
        if (!gPref.prefHasUserValue("thumbnail-" + d + "-url")) {
          foundFreeDial = true;
        }
      }
      
      if (foundFreeDial) {
        var item = document.createElement("menuitem");
        if (gPref.prefHasUserValue("group-" + c + "-title")) {
          item.setAttribute("label", gPref.getComplexValue("group-" + c + "-title", Components.interfaces.nsISupportsString).data);
        } else {
          item.setAttribute("label",  speedDialBundle.getFormattedString("untitledGroup.label", [c]));
        }
        item.setAttribute("group", c);
        menu.appendChild(item);
        addedMenuEntries = true;
      }
    }
  }
  
  if (!addedMenuEntries) {
    var menuitem = document.createElement("menuitem");
    menuitem.setAttribute("label", speedDialBundle.getString("empty.label"));
    menuitem.setAttribute("disabled", "true");
    menu.appendChild(menuitem);
  }
}

function moveToGroup(event) {
  try {
  var menuitem = event.target;
  var targetDial = parseInt(document.popupNode.getAttribute('speeddial'));
  var freeDial = -1;
  var initialDial;
  var screenRows;
  var screenColumns;
  var targetGroup;
  
  if (!menuitem.hasAttribute("group")) return true;
  
  targetGroup = parseInt(menuitem.getAttribute("group"))
  initialDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup);
  
  if (gPref.prefHasUserValue("group-" + targetGroup + "-rows")) {
    screenRows = gPref.getIntPref("group-" + targetGroup + "-rows");
  } else {
    screenRows = gPref.getIntPref("rows");
  }
  if (gPref.prefHasUserValue("group-" + targetGroup + "-columns")) {
    screenColumns = gPref.getIntPref("group-" + targetGroup + "-columns");
  } else {
    screenColumns = gPref.getIntPref("columns");
  }
  
  for (var d=initialDial; ((d<(initialDial + screenRows * screenColumns)) && (freeDial < 1)); d++) {
    if (!gPref.prefHasUserValue("thumbnail-" + d + "-url")) {
      freeDial = d;
    }
  }
  
  if (freeDial > -1) {
    SpeedDialUtils.swapThumbnails(freeDial, targetDial);
  }
  } catch (e) { alert(e); }
  
  return true;
}

function sizeChanged() {
/*
  var innerBox = document.getElementById("speeddialBox");
  
  if ((innerBox.boxObject.width < boardWidth) || (innerBox.boxObject.height < boardHeight)) {
    boardWidth = innerBox.boxObject.width;
    boardHeight = innerBox.boxObject.height;
    nullifyCanvasSize();
    setTimeout(restoreCanvasSize, 0);
  } else {
    restoreCanvasSize();
  }
*/
//  nullifyCanvasSize();
//  setTimeout(restoreCanvasSize, 0, false);
//  thumbnailCanvasWidth = -1;
//  thumbnailCanvasHeight = -1;

  calculateBoardSize();

  restoreCanvasSize(false);
}

function windowMouseDown(el) {
  if (el.button == 1) {
    el.stopPropagation();
//    el.preventDefault();
  }
}

var SpeedDialPrefObserver = 
{
  prefObserver : {
    observe: function(subject, topic, data) {
    // subject is the nsIPrefBranch we're observing (after appropriate QI)
    // data is the name of the pref that's been changed (relative to subject)
    var updateAllThumbnails = false;
    var updatePendingThumbnails = false;

    if (topic == "nsPref:changed") {
      if (data.indexOf("extensions.speeddial.thumbnail-") == 0) {
        // A thumbnail is updated!
        var number = (data.split("-", 2))[1];
        var totalDials = SpeedDialUtils.getTotalDials();
        if (number <= totalDials) {
          updateItems[number] = true;
          updatePendingThumbnails = true;
        }
      } else {
        var updateSize = false;
        if (data == "extensions.speeddial.thumbnailTooltipTitle") {
          thumbnailTooltipTitle = gPref.getBoolPref("thumbnailTooltipTitle");
        } else if (data == "extensions.speeddial.thumbnailTooltipTitle") {
          thumbnailTooltipURL = gPref.getBoolPref("thumbnailTooltipURL");
        } else if (data == "extensions.speeddial.thumbnailDragDropExclude") {
          thumbnailDragDropExclude = gPref.getBoolPref("thumbnailDragDropExclude");
        } else if (data == "extensions.speeddial.showThumbnailReloadButton") {
          showThumbnailReloadButton = gPref.getBoolPref("showThumbnailReloadButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailDeassignButton") {
          showThumbnailDeassignButton = gPref.getBoolPref("showThumbnailDeassignButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailNewTabButton") {
          showThumbnailNewTabButton = gPref.getBoolPref("showThumbnailNewTabButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailNewWindowButton") {
          showThumbnailNewWindowButton = gPref.getBoolPref("showThumbnailNewWindowButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailEditButton") {
          showThumbnailEditButton = gPref.getBoolPref("showThumbnailEditButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailBackgroundTabButton") {
          showThumbnailBackgroundTabButton = gPref.getBoolPref("showThumbnailBackgroundTabButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailOpenButton") {
          showThumbnailOpenButton = gPref.getBoolPref("showThumbnailOpenButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.whellScrollAmount") {
          whellScrollAmount = gPref.getIntPref("whellScrollAmount");
        } else if (data == "extensions.speeddial.enableCache") {
          enableCache = gPref.getBoolPref("enableCache");
        } else if (data == "extensions.speeddial.minimumWidth") {
          defaultMinimumWidth = gPref.getIntPref("minimumWidth");
          updateSize = true;
        } else if (data == "extensions.speeddial.widthModifier") {
          defaultWidthModifier = gPref.getIntPref("widthModifier");
          updateSize = true;
        } else if (data == "extensions.speeddial.widthModifierType") {
          defaultWidthModifierType = gPref.getIntPref("widthModifierType");
          updateSize = true;
        } else if (data == "extensions.speeddial.maximumWidth") {
          defaultMaximumWidth = gPref.getIntPref("maximumWidth");
          updateSize = true;
        } else if (data == "extensions.speeddial.minimumHeight") {
          defaultMinimumHeight = gPref.getIntPref("minimumHeight");
          updateSize = true;
        } else if (data == "extensions.speeddial.heightModifier") {
          defaultHeightModifier = gPref.getIntPref("heightModifier");
          updateSize = true;
        } else if (data == "heightModifierType") {
          defaultHeightModifierType = gPref.getIntPref("heightModifierType");
          updateSize = true;
        } else if (data == "extensions.speeddial.maximumHeight") {
          defaultMaximumHeight = gPref.getIntPref("maximumHeight");
          updateSize = true;
        } else if (data == "extensions.speeddial.rightClickAction") {
          rightClickAction = gPref.getIntPref("rightClickAction");
          updateAllThumbnails = true;
          updateLayout = true;
        } else if (data == "extensions.speeddial.imageFormat") {
          imageFormat = gPref.getCharPref("imageFormat");
        } else if ((data == "extensions.speeddial.oldResampling") && (!isFirefox3)) {
          oldResampling = gPref.getBoolPref("oldResampling");
        } else if (data == "extensions.speeddial.mouseOverThumbnailButtons") {
          document.getElementById("speeddialTabbox").setAttribute("hideThumbButtons", gPref.getBoolPref("mouseOverThumbnailButtons"));
        } else if (data == "extensions.speeddial.hideThumbnailNumbers") {
          hideThumbnailNumbers = gPref.getBoolPref("hideThumbnailNumbers");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.hideThumbnailIcons") {
          document.getElementById("speeddialTabbox").setAttribute("hideThumbIcons", gPref.getBoolPref("hideThumbnailIcons"));
        } else if (data == "extensions.speeddial.colorizeTabs") {
          colorizeTabs = gPref.getBoolPref("colorizeTabs");
          if (enableGroups) {
            updateAllThumbnails = true;
            updateLayout = true;
          }
        } else if (data == "extensions.speeddial.flexibleTabBar") {
          flexibleTabBar = gPref.getBoolPref("flexibleTabBar");
        } else if (data == "extensions.speeddial.enableGroups") {
          enableGroups = gPref.getBoolPref("enableGroups");
          if (enableGroups) {
            document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", false);
            numGroups = gPref.getIntPref("numGroups");
            colorizeTabs = gPref.getBoolPref("colorizeTabs");
            if (numGroups < 1) numGroups = 1;
          } else {
            document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", true);
            numGroups = 1;
          }
          updateAllThumbnails = true;
          updateLayout = true;
        } else if (data == "extensions.speeddial.numGroups") {
          if (enableGroups) {
            numGroups = gPref.getIntPref("numGroups");
            if (numGroups < 1) numGroups = 1;
            updateAllThumbnails = true;
            updateLayout = true;
          }
        } else if (data.indexOf("extensions.speeddial.group-") == 0) {
          var number = (data.split("-", 2))[1];
          if ((number == 1) || (enableGroups)) {
            updateAllThumbnails = true;
            updateLayout = true;
          }
        }
        
        if (updateSize) {
          sizeChanged();
        }
      }
      if (updateAllThumbnails) {
        var totalDials = SpeedDialUtils.getTotalDials();
        for (var c=1; c<=totalDials; c++) {
          updateItems[c] = true;
        }
      }

      if (updateAllThumbnails || updatePendingThumbnails) {
        if (updateTimer == null) {
          updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        updateTimer.cancel();
        updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
      }
    }
  },

  QueryInterface : function (aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) || 
    aIID.equals(Components.interfaces.nsITimerCallback) ||
    aIID.equals(Components.interfaces.nsISupports) ||
    aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

    notify: function(timer) {
      if (updateLayout) {
        destroyContent();
        generateContent();
//        thumbnailCanvasWidth = -1;
//        thumbnailCanvasHeight = -1;
        sizeChanged();
        restoreCanvasSize(false);
      } else {
        updatePendingItems();
      }
    }
  },

  addPrefObserver : function () {
    globalPrefs.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    globalPrefs.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
  }
};

// Firefox 3.5 and newer 
var newDragDropHandler = {
  onDragStart: function(event) {
    var dt = event.dataTransfer;
    var targetEntry = event.currentTarget.getAttribute("speeddial");
    var value;
    var title;
  
    if (gPref.prefHasUserValue("thumbnail-" + targetEntry + "-url")) {
      value = gPref.getCharPref("thumbnail-" + targetEntry + "-url");
    } else {
      return null;
    }
  
    if (gPref.prefHasUserValue("thumbnail-" + targetEntry + "-label")) {
      title = gPref.getCharPref("thumbnail-" + targetEntry + "-label");
    } else {
      title = "";
    }
  
    if (title == "") {
      title = speedDialBundle.getString("untitled.label");
    }
    
    var urlString = value + "\n" + title;
    var htmlString = "<a href=\"" + value + "\">" + title + "</a>";
    dt.setData("text/x-speeddial-entry", targetEntry);
    if ((value == "") || (value == "about:blank")) {
      dt.setData("text/unicode", value);
    } else {
      dt.setData("text/x-moz-url", urlString);
      dt.setData("text/unicode", value);
      dt.setData("text/html", htmlString);
      //dt.setData("application/x-bookmark", bookmarkString);
      dt.setData("text/uri-list", value);
      dt.setData("text/plain", urlString);
    }
  },
  
  onDragOver: function(event) {
    var types = event.dataTransfer.types;
    var supportedTypes = ["text/x-speeddial-entry", "application/x-moz-file", "text/x-moz-url", "text/uri-list", "text/x-moz-text-internal" ];
    types = supportedTypes.filter(function(value) { return types.contains(value); });
    if (types.length) {
      event.preventDefault();
    }
  },
  
  onDrop: function(event) {
    var targetDial = event.currentTarget.getAttribute("speeddial");
    var types = event.dataTransfer.types;
    var supportedTypes = ["text/x-speeddial-entry", "application/x-moz-file", "text/x-moz-url", "text/uri-list", "text/x-moz-text-internal" ];
    types = supportedTypes.filter(function(value) { return types.contains(value); });
    if (types.length) {
      if (types[0] == "text/x-speeddial-entry") {
        var originalDial = event.dataTransfer.getData(types[0]);
  
        if (originalDial == targetDial) {
          return;
        }
  
        if (event.dataTransfer.dropEffect == "move") {
          SpeedDialUtils.swapThumbnails(originalDial, targetDial);
        } else {
          SpeedDialUtils.deassignThumbnail(targetDial);
          SpeedDialUtils.copyThumbnailData(originalDial, targetDial);
          // Copy image
          SpeedDialUtils.copyThumbnailImage(originalDial, targetDial);
  
          // Update cache...
          if (enableCache || oldResampling) {
            cacheService.setImage(getThumbnailImageURL(targetDial), targetDial);
          }
        }
      } else if (types[0] == "application/x-moz-file") {
        var file = event.dataTransfer.mozGetDataAt("application/x-moz-file", 0);
        if (file instanceof Components.interfaces.nsIFile) {
          var text = file.path;
          // Delete thumbnail
          SpeedDialUtils.deassignThumbnail(targetDial);
          
          gPref.setCharPref("thumbnail-" + targetDial + "-url", "launch:" + text);
          gPref.setBoolPref("thumbnail-" + targetDial + "-js", false);
          gPref.setIntPref("thumbnail-" + targetDial + "-layout", 3);
          
          var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
          var position = text.lastIndexOf("\\");
          if (position < 0) {
            position = text.lastIndexOf("/");
          }
          if (position == text.length - 1) {
            position = text.lastIndexOf("\\", text.length - 2);
            if (position < 0) {
              position = text.lastIndexOf("/", text.length - 2);
            }
          }
          if (position > -1) {
            str.data = text.substring(position + 1);
          } else {
            str.data = text;
          }
          
          gPref.setComplexValue("thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
          
          if (!SpeedDialUtils.isFirefox3()) {
            gPref.setCharPref("thumbnail-" + targetDial + "-icon", "data:");
          }
          
        }
      } else {
        var url;
        var title = "";
        if (types[0] == "text/x-moz-url") {
          var lines = event.dataTransfer.getData("text/x-moz-url").split("\n");
          if (lines.length < 2)
            return;
          title = lines[1];
          url = lines[0];
        } else if (types[0] == "text/x-moz-text-internal") {
          url = event.dataTransfer.mozGetDataAt("text/x-moz-text-internal", 0);
        } else { //if (types[0] == "text/uri-list") {
          var links = event.dataTransfer.getData("text/uri-list").split("\n");
          var foundFirstLink = false;
          var currentLinkIndex = 0;
          while (!foundFirstLink && (currentLinkIndex < links.length)) {
            if (links[currentLinkIndex].indexOf("#") != 0) {
              foundFirstLink = true;
              url = links[0];
            }
            currentLinkIndex++;
          }
          if (!foundFirstLink) return;
        }
        if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
          /^\s*(javascript|data):/.test(url))
          return;
        
        // Clean previous
        SpeedDialUtils.deassignThumbnail(targetDial);
        
        // Just add the information...
        gPref.setCharPref("thumbnail-" + targetDial + "-url", url);
  
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
        str.data = title;
        gPref.setComplexValue("thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
  
        if (!isFirefox3) {
          gPref.setCharPref("thumbnail-" + targetDial + "-icon", "data:");
        }
        
        gPref.setBoolPref("thumbnail-" + targetDial + "-dynamictitle", (title == ""));
  
        // add time intervals
        var defaultRefreshInterval = gPref.getIntPref("defaultRefreshInterval");
        if (defaultRefreshInterval > 0) {
          gPref.setIntPref("thumbnail-" + targetDial + "-refreshinterval", defaultRefreshInterval);
        } else {
          if (gPref.prefHasUserValue("thumbnail-" + targetDial + "-refreshinterval")) {
            gPref.clearUserPref("thumbnail-" + targetDial + "-refreshinterval");
          }
        }
  
        // add default javascript
        var defaultJs = gPref.getBoolPref("defaultDialJavascript");
        gPref.setBoolPref("thumbnail-" + targetDial + "-js", defaultJs);
      }
    }
//      var data = event.dataTransfer.getData(types[0]);
    event.preventDefault();
  }
};

// Drag & drop
var thumbnailObserver = {
  onDragStart: function (evt,transferData,action) {
    transferData.data = createTransferDataForEntry(evt.currentTarget.getAttribute("speeddial"));
    if (transferData.data == null)
      return false;
    return true;
  },

  getSupportedFlavours : function () {
    var flavours = new FlavourSet();
    
    flavours.appendFlavour("text/x-speeddial-entry");
    flavours.appendFlavour("text/x-moz-url");
    if (!ignoreFileDrops) {
      flavours.appendFlavour("application/x-moz-file", "nsIFile");
    }
    return flavours;
  },

  canDrop: function(aEvent, mDragSession) {
    return true;
  },

  onDragOver: function (evt,flavour,session) {
    session.canDrop = true;
  },

  onDragExit: function (aEvent, aDragSession) {
  },

  onDrop: function (aEvent,dropdata,session) {
try {
    const kDSIID      = Components.interfaces.nsIDragService;
    const kCopyAction = kDSIID.DRAGDROP_ACTION_COPY + kDSIID.DRAGDROP_ACTION_LINK;
    var moveIfPossible = !(session.dragAction & kCopyAction);

    var targetDial = aEvent.currentTarget.getAttribute("speeddial");

    var targetData = getSelectionFromXferData(session);
    
    if (targetData.type == "speedDialId") {
      var originalDial = targetData.value;

      if (originalDial == targetDial) {
//        openURL(gPref.getCharPref("thumbnail-" + targetDial + "-url"), originalDial, "current");
        return;
      }

      if (moveIfPossible) {
        SpeedDialUtils.swapThumbnails(originalDial, targetDial);
      } else {
        SpeedDialUtils.deassignThumbnail(targetDial);
        SpeedDialUtils.copyThumbnailData(originalDial, targetDial);
        // Copy image
        SpeedDialUtils.copyThumbnailImage(originalDial, targetDial);

        // Update cache...
        if (enableCache || oldResampling) {
          cacheService.setImage(getThumbnailImageURL(targetDial), targetDial);
        }
      }
    } else {
      // We're inserting a new URL if possible...
      var url = transferUtils.retrieveURLFromData(targetData.data, targetData.contentType);
        
      if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
        /^\s*(javascript|data):/.test(url))
        return;
      
      // Clean previous
      SpeedDialUtils.deassignThumbnail(targetDial);
      
      // Just add the information...
      gPref.setCharPref("thumbnail-" + targetDial + "-url", url);

      var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
      str.data = "";
      gPref.setComplexValue("thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);

      if (!isFirefox3) {
        gPref.setCharPref("thumbnail-" + targetDial + "-icon", "data:");
      }
      gPref.setBoolPref("thumbnail-" + targetDial + "-dynamictitle", true);

      // add time intervals
      var defaultRefreshInterval = gPref.getIntPref("defaultRefreshInterval");
      if (defaultRefreshInterval > 0) {
        gPref.setIntPref("thumbnail-" + targetDial + "-refreshinterval", defaultRefreshInterval);
      } else {
        if (gPref.prefHasUserValue("thumbnail-" + targetDial + "-refreshinterval")) {
          gPref.clearUserPref("thumbnail-" + targetDial + "-refreshinterval");
        }
      }

      // add default javascript
      var defaultJs = gPref.getBoolPref("defaultDialJavascript");
      gPref.setBoolPref("thumbnail-" + targetDial + "-js", defaultJs);
    }
} catch (e) {
alert(e);
}
  },

  canHandleMultipleItems: false,
  
  checkOwnDrop: function (evt,session) {
    if (!session) return false;
    
    if (session.sourceNode == evt.target) {
      if ("handleClick" in evt.target) {
        evt.target.handleClick(evt);
        return true;
      }
    }
    
    return false;
  }

};

function getSelectionFromXferData(aDragSession) {
    var newValue = {};
    var trans = Components.classes["@mozilla.org/widget/transferable;1"]
                          .createInstance(Components.interfaces.nsITransferable);
    trans.addDataFlavor("text/x-speeddial-entry");
    trans.addDataFlavor("text/x-moz-url");
    trans.addDataFlavor("text/x-moz-file");
    trans.addDataFlavor("text/unicode");
    var uri, extra, rSource, rParent, parent;
    if (aDragSession.numDropItems > 0) {
      var bestFlavour = {}, dataObj = {}, len = {};
      aDragSession.getData(trans, 0);
      trans.getAnyTransferData(bestFlavour, dataObj, len);
      dataObj = dataObj.value.QueryInterface(Components.interfaces.nsISupportsString);
      if (dataObj) {
        var value = dataObj.data.substring(0, len.value);

        newValue.value = value;
        switch (bestFlavour.value) {
        case "text/x-speeddial-entry":
          newValue.type = "speedDialId";
          break;
        case "text/x-moz-url":
        case "text/x-moz-file":
        case "text/unicode":
          newValue.type = "url";
          newValue.contentType = bestFlavour.value;
          newValue.data = dataObj.data;
          break;
        }
      }
    }
    return newValue;
}

function createTransferDataForEntry(targetEntry) {
  var value;
  var title;

  if (gPref.prefHasUserValue("thumbnail-" + targetEntry + "-url")) {
    value = gPref.getCharPref("thumbnail-" + targetEntry + "-url");
  } else {
    return null;
  }

  if (gPref.prefHasUserValue("thumbnail-" + targetEntry + "-label")) {
    title = gPref.getCharPref("thumbnail-" + targetEntry + "-label");
  } else {
    title = "";
  }

  if (title == "") {
    title = speedDialBundle.getString("untitled.label");
  }
  
  var urlString = value + "\n" + title;
  var htmlString = "<a href=\"" + value + "\">" + title + "</a>";

  var data = new TransferData();
  data.addDataForFlavour("text/x-speeddial-entry", targetEntry);
  if (!isFirefox31) {
    if ((value == "") || (value == "about:blank")) {
      data.addDataForFlavour("text/unicode", value);
    } else {
      data.addDataForFlavour("text/x-moz-url", urlString);
      data.addDataForFlavour("text/unicode", value);
      data.addDataForFlavour("text/html", htmlString);
    }
  }

  return data;
}

function calculateBoardSize() {
  var innerBox = document.getElementById("speedDialPanel" + currentGroup);
  boardWidth = innerBox.boxObject.width;
  boardHeight = innerBox.boxObject.height;
  
  var boardMinimumWidth;
  var boardMinimumHeight;
  var boardMaximumWidth;
  var boardMaximumHeight;
  var boardWidthModifier;
  var boardHeightModifier;
  var boardWidthModifierType;
  var boardHeightModifierType;
  
  if (gPref.prefHasUserValue("group-" + currentGroup + "-minimumWidth")) {
    boardMinimumWidth = gPref.getIntPref("group-" + currentGroup + "-minimumWidth");
    boardMinimumHeight = gPref.getIntPref("group-" + currentGroup + "-minimumHeight");
    boardMaximumWidth = gPref.getIntPref("group-" + currentGroup + "-maximumWidth");
    boardMaximumHeight = gPref.getIntPref("group-" + currentGroup + "-maximumHeight");
    boardWidthModifier = gPref.getIntPref("group-" + currentGroup + "-widthModifier");
    boardHeightModifier = gPref.getIntPref("group-" + currentGroup + "-heightModifier");
    boardWidthModifierType = gPref.getIntPref("group-" + currentGroup + "-widthModifierType");
    boardHeightModifierType = gPref.getIntPref("group-" + currentGroup + "-heightModifierType");
  } else {
    boardMinimumWidth = defaultMinimumWidth;
    boardMinimumHeight = defaultMinimumHeight;
    boardMaximumWidth = defaultMaximumWidth;
    boardMaximumHeight = defaultMaximumHeight;
    boardWidthModifier = defaultWidthModifier;
    boardHeightModifier = defaultHeightModifier;
    boardWidthModifierType = defaultWidthModifierType;
    boardHeightModifierType = defaultHeightModifierType;
  }
  
  if (boardWidthModifierType == 0) {
    boardWidth = Math.floor(boardWidth * boardWidthModifier / 100);
  } else {
    boardWidth -= boardWidthModifier;
  }
  if ((boardMinimumWidth > 0) && (boardWidth < boardMinimumWidth)) {
    boardWidth = boardMinimumWidth;
  }
  if ((boardMaximumWidth > 0) && (boardWidth > boardMaximumWidth)) {
    boardWidth = boardMaximumWidth;
  }
  
  if (boardHeightModifierType == 0) {
    boardHeight = Math.floor(boardHeight * boardHeightModifier / 100);
  } else {
    boardHeight -= boardHeightModifier;
  }
  if ((boardMinimumHeight > 0) && (boardHeight < boardMinimumHeight)) {
    boardHeight = boardMinimumHeight;
  }
  if ((boardMaximumHeight > 0) && (boardHeight > boardMaximumHeight)) {
    boardHeight = boardMaximumHeight;
  }

  if (boardWidth > innerBox.boxObject.width) boardWidth = innerBox.boxObject.width;
  if (boardHeight > innerBox.boxObject.height) boardHeight = innerBox.boxObject.height;

  // Set border
  innerBox.style.paddingLeft = ((innerBox.boxObject.width - boardWidth) / 2) + "px";
  innerBox.style.paddingRight = innerBox.style.paddingLeft;
  innerBox.style.paddingTop = ((innerBox.boxObject.height - boardHeight) / 2) + "px";
  if (SpeedDialUtils.isFennec()) {
    innerBox.style.paddingBottom = ((innerBox.boxObject.height - boardHeight) / 2 + SpeedDialUtils.fennecToolbarHeight) + "px";
  } else {
    innerBox.style.paddingBottom = innerBox.style.paddingTop;
  }
}

function groupContextShowing(event) {
  var currentNode = document.popupNode;
  var found = false;
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
    }
    currentNode = currentNode.parentNode;
  }
  
  if (found) {
    // Show edit and remove
    document.getElementById("groupcontext-openall").setAttribute("hidden", false);
    document.getElementById("groupcontext-firstseparator").setAttribute("hidden", false);
    document.getElementById("groupcontext-edit").setAttribute("hidden", false);
    var contextRemove = document.getElementById("groupcontext-remove");
    contextRemove.setAttribute("hidden", false);
    if (numGroups < 2) {
      contextRemove.setAttribute("disabled", true);
    } else {
      contextRemove.setAttribute("disabled", false);
    }
  } else {
    // hide edit and remove
    document.getElementById("groupcontext-openall").setAttribute("hidden", true);
    document.getElementById("groupcontext-firstseparator").setAttribute("hidden", true);
    document.getElementById("groupcontext-edit").setAttribute("hidden", true);
    document.getElementById("groupcontext-remove").setAttribute("hidden", true);
  }
  return true;
}

function checkShouldShowGroupMenu(event) {
  var currentNode = document.popupNode;
  var found = false;
  while ((currentNode.parentNode) && !found) {
    if ((currentNode.localName == "box")
             && (currentNode.hasAttribute("class"))
             && (currentNode.getAttribute("class") == "speeddialThumb")) {
      found = true;
    }
    currentNode = currentNode.parentNode;
  }
  
  return !found;
}

// Log

function log(msg) {
  var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
  consoleService.logStringMessage(msg);
}

window.addEventListener("load", function(e) { speeddialStartup() }, false);

