var targetDial = -1;
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);

var addDialBundle;
var currentUnitValue = 1;
var cropSelected = false;
var isFirefox3 = false;

function Startup() {
  // Set variables
  targetDial = window.arguments[0];
  addDialBundle = document.getElementById("bundle_editDial");
  var defaultRefreshInterval = gPref.getIntPref("extensions.speeddial.defaultRefreshInterval");
  var refreshIntervalValue = defaultRefreshInterval;
  var defaultDialJavascript = gPref.getBoolPref("extensions.speeddial.defaultDialJavascript");

  // Set actions button
  if(document.documentElement.getButton && document.documentElement.getButton('extra2')) {
    var extra2 = document.documentElement.getButton('extra2');
    extra2.setAttribute('type', 'menu');
    extra2.setAttribute('popup', 'editdial-actions-popup');
  }
  
  // Detect version
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
  // only if this is Firefox
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                      .getService(Components.interfaces.nsIVersionComparator);
  // only if the platform version is 1.9 or greater
  if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
    isFirefox3 = true;
  }
  
  
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    // We've an URL, edit
    document.getElementById("url").value = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    document.getElementById("title").value = gPref.getComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString).data;
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle")) {
      document.getElementById("dynamicTitle").checked = gPref.getBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval")) {
      document.getElementById("refreshType").selectedIndex = 1;
      refreshIntervalValue = gPref.getIntPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor")) {
      document.getElementById("backgroundColor").color = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor");
    } else {
      document.getElementById("backgroundColor").color = "#FFFFFF";
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-layout")) {
      document.getElementById("layoutScaling").selectedIndex = gPref.getIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-cropping")) {
      document.getElementById("enableThumbnailCrop").checked = true;
      var croppingValues = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping").split(",");
      document.getElementById("leftOffset").value = croppingValues[0];
      document.getElementById("topOffset").value = croppingValues[1];
      document.getElementById("cropWidth").value = croppingValues[2];
      document.getElementById("cropHeight").value = croppingValues[3];
      if (croppingValues[4]) {
        document.getElementById("cropScaling").value = croppingValues[4];
      } else {
        document.getElementById("cropScaling").value = 100;
      }
      cropSelected  = true;
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl")) {
      document.getElementById("customThumbnailURL").checked = true;
      document.getElementById("thumbnailURL").value = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-js")) {
      document.getElementById("enableJavaScript").checked = gPref.getBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js");
    } else {
      document.getElementById("enableJavaScript").checked = defaultDialJavascript;
    }
  } else {
    // We don't have an URL, new dial
    // Set title
    document.title = addDialBundle.getString("addDialTitle");
    // Set default thumbnail refresh
    if (defaultRefreshInterval > 0) {
      document.getElementById("refreshType").selectedIndex = 1;
    }
		var clearButton = document.getElementById('editdial-clear');
    clearButton.setAttribute('hidden', 'true');
		var clearSeparator = document.getElementById('clear-separator');
    clearSeparator.setAttribute('hidden', 'true');
    document.getElementById("backgroundColor").color = "#FFFFFF";
    document.getElementById("enableJavaScript").checked = defaultDialJavascript;
  }
  if (refreshIntervalValue == 0) {
    refreshIntervalValue = 3600*24;
  }
  
  document.getElementById("backgroundColorText").value = document.getElementById("backgroundColor").color;

  
  // Set the correct refresh interval unit value
  var refreshInterval = document.getElementById("refreshInterval");
  var unitIndex = SpeedDialUtils.getTimeUnitIndex(refreshIntervalValue);
  currentUnitValue = SpeedDialUtils.timeUnits[unitIndex];
  
  document.getElementById("refreshIntervalUnit").selectedIndex = unitIndex;
  refreshInterval.value = refreshIntervalValue / currentUnitValue;

  dynamicTitleChanged();
  refreshTypeChanged();
  enableThumbnailCropChanged();
  customThumbnailURLChanged();
  
  sizeToContent();
}

function fixURL(targetURL) {
  var lowercaseURL = targetURL.toLowerCase();
  if ((lowercaseURL.indexOf("moz-icon:") != 0)
      && (lowercaseURL.indexOf("bbs2chreader:") != 0)
      && (!lowercaseURL.match(/^[a-z]+:/))
      ) {
    targetURL = "http://" + targetURL;
  }
  
  return targetURL;
}

function onOK(event) {
  var trimmedURL = document.getElementById("url").value.replace(/^\s+|\s+$/g, '') ;
  if (trimmedURL.length == 0) {
    alert(addDialBundle.getString("noURLAlert"));
    // Select main tab and URL textbox
    document.getElementById("editDialTabBox").selectedIndex = 0;
    document.getElementById("url").focus();
    return false;
  }

  // Check if it has protocol
  trimmedURL = fixURL(trimmedURL);

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    var isRefreshing = false;

    // Thumbnail URL
    var oldURL = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    if (oldURL != trimmedURL) {
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", trimmedURL);
      isRefreshing = true;
//      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-lastsaved")) {
//        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-lastsaved");
//      }
      // Reset extra parameters if present
      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-extra")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-extra");
      }
    }

    // Thumbnail title
    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = document.getElementById("title").value;
    gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);

    // Dynamic title
    var oldDynamicTitle = false;
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle")) {
      oldDynamicTitle = gPref.getBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle");
    }
    var newDynamicTitle = document.getElementById("dynamicTitle").checked;
    if (oldDynamicTitle != newDynamicTitle) {
      gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", newDynamicTitle);
      if (newDynamicTitle) {
        isRefreshing = true;
      }
    }
    
    // Background color
    var backgroundColor = document.getElementById("backgroundColorText").value;
    if (backgroundColor != "#FFFFFF") {
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor", backgroundColor);
    } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor")) {
      gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor");
    }
    
    // Layout
    var layoutScalingIndex = document.getElementById("layoutScaling").selectedIndex;
    if (layoutScalingIndex != 0) {
      gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout", layoutScalingIndex);
    } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-layout")) {
      gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-layout");
    }
    
    // Cropping
    if (document.getElementById("enableThumbnailCrop").checked) {
      var croppingValue = "" + document.getElementById("leftOffset").value + "," + 
                               document.getElementById("topOffset").value + "," +
                               document.getElementById("cropWidth").value + "," +
                               document.getElementById("cropHeight").value + "," +
                               document.getElementById("cropScaling").value;
      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-cropping")) {
        if (gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping") != croppingValue) {
          isRefreshing = true;
          gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", croppingValue);
        }
      } else {
        isRefreshing = true;
        gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", croppingValue);
      }
    } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-cropping")) {
      isRefreshing = true;
      gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping");
    }

    // Thumbnail URL
    if (document.getElementById("customThumbnailURL").checked) {
      var thumbnailURL = document.getElementById("thumbnailURL").value.replace(/^\s+|\s+$/g, '');

      if (thumbnailURL != "") {
        thumbnailURL = fixURL(thumbnailURL);
        if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl")) {
          if (gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl") != thumbnailURL) {
            isRefreshing = true;
            gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl", thumbnailURL);
            // Reset extra parameters if present
            if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-extra")) {
              gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-extra");
            }
          }
        } else {
          isRefreshing = true;
          gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl", thumbnailURL);
          // Reset extra parameters if present
          if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-extra")) {
            gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-extra");
          }
        }
      } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl")) {
        isRefreshing = true;
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl");
        // Reset extra parameters if present
        if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-extra")) {
          gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-extra");
        }
      }
    } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl")) {
      isRefreshing = true;
      gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl");
      // Reset extra parameters if present
      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-extra")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-extra");
      }
    }
    
    var enableJs = document.getElementById("enableJavaScript").checked;
    if (!gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-js") ||
        (gPref.getBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js") != enableJs )) {
      isRefreshing = true;
      gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js", enableJs);
    }
    
    // TODO: fix this in Fennec
    if (isRefreshing) {
      if (SpeedDialUtils.isFennec()) {
        gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-manualrefresh", true);
      } else {
        var promptService = Components.classes['@mozilla.org/embedcomp/prompt-service;1'].getService(Components.interfaces.nsIPromptService);
        if (promptService.confirmEx(
            window,
            addDialBundle.getString("refreshThumbnail.confirmtitle"),
            addDialBundle.getString("refreshThumbnail.confirmtext"),
            (promptService.BUTTON_TITLE_YES * promptService.BUTTON_POS_0) +
            (promptService.BUTTON_TITLE_NO  * promptService.BUTTON_POS_1),
            null, null, null, null, {}
            ) == 0) {
          gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-manualrefresh", true);
        }
      }
    }
  } else {
    // Just add the information...
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", trimmedURL);

    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = document.getElementById("title").value;
    gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);

    if (!isFirefox3) {
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
    }
    gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", document.getElementById("dynamicTitle").checked);
    
    // Background color
    var backgroundColor = document.getElementById("backgroundColorText").value;
    if (backgroundColor != "#FFFFFF") {
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor", backgroundColor);
    }
    
    // Layout
    var layoutScalingIndex = document.getElementById("layoutScaling").selectedIndex;
    if (layoutScalingIndex != 0) {
      gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout", layoutScalingIndex);
    }

    // Cropping
    if (document.getElementById("enableThumbnailCrop").checked) {
      var croppingValue = "" + document.getElementById("leftOffset").value + "," + 
                               document.getElementById("topOffset").value + "," +
                               document.getElementById("cropWidth").value + "," +
                               document.getElementById("cropHeight").value + "," +
                               document.getElementById("cropScaling").value;
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", croppingValue);
    }
    
    // Thumbnail URL
    if (document.getElementById("customThumbnailURL").checked) {
      var thumbnailURL = document.getElementById("thumbnailURL").value;
      
      if (thumbnailURL != "") {
        gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl", thumbnailURL);
      }
    }

    gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js", document.getElementById("enableJavaScript").checked);
  }

  // modify time intervals
  if (document.getElementById("refreshType").selectedIndex == 1) {
    var newRefreshInterval = document.getElementById("refreshInterval").value * currentUnitValue;
    if (newRefreshInterval < 5) newRefreshInterval = 5;
    gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval", document.getElementById("refreshInterval").value * currentUnitValue);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval")) {
      gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval");
    }
  }
  
  SpeedDialUtils.automaticBackup();
  return true;
}

function onCancel(event) {
  return true;
}

function onClearAction(event) {
  var confirmClearMessage = addDialBundle.getString("confirmClear");
  // TODO: fix this in Fennec
  if (SpeedDialUtils.isFennec() || confirm(confirmClearMessage)) {
    // Clear thumbnail
    SpeedDialUtils.deassignThumbnail(targetDial);
    close();
  }
  return true;
}

function dynamicTitleChanged() {
  document.getElementById("title").disabled = document.getElementById("dynamicTitle").checked;
}

function refreshTypeChanged() {
  document.getElementById("refreshIntervalBox").hidden = !(document.getElementById("refreshType").selectedIndex == 1);
}

function refreshIntervalUnitChanged() {
  var newValue = SpeedDialUtils.timeUnits[document.getElementById("refreshIntervalUnit").selectedIndex];
  if (newValue != currentUnitValue) {
    // Update ammount
//    var refreshInterval = document.getElementById("refreshInterval");
//    refreshInterval.value = Math.floor(refreshInterval.value * currentUnitValue / newValue);
    currentUnitValue = newValue;
  }
}

function backgroundColorChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColorText.value = backgroundColor.color;
  }
}

function backgroundColorTextChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColor.color = backgroundColorText.value;
  }
}

function showFileBrowser() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, addDialBundle.getString("selectFile"), nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterImages);
  fp.appendFilters(nsIFilePicker.filterHTML); 
  fp.appendFilters(nsIFilePicker.filterAll);
  var res = fp.show();
  if (res == nsIFilePicker.returnOK){
    document.getElementById("thumbnailURL").value = fp.fileURL.spec;
  }
}

function enableThumbnailCropChanged() {
  var enableThumbnailCropCheckbox = document.getElementById("enableThumbnailCrop");
  document.getElementById("leftOffsetLabel").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("leftOffset").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("leftOffsetPixels").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("topOffsetLabel").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("topOffset").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("topOffsetPixels").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropWidthLabel").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropWidth").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropWidthPixels").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropHeightLabel").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropHeight").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropHeightPixels").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropScalingLabel").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropScaling").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropScalingPercent").disabled = !enableThumbnailCropCheckbox.checked;
  document.getElementById("cropSelectorButton").disabled = !enableThumbnailCropCheckbox.checked;
}

function customThumbnailURLChanged() {
  var customThumbnailURLCheckbox = document.getElementById("customThumbnailURL");
  document.getElementById("thumbnailURL").disabled = !customThumbnailURLCheckbox.checked;
  document.getElementById("chooseFileButton").disabled = !customThumbnailURLCheckbox.checked;
}

function cropSelectorButtonPressed() {
  var targetURL;

  if (document.getElementById("customThumbnailURL").checked) {
    targetURL = document.getElementById("thumbnailURL").value;
  } else {
    targetURL = document.getElementById("url").value;
  }
  
  openDialog("chrome://speeddial/content/cropSelector.xul", "",
             "centerscreen,chrome,dialog,resizable,modal",
             targetURL,
             cropSelected,
             document.getElementById("leftOffset").value,
             document.getElementById("topOffset").value,
             document.getElementById("cropWidth").value,
             document.getElementById("cropHeight").value,
             document.getElementById("cropScaling").value,
             document.getElementById("enableJavaScript").checked
             );
}

function colorPickerButtonPressed() {
  var targetURL;

  if (document.getElementById("customThumbnailURL").checked) {
    targetURL = document.getElementById("thumbnailURL").value;
  } else {
    targetURL = document.getElementById("url").value;
  }
  
  openDialog("chrome://speeddial/content/colorPicker.xul", "",
             "centerscreen,chrome,dialog,resizable,modal",
             targetURL,
             document.getElementById("backgroundColorText").value,
             document.getElementById("enableJavaScript").checked
             );
}

function setCropData(cropX, cropY, cropWidth, cropHeight, cropScaling) {
  cropSelected = true;
  document.getElementById("leftOffset").value = cropX;
  document.getElementById("topOffset").value = cropY;
  document.getElementById("cropWidth").value = cropWidth;
  document.getElementById("cropHeight").value = cropHeight;
  document.getElementById("cropScaling").value = cropScaling;
}

function setPickerData(color) {
  document.getElementById("backgroundColor").color = color;
  document.getElementById("backgroundColorText").value = color;
}

function showEditWeatherDial() {
  window.opener.openDialog("chrome://speeddial/content/editWeatherDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}

function showEditLaunchDial() {
  window.opener.openDialog("chrome://speeddial/content/editLaunchDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}

function showEditGroupDial() {
  window.opener.openDialog("chrome://speeddial/content/editGroupDial.xul", "",
               "centerscreen,chrome,dialog,resizable,dependent",
               targetDial);
  window.close();
}

function showEditPluginDial() {
  window.opener.openDialog("chrome://speeddial/content/editPluginDial.xul", "",
               "centerscreen,chrome,dialog,resizable,dependent",
               targetDial);
  window.close();
}