/******************************************************************************
 * File Name    : PassWordWindow.cpp
 * Created      : 2008/11/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Initialize and show Password window
 ******************************************************************************/
#include <glib/gi18n.h>
#include "SESCommonDef.h"
#include "PasswordWindow.h"
#include "libsesdata.h"
#include "PublicFunc.h"

using namespace std;
using namespace LibSESData;
using namespace IPCAPI;
using namespace LibSESGUI;

#define PASSWORD_WINDOW_BORDER_WIDTH 1
#define PASSWORD_WINDOW_WIDTH 315
#define PASSWORD_WINDOW_HEIGHT 150
#define PASSWORD_WINDOW_ENTRY_WIDTH 220
#define PASSWORD_WINDOW_ENTRY_HEIGHT 25



/******************************************************************************
 * Function Name: PassWordWindow
 * Description  : Constructor of PassWordWindow
 * Date         : 2008/11/10
 * Parameter    : path		the path of certificate
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
PassWordWindow::PassWordWindow(string& path, bool iStart)
			: m_gWindow (NULL)
			, m_gPasswordEntry (NULL)
			, m_iClickResult (BUTTON_CLICK_IS_CANCEL)
			, m_iPasswordIsTrue (0)
			, m_inputPasswdNum (0)
			, m_pathString (path)
{
	CSESLog::WriteLine("PassWordWindow::PassWordWindow>>Start");
//	m_pathString = path;
//	m_iPasswordIsTrue = 0;
//	m_gPasswordEntry = NULL;
//	m_iClickResult = BUTTON_CLICK_IS_CANCEL;
//	m_gWindow = NULL;
//	m_inputPasswdNum = 0;
	m_iStart = iStart;
	m_iQuitStatus = NOT_QUIT;
	CSESLog::WriteLine("PassWordWindow::PassWordWindow<<End");
}
/******************************************************************************
 * Function Name: ~PassWordWindow
 * Description  :
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
PassWordWindow::~PassWordWindow()
{
	CSESLog::WriteLine("PassWordWindow::~PassWordWindow>>Start");
	CSESLog::WriteLine("PassWordWindow::~PassWordWindow<<End");
}
/******************************************************************************
 * Function Name: Init
 * Description  :
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK 		0
 * 				  Error		-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int PassWordWindow::Init()
{
	CSESLog::WriteLine("PassWordWindow::Init>>Start");
	InitWindow();
	CSESLog::WriteLine("PassWordWindow::Init<<End");
	return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  :
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK 		0
 * 				  Error		-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int PassWordWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("PassWordWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("PassWordWindow::ShowModal<<End");
	return 0;
}
/******************************************************************************
 * Function Name: Release
 * Description  : Release memory
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK 		0
 * 				  Error		-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int PassWordWindow::Release()
{
	CSESLog::WriteLine("PassWordWindow::Release>>Start");
	if(NULL != m_gWindow)
	{
		delete m_gWindow;
		m_gWindow = NULL;
	}
	CSESLog::WriteLine("PassWordWindow::Release<<End");
	return 0;
}
/******************************************************************************
 * Function Name: InitWindow
 * Description  : Initialize main window
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : OK 		0
 * 				  Error		-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int PassWordWindow::InitWindow()
{
	CSESLog::WriteLine("PassWordWindow::InitWindow>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pButton = NULL;
	GtkWidget* pLabel = NULL;
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect (m_gWindow, "delete-event", G_CALLBACK (OnWindowClosing), this);
	//gtk_window_set_decorated(GTK_WINDOW (m_gWindow), false);
	gtk_container_set_border_width (GTK_CONTAINER(m_gWindow), PASSWORD_WINDOW_BORDER_WIDTH);
	gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_widget_set_size_request (GTK_WIDGET(m_gWindow), PASSWORD_WINDOW_WIDTH, PASSWORD_WINDOW_HEIGHT);
	gtk_window_set_type_hint(GTK_WINDOW(m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_resizable(GTK_WINDOW(m_gWindow), FALSE);
	gtk_window_set_title(GTK_WINDOW(m_gWindow), _("Input Password"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Input Password"), "SES");
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");
    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), iconPath.c_str(), error);

	pVbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(m_gWindow), pVbox);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	//PangoFontDescription* desc = NULL;
	//desc = pango_font_description_new ();
	//pango_font_description_set_absolute_size (desc, 20*PANGO_SCALE);
	//pango_font_description_set_style (desc, PANGO_STYLE_ITALIC);



	if(1 == m_iStart)
	{
	    pLabel = gtk_label_new(_("Enter your password to start Shell Controller."));
	    gtk_widget_set_tooltip_text (pLabel, _("Enter your password to start Shell Controller."));
	}
	else
	{
	    pLabel = gtk_label_new(_("Input the password of teacher's private key."));
	    gtk_widget_set_tooltip_text (pLabel, _("Input the password of teacher's private key."));
	}


	//gtk_widget_modify_font (pLabel, desc);
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 10);

//	pHbox = gtk_hbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 5);
//
//	pLabel = gtk_label_new(_("The Password Is Private Key Password."));
//	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 25);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 20);

	pLabel = gtk_label_new(_("Password:"));
	//gtk_label_set_width_chars(GTK_LABEL(pLabel), 12);
	//gtk_misc_set_alignment(GTK_MISC(pLabel), 0.8, 0.5);
	gtk_widget_set_tooltip_text (pLabel, _("Password:"));
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 10);

	m_gPasswordEntry = gtk_entry_new_with_max_length(PASSWORD_MAX_LENGTH);
	gtk_entry_set_activates_default(GTK_ENTRY(m_gPasswordEntry), true);
	gtk_entry_set_visibility(GTK_ENTRY(m_gPasswordEntry), false);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gPasswordEntry), '*');
	gtk_widget_set_size_request(m_gPasswordEntry, PASSWORD_WINDOW_ENTRY_WIDTH, PASSWORD_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gPasswordEntry, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	GtkWidget* pOKButton = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(pOKButton), "clicked", G_CALLBACK(OnOkCallback), this);
	//gtk_button_set_focus_on_click(GTK_BUTTON(pOKButton), true);
	GTK_WIDGET_SET_FLAGS (pOKButton, GTK_CAN_DEFAULT);
	gtk_window_set_default (GTK_WINDOW(m_gWindow), pOKButton);

	//gtk_widget_grab_focus (pOKButton);
	gtk_widget_set_tooltip_text (pOKButton, _("OK"));
	gtk_widget_set_size_request(pOKButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pOKButton, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OnCancelCallBack), this);
	gtk_widget_set_tooltip_text (pButton, _("Cancel"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 0);
	CSESLog::WriteLine("PassWordWindow::InitWindow<<End");
	return 0;
}
/******************************************************************************
 * Function Name: OnWindowClosing
 * Description  : Call this function while password window is closing
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			main window
 * 				  event				close window event
 * 				  data				user data
 * Return Code  : TRUE 		dont close the window
 * 				  FALSE		close the window
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool PassWordWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("PassWordWindow::OnWindowClosing>>Start");
	PassWordWindow* ptr = (PassWordWindow*)data;
//	GtkWidget* pDialog = NULL;
//	pDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_QUESTION,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to quit?"));
//	gtk_window_set_title(GTK_WINDOW(pDialog), "Information");
	string message(_("Do you want to quit?"));
	int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
	if(GTK_RESPONSE_YES == result)
	{
		//gtk_widget_destroy(pDialog);
		//gtk_main_quit();
		CSESLog::WriteLine("PassWordWindow::OnWindowClosing<<End");
		return false;
	}
	else
	{
		//gtk_widget_destroy(pDialog);
		gtk_widget_grab_focus(ptr->m_gPasswordEntry);
		CSESLog::WriteLine("PassWordWindow::OnWindowClosing<<End");
		return true;
	}
}
/******************************************************************************
 * Function Name: OnOkCallback
 * Description  : Call this function when OK button is clicked
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			OK button
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void PassWordWindow::OnOkCallback(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("PassWordWindow::OnOkCallback>>Start");
	PassWordWindow* ptr = (PassWordWindow*)data;
	string nothingString("");
	string firstEntry = gtk_entry_get_text(GTK_ENTRY(ptr->m_gPasswordEntry));
	PublicFunc::TrimString(firstEntry);
	if(0 == firstEntry.compare(nothingString))
	{
		string message(_("You must input the password!"));
		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
	}
	else
	{
		int verifyResult = 0;
		int errCode = 0;
		string str = ptr->m_pathString;
		verifyResult = ptr->m_pTeacherAPI->VerifyCertificate(str, errCode);
		if(SES_API_SUCCESS == verifyResult)
		{
			if(SES_API_SUCCESS == errCode)
			{
				if(PASSWORD_MIN_LENGTH <= firstEntry.size() && PASSWORD_MAX_LENGTH >= firstEntry.size())
				{
					errCode = 0;
					int passwordResult = 0;
					passwordResult = ptr->m_pTeacherAPI->VerifyPassword(ptr->m_pathString, firstEntry, errCode);
					if(SES_API_SUCCESS == passwordResult)
					{
						if(SES_API_SUCCESS != errCode)
						{
							ptr->m_inputPasswdNum++;
							string message(_("The password is wrong!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						}
						else
						{
							ptr->m_iClickResult = BUTTON_CLICK_IS_OK;
							ptr->m_iPasswordIsTrue = 1;
							gtk_widget_destroy(ptr->m_gWindow);
						}
					}
					else if(SES_API_TIME_OUT == passwordResult)
					{
					    ptr->m_iQuitStatus = TIME_OUT_QUIT;
						CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");
						string message(_("Time out, the application will quit!"));
						CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						//PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
					}
					else
					{
					    ptr->m_iQuitStatus = SERVICE_FAILURE_QUIT;
						CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");
						string message(_("Fail to verify password, the application will quit!"));
						CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						//PublicFunc::SESShowDialogAndQuit(_("Fail to verify password, the application will quit!"), ptr->m_gWindow);
					}
				}
				else
				{
					ptr->m_inputPasswdNum++;
					string message(_("The length of password should be between 6~64 characters!"));
					CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
				}
			}
//			else if(SES_API_NEEDRESTART == verifyResult)
//            {
//			    ptr->m_iQuitStatus = RESTART_QUIT;
//			    string message(_("You should restart your computer!"));
//			    CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
//                //PublicFunc::SESShowDialogAndQuit(_("You should restart your computer!"), ptr->m_gWindow);
//            }
			else
			{
			    ptr->m_iQuitStatus = SERVICE_FAILURE_QUIT;
				CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");
				string message(_("Fail to verify certificate, the application will quit!"));
				CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				//PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
			}
		}
		else if(SES_API_TIME_OUT == verifyResult)
		{
		    ptr->m_iQuitStatus = TIME_OUT_QUIT;
			CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");
			string message(_("Time out, the application will quit!"));
			CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			//PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
		}
		else
		{
		    ptr->m_iQuitStatus = SERVICE_FAILURE_QUIT;
			CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");

            string message(_("Fail to verify certificate, the application will quit!"));
            CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);


			//PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
		}
	}
	if(ptr->m_inputPasswdNum>=3)
	{
	    ptr->m_iQuitStatus = PASSWORD_THREE_TIMES_QUIT;
		CSESLog::WriteLine("PassWordWindow::OnOkCallback<<End");
		if(1 == ptr->m_iStart)
		{
		    string message(_("Sorry! You have entered wrong password for three times, the application will quit!"));
		    CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		}
		else
		{
		    string message(_("Sorry! You have entered wrong password for three times, the application will be closed!"));
		    CMessageBox::Show(message,  ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		}

		gtk_widget_destroy(ptr->m_gWindow);
		//PublicFunc::SESShowDialogAndQuit(_("Sorry! You have entered wrong password for three times, the application will quit!"), ptr->m_gWindow);
	}
}
/******************************************************************************
 * Function Name: OnCancelCallBack
 * Description  : Call this function when Cancel button is clicked
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			Cancel button
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void PassWordWindow::OnCancelCallBack(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("PassWordWindow::OnCancelCallBack>>Start");
	PassWordWindow* ptr = (PassWordWindow*)data;
	//GtkWidget* pDialog = NULL;
//	pDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_QUESTION,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to quit?"));
//	gtk_window_set_title(GTK_WINDOW(pDialog), "Information");

	string message(_("Do you want to quit?"));
	int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
	if(GTK_RESPONSE_YES == result)
	{
	    ptr->m_iClickResult = BUTTON_CLICK_IS_CANCEL;
		//gtk_widget_destroy(pDialog);
		gtk_widget_destroy(ptr->m_gWindow);
		CSESLog::WriteLine("PassWordWindow::OnCancelCallBack<<End");
		//gtk_main_quit();
	}
	else
	{
		//gtk_widget_destroy(pDialog);
		gtk_widget_grab_focus(ptr->m_gPasswordEntry);
		CSESLog::WriteLine("PassWordWindow::OnCancelCallBack<<End");
	}
}
/******************************************************************************
 * Function Name: IsPasswordTrue
 * Description  : Justify whether the password is true
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : TRUE 			the password is true
 * 				  FALSE			the password is wrong
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool PassWordWindow::IsPasswordTrue()
{
	CSESLog::WriteLine("PassWordWindow::IsPasswordTrue>>Start");
	CSESLog::WriteLine("PassWordWindow::IsPasswordTrue<<End");
	return m_iPasswordIsTrue;
}
/******************************************************************************
 * Function Name: GetResult
 * Description  : Get the click result
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : 0 			BUTTON_CLICK_IS_CANCEL
 * 				  1				BUTTON_CLICK_IS_OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int PassWordWindow::GetResult()
{
	CSESLog::WriteLine("PassWordWindow::GetResult>>Start");
	CSESLog::WriteLine("PassWordWindow::GetResult<<End");
	return m_iClickResult;
}
/******************************************************************************
 * Function Name: GetPassword
 * Description  : Get password
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : the return password
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
string& PassWordWindow::GetPassword()
{
	CSESLog::WriteLine("PassWordWindow::GetPassword>>Start");
	CSESLog::WriteLine("PassWordWindow::GetPassword<<End");
	return strPassword;
}

int PassWordWindow::GetQuitStatus()
{
    return m_iQuitStatus;
}
