/******************************************************************************
 * File Name    : ShellControllerWindow.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file of ShellControllerWindow
 ******************************************************************************/
#ifndef SHELLCONTROLLERWINDOW_H_
#define SHELLCONTROLLERWINDOW_H_
#include "libsesdata.h"
#include "SESCommonDef.h"
#include "StudentDetailedInfoWindow.h"
#include "NewStudentConnectWindow.h"
#include "ChangePasswordWindow.h"
#include "PasswordWindow.h"
#include <gtk/gtk.h>
#include "SelectClassWindow.h"
#include "LockStudentsWindow.h"
#include "libsesgui.h"
#include "IPCTeacherAPI.h"
#include "TeacherInfoWindow.h"
#include "MainTreeVeiwOperation.h"
#include "MainIconVeiwOperation.h"
#include "DeployShellSettingsWindow.h"
#include "PreferenceWindow.h"
#include <gnome-client.h>

namespace ShellController
{

class ShellControllerWindow : public IPCAPI::CTeacherAPICallbackBase
{
public:
	ShellControllerWindow();
	~ShellControllerWindow();

public:
	int Init();
	int Show();
	int Close();

public:
	// GTK Handlers
	static void ShowUnlockDialog (GtkWidget*, gpointer data);

	static void ShowLockDialog(GtkWidget*, gpointer data);

	static void ShowShellSettings(GtkWidget*, gpointer data);

	static void ShowProgramSearching(GtkWidget*, gpointer data);

	static void ImportShellSettings(GtkWidget*, gpointer data);

	static void ExportShellSettings(GtkWidget*, gpointer data);

	static void SelectAll(GtkWidget*, gpointer data);
	//static void ViewChange(GtkWidget*, gpointer data);

	static void WindowShow(GtkWidget*, gpointer data);

	static void ClassSelectWinDestroy(GtkWidget*, gpointer data);

	static void ShowStuInfoTreeView(GtkTreeView *tree_view, GtkTreePath *path,GtkTreeViewColumn *column, gpointer user_data);

	static void ShowStuInfo(GtkWidget* gtkwidget, GtkTreePath* path, gpointer data);

	static void StudentInfoWindowClosed(GtkWidget* gtkwidget, gpointer data);

	static void LockStudentsWindowDestroy(GtkWidget* gtkwidget, gpointer data);

	static void DeploySettings(GtkWidget*, gpointer data);

	static void AutoDeploy(GtkWidget*, gpointer data);

	static void NewStudentConnectWinDestroy(GtkWidget*, gpointer data);

	static void ChangePassWordWindowDestroy(GtkWidget*, gpointer data);

	static void ChangePassword(GtkWidget*, gpointer);

	static void ImportNewCAWindowDestroy(GtkWidget*, gpointer data);

	static void ShowTeacherWindow(GtkWidget*, gpointer);

	static void TeacherWindowDestroy(GtkWidget*, gpointer);

	static void ShowAboutInfo(GtkWidget*, gpointer);

	static void SelectClass(GtkMenuItem* ,gpointer);

	static void FilePassWordWindowDestroy(GtkWidget*, gpointer);

	static void StartImportCAWindowDestroy(GtkWidget*, gpointer);

	static void StartPasswordWindowDestroy(GtkWidget*, gpointer);

	static void HasSelected(GObject*, gpointer);

	static void ImportNewCACallBack(GtkWidget*, gpointer);

	static void ShellSettingsDestroy(GtkWidget*, gpointer);

	static void ProgramSearchDestroy(GtkWidget*, gpointer);

	static void AboutWindowDestroy(GtkWidget*, gpointer);

	static void RadioButtonChangeView(GtkCheckMenuItem* item, gpointer);

	static void CheckButtonChangeView(GtkToggleButton* gtkwidget, gpointer data);

	static void DeployShellSettingsWindowDestroy(GtkWidget*, gpointer);

	static void OnWindowClosing(GtkWidget*, GdkEvent*, gpointer);

//	static gboolean	client_save_yourself_cb (GnomeClient        *client,
//				 gint                phase,
//				 GnomeSaveStyle      save_style,
//				 gboolean            shutdown,
//				 GnomeInteractStyle  interact_style,
//				 gboolean            fast,
//				 gpointer            data);
public:
	/////////////////////////////////////////////////////////////////////////////////////
	// IPCAPI Standard Callback
	virtual void NotifyStudentStatusChanged(std::string studentID, int iStatus);

	virtual void NewStudentCallBack(const IPCAPI::StudentInfo_t& studentInfo);
	//virtual void DeploySchedulePolicyCallBack(std::string studentID, bool bSuccess);

	virtual void ManualUnLockRemotStudentCallBack(std::string studentID, int iReturn);

	virtual void NotifyStudentInfoChanged(std::string& OldStudentID, std::string& NewStudentID, std::string& NewStudentName, bool bNeedDelete);

public:

	static void StudentIdCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data);

	static gint	StudentIdCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data);

	static void StudentNameCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data);

	static gint	StudentNameCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data);

	static void ConnectedStatusCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data);

	static gint ConnectedStatusCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data);

	static void LockedStatusCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data);

	static gint	LockedStatusCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data);

	static void PreferenceWindowShow(GtkWidget* gtkwidget, gpointer data);

	static void PreferenceWindowDestroy(GtkWidget* gtkwidget, gpointer data);

public:

	// For Class Info Edit
	int NotifyClassInfoChanged(std::string orgClassName, std::string newClassName);

	// For Class Info Is Deleted.
	int NotifyClassIsDeleted(std::string className);

public:
	static bool HandleSessionDie(GnomeClient* masterClient,
									gint                phase,
									GnomeSaveStyle      save_style,
									gboolean            shutdown,
									GnomeInteractStyle  interact_style,
									gboolean            fast,
									gpointer data);

private:
	//
	int InitWindow();
	//
	int InitFileMenu(GtkWidget* parent);

	int CreateTreeView(GtkListStore * gStore);
	//
	int CreateIconView(GtkListStore * gStore);
	//
	int InitButtons(GtkWidget* parent);
	//
	int AddStudentToIconView(IPCAPI::tagStudent_t& student);
	//
	int IsStudentConnected(int iStatus);
	//
	int IsStudentLocked(int iStatus);
	//
	int FindStudentInfoInIconView(std::string studentID, IPCAPI::tagStudent_t** pStudent, GtkTreeIter& iter);
	//
	int RemoveStudent(std::string studentID);
	//
	int ClearList(list<IPCAPI::tagStudent_t*>& tagList);
	//
	void GetSelectedStudents(std::list<IPCAPI::tagStudent_t>& tagStudentList, GtkWidget* iconview, gboolean isOnlyConnected);
	//GtkTreeModel
	void UpdateStudentStatus(std::string studentID, int iStatus);

	void UpdateStudentStatusAndName(IPCAPI::tagStudent_t* pNewTagStudent_t);
	//
//	void SESShowDialog(std::string);
//	//
//	void SESShowDialogQuit(std::string);
	//
	void ReloadSystemSetting();
	//
	void ReDrawIconView();
	//
	int EnterNoClassStatus();
	//
	int EnterSomeClassStatus(std::string className);
	//
	int EnterOpenForAllStatus();
	//
	int MakeStudentNameUnique();
	//
	int DeployPolicy(std::string studentID);
	//
	int AddStudentToCurrentClass(IPCAPI::StudentInfo_t studentinfo, bool addToClass);
	//
	int UpdateStudentInClass(IPCAPI::StudentInfo_t studentinfo);
	//
	int CloseNewStudentDialogWhenTimeOut(string studentID, int status);
	//
	//void MakeSearchItemDisableStatus();
	//
	//void MakeSearchItemAbleStatus();
	//Add by lfeng
	void HandleReStartContrller();
	//
	int IsStudentInSelectedClass(std::string className, std::string studentID);

	//Make main UI button status
	void SetMainUIButtonStatus(GList* gList);

	//Make main UI file status
	void SetMainUIFileStatus(GList* gList);

	//
	GdkPixbuf* GetStudentStatusIcon(const IPCAPI::StudentInfo_t* pStudentInfo, int iStatus);

	//
	int NotifyOtherWindowStudentChanged(const IPCAPI::StudentInfo_t* pStudent, int iOption);

	//ReleasePixbuf
	void ReleasePixbuf();

	//added by lfeng, justify if some files are existed!
	bool IsShellSettingsExisted(std::string folder);

private:


	GtkWidget* m_pScrolledWindow;
	GtkWidget* m_gWindow;
	GtkWidget* m_gIconView;
	GtkWidget* m_gTreeview;
	GtkListStore* m_gStore;
	GtkWidget* m_gClassLabel;
	GtkWidget* m_gSelectAllCheckbtn;
	GtkWidget* m_gViewCheckbtn;

	GtkWidget* m_gDeployBtn;
	GtkWidget* m_gLockBtn;
	GtkWidget* m_gUnlockBtn;
	GtkWidget* m_gShellSettingsBtn;
	//GtkWidget* m_pAutoDeployCheckItem;
	//GtkWidget* m_gSearingProgramItem;

	GtkWidget* m_gDeploySettingsItems;
	GtkWidget* m_gLockItems;
	GtkWidget* m_gUnlockItems;

	GdkPixbuf* m_connectedAndLockedPixBuf;
	GdkPixbuf* m_connectedAndUnlockedPixBuf;
	GdkPixbuf* m_disconnectedPixBuf;
	GdkPixbuf* m_connectedAndLockedExtendPixBuf;
	GdkPixbuf* m_connectedAndUnLockExtendPixBuf;

    GtkWidget* m_gAutoDeployLabel;


    GnomeClient* m_gMasterClient;

private:
    void SetAutoDeployStatusOnBottom(int status);

    int LoadAndSaveShellSettings(std::string original, std::string destination);

    void DoImportShellSettingsAction(std::string path);
    void DoExportShellSettingsAction(std::string path);


private:
	GtkWidget* m_gIconViewItem;
	GtkWidget* m_gListViewItem;


	IMainViewOperation* m_mainViewOperation;
	MainIconVeiwOperation* m_mainIconVeiwOperation;
	MainTreeVeiwOperation* m_mainTreeVeiwOperation;

	int iInited;	// flag for no class status: if FALSE => no class if TRUE => openforall or someclass
	int m_iClassType;
	//int m_iStartControllerOK;//Justify whether call startcontrller interface successfully or not
//	int m_iSNormalClose;//Justify whether call gtk_main_quit before gtk_main or after gtk_main

	ClassSelectStatus m_eClassSelectStatus;

	std::string m_SelectedClassName;
	std::string m_PasswordString;
	std::string m_CAPathString;

	LibSESData::CClassGroupData* m_pClassGroup;
	LibSESData::CClassDef* m_pSelectedClass;
	LibSESData::CSESSystemSettingData* m_pSESSystemSettingData;

	// Maintain all already online students
	std::list<IPCAPI::StudentInfo_t*> m_pOnlineStudentList;

	// Maintain all waiting for approval students
	//std::list<IPCAPI::StudentInfo_t> m_WaitForApprovalStudentList;
	std::list<NewStudentConnectWindow*>	m_pNewStudentDialogList;

	DeployShellSettingsWindow* m_pDeploySettingsWindow;
	PassWordWindow* m_pPassWordWindow;
	ChangePasswordWindow* m_pChangePassWordWindow;
	ImportCAWindow* m_pImportWindow;
	SelectClassWindow* m_pSelectClassWindow;
	LockStudentsWindow* m_pLockStudentsWindow;
	TeacherInfoWindow* m_pTeacherInfoWindow;
	StudentDetailedInfoWindow* m_pStudentDetailedWindow;

	PreferenceWindow* m_pPreferenceWindow;
	LibSESGUI::CAboutDlg* m_pAboutdialogWindow;
	LibSESGUI::CShellSettingCtrlForShellController* m_pShellSetting;
	LibSESGUI::CSearchProgramForShellController* m_pSearchProgram;

	class CCompareStundentInfo
	{
	public:
	  CCompareStundentInfo(IPCAPI::tagStudent_t& TagStudent_t)
	  {
		  m_TagStudent_t = TagStudent_t;
	  }

	  CCompareStundentInfo(IPCAPI::tagStudent_t* pTagStudent_t)
	  {
		  m_TagStudent_t = *pTagStudent_t;
	  }

	  bool operator()(IPCAPI::tagStudent_t& TagStudent_t)
	  {
	  return  ((m_TagStudent_t.studentID == TagStudent_t.studentID));
	  }

	  bool operator()(IPCAPI::tagStudent_t* TagStudent_t)
	  {
		  return  ((m_TagStudent_t.studentID == TagStudent_t->studentID));
	  }

	  bool operator()(LibSESData::CStudentInfoData* studentInfo)
	  {
		  return  ( m_TagStudent_t.studentID == studentInfo->GetStudentID() );
	  }

	private:
		IPCAPI::tagStudent_t m_TagStudent_t;

	};

};

}

//struct ShellControllerWindowData
//{
//	ShellControllerWindow* shellControllerWindow;
//	NewStudentConnectWindow* newStudentConnectWindow;
//};

#endif /*SHELLCONTROLLERWINDOW_H_*/

