/*
 * ManualLock.cpp
 *
 *  Created on: 2008-12-18
 *      Author: wang-l@neusoft.com
 */
#include "ManualLockInfo.h"
#include "IPCCommonUtil.h"
using namespace IPCAPI;
ManualLock::ManualLock(LibSESData::CLockScheduleData& LockSchedule)
{
	this->m_pLockSchedule = &LockSchedule;
}
GtkWidget* ManualLock::CreateChild()
{
	m_pGtkWidget = gtk_text_view_new ();
	gtk_container_set_border_width(GTK_CONTAINER(m_pGtkWidget), 1);
	GtkTextBuffer* buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (m_pGtkWidget));

	gtk_text_view_set_editable(GTK_TEXT_VIEW(m_pGtkWidget),false);
	CManualLock* pManualLock = m_pLockSchedule->GetPManualLockInfo();
	string tempString = "<<Manual Policy>>\nOption:";
	if(0 == pManualLock->GetOption())
	{
		tempString += "Student will be locked forever";
	}
	else if(1==pManualLock->GetOption())
	{
		int time = pManualLock->GetUnlockAfterDisconnect();
		int hour = time/60;
		int minute = time%60;
		tempString += " Unlock student automatically ";
		tempString += IPCCommonUtil::ParseInt2String(hour);
		tempString += " hour ";
		tempString += IPCCommonUtil::ParseInt2String(minute);
		tempString += " mins ";
		tempString += "after students disconnect";
	}
	else if(2 == pManualLock->GetOption())
	{
		int time = pManualLock->GetUnlockAfterConnect();
		int hour = time/60;
		int minute = time%60;
		tempString += " Lock students in the shell for following ";
		tempString += IPCCommonUtil::ParseInt2String(hour);
		tempString += " hour ";
		tempString += IPCCommonUtil::ParseInt2String(minute);
		tempString += " mins ";
	}
	GtkTextIter iter;

	   gtk_text_buffer_get_iter_at_offset (buffer, &iter, 0);

	   gtk_text_buffer_insert (buffer, &iter,
	   _(tempString.c_str()), -1);
	   return m_pGtkWidget;
}
