/******************************************************************************
 * File Name    : SESCommonDef.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file contains macro defines
 ******************************************************************************/
#ifndef SESCOMMONDEF_H_
#define SESCOMMONDEF_H_
#include <gtk/gtk.h>
#include <string>
#include <vector>

#define DECLEAR_GTK_EVENT(className, func, gtkwidget, data) static void func##Static(GtkWidget* gtkwidget, gpointer data){((className*)data)->func(gtkwidget, data);} void func(GtkWidget* gtkwidget, gpointer data);
#define SES_G_CALLBACK(func) G_CALLBACK((func##Static))


const int BUTTON_CLICK_IS_CANCEL = 0;
const int BUTTON_CLICK_IS_OK = 1;

const int SHELLCONTROLLER_SUCCESSFUL = 0;
const int SHELLCONTROLLER_FAILED = -1;

// new student message.
const int NEW_STUDENT_SELECT_ALL = 1;
const int NEW_STUDENT_SELECT_ONE = 2;

const int STUDENT_IS_ALLOWED 		= 3;
const int STUDENT_IS_ADDED_TO_CLASS = 4;
const int STUDENT_IS_DISCONNECTED 	= 5;

const std::string::size_type MAX_VALID_STRING_SIZE = 64;

const unsigned int PASSWORD_MIN_LENGTH = 6;
const unsigned int PASSWORD_MAX_LENGTH = 64;

const int SES_BUTTON_WIDTH = 80;
const int SES_BUTTON_HEIGHT = 30;

const int SES_ENTRY_HEIGHT = 25;

const std::string OPEN_FOR_ALL_STUDENT = "Open for all students";

// Class Select Mode

enum ClassSelectStatus
{
	NoClass 	= 0,
	SomeClass	= 1,
	OpenForAll	= 2
};

enum QuitStatus
{
    SERVICE_FAILURE_QUIT,
    TIME_OUT_QUIT,
    RESTART_QUIT,
    PASSWORD_THREE_TIMES_QUIT,
    NOT_QUIT,
};

#endif /*SESCOMMONDEF_H_*/
