/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CTeacherAPICallbackBase.h

Description:

    This file defines class CTeacherAPICallbackBase.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Jin Xin     2008/9/16

  =====================================================================

****************************************************************************/

#ifndef CTEACHERAPICALLBACKBASE_H_
#define CTEACHERAPICALLBACKBASE_H_

#include "seslib.h"
#include "CommonMessage.h"

namespace IPCAPI
{

class CTeacherAPICallbackBase : public IPCAPI::IIPCTeacherAPICallback
{
public:
	CTeacherAPICallbackBase();
	virtual ~CTeacherAPICallbackBase();

public:
	virtual void SearchProgramCallBack(std::string /*studentID*/, std::string /*programsXML*/){};
	virtual void ManualLockRemotStudentCallBack(std::string /*studentID*/, int /*iReturn*/){};
	virtual void ManualUnLockRemotStudentCallBack(std::string /*studentID*/, int /*iReturn*/){};
	//virtual void IsRemoteStudentLockedCallBack(std::string studentID, bool isLock){};
	//virtual void GetStudentStatusCallBack(std::string studentID, std::string studentStatusXML){};
	//virtual void GetStudentDetailedInfoCallBack(std::string studentID, std::string studentDetailedInfoXML){};
	virtual void KickOffStudentCallBack(std::string /*studentID*/, int /*iReturn*/){};
	virtual void NotifyStudentStatusChanged(std::string /*studentID*/, int /*iStatus*/){};
	virtual void DeployTabNavPolicyCallBack(std::string /*studentID*/, bool /*bSuccess*/){};
	virtual void DeploySchedulePolicyCallBack(std::string /*studentID*/, bool /*bSuccess*/){};
	virtual void NewStudentCallBack(const IPCAPI::StudentInfo_t& /*studentInfo*/){};
	virtual void OnMessage(int /*MessageID*/, std::string /*Message*/) {};

protected:

	IPCAPI::IPCTeacherAPI* m_pTeacherAPI;
};

}

#endif /* CTEACHERAPICALLBACKBASE_H_ */
