/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CStudentAPICallbackBase.h

Description:

    This file defines class CStudentAPICallbackBase.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Jin Xin     2008/9/20

  =====================================================================

****************************************************************************/

#ifndef CSTUDENTAPICALLBACKBASE_H_
#define CSTUDENTAPICALLBACKBASE_H_

#include "seslib.h"

namespace IPCAPI
{

class CStudentAPICallbackBase : public IPCAPI::IIPCStudentAPICallback
{
public:
	CStudentAPICallbackBase();
	virtual ~CStudentAPICallbackBase();

public:
	virtual void ConnectTeacherCallBack(std::string /*strTeacherID*/, int /*iReturn*/){};
	virtual void SearchTeacherCallBack(const std::list<std::string>& /*strTeacherList*/){};
	virtual void NotifyLockStatusChanged(bool /*bLock*/){};
	virtual void NotifyTabNavPolicyChanged(){};
	virtual void NotifySchedulePolicyChanged(){};
	virtual void NotifyTeacherStatusChanged(std::string /*strTeacherID*/, int /*iState*/){};
	virtual void SearchLocalProgramCallBack(std::string /*programsXML*/){};
	virtual void OnMessage(int /*MessageID*/, std::string /*Message*/) {};
	virtual void NotifyTeacherNameChanged(std::string /*OldName*/, std::string /*NewName*/) {};
	virtual void PopNotifyCallback(int iMessageID, std::string MessageContent){};

protected:
	IPCAPI::IPCStudentAPI* m_pStudentAPI;
};

}

#endif /* CSTUDENTAPICALLBACKBASE_H_ */
