/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCAPIBase.h

Description:

    This file defines class IPCAPIBase.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCAPIBASE_H_
#define IPCAPIBASE_H_

//#include <dbus/dbus.h>
#include <string>

#include "IPCCommon.h"
#include "IntfData.h"

struct DBusMessage;

namespace IPCAPI
{
	class IPCController;

	class IPCAPIBase
	{
	protected:
		DBusMessage* m_dmsgCurMsg;
		IPCController * m_objController;
		bool m_bNeedDelete;
		static int m_iOPID;
	public:
		virtual ~IPCAPIBase();

	protected:
		IPCAPIBase();
		int GetOPID();
	private:
		IPCAPIBase(const IPCAPIBase&);
		IPCAPIBase& operator = (const IPCAPIBase&);

	public:
		APIResult Initialize(){return SES_API_SUCCESS;};
		APIResult UnInitialize(){return SES_API_SUCCESS;};

		virtual APIResult DoAction(std::string strName, std::string inArgs, std::string& outArgs);

		APIResult ReceiveMsg(int& iOPID, std::string& strOPName, std::string& outArgs);
		bool IsBlock();
		APIResult ReplyMsg(std::string inArgs);
		APIResult SendMsg(int& iOPID, std::string strOPName, std::string inArgs);

		bool IsNeedDelete();
		void Delete();
	};
}

#endif /*IPCAPIBASE_H_*/
