/**************************************************************************************************
 * File Name	: CAToolUtil.cpp
 * Created		: 2008-11-5
 * Author		: ChenWei
 * Model			: CATool
 * Description	:
 **************************************************************************************************/
#include <CAToolUtil.h>
#include <req.h>
#include <genrsa.h>
#include <sys/stat.h>
#include <iostream>
#include <fstream>
#include <CSESLog.h>
#include <ca.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <openssl/ssl.h>
#include "verify.h"

#include <stdlib.h>

using namespace LibSESData;
using namespace catool;
using namespace std;

/**************************************************************************************************
 * Function Name	: ImportRootCA
 * Description		: ImportRootCA
 * Date				: 2008-11-5
 * Return Code		:	1 success; 0 : Don't have rootca; -1: not SES rootca;
 *  					-2: don't have access;
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::ImportRootCA(const string& fromCAPath)
{
	CSESLog::WriteLine("CAToolUtil::ImportRootCA()>>Start");
	int iReturn = 1;
	string path;
	ofstream fout;

	do
	{
		if (!GetPath(path))
		{
			iReturn = -2;
			break;
		}
		string sysRootCA(path);
		string fromRootCA(fromCAPath);
		fromRootCA.append(CACERT);
		sysRootCA.append(CACERT);
		string foutMsg, foutMsg2;
		char ch;
		foutMsg.clear();

		ifstream fin;
		fin.open(fromRootCA.c_str(), ios::binary);
		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();

		string fromRootKey(fromCAPath);
		string sysRootKey(path);
		sysRootKey.append(CAKEY);
		fromRootKey.append(CAKEY);
		fin.open(fromRootKey.c_str(), ios::binary);
		if (!fin.good())
		{
			iReturn = -2;
			break;
		}

		foutMsg2.clear();
		while (fin.get(ch))
		{
			foutMsg2.append(1, ch);
		}
		fin.close();
		//		char* pFromRootCA = new char[fromRootCA.size() + 1];
		//		memset(pFromRootCA, 0, fromRootCA.size() + 1);
		//		memcpy(pFromRootCA, fromRootCA.c_str(), fromRootCA.size());
		//		char* pFromRootKey = new char[fromRootKey.size() + 1];
		//		memset(pFromRootKey, 0, fromRootKey.size() + 1);
		//		memcpy(pFromRootKey, fromRootKey.c_str(), fromRootKey.size());
		//		delete pFromRootCA;
		//		delete pFromRootKey;
		//		char aVerify[] =
		//		{ 'v', 'e', 'r', 'i', 'f', 'y', '\0' };
		//		char a_CAfile[] =
		//		{ '-', 'C', 'A', 'f', 'i', 'l', 'e', '\0' };
		//		char* acArg1[4] =
		//		{ aVerify, a_CAfile, pFromRootCA, pFromRootKey };
		//		char** ppcArg1;
		//		ppcArg1 = acArg1;

		//		if (0 == Verify(4, ppcArg1))
		//		{
		//			iReturn = -1;
		//			break;
		//		}
		//		SSL_METHOD *meth;
		//		SSL_load_error_strings();
		//		SSLeay_add_ssl_algorithms();
		//		meth = SSLv3_server_method();
		//		SSL_CTX *ctx = SSL_CTX_new(meth);
		//
		//		if (SSL_CTX_use_certificate_file(ctx, fromRootCA.c_str(),
		//				X509_FILETYPE_PEM) < 1)
		//		{
		//			iReturn = -1;
		//			break;
		//		}
		//		if (SSL_CTX_use_PrivateKey_file(ctx, fromRootKey.c_str(),
		//				X509_FILETYPE_PEM) < 1)
		//		{
		//			iReturn = -3;
		//			break;
		//		}
		//
		//		if (SSL_CTX_check_private_key(ctx) < 1)
		//		{
		//			iReturn = -3;
		//			break;
		//		}
		//		//pContext->context()->default_passwd_callback_userdata = NULL;
		//		SSL_CTX_free(ctx);

		if (0 == IsSESSubj(fromRootCA))
		{
			iReturn = -1;
			break;
		}

		fout.open(sysRootCA.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;
			break;
		}

		fout << foutMsg;
		fout.close();

		//filerootKey.append(SES);
		fout.open(sysRootKey.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}

		fout << foutMsg2;
		fout.close();


	} while (0);
	CSESLog::WriteLine("CAToolUtil::ImportRootCA()<<End");
	return iReturn;

}

/**************************************************************************************************
 * Function Name	: BackUpRootCA
 * Description		: BackUpRootCA
 * Date				: 2008-11-5
 * Return Code		:	1: success; 0 : Don't have rootca; -2 :don't have access
 * Author			: ChenWei
 **************************************************************************************************/

int CAToolUtil::BackUpRootCA(const string& DestCAPath)
{
	CSESLog::WriteLine("CAToolUtil::BackUpRootCA()>>Start");
	int iReturn = 1;
	string path;
	string rootCAPath;
	do
	{
		if (!GetPath(path))
		{
			iReturn = -2;
			break;
		}
		string filerootCA(DestCAPath);
		rootCAPath.append(path);
		string rootCA(rootCAPath);
		rootCA.append(CACERT);
		ifstream fin(rootCA.c_str(), ios::binary);

		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		char ch;
		string foutMsg;
		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();
		//filerootCA.append(SES);
		//		int iPos = 0,ifirst=0;;
		//		while (string::npos != iPos)
		//		{
		//			iPos=filerootCA.find('/',iPos);
		//			mkdir(filerootCA.substr(ifirst,iPos).c_str(), S_IRWXU);
		//			ifirst=iPos;
		//		}


		filerootCA.append(CACERT);
		ofstream fout;

		fout.open(filerootCA.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}

		fout << foutMsg;

		fout.close();

		string filerootKey(DestCAPath);
		string rootKey(rootCAPath);
		rootKey.append(CAKEY);
		fin.open(rootKey.c_str(), ios::binary);

		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		foutMsg.clear();
		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();
		//filerootKey.append(SES);
		filerootKey.append(CAKEY);
		fout.open(filerootKey.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}
		fout << foutMsg;
		fout.close();


	} while (0);
	CSESLog::WriteLine(iReturn, "CAToolUtil::BackUpRootCA()>>ed:");

	return iReturn;

}

/**************************************************************************************************
 * Function Name	: ExportServerCert
 * Description		: ExportServerCert
 * Date				: 2008-11-5
 * Return Code		:	1 :success; 0 : Don't have ServerCert; -2 :don't have access
 * Author			: ChenWei
 **************************************************************************************************/

int CAToolUtil::ExportServerCert(const string& DestServerCertPath)
{
	CSESLog::WriteLine("CAToolUtil::ExportServerCert()>>Start");
	int iReturn = 1;
	string path;
	string rootCAPath;
	string servercert;
	string servercertPath;
	do
	{
		if (!GetPath(path))
		{
			iReturn = -2;
			break;
		}

		string filerootCA(DestServerCertPath);
		rootCAPath.append(path);
		string rootCA(rootCAPath);
		rootCA.append(CACERT);
		ifstream fin(rootCA.c_str(), ios::binary);

		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		//filerootCA.append(SES);
		//		int iPos = 0,ifirst=0;;
		//		while (string::npos != iPos)
		//		{
		//			iPos=filerootCA.find('/',iPos);
		//			mkdir(filerootCA.substr(ifirst,iPos).c_str(), S_IRWXU);
		//			ifirst=iPos;
		//		}
		string foutMsg;
		char ch;
		foutMsg.clear();

		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();
		filerootCA.append(CACERT);
		ofstream fout;

		fout.open(filerootCA.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}
		fout << foutMsg;
		fout.close();

		string fileServer(DestServerCertPath);
		servercertPath.append(path);
		servercert.append(servercertPath);
		servercert.append(SERVERCERT);
		fin.open(servercert.c_str(), ios::binary);

		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		//filerootCA.append(SES);
		//		int iPos = 0,ifirst=0;;
		//		while (string::npos != iPos)
		//		{
		//			iPos=filerootCA.find('/',iPos);
		//			mkdir(filerootCA.substr(ifirst,iPos).c_str(), S_IRWXU);
		//			ifirst=iPos;
		//		}

		foutMsg.clear();

		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();
		fileServer.append(SERVERCERT);

		fout.open(fileServer.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}

		fout << foutMsg;
		fout.close();

		string fileServerKey(DestServerCertPath);
		string rootKey(servercertPath);
		rootKey.append(SERVERKEY);
		fin.open(rootKey.c_str(), ios::binary);

		if (!fin.good())
		{
			iReturn = 0;
			break;
		}
		foutMsg.clear();

		while (fin.get(ch))
		{
			foutMsg.append(1, ch);
		}
		fin.close();
		//filerootKey.append(SES);
		fileServerKey.append(SERVERKEY);
		fout.open(fileServerKey.c_str(), ios::binary);
		if (!fout.good())
		{
			iReturn = -2;

			break;
		}

		fout << foutMsg;
		fout.close();


	} while (0);

	CSESLog::WriteLine(iReturn, "CAToolUtil::ExportServerCert()>>ed:");

	return iReturn;
}

/**************************************************************************************************
 * Function Name	: Init
 * Description		: Init serial and index
 * Date				: 2008-11-5
 * Return Code		:	1: success; 0 : Don't access /home/usr/SES
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::Init()
{
	CSESLog::WriteLine("CAToolUtil::Init()>>Start", CSESLog::TRACE,
			"CAToolUtil");
	CSESLog::WriteLine("CAToolUtil::Init()>>Start");
	int iReturn = 1;
	string path;

	do
	{
		if (!GetPath(path))
		{
			iReturn = 0;
			break;
		}
		string filename(path);
		filename.append(FILENAME);
		ofstream fout(filename.c_str());
		if (!fout.good())
		{
			iReturn = 0;
			break;
		}
		fout.close();
		string temp;

		//serial
		string serial(path);
		serial.append("/serial");
		fout.open(serial.c_str());
		if (!fout.good())
		{
			iReturn = -1;
			break;
		}
		string serial01("01");
		fout << serial01 << endl;
		fout.close();

		//serial
		string index(path);
		index.append("/index.txt");
		fout.open(index.c_str());
		if (!fout.good())
		{
			iReturn = -1;
			break;
		}
		fout << "V	111015104226Z		00	unknown	/C=CN/ST=CN/O=CN"
			"/OU=CN/CN=CN/emailAddress=xxx@xxx.com" << endl;
		fout.close();
	} while (0);
	CSESLog::WriteLine(iReturn, "CAToolUtil::Init()>>END :");
	return iReturn;

}

/**************************************************************************************************
 * Function Name	: Uninit
 * Description		: Uninit serial and index
 * Date				: 2008-11-5
 * Return Code		:	1: success; 0 : Don't access /home/usr/SES
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::Uninit()
{
	int iReturn = 1;
	do
	{
		string path;
		if (!GetPath(path))
		{
			iReturn = 0;
			break;
		}
		string comm("rm ");
		comm.append(path);
		string delFile(comm);

		delFile.append("/01.pem");
		system(delFile.c_str());

		delFile.clear();
		delFile.append(comm);
		delFile.append("/careq.pem");
		system(delFile.c_str());

		delFile.clear();
		delFile.append(comm);
		delFile.append("/ind*");
		system(delFile.c_str());

		delFile.clear();
		delFile.append(comm);
		delFile.append("/openssl.cnf");
		system(delFile.c_str());

		delFile.clear();
		delFile.append(comm);
		delFile.append("/ser*");
		system(delFile.c_str());

		delFile.clear();
		delFile.append(comm);
		delFile.append("/sslservercareq.pem");
		system(delFile.c_str());

	} while (0);
	return iReturn;
}

/**************************************************************************************************
 * Function Name	: HaveRootCA
 * Description		:
 * Date				: 2008-11-5
 * Return Code		: 1:have 0 no -1 err
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::HaveRootCA(const string& desPath)
{
	int iReturn = 1;
	string path;
	string strLogFolderName(SES);
	string fileKey;
	do
	{

		string filename(desPath);
		filename.append(CACERT);
		ifstream _file;
		_file.open(filename.c_str(), ios::in);
		if (!_file.good())
		{
			iReturn = 0;
			_file.close();
			break;
		}
		else
		{
			iReturn = 1;
		}
		if (!IsSESSubj(filename))
		{
			iReturn = 0;
			break;
		}
		//filename.clear();
		fileKey.append(desPath);
		fileKey.append(CAKEY);
		_file.close();
		_file.open(fileKey.c_str(), ios::in);
		if (!_file.good())
		{
			_file.close();
			iReturn = 0;
			break;
		}
		else
		{
			iReturn = 1;
		}
		_file.close();
		SSL_METHOD *meth;
		SSL_load_error_strings();
		SSLeay_add_ssl_algorithms();
		meth = SSLv3_server_method();
		SSL_CTX *ctx = SSL_CTX_new(meth);

		if (SSL_CTX_use_certificate_file(ctx, filename.c_str(),
				X509_FILETYPE_PEM) < 1)
		{
			iReturn = -1;
			break;
		}
		if (SSL_CTX_use_PrivateKey_file(ctx, fileKey.c_str(),
				X509_FILETYPE_PEM) < 1)
		{
			iReturn = -3;
			break;
		}

		if (SSL_CTX_check_private_key(ctx) < 1)
		{
			iReturn = -3;
			break;
		}
		//pContext->context()->default_passwd_callback_userdata = NULL;
		SSL_CTX_free(ctx);

	} while (0);

	return iReturn;
}

/**************************************************************************************************
 * Function Name	: HaveServerCert
 * Description		:
 * Date				: 2008-11-5
 * Return Code		: 1:have 0 no -1 err
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::HaveServerCert(const string& desPath)
{
	int iReturn = 1;
	string path;
	string strLogFolderName(SES);
	do
	{

		string filename(desPath);
		filename.append(SERVERCERT);
		ofstream _file;
		_file.open(filename.c_str(), ios::in);
		if (!_file.good())
		{
			iReturn = 0;
			_file.close();
			break;
		}
		else
		{
			iReturn = 1;
		}

		filename.clear();
		filename.append(desPath);
		filename.append(SERVERKEY);
		_file.close();
		_file.open(filename.c_str(), ios::in);
		if (!_file)
		{
			_file.close();
			iReturn = 0;
			break;
		}
		else
		{
			iReturn = 1;
		}
		_file.close();

		filename.clear();
		filename.append(desPath);
		filename.append(CACERT);
		_file.close();
		_file.open(filename.c_str(), ios::in);
		if (!_file.good())
		{
			_file.close();
			iReturn = 0;
			break;
		}
		else
		{
			iReturn = 1;
		}
		_file.close();
	} while (0);

	return iReturn;
}
/**************************************************************************************************
 * Function Name	: GenerationRootCA
 * Description		:
 * Date				: 2008-11-5
 * Return Code		: 1:success 0 err -1 can't access file
 * Author			: ChenWei
 **************************************************************************************************/

int CAToolUtil::GenerateRootCA(const std::string& schoolName)
{

	int iReturn = 1;
	string path;
	string strLogFolderName(SES);
	do
	{
		if (NULL == getenv("HOME"))
		{
			path.append("/root");
		}
		else
		{
			path.append(getenv("HOME"));
		}
		if (access(path.c_str(), W_OK) == 0)
		{
			path.append(strLogFolderName);
			if (access(path.c_str(), R_OK ) != 0)
			{
				mkdir(path.c_str(), S_IRWXU);
			}

		}
		else
		{
			iReturn = 0;
			break;
		}
		string filename(path);
		filename.append(FILENAME);
		ofstream fout(filename.c_str());
		if (!fout.good())
		{
			iReturn = 0;
			break;
		}
		//fout.open("/home/chenwei/SESCA/results.txt",)
		string temp = "[ ca ]\ndefault_ca = myca\n[ myca ]\ndir = ";
		temp.append(path);
		temp.append("\ncertificate = $dir/cacert.pem\n"
			"database = $dir/index.txt\n"
			"new_certs_dir = $dir/"
			"\nprivate_key = $dir/cakey.pem\nserial"
			" = $dir/serial\n"
			"default_crl_days= 7\ndefault_days = "
			"36500\ndefault_md = md5\npolicy = myca_policy\nx509_"
			"extensions = certificate_extensions\n[ myca_policy ]\n"
			"commonName = supplied\nstateOrProvinceName = supplied\n"
			"countryName = supplied\nemailAddress = supplied\n"
			"organizationName= supplied\norganizationalUnitName ="
			"optional\n[ certificate_extensions ]    \n"
			"basicConstraints= CA:false\n"
			"[ req ]\ndefault_bits = 2048\ndefault_keyfile =");
		temp.append(path);
		temp.append("/cakey.pem\ndefault_md = md5\nprompt = no\n"
			"distinguished_name = root_ca_distinguished_name\n"
			"x509_extensions = root_ca_extensions\n"
			"[ root_ca_distinguished_name ]    \n"
			"commonName =Simplified Education Shell");

		temp.append("\nstateOrProvinceName = CN    \n"
			"countryName = CN    \n"
			"emailAddress = xxx@xxx.com    \n"
			"organizationName = ");
		temp.append(schoolName);
		temp.append(
				"\n[ root_ca_extensions ]        \nbasicConstraints = CA:true");
		fout << temp << endl;
		fout.close();
		//getenv
		setenv("OPENSSL_CONF", filename.c_str(), 1);
		string cacert(path);
		cacert.append("/cacert.pem");
		char cCacert[64];
		strcpy(cCacert, cacert.c_str());
		string cakey(path);
		cakey.append("/cakey.pem");
		char cCakey[64] =
		{ 0 };

		strcpy(cCakey, cakey.c_str());

		string caReq(path);
		caReq.append("/careq.pem");
		char cCaReq[64] =
		{ 0 };
		strcpy(cCaReq, caReq.c_str());

		const int iacArg1 = 4;
		//		string str1="genrsa";
		//		char* pc1;
		//		memset(pc1,);
		//		strcpy();
		char genrsa[] =
		{ 'g', 'e', 'n', 'r', 's', 'a', '\0' };
		char out[] =
		{ '-', 'o', 'u', 't', '\0' };
		char time[] =
		{ '2', '0', '4', '8', '\0' };
		char req[] =
		{ 'r', 'e', 'q', '\0' };
		char _new[] =
		{ '-', 'n', 'e', 'w', '\0' };
		char _key[] =
		{ '-', 'k', 'e', 'y', '\0' };
		char _in[] =
		{ '-', 'i', 'n', '\0' };
		char _x509[] =
		{ '-', 'x', '5', '0', '9', '\0' };
		char* acArg1[iacArg1] =
		{ genrsa, out, cCakey, time };
		char** ppcArg1;
		ppcArg1 = acArg1;
		Genrsa(iacArg1, ppcArg1);

		const int iacArg2 = 6;
		//req -new -key key.pem -out req.pem

		char * acArg2[iacArg2] =
		{ req, _new, _key, cCakey, out, cCaReq };

		//				char* acArg2[] =
		//		{ "req", "-x509", "-newkey", "rsa:2048", "-passin", "file:pass.pw",
		//								"-out", cCacert, "-outform", "PEM" };

		char** ppcArg2;
		ppcArg2 = acArg2;
		Req(iacArg2, ppcArg2);

		const int iacArg3 = 8;
		//req -new -key key.pem -out req.pem
		char * acArg3[iacArg3] =
		{ req, _in, cCaReq, _x509, _key, cCakey, out, cCacert };

		//				char* acArg2[] =
		//		{ "req", "-x509", "-newkey", "rsa:2048", "-passin", "file:pass.pw",
		//								"-out", cCacert, "-outform", "PEM" };

		char** ppcArg3;
		ppcArg3 = acArg3;
		Req(iacArg3, ppcArg3);
		string test = "";
		//GetSubj(test, "/root/CA/cacert.pem");
		unsetenv("OPENSSL_CONF");
	} while (0);
	string caSubj(path);
	caSubj.append(CACERT);

	return iReturn;

}

/**************************************************************************************************
 * Function Name	: GenerateServerCert
 * Description		: GenerateServerCertification
 * Date				: 2008-11-5
 * Return Code		: 1:success; 0 :err
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::GenerateServerCert(const std::string& password)
{
	int iReturn = 1;

	string path;
	string strLogFolderName(SES);
	do
	{
		if (NULL == getenv("HOME"))
		{
			path.append("/root");
		}
		else
		{
			path.append(getenv("HOME"));
		}
		if (access(path.c_str(), W_OK) == 0)
		{
			path.append(strLogFolderName);
			if (access(path.c_str(), R_OK ) != 0)
			{
				mkdir(path.c_str(), S_IRWXU);
			}

		}
		else
		{
			iReturn = 0;
			break;
		}

		string filename(path);
		filename.append(FILENAME);
		ofstream fout(filename.c_str());
		if (!fout.good())
		{
			iReturn = 0;
			break;
		}
		//fout.open("/home/chenwei/SESCA/results.txt",)
		string temp = "[ ca ]\ndefault_ca = myca\n[ myca ]\ndir = ";
		temp.append(path);
		temp.append("\ncertificate = $dir/cacert.pem\n"
			"database = $dir/index.txt\n"
			"new_certs_dir = $dir/"
			"\nprivate_key = $dir/cakey.pem\nserial"
			" = $dir/serial\n"
			"default_crl_days= 7\ndefault_days = "
			"36500\ndefault_md = md5\npolicy = myca_policy\nx509_"
			"extensions = certificate_extensions\n[ myca_policy ]\n"
			"commonName = supplied\nstateOrProvinceName = supplied\n"
			"countryName = supplied\nemailAddress = supplied\n"
			"organizationName= supplied\norganizationalUnitName ="
			"optional\n[ certificate_extensions ]    \n"
			"basicConstraints= CA:false\n"
			"[ req ]\ndefault_bits = 2048\ndefault_keyfile =");
		temp.append(path);
		temp.append("/cakey.pem\ndefault_md = md5\nprompt = no\n"
			"distinguished_name = root_ca_distinguished_name\n"
			"x509_extensions = root_ca_extensions\n"
			"[ root_ca_distinguished_name ]    \n"
			"commonName =Simplified Education Shell");

		temp.append("\nstateOrProvinceName = CN    \n"
			"countryName = CN    \n"
			"emailAddress = xxx@xxx.com    \n"
			"organizationName = ");
		string subj;
		string organizationName;
		string rootCaPath(path);
		rootCaPath.append(CACERT);
		GetSubj(subj, rootCaPath);
		int iPosStart = 0, iPosEnd = 0;
		//cout << subj << endl;
		iPosStart = subj.find("/O=", iPosStart);
		cout << iPosStart << endl;
		iPosEnd = subj.find("/", iPosStart + 1);
		cout << iPosEnd << endl;
		if (1 > (iPosEnd - 3 - iPosStart))
		{
			iReturn = 0;
			break;
		}
		organizationName = subj.substr(iPosStart + 3, iPosEnd - 3 - iPosStart);
		cout << "organizationName" << organizationName << endl;
		temp.append(organizationName);
		temp.append(
				"\n[ root_ca_extensions ]        \nbasicConstraints = CA:true");
		fout << temp << endl;
		fout.close();
		//serial
		string serial(path);
		serial.append("/serial");
		fout.open(serial.c_str());
		if (!fout.good())
		{
			iReturn = -1;
			break;
		}
		string serial01("01");
		fout << serial01 << endl;
		fout.close();

		//serial
		string index(path);
		index.append("/index.txt");
		fout.open(index.c_str());
		if (!fout.good())
		{
			iReturn = -1;
			break;
		}
		fout << "V	111015104226Z		00	unknown	/C=CN/ST=CN/O=CN"
			"/OU=CN/CN=CN/emailAddress=xxx@xxx.com" << endl;
		fout.close();

		string passwordpath(path);
		passwordpath.append("/pwd.txt");

		string cacert(path);
		cacert.append("/cacert.pem");
		char cCacert[64] =
		{ 0 };
		strcpy(cCacert, cacert.c_str());

		string servercert(path);
		servercert.append("/sslservercert.pem");
		char cServercert[64];
		strcpy(cServercert, servercert.c_str());

		string cakey(path);
		cakey.append("/sslserverkey.pem");
		char cCakey[64] =
		{ 0 };
		strcpy(cCakey, cakey.c_str());

		string caReq(path);
		caReq.append("/sslservercareq.pem");
		char cCaReq[64];
		strcpy(cCaReq, caReq.c_str());

		string filePassword("file:");
		filePassword.append(passwordpath);
		char cPassword[64] =
		{ 0 };
		strcpy(cPassword, filePassword.c_str());
		char acPass[70] =
		{ 0 };
		string passpassword("pass:");
		passpassword.append(password);
		strcpy(acPass, passpassword.c_str());
		const int iacArg1 = 7;
		//req -newkey rsa:1024 -keyout testkey.pem -keyform PEM -out testreq.pem -outform PEM
		char genrsa[] =
		{ 'g', 'e', 'n', 'r', 's', 'a', '\0' };
		char _out[] =
		{ '-', 'o', 'u', 't', '\0' };
		char time1024[] =
		{ '1', '0', '2', '4', '\0' };
		char req[] =
		{ 'r', 'e', 'q', '\0' };
		char _new[] =
		{ '-', 'n', 'e', 'w', '\0' };
		char _key[] =
		{ '-', 'k', 'e', 'y', '\0' };
		char _in[] =
		{ '-', 'i', 'n', '\0' };
		char des3[] =
		{ '-', 'd', 'e', 's', '3', '\0' };
		char _cert[] =
		{ '-', 'c', 'e', 'r', 't', '\0' };
		char ca[] =
		{ 'c', 'a', '\0' };
		char _passout[] =
		{ '-', 'p', 'a', 's', 's', 'o', 'u', 't', '\0' };
		char _passin[] =
		{ '-', 'p', 'a', 's', 's', 'i', 'n', '\0' };
		char _subj[] =
		{ '-', 's', 'u', 'b', 'j', '\0' };
		char * acArg1[iacArg1] =
		{ genrsa, des3, _passout, acPass, _out, cCakey, time1024 };
		//		char* acArg1[iacArg1] =
		//				{ "req", "-newkey", "rsa:1024", "-keyout", cCakey, "-out", cCaReq,
		//						"-subj", "/CN=CN/OU=test/O=abc/CN=someschool"
		//						};


		//req -newkey rsa:1024 -keyout cCakey.pem -out cCaReq.pem -subj /CN=CN/OU=test/O=abc/CN=someschool -passin file:pwd.txt
		char** ppcArg1;
		ppcArg1 = acArg1;
		Genrsa(iacArg1, ppcArg1);

		const int iacArg2 = 10;
		//req -new -key key.pem -out req.pem
		char acSubj[256] =
		{ 0 };
		string strsubj("/CN=Simplified Education Shell/OU=OU/O=");
		strsubj.append(organizationName);
		strsubj.append("/ST=ST/C=CN/emailAddress=xxx@xxx.com");
		strcpy(acSubj, strsubj.c_str());
		char
				* acArg2[iacArg2] =
				{ req, _new, _passin, acPass, _key, cCakey, _out, cCaReq,
						_subj, acSubj };

		char** ppcArg2;
		ppcArg2 = acArg2;
		Req(iacArg2, ppcArg2);

		const int iacArg3 = 7;
		//req -new -key key.pem -out req.pem
		string filenameConf(path);
		filenameConf.append(FILENAME);

		setenv("OPENSSL_CONF", filenameConf.c_str(), 1);
		char * acArg3[iacArg3] =
		{ ca, _cert, cCacert, _in, cCaReq, _out, cServercert };

		char** ppcArg3;
		ppcArg3 = acArg3;
		Ca(iacArg3, ppcArg3);
		unsetenv("OPENSSL_CONF");
	} while (0);

	return iReturn;
}

/**************************************************************************************************
 * Function Name	: Init
 * Description		:
 * Date				: 2008-11-5
 * Return Code		:	1 success 0 : Don't access /home/usr/SES
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::GetPath(string& SESPath)
{

	int iReturn = 1;
	SESPath.clear();

	string strLogFolderName(SES);
	do
	{
		if (NULL == getenv("HOME"))
		{
			SESPath.append("/root");
		}
		else
		{
			SESPath.append(getenv("HOME"));
		}
		if (access(SESPath.c_str(), W_OK) == 0)
		{
			SESPath.append(strLogFolderName);
			if (access(SESPath.c_str(), R_OK ) != 0)
			{
				mkdir(SESPath.c_str(), S_IRWXU);
			}
		}
		else
		{
			iReturn = 0;
			break;
		}
	} while (0);

	return iReturn;
}

/**************************************************************************************************
 * Function Name	: GetSubj
 * Description		:
 * Date				: 2008-11-5
 * Return Code		:	1 success 0 : Don't access /home/usr/SES
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::GetSubj(std::string& subj, const std::string& filename)
{
	X509 *x = NULL;
	BIO *b = NULL;
	/* cert.cer为PEM 格式的数字证书 */
	int iReturn = 0;
	b = BIO_new_file(filename.c_str(), "r");
	if (NULL != b)
	{
		x = PEM_read_bio_X509(b, NULL, NULL, NULL);
		if (NULL != x)
		{
			//	int iReturn = 1;
			//	X509 * server_cert;
			char * str;
			str = X509_NAME_oneline(X509_get_subject_name(x), 0, 0);
			if (str != NULL)
			{
				printf(" subject: [%s]\n", str);
				subj.append(str);
				OPENSSL_free(str);
			}

			str = X509_NAME_oneline(X509_get_issuer_name(x), 0, 0);
			if (str != NULL)
			{
				printf(" issuer: [%s]\n", str);
				subj.append(str);
				OPENSSL_free(str);
				iReturn = 1;
			}
			X509_free(x);
		}
		BIO_free(b);

	}
	return iReturn;

}

/**************************************************************************************************
 * Function Name	: IsSESSubj
 * Description		:
 * Date				: 2008-11-5
 * Return Code		: 1:success
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::IsSESSubj(const std::string& filename)
{
	int iReturn = 0;
	X509 *x = NULL;
	BIO *b = NULL;
	/* cert.cer为PEM 格式的数字证书 */
	b = BIO_new_file(filename.c_str(), "r");
	if (NULL != b)
	{
		x = PEM_read_bio_X509(b, NULL, NULL, NULL);
		if (NULL != x)
		{
			//	int iReturn = 1;
			//	X509 * server_cert;
			char * str = NULL;
			string strSubj;
			str = X509_NAME_oneline(X509_get_subject_name(x), 0, 0);
			if (str != NULL)
			{
				printf(" subject: [%s]\n", str);
				strSubj.append(str);
				if (strSubj.find(SESSUBJ) >= 0)
				{
					iReturn = 1;
				}

				OPENSSL_free(str);
			}

			str = X509_NAME_oneline(X509_get_issuer_name(x), 0, 0);
			if (str != NULL)
			{
				printf(" issuer: [%s]\n", str);
				strSubj.clear();
				strSubj.append(str);
				if (strSubj.find(SESSUBJ) >= 0)
				{
					if (iReturn)
					{
						iReturn = 1;
					}

				}
				OPENSSL_free(str);
			}
			X509_free(x);
		}
		BIO_free(b);
	}
	return iReturn;

}

/**************************************************************************************************
 * Function Name	: IsSESSubj
 * Description		:
 * Date				: 2008-11-5
 * Return Code		: 1:success
 * Author			: ChenWei
 **************************************************************************************************/
int CAToolUtil::GetON(std::string& context)
{
	string path;
	GetPath(path);
	string subj;
	string organizationName;
	string rootCaPath(path);
	rootCaPath.append(CACERT);
	GetSubj(subj, rootCaPath);
	int iPosStart = 0, iPosEnd = 0;
	//cout << subj << endl;
	iPosStart = subj.find("/O=", iPosStart);
	//cout << iPosStart << endl;

	iPosEnd = subj.find("/", iPosStart + 1);
	//cout<<iPosEnd<<endl;

	organizationName = subj.substr(iPosStart + 3, iPosEnd - 3 - iPosStart);
	context.clear();
	context.append(organizationName.c_str());

	return 0;
}
