/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHGlanceGesture.h"
#include "Log.h"

#define PROP_SHAKING_SENSITIVITY 81

#define SHAKE_SEN_LOW 0
#define SHAKE_SEN_MEDIUM 1
#define SHAKE_SEN_HIGH 2

struct shaking_property {
        unsigned char type;
        int sensitivity;
}__attribute__ ((packed));

struct shaking_data {
        int64_t ts;
        short shaking;
} __attribute__ ((packed));

PSHGlanceGesture::PSHGlanceGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
        :PSHSensor(device, information, data, service)
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

PSHGlanceGesture::~PSHGlanceGesture()
{

}

bool PSHGlanceGesture::startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs)
{
        struct shaking_property property = { PROP_SHAKING_SENSITIVITY, SHAKE_SEN_LOW };
        setProperty(session, &property, sizeof(property));

        return PSHSensor::startStreaming(session, samplingPeriodUs, maxReportLatencyUs);
}

size_t PSHGlanceGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct shaking_data);

        if (bufSize % sizeof(struct shaking_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct shaking_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct shaking_data *shaking = reinterpret_cast<const struct shaking_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = shaking[i].ts;
                mEvents[i].data[0] = 1.0;
        }
        return count;
}
