#include "ISHTapping.h"
#include "Log.h"

// LUID: 0210000000000000

struct tapping_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char tapping;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct tapping_aware {
        int64_t timestamp;
        unsigned char tapping;
} __attribute__ ((packed));

ISHTapping::ISHTapping(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHTapping::ISHTapping(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHTapping::~ISHTapping()
{

}

void ISHTapping::initialize()
{
}

size_t ISHTapping::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct tapping_raw);

        if (bufSize % sizeof(struct tapping_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct tapping_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct tapping_aware));

        const struct tapping_raw *tapping = reinterpret_cast<const struct tapping_raw *>(buf);
        struct tapping_aware *aware = reinterpret_cast<struct tapping_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = tapping[i].timestamp * US_TO_NS;
                aware[i].tapping = tapping[i].tapping;
        }

        return count * sizeof(struct tapping_aware);
}

size_t ISHTapping::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct tapping_raw);

        if (bufSize % sizeof(struct tapping_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct tapping_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct tapping_raw *tapping = reinterpret_cast<const struct tapping_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = tapping[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = tapping[i].tapping;
        }

        return count;
}
