#include "ISHEnergyExpenditure.h"
#include "Log.h"

// LUID:0238000000000080
struct energy_expenditure_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint32_t calorie_burn;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct energy_expenditure_aware {
        int64_t timestamp;
        uint32_t calorie_burn;
} __attribute__ ((packed));

ISHEnergyExpenditure::ISHEnergyExpenditure(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHEnergyExpenditure::ISHEnergyExpenditure(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHEnergyExpenditure::~ISHEnergyExpenditure()
{

}

void ISHEnergyExpenditure::initialize()
{

}

size_t ISHEnergyExpenditure::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct energy_expenditure_raw);

        if (bufSize % sizeof(struct energy_expenditure_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct energy_expenditure_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct energy_expenditure_aware));

        const struct energy_expenditure_raw *energy_expenditure = reinterpret_cast<const struct energy_expenditure_raw *>(buf);
        struct energy_expenditure_aware *aware = reinterpret_cast<struct energy_expenditure_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = energy_expenditure[i].timestamp * US_TO_NS;
                aware[i].calorie_burn = energy_expenditure[i].calorie_burn;
        }

        return count * sizeof(struct energy_expenditure_aware);
}

size_t ISHEnergyExpenditure::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct energy_expenditure_raw);

        if (bufSize % sizeof(struct energy_expenditure_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct energy_expenditure_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct energy_expenditure_raw *calorie = reinterpret_cast<const struct energy_expenditure_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = calorie[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = calorie[i].calorie_burn;
        }

        return count;
}
