/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _PLATFORM_SERVICE_H_
#define _PLATFORM_SERVICE_H_

#include "Sensor.h"
#include "sensorhubd.h"
#include <queue>
#include <libxml/tree.h>

class SensorEnumerator;
class PlatformService {
public:
        virtual ~PlatformService() { }
        virtual void getDataFds(std::queue<int> &dataFdQueue) = 0;
        virtual dataSelectMode getDataSelectMode() = 0;
        virtual bool handleEvents(int fd) = 0;
        virtual int enumerateSensors(SensorEnumerator * enumerator, const xmlNodePtr ishRoot, std::vector<Sensor *> &sensors) = 0;
        virtual int getNotifyFd() = 0;
        virtual void handleNotify(int notification) = 0;
};

#endif
