#include "ISHLinearAcceleration.h"
#include "Log.h"

struct linear_acceleration_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct linear_acceleration_data {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

ISHLinearAcceleration::ISHLinearAcceleration(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHLinearAcceleration::ISHLinearAcceleration(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHLinearAcceleration::~ISHLinearAcceleration()
{

}

void ISHLinearAcceleration::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHLinearAcceleration::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct linear_acceleration_raw);

        if (bufSize % sizeof(struct linear_acceleration_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct linear_acceleration_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct linear_acceleration_raw *linear_acceleration = reinterpret_cast<const struct linear_acceleration_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = linear_acceleration[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = linear_acceleration[i].x * scaleX;
                mEvents[i].data[1] = linear_acceleration[i].y * scaleY;
                mEvents[i].data[2] = linear_acceleration[i].z * scaleZ;
        }
        return count;
}
