/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SESSION_H_
#define _SESSION_H_
#include <map>
#include "Sensor.h"

class Session {
        std::map<int, Sensor *> activateSensors;
        session_category_t category;
        int ctrlFd;
        int eventsFd;
public:
        Session(int eventsFd);
        ~Session();
        void setCategory(session_category_t category);
        session_category_t getCategory() { return category; }
        void setControlFd(int ctrlFd);
        int getControlFd() { return ctrlFd; }
        void activateSensor(int handle, Sensor * sensor, bool activate);
        bool sensorIsActivated(int handle);
        void dispatchEvents(size_t size, void * buf);
};

#endif
