/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "SensorList.h"
#include "Log.h"

SINGLETON_STATIC_INSTANCE(SensorList)

SensorList::SensorList()
        :androidSensorCount(0), awareSensorCount(0)
{
        bool result = enumerator.enumerateSensors(mSensorList, mServiceList);
        if (!result) {
                ALOGE("%s line: %d Enumerate sensors failed!", __FUNCTION__, __LINE__);
                return;
        }

        for (std::map<int, Sensor *>::iterator it = mSensorList.begin(); it != mSensorList.end(); it++) {
                if (it->second->exposeToAndroid())
                        androidSensorCount++;
                if (it->second->exposeToCSDK())
                        awareSensorCount++;
        }

        if (androidSensorCount == 0)
                androidSensorList = NULL;
        else
                androidSensorList = new sensor_device_t[androidSensorCount];

        if (awareSensorCount == 0)
                awareSensorList = NULL;
        else
                awareSensorList = new sensor_device_t[awareSensorCount];

        int i = 0, j = 0;
        for (std::map<int, Sensor *>::iterator it = mSensorList.begin(); it != mSensorList.end(); it++) {
                if (it->second->exposeToAndroid()) {
                        if (androidSensorList != NULL)
                                androidSensorList[i++] = it->second->getDevice();
                }
                if (it->second->exposeToCSDK()) {
                        if (awareSensorList != NULL)
                                awareSensorList[j++] = it->second->getDevice();
                }
        }
        ALOGD_IF(VERBOSE, "sensorhub %s line: %d androidSensorList: %d awareSensorList: %d", __FUNCTION__, __LINE__, androidSensorCount, awareSensorCount);
}

Sensor * SensorList::getSensor(int handle)
{
        std::map<int, Sensor *>::iterator it = mSensorList.find(handle);
        if (it == mSensorList.end()) {
                ALOGE("%s line: %d Cannot find sensor with handle %d!", __FUNCTION__, __LINE__, handle);
                return NULL;
        }

        return it->second;
}

size_t SensorList::getSensorList(const struct sensor_device_t ** list)
{
        *list = androidSensorList;
        return androidSensorCount;
}

size_t SensorList::getAwareList(const struct sensor_device_t ** list)
{
        *list = awareSensorList;
        return awareSensorCount;
}
