/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_samr.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_netr_SamDatabaseID(struct ndr_push *ndr, int ndr_flags, enum netr_SamDatabaseID r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_SamDatabaseID(struct ndr_pull *ndr, int ndr_flags, enum netr_SamDatabaseID *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamDatabaseID(struct ndr_print *ndr, const char *name, enum netr_SamDatabaseID r)
{
	const char *val = NULL;

	switch (r) {
		case SAM_DATABASE_DOMAIN: val = "SAM_DATABASE_DOMAIN"; break;
		case SAM_DATABASE_BUILTIN: val = "SAM_DATABASE_BUILTIN"; break;
		case SAM_DATABASE_PRIVS: val = "SAM_DATABASE_PRIVS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_AcctFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_AcctFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AcctFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_DISABLED", ACB_DISABLED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_HOMDIRREQ", ACB_HOMDIRREQ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_PWNOTREQ", ACB_PWNOTREQ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_TEMPDUP", ACB_TEMPDUP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_NORMAL", ACB_NORMAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_MNS", ACB_MNS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_DOMTRUST", ACB_DOMTRUST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_WSTRUST", ACB_WSTRUST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_SVRTRUST", ACB_SVRTRUST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_PWNOEXP", ACB_PWNOEXP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_AUTOLOCK", ACB_AUTOLOCK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_ENC_TXT_PWD_ALLOWED", ACB_ENC_TXT_PWD_ALLOWED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_SMARTCARD_REQUIRED", ACB_SMARTCARD_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_TRUSTED_FOR_DELEGATION", ACB_TRUSTED_FOR_DELEGATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_NOT_DELEGATED", ACB_NOT_DELEGATED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_USE_DES_KEY_ONLY", ACB_USE_DES_KEY_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_DONT_REQUIRE_PREAUTH", ACB_DONT_REQUIRE_PREAUTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_PW_EXPIRED", ACB_PW_EXPIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION", ACB_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_NO_AUTH_DATA_REQD", ACB_NO_AUTH_DATA_REQD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_PARTIAL_SECRETS_ACCOUNT", ACB_PARTIAL_SECRETS_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ACB_USE_AES_KEYS", ACB_USE_AES_KEYS, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ConnectAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ConnectAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ConnectAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_CONNECT_TO_SERVER", SAMR_ACCESS_CONNECT_TO_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_SHUTDOWN_SERVER", SAMR_ACCESS_SHUTDOWN_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_INITIALIZE_SERVER", SAMR_ACCESS_INITIALIZE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_CREATE_DOMAIN", SAMR_ACCESS_CREATE_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_ENUM_DOMAINS", SAMR_ACCESS_ENUM_DOMAINS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ACCESS_LOOKUP_DOMAIN", SAMR_ACCESS_LOOKUP_DOMAIN, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_NAME_ETC", SAMR_USER_ACCESS_GET_NAME_ETC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_LOCALE", SAMR_USER_ACCESS_GET_LOCALE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_SET_LOC_COM", SAMR_USER_ACCESS_SET_LOC_COM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_LOGONINFO", SAMR_USER_ACCESS_GET_LOGONINFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_ATTRIBUTES", SAMR_USER_ACCESS_GET_ATTRIBUTES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_SET_ATTRIBUTES", SAMR_USER_ACCESS_SET_ATTRIBUTES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_CHANGE_PASSWORD", SAMR_USER_ACCESS_CHANGE_PASSWORD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_SET_PASSWORD", SAMR_USER_ACCESS_SET_PASSWORD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_GROUPS", SAMR_USER_ACCESS_GET_GROUPS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_GET_GROUP_MEMBERSHIP", SAMR_USER_ACCESS_GET_GROUP_MEMBERSHIP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_USER_ACCESS_CHANGE_GROUP_MEMBERSHIP", SAMR_USER_ACCESS_CHANGE_GROUP_MEMBERSHIP, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomainAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomainAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomainAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_LOOKUP_INFO_1", SAMR_DOMAIN_ACCESS_LOOKUP_INFO_1, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_SET_INFO_1", SAMR_DOMAIN_ACCESS_SET_INFO_1, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_LOOKUP_INFO_2", SAMR_DOMAIN_ACCESS_LOOKUP_INFO_2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_SET_INFO_2", SAMR_DOMAIN_ACCESS_SET_INFO_2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_CREATE_USER", SAMR_DOMAIN_ACCESS_CREATE_USER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_CREATE_GROUP", SAMR_DOMAIN_ACCESS_CREATE_GROUP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_CREATE_ALIAS", SAMR_DOMAIN_ACCESS_CREATE_ALIAS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_LOOKUP_ALIAS", SAMR_DOMAIN_ACCESS_LOOKUP_ALIAS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_ENUM_ACCOUNTS", SAMR_DOMAIN_ACCESS_ENUM_ACCOUNTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_OPEN_ACCOUNT", SAMR_DOMAIN_ACCESS_OPEN_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_DOMAIN_ACCESS_SET_INFO_3", SAMR_DOMAIN_ACCESS_SET_INFO_3, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GroupAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GroupAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_GROUP_ACCESS_LOOKUP_INFO", SAMR_GROUP_ACCESS_LOOKUP_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_GROUP_ACCESS_SET_INFO", SAMR_GROUP_ACCESS_SET_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_GROUP_ACCESS_ADD_MEMBER", SAMR_GROUP_ACCESS_ADD_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_GROUP_ACCESS_REMOVE_MEMBER", SAMR_GROUP_ACCESS_REMOVE_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_GROUP_ACCESS_GET_MEMBERS", SAMR_GROUP_ACCESS_GET_MEMBERS, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AliasAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AliasAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AliasAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ALIAS_ACCESS_ADD_MEMBER", SAMR_ALIAS_ACCESS_ADD_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ALIAS_ACCESS_REMOVE_MEMBER", SAMR_ALIAS_ACCESS_REMOVE_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ALIAS_ACCESS_GET_MEMBERS", SAMR_ALIAS_ACCESS_GET_MEMBERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ALIAS_ACCESS_LOOKUP_INFO", SAMR_ALIAS_ACCESS_LOOKUP_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_ALIAS_ACCESS_SET_INFO", SAMR_ALIAS_ACCESS_SET_INFO, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SamEntry(struct ndr_push *ndr, int ndr_flags, const struct samr_SamEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idx));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SamEntry(struct ndr_pull *ndr, int ndr_flags, struct samr_SamEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idx));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SamEntry(struct ndr_print *ndr, const char *name, const struct samr_SamEntry *r)
{
	ndr_print_struct(ndr, name, "samr_SamEntry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "idx", r->idx);
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SamArray(struct ndr_push *ndr, int ndr_flags, const struct samr_SamArray *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_SamEntry(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_SamEntry(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SamArray(struct ndr_pull *ndr, int ndr_flags, struct samr_SamArray *r)
{
	uint32_t _ptr_entries;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_PULL_ALLOC_N(ndr, r->entries, ndr_get_array_size(ndr, &r->entries));
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_SamEntry(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_SamEntry(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SamArray(struct ndr_print *ndr, const char *name, const struct samr_SamArray *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "samr_SamArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_samr_SamEntry(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomainInfoClass(struct ndr_push *ndr, int ndr_flags, enum samr_DomainInfoClass r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomainInfoClass(struct ndr_pull *ndr, int ndr_flags, enum samr_DomainInfoClass *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomainInfoClass(struct ndr_print *ndr, const char *name, enum samr_DomainInfoClass r)
{
	const char *val = NULL;

	switch (r) {
		case DomainPasswordInformation: val = "DomainPasswordInformation"; break;
		case DomainGeneralInformation: val = "DomainGeneralInformation"; break;
		case DomainLogoffInformation: val = "DomainLogoffInformation"; break;
		case DomainOemInformation: val = "DomainOemInformation"; break;
		case DomainNameInformation: val = "DomainNameInformation"; break;
		case DomainReplicationInformation: val = "DomainReplicationInformation"; break;
		case DomainServerRoleInformation: val = "DomainServerRoleInformation"; break;
		case DomainModifiedInformation: val = "DomainModifiedInformation"; break;
		case DomainStateInformation: val = "DomainStateInformation"; break;
		case DomainUasInformation: val = "DomainUasInformation"; break;
		case DomainGeneralInformation2: val = "DomainGeneralInformation2"; break;
		case DomainLockoutInformation: val = "DomainLockoutInformation"; break;
		case DomainModifiedInformation2: val = "DomainModifiedInformation2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_Role(struct ndr_push *ndr, int ndr_flags, enum samr_Role r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Role(struct ndr_pull *ndr, int ndr_flags, enum samr_Role *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Role(struct ndr_print *ndr, const char *name, enum samr_Role r)
{
	const char *val = NULL;

	switch (r) {
		case SAMR_ROLE_STANDALONE: val = "SAMR_ROLE_STANDALONE"; break;
		case SAMR_ROLE_DOMAIN_MEMBER: val = "SAMR_ROLE_DOMAIN_MEMBER"; break;
		case SAMR_ROLE_DOMAIN_BDC: val = "SAMR_ROLE_DOMAIN_BDC"; break;
		case SAMR_ROLE_DOMAIN_PDC: val = "SAMR_ROLE_DOMAIN_PDC"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_PasswordProperties(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_PasswordProperties(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_PasswordProperties(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_PASSWORD_COMPLEX", DOMAIN_PASSWORD_COMPLEX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_PASSWORD_NO_ANON_CHANGE", DOMAIN_PASSWORD_NO_ANON_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_PASSWORD_NO_CLEAR_CHANGE", DOMAIN_PASSWORD_NO_CLEAR_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_PASSWORD_LOCKOUT_ADMINS", DOMAIN_PASSWORD_LOCKOUT_ADMINS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_PASSWORD_STORE_CLEARTEXT", DOMAIN_PASSWORD_STORE_CLEARTEXT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DOMAIN_REFUSE_PASSWORD_CHANGE", DOMAIN_REFUSE_PASSWORD_CHANGE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomainServerState(struct ndr_push *ndr, int ndr_flags, enum samr_DomainServerState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomainServerState(struct ndr_pull *ndr, int ndr_flags, enum samr_DomainServerState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomainServerState(struct ndr_print *ndr, const char *name, enum samr_DomainServerState r)
{
	const char *val = NULL;

	switch (r) {
		case DOMAIN_SERVER_ENABLED: val = "DOMAIN_SERVER_ENABLED"; break;
		case DOMAIN_SERVER_DISABLED: val = "DOMAIN_SERVER_DISABLED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_DomInfo1(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->min_password_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->password_history_length));
		NDR_CHECK(ndr_push_samr_PasswordProperties(ndr, NDR_SCALARS, r->password_properties));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->max_password_age));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->min_password_age));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo1(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->min_password_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->password_history_length));
		NDR_CHECK(ndr_pull_samr_PasswordProperties(ndr, NDR_SCALARS, &r->password_properties));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->max_password_age));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->min_password_age));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo1(struct ndr_print *ndr, const char *name, const struct samr_DomInfo1 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "min_password_length", r->min_password_length);
	ndr_print_uint16(ndr, "password_history_length", r->password_history_length);
	ndr_print_samr_PasswordProperties(ndr, "password_properties", r->password_properties);
	ndr_print_dlong(ndr, "max_password_age", r->max_password_age);
	ndr_print_dlong(ndr, "min_password_age", r->min_password_age);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomGeneralInformation(struct ndr_push *ndr, int ndr_flags, const struct samr_DomGeneralInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_logoff_time));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->primary));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->sequence_num));
		NDR_CHECK(ndr_push_samr_DomainServerState(ndr, NDR_SCALARS, r->domain_server_state));
		NDR_CHECK(ndr_push_samr_Role(ndr, NDR_SCALARS, r->role));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_groups));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_aliases));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->primary));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomGeneralInformation(struct ndr_pull *ndr, int ndr_flags, struct samr_DomGeneralInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_logoff_time));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->primary));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->sequence_num));
		NDR_CHECK(ndr_pull_samr_DomainServerState(ndr, NDR_SCALARS, &r->domain_server_state));
		NDR_CHECK(ndr_pull_samr_Role(ndr, NDR_SCALARS, &r->role));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_groups));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_aliases));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->primary));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomGeneralInformation(struct ndr_print *ndr, const char *name, const struct samr_DomGeneralInformation *r)
{
	ndr_print_struct(ndr, name, "samr_DomGeneralInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "force_logoff_time", r->force_logoff_time);
	ndr_print_lsa_String(ndr, "oem_information", &r->oem_information);
	ndr_print_lsa_String(ndr, "domain_name", &r->domain_name);
	ndr_print_lsa_String(ndr, "primary", &r->primary);
	ndr_print_udlong(ndr, "sequence_num", r->sequence_num);
	ndr_print_samr_DomainServerState(ndr, "domain_server_state", r->domain_server_state);
	ndr_print_samr_Role(ndr, "role", r->role);
	ndr_print_uint32(ndr, "unknown3", r->unknown3);
	ndr_print_uint32(ndr, "num_users", r->num_users);
	ndr_print_uint32(ndr, "num_groups", r->num_groups);
	ndr_print_uint32(ndr, "num_aliases", r->num_aliases);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo3(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_logoff_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo3(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_logoff_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo3(struct ndr_print *ndr, const char *name, const struct samr_DomInfo3 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "force_logoff_time", r->force_logoff_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomOEMInformation(struct ndr_push *ndr, int ndr_flags, const struct samr_DomOEMInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomOEMInformation(struct ndr_pull *ndr, int ndr_flags, struct samr_DomOEMInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomOEMInformation(struct ndr_print *ndr, const char *name, const struct samr_DomOEMInformation *r)
{
	ndr_print_struct(ndr, name, "samr_DomOEMInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "oem_information", &r->oem_information);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo5(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo5(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo5(struct ndr_print *ndr, const char *name, const struct samr_DomInfo5 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo5");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "domain_name", &r->domain_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo6(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->primary));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->primary));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo6(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->primary));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->primary));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo6(struct ndr_print *ndr, const char *name, const struct samr_DomInfo6 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "primary", &r->primary);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo7(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_samr_Role(ndr, NDR_SCALARS, r->role));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo7(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_samr_Role(ndr, NDR_SCALARS, &r->role));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo7(struct ndr_print *ndr, const char *name, const struct samr_DomInfo7 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo7");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_Role(ndr, "role", r->role);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo8(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->sequence_num));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->domain_create_time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo8(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->sequence_num));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->domain_create_time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo8(struct ndr_print *ndr, const char *name, const struct samr_DomInfo8 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo8");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "sequence_num", r->sequence_num);
	ndr_print_NTTIME(ndr, "domain_create_time", r->domain_create_time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo9(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo9 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_samr_DomainServerState(ndr, NDR_SCALARS, r->domain_server_state));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo9(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo9 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_samr_DomainServerState(ndr, NDR_SCALARS, &r->domain_server_state));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo9(struct ndr_print *ndr, const char *name, const struct samr_DomInfo9 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo9");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_DomainServerState(ndr, "domain_server_state", r->domain_server_state);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomGeneralInformation2(struct ndr_push *ndr, int ndr_flags, const struct samr_DomGeneralInformation2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_DomGeneralInformation(ndr, NDR_SCALARS, &r->general));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->lockout_duration));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->lockout_window));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lockout_threshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_DomGeneralInformation(ndr, NDR_BUFFERS, &r->general));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomGeneralInformation2(struct ndr_pull *ndr, int ndr_flags, struct samr_DomGeneralInformation2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_DomGeneralInformation(ndr, NDR_SCALARS, &r->general));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->lockout_duration));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->lockout_window));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lockout_threshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_DomGeneralInformation(ndr, NDR_BUFFERS, &r->general));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomGeneralInformation2(struct ndr_print *ndr, const char *name, const struct samr_DomGeneralInformation2 *r)
{
	ndr_print_struct(ndr, name, "samr_DomGeneralInformation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_DomGeneralInformation(ndr, "general", &r->general);
	ndr_print_hyper(ndr, "lockout_duration", r->lockout_duration);
	ndr_print_hyper(ndr, "lockout_window", r->lockout_window);
	ndr_print_uint16(ndr, "lockout_threshold", r->lockout_threshold);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo12(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo12 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->lockout_duration));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->lockout_window));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lockout_threshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo12(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo12 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->lockout_duration));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->lockout_window));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lockout_threshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo12(struct ndr_print *ndr, const char *name, const struct samr_DomInfo12 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo12");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "lockout_duration", r->lockout_duration);
	ndr_print_hyper(ndr, "lockout_window", r->lockout_window);
	ndr_print_uint16(ndr, "lockout_threshold", r->lockout_threshold);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomInfo13(struct ndr_push *ndr, int ndr_flags, const struct samr_DomInfo13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->sequence_num));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->domain_create_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->modified_count_at_last_promotion));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomInfo13(struct ndr_pull *ndr, int ndr_flags, struct samr_DomInfo13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->sequence_num));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->domain_create_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->modified_count_at_last_promotion));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomInfo13(struct ndr_print *ndr, const char *name, const struct samr_DomInfo13 *r)
{
	ndr_print_struct(ndr, name, "samr_DomInfo13");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "sequence_num", r->sequence_num);
	ndr_print_NTTIME(ndr, "domain_create_time", r->domain_create_time);
	ndr_print_hyper(ndr, "modified_count_at_last_promotion", r->modified_count_at_last_promotion);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DomainInfo(struct ndr_push *ndr, int ndr_flags, const union samr_DomainInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_DomInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_samr_DomGeneralInformation(ndr, NDR_SCALARS, &r->general));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_samr_DomInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_samr_DomOEMInformation(ndr, NDR_SCALARS, &r->oem));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_samr_DomInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_samr_DomInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_samr_DomInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_samr_DomInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_push_samr_DomInfo9(ndr, NDR_SCALARS, &r->info9));
			break; }

			case 11: {
				NDR_CHECK(ndr_push_samr_DomGeneralInformation2(ndr, NDR_SCALARS, &r->general2));
			break; }

			case 12: {
				NDR_CHECK(ndr_push_samr_DomInfo12(ndr, NDR_SCALARS, &r->info12));
			break; }

			case 13: {
				NDR_CHECK(ndr_push_samr_DomInfo13(ndr, NDR_SCALARS, &r->info13));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
			break;

			case 2:
				NDR_CHECK(ndr_push_samr_DomGeneralInformation(ndr, NDR_BUFFERS, &r->general));
			break;

			case 3:
			break;

			case 4:
				NDR_CHECK(ndr_push_samr_DomOEMInformation(ndr, NDR_BUFFERS, &r->oem));
			break;

			case 5:
				NDR_CHECK(ndr_push_samr_DomInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_push_samr_DomInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 7:
			break;

			case 8:
			break;

			case 9:
			break;

			case 11:
				NDR_CHECK(ndr_push_samr_DomGeneralInformation2(ndr, NDR_BUFFERS, &r->general2));
			break;

			case 12:
			break;

			case 13:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DomainInfo(struct ndr_pull *ndr, int ndr_flags, union samr_DomainInfo *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_DomInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_samr_DomGeneralInformation(ndr, NDR_SCALARS, &r->general));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_samr_DomInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_samr_DomOEMInformation(ndr, NDR_SCALARS, &r->oem));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_samr_DomInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_samr_DomInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_samr_DomInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_samr_DomInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_pull_samr_DomInfo9(ndr, NDR_SCALARS, &r->info9));
			break; }

			case 11: {
				NDR_CHECK(ndr_pull_samr_DomGeneralInformation2(ndr, NDR_SCALARS, &r->general2));
			break; }

			case 12: {
				NDR_CHECK(ndr_pull_samr_DomInfo12(ndr, NDR_SCALARS, &r->info12));
			break; }

			case 13: {
				NDR_CHECK(ndr_pull_samr_DomInfo13(ndr, NDR_SCALARS, &r->info13));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			case 2:
				NDR_CHECK(ndr_pull_samr_DomGeneralInformation(ndr, NDR_BUFFERS, &r->general));
			break;

			case 3:
			break;

			case 4:
				NDR_CHECK(ndr_pull_samr_DomOEMInformation(ndr, NDR_BUFFERS, &r->oem));
			break;

			case 5:
				NDR_CHECK(ndr_pull_samr_DomInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_pull_samr_DomInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 7:
			break;

			case 8:
			break;

			case 9:
			break;

			case 11:
				NDR_CHECK(ndr_pull_samr_DomGeneralInformation2(ndr, NDR_BUFFERS, &r->general2));
			break;

			case 12:
			break;

			case 13:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DomainInfo(struct ndr_print *ndr, const char *name, const union samr_DomainInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_DomainInfo");
	switch (level) {
		case 1:
			ndr_print_samr_DomInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_samr_DomGeneralInformation(ndr, "general", &r->general);
		break;

		case 3:
			ndr_print_samr_DomInfo3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_samr_DomOEMInformation(ndr, "oem", &r->oem);
		break;

		case 5:
			ndr_print_samr_DomInfo5(ndr, "info5", &r->info5);
		break;

		case 6:
			ndr_print_samr_DomInfo6(ndr, "info6", &r->info6);
		break;

		case 7:
			ndr_print_samr_DomInfo7(ndr, "info7", &r->info7);
		break;

		case 8:
			ndr_print_samr_DomInfo8(ndr, "info8", &r->info8);
		break;

		case 9:
			ndr_print_samr_DomInfo9(ndr, "info9", &r->info9);
		break;

		case 11:
			ndr_print_samr_DomGeneralInformation2(ndr, "general2", &r->general2);
		break;

		case 12:
			ndr_print_samr_DomInfo12(ndr, "info12", &r->info12);
		break;

		case 13:
			ndr_print_samr_DomInfo13(ndr, "info13", &r->info13);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_Ids(struct ndr_push *ndr, int ndr_flags, const struct samr_Ids *r)
{
	uint32_t cntr_ids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_ids_1 = 0; cntr_ids_1 < r->count; cntr_ids_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ids[cntr_ids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Ids(struct ndr_pull *ndr, int ndr_flags, struct samr_Ids *r)
{
	uint32_t _ptr_ids;
	uint32_t cntr_ids_1;
	TALLOC_CTX *_mem_save_ids_0;
	TALLOC_CTX *_mem_save_ids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ids));
		if (_ptr_ids) {
			NDR_PULL_ALLOC(ndr, r->ids);
		} else {
			r->ids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ids) {
			_mem_save_ids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ids));
			NDR_PULL_ALLOC_N(ndr, r->ids, ndr_get_array_size(ndr, &r->ids));
			_mem_save_ids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ids, 0);
			for (cntr_ids_1 = 0; cntr_ids_1 < r->count; cntr_ids_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ids[cntr_ids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_0, 0);
		}
		if (r->ids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ids, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Ids(struct ndr_print *ndr, const char *name, const struct samr_Ids *r)
{
	uint32_t cntr_ids_1;
	ndr_print_struct(ndr, name, "samr_Ids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "ids", r->ids);
	ndr->depth++;
	if (r->ids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "ids", (int)r->count);
		ndr->depth++;
		for (cntr_ids_1=0;cntr_ids_1<r->count;cntr_ids_1++) {
			ndr_print_uint32(ndr, "ids", r->ids[cntr_ids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_GroupAttrs(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_GroupAttrs(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupAttrs(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_MANDATORY", SE_GROUP_MANDATORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_ENABLED_BY_DEFAULT", SE_GROUP_ENABLED_BY_DEFAULT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_ENABLED", SE_GROUP_ENABLED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_OWNER", SE_GROUP_OWNER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_USE_FOR_DENY_ONLY", SE_GROUP_USE_FOR_DENY_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_RESOURCE", SE_GROUP_RESOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SE_GROUP_LOGON_ID", SE_GROUP_LOGON_ID, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GroupInfoAll(struct ndr_push *ndr, int ndr_flags, const struct samr_GroupInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_members));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GroupInfoAll(struct ndr_pull *ndr, int ndr_flags, struct samr_GroupInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_members));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupInfoAll(struct ndr_print *ndr, const char *name, const struct samr_GroupInfoAll *r)
{
	ndr_print_struct(ndr, name, "samr_GroupInfoAll");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_samr_GroupAttrs(ndr, "attributes", r->attributes);
	ndr_print_uint32(ndr, "num_members", r->num_members);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GroupInfoAttributes(struct ndr_push *ndr, int ndr_flags, const struct samr_GroupInfoAttributes *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GroupInfoAttributes(struct ndr_pull *ndr, int ndr_flags, struct samr_GroupInfoAttributes *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupInfoAttributes(struct ndr_print *ndr, const char *name, const struct samr_GroupInfoAttributes *r)
{
	ndr_print_struct(ndr, name, "samr_GroupInfoAttributes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_GroupAttrs(ndr, "attributes", r->attributes);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GroupInfoEnum(struct ndr_push *ndr, int ndr_flags, enum samr_GroupInfoEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GroupInfoEnum(struct ndr_pull *ndr, int ndr_flags, enum samr_GroupInfoEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupInfoEnum(struct ndr_print *ndr, const char *name, enum samr_GroupInfoEnum r)
{
	const char *val = NULL;

	switch (r) {
		case GROUPINFOALL: val = "GROUPINFOALL"; break;
		case GROUPINFONAME: val = "GROUPINFONAME"; break;
		case GROUPINFOATTRIBUTES: val = "GROUPINFOATTRIBUTES"; break;
		case GROUPINFODESCRIPTION: val = "GROUPINFODESCRIPTION"; break;
		case GROUPINFOALL2: val = "GROUPINFOALL2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_GroupInfo(struct ndr_push *ndr, int ndr_flags, const union samr_GroupInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_samr_GroupInfoEnum(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case GROUPINFOALL: {
				NDR_CHECK(ndr_push_samr_GroupInfoAll(ndr, NDR_SCALARS, &r->all));
			break; }

			case GROUPINFONAME: {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
			break; }

			case GROUPINFOATTRIBUTES: {
				NDR_CHECK(ndr_push_samr_GroupInfoAttributes(ndr, NDR_SCALARS, &r->attributes));
			break; }

			case GROUPINFODESCRIPTION: {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
			break; }

			case GROUPINFOALL2: {
				NDR_CHECK(ndr_push_samr_GroupInfoAll(ndr, NDR_SCALARS, &r->all2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case GROUPINFOALL:
				NDR_CHECK(ndr_push_samr_GroupInfoAll(ndr, NDR_BUFFERS, &r->all));
			break;

			case GROUPINFONAME:
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
			break;

			case GROUPINFOATTRIBUTES:
			break;

			case GROUPINFODESCRIPTION:
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
			break;

			case GROUPINFOALL2:
				NDR_CHECK(ndr_push_samr_GroupInfoAll(ndr, NDR_BUFFERS, &r->all2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GroupInfo(struct ndr_pull *ndr, int ndr_flags, union samr_GroupInfo *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case GROUPINFOALL: {
				NDR_CHECK(ndr_pull_samr_GroupInfoAll(ndr, NDR_SCALARS, &r->all));
			break; }

			case GROUPINFONAME: {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
			break; }

			case GROUPINFOATTRIBUTES: {
				NDR_CHECK(ndr_pull_samr_GroupInfoAttributes(ndr, NDR_SCALARS, &r->attributes));
			break; }

			case GROUPINFODESCRIPTION: {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
			break; }

			case GROUPINFOALL2: {
				NDR_CHECK(ndr_pull_samr_GroupInfoAll(ndr, NDR_SCALARS, &r->all2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case GROUPINFOALL:
				NDR_CHECK(ndr_pull_samr_GroupInfoAll(ndr, NDR_BUFFERS, &r->all));
			break;

			case GROUPINFONAME:
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
			break;

			case GROUPINFOATTRIBUTES:
			break;

			case GROUPINFODESCRIPTION:
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
			break;

			case GROUPINFOALL2:
				NDR_CHECK(ndr_pull_samr_GroupInfoAll(ndr, NDR_BUFFERS, &r->all2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GroupInfo(struct ndr_print *ndr, const char *name, const union samr_GroupInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_GroupInfo");
	switch (level) {
		case GROUPINFOALL:
			ndr_print_samr_GroupInfoAll(ndr, "all", &r->all);
		break;

		case GROUPINFONAME:
			ndr_print_lsa_String(ndr, "name", &r->name);
		break;

		case GROUPINFOATTRIBUTES:
			ndr_print_samr_GroupInfoAttributes(ndr, "attributes", &r->attributes);
		break;

		case GROUPINFODESCRIPTION:
			ndr_print_lsa_String(ndr, "description", &r->description);
		break;

		case GROUPINFOALL2:
			ndr_print_samr_GroupInfoAll(ndr, "all2", &r->all2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_RidAttrArray(struct ndr_push *ndr, int ndr_flags, const struct samr_RidAttrArray *r)
{
	uint32_t cntr_rids_1;
	uint32_t cntr_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->rids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_rids_1 = 0; cntr_rids_1 < r->count; cntr_rids_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rids[cntr_rids_1]));
			}
		}
		if (r->attributes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->count; cntr_attributes_1++) {
				NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->attributes[cntr_attributes_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_RidAttrArray(struct ndr_pull *ndr, int ndr_flags, struct samr_RidAttrArray *r)
{
	uint32_t _ptr_rids;
	uint32_t cntr_rids_1;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_rids_1;
	uint32_t _ptr_attributes;
	uint32_t cntr_attributes_1;
	TALLOC_CTX *_mem_save_attributes_0;
	TALLOC_CTX *_mem_save_attributes_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rids));
		if (_ptr_rids) {
			NDR_PULL_ALLOC(ndr, r->rids);
		} else {
			r->rids = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attributes));
		if (_ptr_attributes) {
			NDR_PULL_ALLOC(ndr, r->attributes);
		} else {
			r->attributes = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->rids));
			NDR_PULL_ALLOC_N(ndr, r->rids, ndr_get_array_size(ndr, &r->rids));
			_mem_save_rids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			for (cntr_rids_1 = 0; cntr_rids_1 < r->count; cntr_rids_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rids[cntr_rids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		}
		if (r->attributes) {
			_mem_save_attributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attributes));
			NDR_PULL_ALLOC_N(ndr, r->attributes, ndr_get_array_size(ndr, &r->attributes));
			_mem_save_attributes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			for (cntr_attributes_1 = 0; cntr_attributes_1 < r->count; cntr_attributes_1++) {
				NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->attributes[cntr_attributes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_0, 0);
		}
		if (r->rids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->rids, r->count));
		}
		if (r->attributes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->attributes, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RidAttrArray(struct ndr_print *ndr, const char *name, const struct samr_RidAttrArray *r)
{
	uint32_t cntr_rids_1;
	uint32_t cntr_attributes_1;
	ndr_print_struct(ndr, name, "samr_RidAttrArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "rids", r->rids);
	ndr->depth++;
	if (r->rids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "rids", (int)r->count);
		ndr->depth++;
		for (cntr_rids_1=0;cntr_rids_1<r->count;cntr_rids_1++) {
			ndr_print_uint32(ndr, "rids", r->rids[cntr_rids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "attributes", r->attributes);
	ndr->depth++;
	if (r->attributes) {
		ndr->print(ndr, "%s: ARRAY(%d)", "attributes", (int)r->count);
		ndr->depth++;
		for (cntr_attributes_1=0;cntr_attributes_1<r->count;cntr_attributes_1++) {
			ndr_print_samr_GroupAttrs(ndr, "attributes", r->attributes[cntr_attributes_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AliasInfoAll(struct ndr_push *ndr, int ndr_flags, const struct samr_AliasInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_members));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AliasInfoAll(struct ndr_pull *ndr, int ndr_flags, struct samr_AliasInfoAll *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_members));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AliasInfoAll(struct ndr_print *ndr, const char *name, const struct samr_AliasInfoAll *r)
{
	ndr_print_struct(ndr, name, "samr_AliasInfoAll");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "name", &r->name);
	ndr_print_uint32(ndr, "num_members", r->num_members);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AliasInfoEnum(struct ndr_push *ndr, int ndr_flags, enum samr_AliasInfoEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AliasInfoEnum(struct ndr_pull *ndr, int ndr_flags, enum samr_AliasInfoEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AliasInfoEnum(struct ndr_print *ndr, const char *name, enum samr_AliasInfoEnum r)
{
	const char *val = NULL;

	switch (r) {
		case ALIASINFOALL: val = "ALIASINFOALL"; break;
		case ALIASINFONAME: val = "ALIASINFONAME"; break;
		case ALIASINFODESCRIPTION: val = "ALIASINFODESCRIPTION"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_AliasInfo(struct ndr_push *ndr, int ndr_flags, const union samr_AliasInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_samr_AliasInfoEnum(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case ALIASINFOALL: {
				NDR_CHECK(ndr_push_samr_AliasInfoAll(ndr, NDR_SCALARS, &r->all));
			break; }

			case ALIASINFONAME: {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->name));
			break; }

			case ALIASINFODESCRIPTION: {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case ALIASINFOALL:
				NDR_CHECK(ndr_push_samr_AliasInfoAll(ndr, NDR_BUFFERS, &r->all));
			break;

			case ALIASINFONAME:
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->name));
			break;

			case ALIASINFODESCRIPTION:
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AliasInfo(struct ndr_pull *ndr, int ndr_flags, union samr_AliasInfo *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case ALIASINFOALL: {
				NDR_CHECK(ndr_pull_samr_AliasInfoAll(ndr, NDR_SCALARS, &r->all));
			break; }

			case ALIASINFONAME: {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->name));
			break; }

			case ALIASINFODESCRIPTION: {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case ALIASINFOALL:
				NDR_CHECK(ndr_pull_samr_AliasInfoAll(ndr, NDR_BUFFERS, &r->all));
			break;

			case ALIASINFONAME:
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->name));
			break;

			case ALIASINFODESCRIPTION:
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AliasInfo(struct ndr_print *ndr, const char *name, const union samr_AliasInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_AliasInfo");
	switch (level) {
		case ALIASINFOALL:
			ndr_print_samr_AliasInfoAll(ndr, "all", &r->all);
		break;

		case ALIASINFONAME:
			ndr_print_lsa_String(ndr, "name", &r->name);
		break;

		case ALIASINFODESCRIPTION:
			ndr_print_lsa_String(ndr, "description", &r->description);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_UserInfoLevel(struct ndr_push *ndr, int ndr_flags, enum samr_UserInfoLevel r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfoLevel(struct ndr_pull *ndr, int ndr_flags, enum samr_UserInfoLevel *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfoLevel(struct ndr_print *ndr, const char *name, enum samr_UserInfoLevel r)
{
	const char *val = NULL;

	switch (r) {
		case UserGeneralInformation: val = "UserGeneralInformation"; break;
		case UserPreferencesInformation: val = "UserPreferencesInformation"; break;
		case UserLogonInformation: val = "UserLogonInformation"; break;
		case UserLogonHoursInformation: val = "UserLogonHoursInformation"; break;
		case UserAccountInformation: val = "UserAccountInformation"; break;
		case UserNameInformation: val = "UserNameInformation"; break;
		case UserAccountNameInformation: val = "UserAccountNameInformation"; break;
		case UserFullNameInformation: val = "UserFullNameInformation"; break;
		case UserPrimaryGroupInformation: val = "UserPrimaryGroupInformation"; break;
		case UserHomeInformation: val = "UserHomeInformation"; break;
		case UserScriptInformation: val = "UserScriptInformation"; break;
		case UserProfileInformation: val = "UserProfileInformation"; break;
		case UserAdminCommentInformation: val = "UserAdminCommentInformation"; break;
		case UserWorkStationsInformation: val = "UserWorkStationsInformation"; break;
		case UserControlInformation: val = "UserControlInformation"; break;
		case UserExpiresInformation: val = "UserExpiresInformation"; break;
		case UserInternal1Information: val = "UserInternal1Information"; break;
		case UserParametersInformation: val = "UserParametersInformation"; break;
		case UserAllInformation: val = "UserAllInformation"; break;
		case UserInternal4Information: val = "UserInternal4Information"; break;
		case UserInternal5Information: val = "UserInternal5Information"; break;
		case UserInternal4InformationNew: val = "UserInternal4InformationNew"; break;
		case UserInternal5InformationNew: val = "UserInternal5InformationNew"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_UserInfo1(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->comment));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo1(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->comment));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo1(struct ndr_print *ndr, const char *name, const struct samr_UserInfo1 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "comment", &r->comment);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo2(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->country_code));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->code_page));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->reserved));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo2(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->country_code));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->code_page));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->reserved));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo2(struct ndr_print *ndr, const char *name, const struct samr_UserInfo2 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "comment", &r->comment);
	ndr_print_lsa_String(ndr, "reserved", &r->reserved);
	ndr_print_uint16(ndr, "country_code", r->country_code);
	ndr_print_uint16(ndr, "code_page", r->code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_LogonHours(struct ndr_push *ndr, int ndr_flags, const struct samr_LogonHours *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->units_per_week));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->bits));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->bits) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1260));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->units_per_week / 8));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->bits, r->units_per_week / 8));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_LogonHours(struct ndr_pull *ndr, int ndr_flags, struct samr_LogonHours *r)
{
	uint32_t _ptr_bits;
	TALLOC_CTX *_mem_save_bits_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->units_per_week));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bits));
			if (_ptr_bits) {
				NDR_PULL_ALLOC(ndr, r->bits);
			} else {
				r->bits = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->bits) {
				_mem_save_bits_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->bits, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->bits));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->bits));
				if (ndr_get_array_length(ndr, &r->bits) > ndr_get_array_size(ndr, &r->bits)) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->bits), ndr_get_array_length(ndr, &r->bits));
				}
				NDR_PULL_ALLOC_N(ndr, r->bits, ndr_get_array_size(ndr, &r->bits));
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->bits, ndr_get_array_length(ndr, &r->bits)));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bits_0, 0);
			}
			if (r->bits) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->bits, 1260));
			}
			if (r->bits) {
				NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->bits, r->units_per_week / 8));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_LogonHours(struct ndr_print *ndr, const char *name, const struct samr_LogonHours *r)
{
	ndr_print_struct(ndr, name, "samr_LogonHours");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint16(ndr, "units_per_week", r->units_per_week);
		ndr_print_ptr(ndr, "bits", r->bits);
		ndr->depth++;
		if (r->bits) {
			ndr_print_array_uint8(ndr, "bits", r->bits, r->units_per_week / 8);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_samr_UserInfo3(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->allow_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_password_change));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo3(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->allow_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_password_change));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo3(struct ndr_print *ndr, const char *name, const struct samr_UserInfo3 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr_print_lsa_String(ndr, "workstations", &r->workstations);
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "allow_password_change", r->allow_password_change);
	ndr_print_NTTIME(ndr, "force_password_change", r->force_password_change);
	ndr_print_samr_LogonHours(ndr, "logon_hours", &r->logon_hours);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo4(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo4(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo4(struct ndr_print *ndr, const char *name, const struct samr_UserInfo4 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_LogonHours(ndr, "logon_hours", &r->logon_hours);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo5(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo5(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo5(struct ndr_print *ndr, const char *name, const struct samr_UserInfo5 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo5");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "workstations", &r->workstations);
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_samr_LogonHours(ndr, "logon_hours", &r->logon_hours);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo6(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo6(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo6(struct ndr_print *ndr, const char *name, const struct samr_UserInfo6 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo7(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo7(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo7(struct ndr_print *ndr, const char *name, const struct samr_UserInfo7 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo7");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo8(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo8(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo8(struct ndr_print *ndr, const char *name, const struct samr_UserInfo8 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo8");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo9(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo9 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo9(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo9 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo9(struct ndr_print *ndr, const char *name, const struct samr_UserInfo9 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo9");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo10(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo10(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo10(struct ndr_print *ndr, const char *name, const struct samr_UserInfo10 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo10");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo11(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo11(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo11(struct ndr_print *ndr, const char *name, const struct samr_UserInfo11 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo11");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo12(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo12 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo12(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo12 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo12(struct ndr_print *ndr, const char *name, const struct samr_UserInfo12 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo12");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo13(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo13(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo13 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo13(struct ndr_print *ndr, const char *name, const struct samr_UserInfo13 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo13");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo14(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo14 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo14(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo14 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo14(struct ndr_print *ndr, const char *name, const struct samr_UserInfo14 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo14");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "workstations", &r->workstations);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo16(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo16 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo16(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo16 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo16(struct ndr_print *ndr, const char *name, const struct samr_UserInfo16 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo16");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo17(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo17 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo17(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo17 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo17(struct ndr_print *ndr, const char *name, const struct samr_UserInfo17 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo17");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_Password(struct ndr_push *ndr, int ndr_flags, const struct samr_Password *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->hash, 16));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_Password(struct ndr_pull *ndr, int ndr_flags, struct samr_Password *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->hash, 16));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Password(struct ndr_print *ndr, const char *name, const struct samr_Password *r)
{
	ndr_print_struct(ndr, name, "samr_Password");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "hash", r->hash, 16);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_samr_UserInfo18(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo18 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->nt_pwd));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->lm_pwd));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->nt_pwd_active));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->lm_pwd_active));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo18(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo18 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->nt_pwd));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->lm_pwd));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->nt_pwd_active));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->lm_pwd_active));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo18(struct ndr_print *ndr, const char *name, const struct samr_UserInfo18 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo18");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_Password(ndr, "nt_pwd", &r->nt_pwd);
	ndr_print_samr_Password(ndr, "lm_pwd", &r->lm_pwd);
	ndr_print_uint8(ndr, "nt_pwd_active", r->nt_pwd_active);
	ndr_print_uint8(ndr, "lm_pwd_active", r->lm_pwd_active);
	ndr_print_uint8(ndr, "password_expired", r->password_expired);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo20(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo20(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo20(struct ndr_print *ndr, const char *name, const struct samr_UserInfo20 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo20");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_BinaryString(ndr, "parameters", &r->parameters);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_FieldsPresent(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_FieldsPresent(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_FieldsPresent(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_ACCOUNT_NAME", SAMR_FIELD_ACCOUNT_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_FULL_NAME", SAMR_FIELD_FULL_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_RID", SAMR_FIELD_RID, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_PRIMARY_GID", SAMR_FIELD_PRIMARY_GID, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_DESCRIPTION", SAMR_FIELD_DESCRIPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_COMMENT", SAMR_FIELD_COMMENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_HOME_DIRECTORY", SAMR_FIELD_HOME_DIRECTORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_HOME_DRIVE", SAMR_FIELD_HOME_DRIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LOGON_SCRIPT", SAMR_FIELD_LOGON_SCRIPT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_PROFILE_PATH", SAMR_FIELD_PROFILE_PATH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_WORKSTATIONS", SAMR_FIELD_WORKSTATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LAST_LOGON", SAMR_FIELD_LAST_LOGON, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LAST_LOGOFF", SAMR_FIELD_LAST_LOGOFF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LOGON_HOURS", SAMR_FIELD_LOGON_HOURS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_BAD_PWD_COUNT", SAMR_FIELD_BAD_PWD_COUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_NUM_LOGONS", SAMR_FIELD_NUM_LOGONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_ALLOW_PWD_CHANGE", SAMR_FIELD_ALLOW_PWD_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_FORCE_PWD_CHANGE", SAMR_FIELD_FORCE_PWD_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LAST_PWD_CHANGE", SAMR_FIELD_LAST_PWD_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_ACCT_EXPIRY", SAMR_FIELD_ACCT_EXPIRY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_ACCT_FLAGS", SAMR_FIELD_ACCT_FLAGS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_PARAMETERS", SAMR_FIELD_PARAMETERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_COUNTRY_CODE", SAMR_FIELD_COUNTRY_CODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_CODE_PAGE", SAMR_FIELD_CODE_PAGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_NT_PASSWORD_PRESENT", SAMR_FIELD_NT_PASSWORD_PRESENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_LM_PASSWORD_PRESENT", SAMR_FIELD_LM_PASSWORD_PRESENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_PRIVATE_DATA", SAMR_FIELD_PRIVATE_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_EXPIRED_FLAG", SAMR_FIELD_EXPIRED_FLAG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_SEC_DESC", SAMR_FIELD_SEC_DESC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_FIELD_OWF_PWD", SAMR_FIELD_OWF_PWD, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo21(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo21 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->allow_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_password_change));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->lm_owf_password));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->nt_owf_password));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->private_data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buf_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buffer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_samr_FieldsPresent(ndr, NDR_SCALARS, r->fields_present));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->country_code));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->code_page));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->lm_password_set));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->nt_password_set));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_expired));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->private_data_sensitive));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->lm_owf_password));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->nt_owf_password));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->private_data));
		if (r->buffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->buf_count));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->buf_count));
		}
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo21(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo21 *r)
{
	uint32_t _ptr_buffer;
	TALLOC_CTX *_mem_save_buffer_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->allow_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_password_change));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->lm_owf_password));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->nt_owf_password));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->private_data));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buf_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->buffer);
		} else {
			r->buffer = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_samr_FieldsPresent(ndr, NDR_SCALARS, &r->fields_present));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->country_code));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->code_page));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->lm_password_set));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->nt_password_set));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_expired));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->private_data_sensitive));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->lm_owf_password));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->nt_owf_password));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->private_data));
		if (r->buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->buffer));
			NDR_PULL_ALLOC_N(ndr, r->buffer, ndr_get_array_size(ndr, &r->buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, ndr_get_array_size(ndr, &r->buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
		if (r->buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->buffer, r->buf_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo21(struct ndr_print *ndr, const char *name, const struct samr_UserInfo21 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo21");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr_print_NTTIME(ndr, "allow_password_change", r->allow_password_change);
	ndr_print_NTTIME(ndr, "force_password_change", r->force_password_change);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "workstations", &r->workstations);
	ndr_print_lsa_String(ndr, "comment", &r->comment);
	ndr_print_lsa_BinaryString(ndr, "parameters", &r->parameters);
	ndr_print_lsa_BinaryString(ndr, "lm_owf_password", &r->lm_owf_password);
	ndr_print_lsa_BinaryString(ndr, "nt_owf_password", &r->nt_owf_password);
	ndr_print_lsa_String(ndr, "private_data", &r->private_data);
	ndr_print_uint32(ndr, "buf_count", r->buf_count);
	ndr_print_ptr(ndr, "buffer", r->buffer);
	ndr->depth++;
	if (r->buffer) {
		ndr_print_array_uint8(ndr, "buffer", r->buffer, r->buf_count);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr_print_samr_FieldsPresent(ndr, "fields_present", r->fields_present);
	ndr_print_samr_LogonHours(ndr, "logon_hours", &r->logon_hours);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_uint16(ndr, "country_code", r->country_code);
	ndr_print_uint16(ndr, "code_page", r->code_page);
	ndr_print_uint8(ndr, "lm_password_set", r->lm_password_set);
	ndr_print_uint8(ndr, "nt_password_set", r->nt_password_set);
	ndr_print_uint8(ndr, "password_expired", r->password_expired);
	ndr_print_uint8(ndr, "private_data_sensitive", r->private_data_sensitive);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_CryptPassword(struct ndr_push *ndr, int ndr_flags, const struct samr_CryptPassword *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 516));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_CryptPassword(struct ndr_pull *ndr, int ndr_flags, struct samr_CryptPassword *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, 516));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CryptPassword(struct ndr_print *ndr, const char *name, const struct samr_CryptPassword *r)
{
	ndr_print_struct(ndr, name, "samr_CryptPassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->data, 516);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_samr_UserInfo23(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo23 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo23(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo23 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo23(struct ndr_print *ndr, const char *name, const struct samr_UserInfo23 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo23");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_UserInfo21(ndr, "info", &r->info);
	ndr_print_samr_CryptPassword(ndr, "password", &r->password);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo24(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo24 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo24(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo24 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo24(struct ndr_print *ndr, const char *name, const struct samr_UserInfo24 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo24");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_CryptPassword(ndr, "password", &r->password);
	ndr_print_uint8(ndr, "password_expired", r->password_expired);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_CryptPasswordEx(struct ndr_push *ndr, int ndr_flags, const struct samr_CryptPasswordEx *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 532));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_CryptPasswordEx(struct ndr_pull *ndr, int ndr_flags, struct samr_CryptPasswordEx *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, 532));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CryptPasswordEx(struct ndr_print *ndr, const char *name, const struct samr_CryptPasswordEx *r)
{
	ndr_print_struct(ndr, name, "samr_CryptPasswordEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->data, 532);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_samr_UserInfo25(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo25 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_samr_CryptPasswordEx(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo25(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo25 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_samr_CryptPasswordEx(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo25(struct ndr_print *ndr, const char *name, const struct samr_UserInfo25 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo25");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_UserInfo21(ndr, "info", &r->info);
	ndr_print_samr_CryptPasswordEx(ndr, "password", &r->password);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo26(struct ndr_push *ndr, int ndr_flags, const struct samr_UserInfo26 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_samr_CryptPasswordEx(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo26(struct ndr_pull *ndr, int ndr_flags, struct samr_UserInfo26 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_samr_CryptPasswordEx(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo26(struct ndr_print *ndr, const char *name, const struct samr_UserInfo26 *r)
{
	ndr_print_struct(ndr, name, "samr_UserInfo26");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_CryptPasswordEx(ndr, "password", &r->password);
	ndr_print_uint8(ndr, "password_expired", r->password_expired);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_UserInfo(struct ndr_push *ndr, int ndr_flags, const union samr_UserInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_UserInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_samr_UserInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_samr_UserInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_samr_UserInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_samr_UserInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_samr_UserInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_samr_UserInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_samr_UserInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_push_samr_UserInfo9(ndr, NDR_SCALARS, &r->info9));
			break; }

			case 10: {
				NDR_CHECK(ndr_push_samr_UserInfo10(ndr, NDR_SCALARS, &r->info10));
			break; }

			case 11: {
				NDR_CHECK(ndr_push_samr_UserInfo11(ndr, NDR_SCALARS, &r->info11));
			break; }

			case 12: {
				NDR_CHECK(ndr_push_samr_UserInfo12(ndr, NDR_SCALARS, &r->info12));
			break; }

			case 13: {
				NDR_CHECK(ndr_push_samr_UserInfo13(ndr, NDR_SCALARS, &r->info13));
			break; }

			case 14: {
				NDR_CHECK(ndr_push_samr_UserInfo14(ndr, NDR_SCALARS, &r->info14));
			break; }

			case 16: {
				NDR_CHECK(ndr_push_samr_UserInfo16(ndr, NDR_SCALARS, &r->info16));
			break; }

			case 17: {
				NDR_CHECK(ndr_push_samr_UserInfo17(ndr, NDR_SCALARS, &r->info17));
			break; }

			case 18: {
				NDR_CHECK(ndr_push_samr_UserInfo18(ndr, NDR_SCALARS, &r->info18));
			break; }

			case 20: {
				NDR_CHECK(ndr_push_samr_UserInfo20(ndr, NDR_SCALARS, &r->info20));
			break; }

			case 21: {
				NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_SCALARS, &r->info21));
			break; }

			case 23: {
				NDR_CHECK(ndr_push_samr_UserInfo23(ndr, NDR_SCALARS, &r->info23));
			break; }

			case 24: {
				NDR_CHECK(ndr_push_samr_UserInfo24(ndr, NDR_SCALARS, &r->info24));
			break; }

			case 25: {
				NDR_CHECK(ndr_push_samr_UserInfo25(ndr, NDR_SCALARS, &r->info25));
			break; }

			case 26: {
				NDR_CHECK(ndr_push_samr_UserInfo26(ndr, NDR_SCALARS, &r->info26));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_samr_UserInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_samr_UserInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_samr_UserInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_push_samr_UserInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_push_samr_UserInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_push_samr_UserInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 7:
				NDR_CHECK(ndr_push_samr_UserInfo7(ndr, NDR_BUFFERS, &r->info7));
			break;

			case 8:
				NDR_CHECK(ndr_push_samr_UserInfo8(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 9:
			break;

			case 10:
				NDR_CHECK(ndr_push_samr_UserInfo10(ndr, NDR_BUFFERS, &r->info10));
			break;

			case 11:
				NDR_CHECK(ndr_push_samr_UserInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			case 12:
				NDR_CHECK(ndr_push_samr_UserInfo12(ndr, NDR_BUFFERS, &r->info12));
			break;

			case 13:
				NDR_CHECK(ndr_push_samr_UserInfo13(ndr, NDR_BUFFERS, &r->info13));
			break;

			case 14:
				NDR_CHECK(ndr_push_samr_UserInfo14(ndr, NDR_BUFFERS, &r->info14));
			break;

			case 16:
			break;

			case 17:
			break;

			case 18:
			break;

			case 20:
				NDR_CHECK(ndr_push_samr_UserInfo20(ndr, NDR_BUFFERS, &r->info20));
			break;

			case 21:
				NDR_CHECK(ndr_push_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info21));
			break;

			case 23:
				NDR_CHECK(ndr_push_samr_UserInfo23(ndr, NDR_BUFFERS, &r->info23));
			break;

			case 24:
			break;

			case 25:
				NDR_CHECK(ndr_push_samr_UserInfo25(ndr, NDR_BUFFERS, &r->info25));
			break;

			case 26:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_UserInfo(struct ndr_pull *ndr, int ndr_flags, union samr_UserInfo *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_UserInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_samr_UserInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_samr_UserInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_samr_UserInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_samr_UserInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_samr_UserInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_samr_UserInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_samr_UserInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_pull_samr_UserInfo9(ndr, NDR_SCALARS, &r->info9));
			break; }

			case 10: {
				NDR_CHECK(ndr_pull_samr_UserInfo10(ndr, NDR_SCALARS, &r->info10));
			break; }

			case 11: {
				NDR_CHECK(ndr_pull_samr_UserInfo11(ndr, NDR_SCALARS, &r->info11));
			break; }

			case 12: {
				NDR_CHECK(ndr_pull_samr_UserInfo12(ndr, NDR_SCALARS, &r->info12));
			break; }

			case 13: {
				NDR_CHECK(ndr_pull_samr_UserInfo13(ndr, NDR_SCALARS, &r->info13));
			break; }

			case 14: {
				NDR_CHECK(ndr_pull_samr_UserInfo14(ndr, NDR_SCALARS, &r->info14));
			break; }

			case 16: {
				NDR_CHECK(ndr_pull_samr_UserInfo16(ndr, NDR_SCALARS, &r->info16));
			break; }

			case 17: {
				NDR_CHECK(ndr_pull_samr_UserInfo17(ndr, NDR_SCALARS, &r->info17));
			break; }

			case 18: {
				NDR_CHECK(ndr_pull_samr_UserInfo18(ndr, NDR_SCALARS, &r->info18));
			break; }

			case 20: {
				NDR_CHECK(ndr_pull_samr_UserInfo20(ndr, NDR_SCALARS, &r->info20));
			break; }

			case 21: {
				NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_SCALARS, &r->info21));
			break; }

			case 23: {
				NDR_CHECK(ndr_pull_samr_UserInfo23(ndr, NDR_SCALARS, &r->info23));
			break; }

			case 24: {
				NDR_CHECK(ndr_pull_samr_UserInfo24(ndr, NDR_SCALARS, &r->info24));
			break; }

			case 25: {
				NDR_CHECK(ndr_pull_samr_UserInfo25(ndr, NDR_SCALARS, &r->info25));
			break; }

			case 26: {
				NDR_CHECK(ndr_pull_samr_UserInfo26(ndr, NDR_SCALARS, &r->info26));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_samr_UserInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_samr_UserInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_samr_UserInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_samr_UserInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_pull_samr_UserInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_pull_samr_UserInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 7:
				NDR_CHECK(ndr_pull_samr_UserInfo7(ndr, NDR_BUFFERS, &r->info7));
			break;

			case 8:
				NDR_CHECK(ndr_pull_samr_UserInfo8(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 9:
			break;

			case 10:
				NDR_CHECK(ndr_pull_samr_UserInfo10(ndr, NDR_BUFFERS, &r->info10));
			break;

			case 11:
				NDR_CHECK(ndr_pull_samr_UserInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			case 12:
				NDR_CHECK(ndr_pull_samr_UserInfo12(ndr, NDR_BUFFERS, &r->info12));
			break;

			case 13:
				NDR_CHECK(ndr_pull_samr_UserInfo13(ndr, NDR_BUFFERS, &r->info13));
			break;

			case 14:
				NDR_CHECK(ndr_pull_samr_UserInfo14(ndr, NDR_BUFFERS, &r->info14));
			break;

			case 16:
			break;

			case 17:
			break;

			case 18:
			break;

			case 20:
				NDR_CHECK(ndr_pull_samr_UserInfo20(ndr, NDR_BUFFERS, &r->info20));
			break;

			case 21:
				NDR_CHECK(ndr_pull_samr_UserInfo21(ndr, NDR_BUFFERS, &r->info21));
			break;

			case 23:
				NDR_CHECK(ndr_pull_samr_UserInfo23(ndr, NDR_BUFFERS, &r->info23));
			break;

			case 24:
			break;

			case 25:
				NDR_CHECK(ndr_pull_samr_UserInfo25(ndr, NDR_BUFFERS, &r->info25));
			break;

			case 26:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_UserInfo(struct ndr_print *ndr, const char *name, const union samr_UserInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_UserInfo");
	switch (level) {
		case 1:
			ndr_print_samr_UserInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_samr_UserInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_samr_UserInfo3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_samr_UserInfo4(ndr, "info4", &r->info4);
		break;

		case 5:
			ndr_print_samr_UserInfo5(ndr, "info5", &r->info5);
		break;

		case 6:
			ndr_print_samr_UserInfo6(ndr, "info6", &r->info6);
		break;

		case 7:
			ndr_print_samr_UserInfo7(ndr, "info7", &r->info7);
		break;

		case 8:
			ndr_print_samr_UserInfo8(ndr, "info8", &r->info8);
		break;

		case 9:
			ndr_print_samr_UserInfo9(ndr, "info9", &r->info9);
		break;

		case 10:
			ndr_print_samr_UserInfo10(ndr, "info10", &r->info10);
		break;

		case 11:
			ndr_print_samr_UserInfo11(ndr, "info11", &r->info11);
		break;

		case 12:
			ndr_print_samr_UserInfo12(ndr, "info12", &r->info12);
		break;

		case 13:
			ndr_print_samr_UserInfo13(ndr, "info13", &r->info13);
		break;

		case 14:
			ndr_print_samr_UserInfo14(ndr, "info14", &r->info14);
		break;

		case 16:
			ndr_print_samr_UserInfo16(ndr, "info16", &r->info16);
		break;

		case 17:
			ndr_print_samr_UserInfo17(ndr, "info17", &r->info17);
		break;

		case 18:
			ndr_print_samr_UserInfo18(ndr, "info18", &r->info18);
		break;

		case 20:
			ndr_print_samr_UserInfo20(ndr, "info20", &r->info20);
		break;

		case 21:
			ndr_print_samr_UserInfo21(ndr, "info21", &r->info21);
		break;

		case 23:
			ndr_print_samr_UserInfo23(ndr, "info23", &r->info23);
		break;

		case 24:
			ndr_print_samr_UserInfo24(ndr, "info24", &r->info24);
		break;

		case 25:
			ndr_print_samr_UserInfo25(ndr, "info25", &r->info25);
		break;

		case 26:
			ndr_print_samr_UserInfo26(ndr, "info26", &r->info26);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_RidWithAttribute(struct ndr_push *ndr, int ndr_flags, const struct samr_RidWithAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_RidWithAttribute(struct ndr_pull *ndr, int ndr_flags, struct samr_RidWithAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RidWithAttribute(struct ndr_print *ndr, const char *name, const struct samr_RidWithAttribute *r)
{
	ndr_print_struct(ndr, name, "samr_RidWithAttribute");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_samr_GroupAttrs(ndr, "attributes", r->attributes);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_RidWithAttributeArray(struct ndr_push *ndr, int ndr_flags, const struct samr_RidWithAttributeArray *r)
{
	uint32_t cntr_rids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->rids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_rids_1 = 0; cntr_rids_1 < r->count; cntr_rids_1++) {
				NDR_CHECK(ndr_push_samr_RidWithAttribute(ndr, NDR_SCALARS, &r->rids[cntr_rids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_RidWithAttributeArray(struct ndr_pull *ndr, int ndr_flags, struct samr_RidWithAttributeArray *r)
{
	uint32_t _ptr_rids;
	uint32_t cntr_rids_1;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_rids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rids));
		if (_ptr_rids) {
			NDR_PULL_ALLOC(ndr, r->rids);
		} else {
			r->rids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->rids));
			NDR_PULL_ALLOC_N(ndr, r->rids, ndr_get_array_size(ndr, &r->rids));
			_mem_save_rids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			for (cntr_rids_1 = 0; cntr_rids_1 < r->count; cntr_rids_1++) {
				NDR_CHECK(ndr_pull_samr_RidWithAttribute(ndr, NDR_SCALARS, &r->rids[cntr_rids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		}
		if (r->rids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->rids, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RidWithAttributeArray(struct ndr_print *ndr, const char *name, const struct samr_RidWithAttributeArray *r)
{
	uint32_t cntr_rids_1;
	ndr_print_struct(ndr, name, "samr_RidWithAttributeArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "rids", r->rids);
	ndr->depth++;
	if (r->rids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "rids", (int)r->count);
		ndr->depth++;
		for (cntr_rids_1=0;cntr_rids_1<r->count;cntr_rids_1++) {
			ndr_print_samr_RidWithAttribute(ndr, "rids", &r->rids[cntr_rids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispEntryGeneral(struct ndr_push *ndr, int ndr_flags, const struct samr_DispEntryGeneral *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispEntryGeneral(struct ndr_pull *ndr, int ndr_flags, struct samr_DispEntryGeneral *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispEntryGeneral(struct ndr_print *ndr, const char *name, const struct samr_DispEntryGeneral *r)
{
	ndr_print_struct(ndr, name, "samr_DispEntryGeneral");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "idx", r->idx);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispInfoGeneral(struct ndr_push *ndr, int ndr_flags, const struct samr_DispInfoGeneral *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryGeneral(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryGeneral(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispInfoGeneral(struct ndr_pull *ndr, int ndr_flags, struct samr_DispInfoGeneral *r)
{
	uint32_t _ptr_entries;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_PULL_ALLOC_N(ndr, r->entries, ndr_get_array_size(ndr, &r->entries));
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryGeneral(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryGeneral(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispInfoGeneral(struct ndr_print *ndr, const char *name, const struct samr_DispInfoGeneral *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "samr_DispInfoGeneral");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_samr_DispEntryGeneral(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispEntryFull(struct ndr_push *ndr, int ndr_flags, const struct samr_DispEntryFull *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispEntryFull(struct ndr_pull *ndr, int ndr_flags, struct samr_DispEntryFull *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispEntryFull(struct ndr_print *ndr, const char *name, const struct samr_DispEntryFull *r)
{
	ndr_print_struct(ndr, name, "samr_DispEntryFull");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "idx", r->idx);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispInfoFull(struct ndr_push *ndr, int ndr_flags, const struct samr_DispInfoFull *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryFull(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryFull(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispInfoFull(struct ndr_pull *ndr, int ndr_flags, struct samr_DispInfoFull *r)
{
	uint32_t _ptr_entries;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_PULL_ALLOC_N(ndr, r->entries, ndr_get_array_size(ndr, &r->entries));
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryFull(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryFull(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispInfoFull(struct ndr_print *ndr, const char *name, const struct samr_DispInfoFull *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "samr_DispInfoFull");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_samr_DispEntryFull(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispEntryFullGroup(struct ndr_push *ndr, int ndr_flags, const struct samr_DispEntryFullGroup *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispEntryFullGroup(struct ndr_pull *ndr, int ndr_flags, struct samr_DispEntryFullGroup *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispEntryFullGroup(struct ndr_print *ndr, const char *name, const struct samr_DispEntryFullGroup *r)
{
	ndr_print_struct(ndr, name, "samr_DispEntryFullGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "idx", r->idx);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_samr_GroupAttrs(ndr, "acct_flags", r->acct_flags);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispInfoFullGroups(struct ndr_push *ndr, int ndr_flags, const struct samr_DispInfoFullGroups *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryFullGroup(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryFullGroup(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispInfoFullGroups(struct ndr_pull *ndr, int ndr_flags, struct samr_DispInfoFullGroups *r)
{
	uint32_t _ptr_entries;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_PULL_ALLOC_N(ndr, r->entries, ndr_get_array_size(ndr, &r->entries));
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryFullGroup(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryFullGroup(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispInfoFullGroups(struct ndr_print *ndr, const char *name, const struct samr_DispInfoFullGroups *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "samr_DispInfoFullGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_samr_DispEntryFullGroup(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispEntryAscii(struct ndr_push *ndr, int ndr_flags, const struct samr_DispEntryAscii *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idx));
		NDR_CHECK(ndr_push_lsa_AsciiStringLarge(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_AsciiStringLarge(ndr, NDR_BUFFERS, &r->account_name));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispEntryAscii(struct ndr_pull *ndr, int ndr_flags, struct samr_DispEntryAscii *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idx));
		NDR_CHECK(ndr_pull_lsa_AsciiStringLarge(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_AsciiStringLarge(ndr, NDR_BUFFERS, &r->account_name));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispEntryAscii(struct ndr_print *ndr, const char *name, const struct samr_DispEntryAscii *r)
{
	ndr_print_struct(ndr, name, "samr_DispEntryAscii");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "idx", r->idx);
	ndr_print_lsa_AsciiStringLarge(ndr, "account_name", &r->account_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispInfoAscii(struct ndr_push *ndr, int ndr_flags, const struct samr_DispInfoAscii *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryAscii(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_samr_DispEntryAscii(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispInfoAscii(struct ndr_pull *ndr, int ndr_flags, struct samr_DispInfoAscii *r)
{
	uint32_t _ptr_entries;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			NDR_PULL_ALLOC_N(ndr, r->entries, ndr_get_array_size(ndr, &r->entries));
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryAscii(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_samr_DispEntryAscii(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispInfoAscii(struct ndr_print *ndr, const char *name, const struct samr_DispInfoAscii *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "samr_DispInfoAscii");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_samr_DispEntryAscii(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DispInfo(struct ndr_push *ndr, int ndr_flags, const union samr_DispInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_DispInfoGeneral(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_samr_DispInfoFull(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_samr_DispInfoFullGroups(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_samr_DispInfoAscii(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_samr_DispInfoAscii(ndr, NDR_SCALARS, &r->info5));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_samr_DispInfoGeneral(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_samr_DispInfoFull(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_samr_DispInfoFullGroups(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_push_samr_DispInfoAscii(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_push_samr_DispInfoAscii(ndr, NDR_BUFFERS, &r->info5));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DispInfo(struct ndr_pull *ndr, int ndr_flags, union samr_DispInfo *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_DispInfoGeneral(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_samr_DispInfoFull(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_samr_DispInfoFullGroups(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_samr_DispInfoAscii(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_samr_DispInfoAscii(ndr, NDR_SCALARS, &r->info5));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_samr_DispInfoGeneral(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_samr_DispInfoFull(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_samr_DispInfoFullGroups(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_samr_DispInfoAscii(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_pull_samr_DispInfoAscii(ndr, NDR_BUFFERS, &r->info5));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DispInfo(struct ndr_print *ndr, const char *name, const union samr_DispInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_DispInfo");
	switch (level) {
		case 1:
			ndr_print_samr_DispInfoGeneral(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_samr_DispInfoFull(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_samr_DispInfoFullGroups(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_samr_DispInfoAscii(ndr, "info4", &r->info4);
		break;

		case 5:
			ndr_print_samr_DispInfoAscii(ndr, "info5", &r->info5);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_PwInfo(struct ndr_push *ndr, int ndr_flags, const struct samr_PwInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->min_password_length));
		NDR_CHECK(ndr_push_samr_PasswordProperties(ndr, NDR_SCALARS, r->password_properties));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_PwInfo(struct ndr_pull *ndr, int ndr_flags, struct samr_PwInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->min_password_length));
		NDR_CHECK(ndr_pull_samr_PasswordProperties(ndr, NDR_SCALARS, &r->password_properties));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_PwInfo(struct ndr_print *ndr, const char *name, const struct samr_PwInfo *r)
{
	ndr_print_struct(ndr, name, "samr_PwInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "min_password_length", r->min_password_length);
	ndr_print_samr_PasswordProperties(ndr, "password_properties", r->password_properties);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ConnectVersion(struct ndr_push *ndr, int ndr_flags, enum samr_ConnectVersion r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ConnectVersion(struct ndr_pull *ndr, int ndr_flags, enum samr_ConnectVersion *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ConnectVersion(struct ndr_print *ndr, const char *name, enum samr_ConnectVersion r)
{
	const char *val = NULL;

	switch (r) {
		case SAMR_CONNECT_PRE_W2K: val = "SAMR_CONNECT_PRE_W2K"; break;
		case SAMR_CONNECT_W2K: val = "SAMR_CONNECT_W2K"; break;
		case SAMR_CONNECT_AFTER_W2K: val = "SAMR_CONNECT_AFTER_W2K"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_samPwdChangeReason(struct ndr_push *ndr, int ndr_flags, enum samPwdChangeReason r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samPwdChangeReason(struct ndr_pull *ndr, int ndr_flags, enum samPwdChangeReason *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samPwdChangeReason(struct ndr_print *ndr, const char *name, enum samPwdChangeReason r)
{
	const char *val = NULL;

	switch (r) {
		case SAM_PWD_CHANGE_NO_ERROR: val = "SAM_PWD_CHANGE_NO_ERROR"; break;
		case SAM_PWD_CHANGE_PASSWORD_TOO_SHORT: val = "SAM_PWD_CHANGE_PASSWORD_TOO_SHORT"; break;
		case SAM_PWD_CHANGE_PWD_IN_HISTORY: val = "SAM_PWD_CHANGE_PWD_IN_HISTORY"; break;
		case SAM_PWD_CHANGE_USERNAME_IN_PASSWORD: val = "SAM_PWD_CHANGE_USERNAME_IN_PASSWORD"; break;
		case SAM_PWD_CHANGE_FULLNAME_IN_PASSWORD: val = "SAM_PWD_CHANGE_FULLNAME_IN_PASSWORD"; break;
		case SAM_PWD_CHANGE_NOT_COMPLEX: val = "SAM_PWD_CHANGE_NOT_COMPLEX"; break;
		case SAM_PWD_CHANGE_MACHINE_NOT_DEFAULT: val = "SAM_PWD_CHANGE_MACHINE_NOT_DEFAULT"; break;
		case SAM_PWD_CHANGE_FAILED_BY_FILTER: val = "SAM_PWD_CHANGE_FAILED_BY_FILTER"; break;
		case SAM_PWD_CHANGE_PASSWORD_TOO_LONG: val = "SAM_PWD_CHANGE_PASSWORD_TOO_LONG"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_userPwdChangeFailureInformation(struct ndr_push *ndr, int ndr_flags, const struct userPwdChangeFailureInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_samPwdChangeReason(ndr, NDR_SCALARS, r->extendedFailureReason));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->filterModuleName));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->filterModuleName));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_userPwdChangeFailureInformation(struct ndr_pull *ndr, int ndr_flags, struct userPwdChangeFailureInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_samPwdChangeReason(ndr, NDR_SCALARS, &r->extendedFailureReason));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->filterModuleName));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->filterModuleName));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_userPwdChangeFailureInformation(struct ndr_print *ndr, const char *name, const struct userPwdChangeFailureInformation *r)
{
	ndr_print_struct(ndr, name, "userPwdChangeFailureInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samPwdChangeReason(ndr, "extendedFailureReason", r->extendedFailureReason);
	ndr_print_lsa_String(ndr, "filterModuleName", &r->filterModuleName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ConnectInfo1(struct ndr_push *ndr, int ndr_flags, const struct samr_ConnectInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_samr_ConnectVersion(ndr, NDR_SCALARS, r->client_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ConnectInfo1(struct ndr_pull *ndr, int ndr_flags, struct samr_ConnectInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_samr_ConnectVersion(ndr, NDR_SCALARS, &r->client_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ConnectInfo1(struct ndr_print *ndr, const char *name, const struct samr_ConnectInfo1 *r)
{
	ndr_print_struct(ndr, name, "samr_ConnectInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ConnectVersion(ndr, "client_version", r->client_version);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ConnectInfo(struct ndr_push *ndr, int ndr_flags, const union samr_ConnectInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_ConnectInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ConnectInfo(struct ndr_pull *ndr, int ndr_flags, union samr_ConnectInfo *r)
{
	uint32_t level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_ConnectInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ConnectInfo(struct ndr_print *ndr, const char *name, const union samr_ConnectInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_ConnectInfo");
	switch (level) {
		case 1:
			ndr_print_samr_ConnectInfo1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_ValidateFieldsPresent(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidateFieldsPresent(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidateFieldsPresent(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_PASSWORD_LAST_SET", SAMR_VALIDATE_FIELD_PASSWORD_LAST_SET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_BAD_PASSWORD_TIME", SAMR_VALIDATE_FIELD_BAD_PASSWORD_TIME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_LOCKOUT_TIME", SAMR_VALIDATE_FIELD_LOCKOUT_TIME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_BAD_PASSWORD_COUNT", SAMR_VALIDATE_FIELD_BAD_PASSWORD_COUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_PASSWORD_HISTORY_LENGTH", SAMR_VALIDATE_FIELD_PASSWORD_HISTORY_LENGTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SAMR_VALIDATE_FIELD_PASSWORD_HISTORY", SAMR_VALIDATE_FIELD_PASSWORD_HISTORY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordLevel(struct ndr_push *ndr, int ndr_flags, enum samr_ValidatePasswordLevel r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordLevel(struct ndr_pull *ndr, int ndr_flags, enum samr_ValidatePasswordLevel *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordLevel(struct ndr_print *ndr, const char *name, enum samr_ValidatePasswordLevel r)
{
	const char *val = NULL;

	switch (r) {
		case NetValidateAuthentication: val = "NetValidateAuthentication"; break;
		case NetValidatePasswordChange: val = "NetValidatePasswordChange"; break;
		case NetValidatePasswordReset: val = "NetValidatePasswordReset"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_ValidationStatus(struct ndr_push *ndr, int ndr_flags, enum samr_ValidationStatus r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidationStatus(struct ndr_pull *ndr, int ndr_flags, enum samr_ValidationStatus *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidationStatus(struct ndr_print *ndr, const char *name, enum samr_ValidationStatus r)
{
	const char *val = NULL;

	switch (r) {
		case SAMR_VALIDATION_STATUS_SUCCESS: val = "SAMR_VALIDATION_STATUS_SUCCESS"; break;
		case SAMR_VALIDATION_STATUS_PASSWORD_MUST_CHANGE: val = "SAMR_VALIDATION_STATUS_PASSWORD_MUST_CHANGE"; break;
		case SAMR_VALIDATION_STATUS_ACCOUNT_LOCKED_OUT: val = "SAMR_VALIDATION_STATUS_ACCOUNT_LOCKED_OUT"; break;
		case SAMR_VALIDATION_STATUS_PASSWORD_EXPIRED: val = "SAMR_VALIDATION_STATUS_PASSWORD_EXPIRED"; break;
		case SAMR_VALIDATION_STATUS_BAD_PASSWORD: val = "SAMR_VALIDATION_STATUS_BAD_PASSWORD"; break;
		case SAMR_VALIDATION_STATUS_PWD_HISTORY_CONFLICT: val = "SAMR_VALIDATION_STATUS_PWD_HISTORY_CONFLICT"; break;
		case SAMR_VALIDATION_STATUS_PWD_TOO_SHORT: val = "SAMR_VALIDATION_STATUS_PWD_TOO_SHORT"; break;
		case SAMR_VALIDATION_STATUS_PWD_TOO_LONG: val = "SAMR_VALIDATION_STATUS_PWD_TOO_LONG"; break;
		case SAMR_VALIDATION_STATUS_NOT_COMPLEX_ENOUGH: val = "SAMR_VALIDATION_STATUS_NOT_COMPLEX_ENOUGH"; break;
		case SAMR_VALIDATION_STATUS_PASSWORD_TOO_RECENT: val = "SAMR_VALIDATION_STATUS_PASSWORD_TOO_RECENT"; break;
		case SAMR_VALIDATION_STATUS_PASSWORD_FILTER_ERROR: val = "SAMR_VALIDATION_STATUS_PASSWORD_FILTER_ERROR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_samr_ValidationBlob(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidationBlob *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidationBlob(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidationBlob *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_size(ndr, &r->data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidationBlob(struct ndr_print *ndr, const char *name, const struct samr_ValidationBlob *r)
{
	ndr_print_struct(ndr, name, "samr_ValidationBlob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordInfo(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidatePasswordInfo *r)
{
	uint32_t cntr_pwd_history_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_ValidateFieldsPresent(ndr, NDR_SCALARS, r->fields_present));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->bad_password_time));
		NDR_CHECK(ndr_push_NTTIME_hyper(ndr, NDR_SCALARS, r->lockout_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bad_pwd_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pwd_history_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pwd_history));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pwd_history) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->pwd_history_len));
			for (cntr_pwd_history_1 = 0; cntr_pwd_history_1 < r->pwd_history_len; cntr_pwd_history_1++) {
				NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_SCALARS, &r->pwd_history[cntr_pwd_history_1]));
			}
			for (cntr_pwd_history_1 = 0; cntr_pwd_history_1 < r->pwd_history_len; cntr_pwd_history_1++) {
				NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->pwd_history[cntr_pwd_history_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordInfo(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidatePasswordInfo *r)
{
	uint32_t _ptr_pwd_history;
	uint32_t cntr_pwd_history_1;
	TALLOC_CTX *_mem_save_pwd_history_0;
	TALLOC_CTX *_mem_save_pwd_history_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_ValidateFieldsPresent(ndr, NDR_SCALARS, &r->fields_present));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->bad_password_time));
		NDR_CHECK(ndr_pull_NTTIME_hyper(ndr, NDR_SCALARS, &r->lockout_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bad_pwd_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pwd_history_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwd_history));
		if (_ptr_pwd_history) {
			NDR_PULL_ALLOC(ndr, r->pwd_history);
		} else {
			r->pwd_history = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pwd_history) {
			_mem_save_pwd_history_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwd_history, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pwd_history));
			NDR_PULL_ALLOC_N(ndr, r->pwd_history, ndr_get_array_size(ndr, &r->pwd_history));
			_mem_save_pwd_history_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwd_history, 0);
			for (cntr_pwd_history_1 = 0; cntr_pwd_history_1 < r->pwd_history_len; cntr_pwd_history_1++) {
				NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_SCALARS, &r->pwd_history[cntr_pwd_history_1]));
			}
			for (cntr_pwd_history_1 = 0; cntr_pwd_history_1 < r->pwd_history_len; cntr_pwd_history_1++) {
				NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->pwd_history[cntr_pwd_history_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwd_history_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwd_history_0, 0);
		}
		if (r->pwd_history) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pwd_history, r->pwd_history_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordInfo(struct ndr_print *ndr, const char *name, const struct samr_ValidatePasswordInfo *r)
{
	uint32_t cntr_pwd_history_1;
	ndr_print_struct(ndr, name, "samr_ValidatePasswordInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ValidateFieldsPresent(ndr, "fields_present", r->fields_present);
	ndr_print_NTTIME_hyper(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME_hyper(ndr, "bad_password_time", r->bad_password_time);
	ndr_print_NTTIME_hyper(ndr, "lockout_time", r->lockout_time);
	ndr_print_uint32(ndr, "bad_pwd_count", r->bad_pwd_count);
	ndr_print_uint32(ndr, "pwd_history_len", r->pwd_history_len);
	ndr_print_ptr(ndr, "pwd_history", r->pwd_history);
	ndr->depth++;
	if (r->pwd_history) {
		ndr->print(ndr, "%s: ARRAY(%d)", "pwd_history", (int)r->pwd_history_len);
		ndr->depth++;
		for (cntr_pwd_history_1=0;cntr_pwd_history_1<r->pwd_history_len;cntr_pwd_history_1++) {
			ndr_print_samr_ValidationBlob(ndr, "pwd_history", &r->pwd_history[cntr_pwd_history_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordRepCtr(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidatePasswordRepCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_samr_ValidationStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordRepCtr(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidatePasswordRepCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_samr_ValidationStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordRepCtr(struct ndr_print *ndr, const char *name, const struct samr_ValidatePasswordRepCtr *r)
{
	ndr_print_struct(ndr, name, "samr_ValidatePasswordRepCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ValidatePasswordInfo(ndr, "info", &r->info);
	ndr_print_samr_ValidationStatus(ndr, "status", r->status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordRep(struct ndr_push *ndr, int ndr_flags, const union samr_ValidatePasswordRep *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_push_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordRep(struct ndr_pull *ndr, int ndr_flags, union samr_ValidatePasswordRep *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordRepCtr(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordRep(struct ndr_print *ndr, const char *name, const union samr_ValidatePasswordRep *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_ValidatePasswordRep");
	switch (level) {
		case 1:
			ndr_print_samr_ValidatePasswordRepCtr(ndr, "ctr1", &r->ctr1);
		break;

		case 2:
			ndr_print_samr_ValidatePasswordRepCtr(ndr, "ctr2", &r->ctr2);
		break;

		case 3:
			ndr_print_samr_ValidatePasswordRepCtr(ndr, "ctr3", &r->ctr3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordReq3(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidatePasswordReq3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_SCALARS, &r->hash));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pwd_must_change_at_next_logon));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->clear_lockout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->password));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->account));
		NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->hash));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordReq3(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidatePasswordReq3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_SCALARS, &r->hash));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pwd_must_change_at_next_logon));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->clear_lockout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->password));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->account));
		NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->hash));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordReq3(struct ndr_print *ndr, const char *name, const struct samr_ValidatePasswordReq3 *r)
{
	ndr_print_struct(ndr, name, "samr_ValidatePasswordReq3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ValidatePasswordInfo(ndr, "info", &r->info);
	ndr_print_lsa_StringLarge(ndr, "password", &r->password);
	ndr_print_lsa_StringLarge(ndr, "account", &r->account);
	ndr_print_samr_ValidationBlob(ndr, "hash", &r->hash);
	ndr_print_uint8(ndr, "pwd_must_change_at_next_logon", r->pwd_must_change_at_next_logon);
	ndr_print_uint8(ndr, "clear_lockout", r->clear_lockout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordReq2(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidatePasswordReq2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_SCALARS, &r->hash));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_matched));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->password));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->account));
		NDR_CHECK(ndr_push_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->hash));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordReq2(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidatePasswordReq2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->password));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->account));
		NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_SCALARS, &r->hash));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_matched));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->password));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->account));
		NDR_CHECK(ndr_pull_samr_ValidationBlob(ndr, NDR_BUFFERS, &r->hash));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordReq2(struct ndr_print *ndr, const char *name, const struct samr_ValidatePasswordReq2 *r)
{
	ndr_print_struct(ndr, name, "samr_ValidatePasswordReq2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ValidatePasswordInfo(ndr, "info", &r->info);
	ndr_print_lsa_StringLarge(ndr, "password", &r->password);
	ndr_print_lsa_StringLarge(ndr, "account", &r->account);
	ndr_print_samr_ValidationBlob(ndr, "hash", &r->hash);
	ndr_print_uint8(ndr, "password_matched", r->password_matched);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordReq1(struct ndr_push *ndr, int ndr_flags, const struct samr_ValidatePasswordReq1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_matched));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordReq1(struct ndr_pull *ndr, int ndr_flags, struct samr_ValidatePasswordReq1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_matched));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_samr_ValidatePasswordInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordReq1(struct ndr_print *ndr, const char *name, const struct samr_ValidatePasswordReq1 *r)
{
	ndr_print_struct(ndr, name, "samr_ValidatePasswordReq1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_samr_ValidatePasswordInfo(ndr, "info", &r->info);
	ndr_print_uint8(ndr, "password_matched", r->password_matched);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePasswordReq(struct ndr_push *ndr, int ndr_flags, const union samr_ValidatePasswordReq *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq2(ndr, NDR_SCALARS, &r->req2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq3(ndr, NDR_SCALARS, &r->req3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case 2:
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq2(ndr, NDR_BUFFERS, &r->req2));
			break;

			case 3:
				NDR_CHECK(ndr_push_samr_ValidatePasswordReq3(ndr, NDR_BUFFERS, &r->req3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePasswordReq(struct ndr_pull *ndr, int ndr_flags, union samr_ValidatePasswordReq *r)
{
	uint32_t level;
	uint16_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq2(ndr, NDR_SCALARS, &r->req2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq3(ndr, NDR_SCALARS, &r->req3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq2(ndr, NDR_BUFFERS, &r->req2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_samr_ValidatePasswordReq3(ndr, NDR_BUFFERS, &r->req3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePasswordReq(struct ndr_print *ndr, const char *name, const union samr_ValidatePasswordReq *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "samr_ValidatePasswordReq");
	switch (level) {
		case 1:
			ndr_print_samr_ValidatePasswordReq1(ndr, "req1", &r->req1);
		break;

		case 2:
			ndr_print_samr_ValidatePasswordReq2(ndr, "req2", &r->req2);
		break;

		case 3:
			ndr_print_samr_ValidatePasswordReq3(ndr, "req3", &r->req3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_samr_Connect(struct ndr_push *ndr, int flags, const struct samr_Connect *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_samr_ConnectAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Connect(struct ndr_pull *ndr, int flags, struct samr_Connect *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_ConnectAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		ZERO_STRUCTP(r->out.connect_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Connect(struct ndr_print *ndr, const char *name, int flags, const struct samr_Connect *r)
{
	ndr_print_struct(ndr, name, "samr_Connect");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Connect");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_samr_ConnectAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Connect");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_Close(struct ndr_push *ndr, int flags, const struct samr_Close *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_Close(struct ndr_pull *ndr, int flags, struct samr_Close *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Close(struct ndr_print *ndr, const char *name, int flags, const struct samr_Close *r)
{
	ndr_print_struct(ndr, name, "samr_Close");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Close");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetSecurity(struct ndr_push *ndr, int flags, const struct samr_SetSecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
		if (r->in.sdbuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sdbuf));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetSecurity(struct ndr_pull *ndr, int flags, struct samr_SetSecurity *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sdbuf_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sdbuf);
		}
		_mem_save_sdbuf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sdbuf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sdbuf));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetSecurity(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetSecurity *r)
{
	ndr_print_struct(ndr, name, "samr_SetSecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr_print_ptr(ndr, "sdbuf", r->in.sdbuf);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "sdbuf", r->in.sdbuf);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetSecurity");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QuerySecurity(struct ndr_push *ndr, int flags, const struct samr_QuerySecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
	}
	if (flags & NDR_OUT) {
		if (r->out.sdbuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sdbuf));
		if (*r->out.sdbuf) {
			NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sdbuf));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QuerySecurity(struct ndr_pull *ndr, int flags, struct samr_QuerySecurity *r)
{
	uint32_t _ptr_sdbuf;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sdbuf_0;
	TALLOC_CTX *_mem_save_sdbuf_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
		NDR_PULL_ALLOC(ndr, r->out.sdbuf);
		ZERO_STRUCTP(r->out.sdbuf);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sdbuf);
		}
		_mem_save_sdbuf_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sdbuf, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sdbuf));
		if (_ptr_sdbuf) {
			NDR_PULL_ALLOC(ndr, *r->out.sdbuf);
		} else {
			*r->out.sdbuf = NULL;
		}
		if (*r->out.sdbuf) {
			_mem_save_sdbuf_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sdbuf, 0);
			NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sdbuf));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sdbuf_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QuerySecurity(struct ndr_print *ndr, const char *name, int flags, const struct samr_QuerySecurity *r)
{
	ndr_print_struct(ndr, name, "samr_QuerySecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QuerySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "sdbuf", r->out.sdbuf);
		ndr->depth++;
		ndr_print_ptr(ndr, "sdbuf", *r->out.sdbuf);
		ndr->depth++;
		if (*r->out.sdbuf) {
			ndr_print_sec_desc_buf(ndr, "sdbuf", *r->out.sdbuf);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_Shutdown(struct ndr_push *ndr, int flags, const struct samr_Shutdown *r)
{
	if (flags & NDR_IN) {
		if (r->in.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Shutdown(struct ndr_pull *ndr, int flags, struct samr_Shutdown *r)
{
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Shutdown(struct ndr_print *ndr, const char *name, int flags, const struct samr_Shutdown *r)
{
	ndr_print_struct(ndr, name, "samr_Shutdown");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Shutdown");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Shutdown");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_LookupDomain(struct ndr_push *ndr, int flags, const struct samr_LookupDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		if (r->in.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_name));
	}
	if (flags & NDR_OUT) {
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sid));
		if (*r->out.sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sid));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_LookupDomain(struct ndr_pull *ndr, int flags, struct samr_LookupDomain *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_connect_handle_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_sid_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		}
		_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sid);
		ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, *r->out.sid);
		} else {
			*r->out.sid = NULL;
		}
		if (*r->out.sid) {
			_mem_save_sid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_LookupDomain(struct ndr_print *ndr, const char *name, int flags, const struct samr_LookupDomain *r)
{
	ndr_print_struct(ndr, name, "samr_LookupDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_LookupDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_LookupDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", *r->out.sid);
		ndr->depth++;
		if (*r->out.sid) {
			ndr_print_dom_sid2(ndr, "sid", *r->out.sid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_EnumDomains(struct ndr_push *ndr, int flags, const struct samr_EnumDomains *r)
{
	if (flags & NDR_IN) {
		if (r->in.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.sam == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sam));
		if (*r->out.sam) {
			NDR_CHECK(ndr_push_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
		}
		if (r->out.num_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_entries));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_EnumDomains(struct ndr_pull *ndr, int flags, struct samr_EnumDomains *r)
{
	uint32_t _ptr_sam;
	TALLOC_CTX *_mem_save_connect_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_sam_0;
	TALLOC_CTX *_mem_save_sam_1;
	TALLOC_CTX *_mem_save_num_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sam);
		ZERO_STRUCTP(r->out.sam);
		NDR_PULL_ALLOC(ndr, r->out.num_entries);
		ZERO_STRUCTP(r->out.num_entries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sam);
		}
		_mem_save_sam_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sam, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam));
		if (_ptr_sam) {
			NDR_PULL_ALLOC(ndr, *r->out.sam);
		} else {
			*r->out.sam = NULL;
		}
		if (*r->out.sam) {
			_mem_save_sam_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sam, 0);
			NDR_CHECK(ndr_pull_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_entries);
		}
		_mem_save_num_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_entries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_EnumDomains(struct ndr_print *ndr, const char *name, int flags, const struct samr_EnumDomains *r)
{
	ndr_print_struct(ndr, name, "samr_EnumDomains");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_EnumDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_EnumDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sam", r->out.sam);
		ndr->depth++;
		ndr_print_ptr(ndr, "sam", *r->out.sam);
		ndr->depth++;
		if (*r->out.sam) {
			ndr_print_samr_SamArray(ndr, "sam", *r->out.sam);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "num_entries", r->out.num_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_entries", *r->out.num_entries);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_OpenDomain(struct ndr_push *ndr, int flags, const struct samr_OpenDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_CHECK(ndr_push_samr_DomainAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.domain_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_OpenDomain(struct ndr_pull *ndr, int flags, struct samr_OpenDomain *r)
{
	TALLOC_CTX *_mem_save_connect_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_domain_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_DomainAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domain_handle);
		ZERO_STRUCTP(r->out.domain_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_OpenDomain(struct ndr_print *ndr, const char *name, int flags, const struct samr_OpenDomain *r)
{
	ndr_print_struct(ndr, name, "samr_OpenDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_OpenDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth--;
		ndr_print_samr_DomainAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_OpenDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->out.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->out.domain_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryDomainInfo(struct ndr_push *ndr, int flags, const struct samr_QueryDomainInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_DomainInfoClass(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryDomainInfo(struct ndr_pull *ndr, int flags, struct samr_QueryDomainInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_DomainInfoClass(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryDomainInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryDomainInfo *r)
{
	ndr_print_struct(ndr, name, "samr_QueryDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_DomainInfoClass(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_DomainInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetDomainInfo(struct ndr_push *ndr, int flags, const struct samr_SetDomainInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_DomainInfoClass(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetDomainInfo(struct ndr_pull *ndr, int flags, struct samr_SetDomainInfo *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_DomainInfoClass(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetDomainInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetDomainInfo *r)
{
	ndr_print_struct(ndr, name, "samr_SetDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_DomainInfoClass(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_samr_DomainInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetDomainInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_CreateDomainGroup(struct ndr_push *ndr, int flags, const struct samr_CreateDomainGroup *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_samr_GroupAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_CreateDomainGroup(struct ndr_pull *ndr, int flags, struct samr_CreateDomainGroup *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_group_handle_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_GroupAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.group_handle);
		ZERO_STRUCTP(r->out.group_handle);
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CreateDomainGroup(struct ndr_print *ndr, const char *name, int flags, const struct samr_CreateDomainGroup *r)
{
	ndr_print_struct(ndr, name, "samr_CreateDomainGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_CreateDomainGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_samr_GroupAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_CreateDomainGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->out.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->out.group_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_EnumDomainGroups(struct ndr_push *ndr, int flags, const struct samr_EnumDomainGroups *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.sam == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sam));
		if (*r->out.sam) {
			NDR_CHECK(ndr_push_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
		}
		if (r->out.num_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_entries));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_EnumDomainGroups(struct ndr_pull *ndr, int flags, struct samr_EnumDomainGroups *r)
{
	uint32_t _ptr_sam;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_sam_0;
	TALLOC_CTX *_mem_save_sam_1;
	TALLOC_CTX *_mem_save_num_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sam);
		ZERO_STRUCTP(r->out.sam);
		NDR_PULL_ALLOC(ndr, r->out.num_entries);
		ZERO_STRUCTP(r->out.num_entries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sam);
		}
		_mem_save_sam_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sam, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam));
		if (_ptr_sam) {
			NDR_PULL_ALLOC(ndr, *r->out.sam);
		} else {
			*r->out.sam = NULL;
		}
		if (*r->out.sam) {
			_mem_save_sam_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sam, 0);
			NDR_CHECK(ndr_pull_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_entries);
		}
		_mem_save_num_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_entries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_EnumDomainGroups(struct ndr_print *ndr, const char *name, int flags, const struct samr_EnumDomainGroups *r)
{
	ndr_print_struct(ndr, name, "samr_EnumDomainGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_EnumDomainGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_EnumDomainGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sam", r->out.sam);
		ndr->depth++;
		ndr_print_ptr(ndr, "sam", *r->out.sam);
		ndr->depth++;
		if (*r->out.sam) {
			ndr_print_samr_SamArray(ndr, "sam", *r->out.sam);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "num_entries", r->out.num_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_entries", *r->out.num_entries);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_CreateUser(struct ndr_push *ndr, int flags, const struct samr_CreateUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
		NDR_CHECK(ndr_push_samr_UserAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_CreateUser(struct ndr_pull *ndr, int flags, struct samr_CreateUser *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_account_name_0;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
		}
		_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.user_handle);
		ZERO_STRUCTP(r->out.user_handle);
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CreateUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_CreateUser *r)
{
	ndr_print_struct(ndr, name, "samr_CreateUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_CreateUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_samr_UserAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_CreateUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->out.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->out.user_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_EnumDomainUsers(struct ndr_push *ndr, int flags, const struct samr_EnumDomainUsers *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->in.acct_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.sam == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sam));
		if (*r->out.sam) {
			NDR_CHECK(ndr_push_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
		}
		if (r->out.num_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_entries));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_EnumDomainUsers(struct ndr_pull *ndr, int flags, struct samr_EnumDomainUsers *r)
{
	uint32_t _ptr_sam;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_sam_0;
	TALLOC_CTX *_mem_save_sam_1;
	TALLOC_CTX *_mem_save_num_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->in.acct_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sam);
		ZERO_STRUCTP(r->out.sam);
		NDR_PULL_ALLOC(ndr, r->out.num_entries);
		ZERO_STRUCTP(r->out.num_entries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sam);
		}
		_mem_save_sam_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sam, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam));
		if (_ptr_sam) {
			NDR_PULL_ALLOC(ndr, *r->out.sam);
		} else {
			*r->out.sam = NULL;
		}
		if (*r->out.sam) {
			_mem_save_sam_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sam, 0);
			NDR_CHECK(ndr_pull_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_entries);
		}
		_mem_save_num_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_entries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_EnumDomainUsers(struct ndr_print *ndr, const char *name, int flags, const struct samr_EnumDomainUsers *r)
{
	ndr_print_struct(ndr, name, "samr_EnumDomainUsers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_EnumDomainUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_samr_AcctFlags(ndr, "acct_flags", r->in.acct_flags);
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_EnumDomainUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sam", r->out.sam);
		ndr->depth++;
		ndr_print_ptr(ndr, "sam", *r->out.sam);
		ndr->depth++;
		if (*r->out.sam) {
			ndr_print_samr_SamArray(ndr, "sam", *r->out.sam);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "num_entries", r->out.num_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_entries", *r->out.num_entries);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_CreateDomAlias(struct ndr_push *ndr, int flags, const struct samr_CreateDomAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.alias_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.alias_name));
		NDR_CHECK(ndr_push_samr_AliasAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_CreateDomAlias(struct ndr_pull *ndr, int flags, struct samr_CreateDomAlias *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_alias_name_0;
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_name);
		}
		_mem_save_alias_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.alias_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AliasAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		ZERO_STRUCTP(r->out.alias_handle);
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CreateDomAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_CreateDomAlias *r)
{
	ndr_print_struct(ndr, name, "samr_CreateDomAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_CreateDomAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "alias_name", r->in.alias_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "alias_name", r->in.alias_name);
		ndr->depth--;
		ndr_print_samr_AliasAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_CreateDomAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_EnumDomainAliases(struct ndr_push *ndr, int flags, const struct samr_EnumDomainAliases *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.resume_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		if (r->out.sam == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sam));
		if (*r->out.sam) {
			NDR_CHECK(ndr_push_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
		}
		if (r->out.num_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_entries));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_EnumDomainAliases(struct ndr_pull *ndr, int flags, struct samr_EnumDomainAliases *r)
{
	uint32_t _ptr_sam;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_sam_0;
	TALLOC_CTX *_mem_save_sam_1;
	TALLOC_CTX *_mem_save_num_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_size));
		NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		*r->out.resume_handle = *r->in.resume_handle;
		NDR_PULL_ALLOC(ndr, r->out.sam);
		ZERO_STRUCTP(r->out.sam);
		NDR_PULL_ALLOC(ndr, r->out.num_entries);
		ZERO_STRUCTP(r->out.num_entries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		}
		_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sam);
		}
		_mem_save_sam_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sam, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam));
		if (_ptr_sam) {
			NDR_PULL_ALLOC(ndr, *r->out.sam);
		} else {
			*r->out.sam = NULL;
		}
		if (*r->out.sam) {
			_mem_save_sam_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sam, 0);
			NDR_CHECK(ndr_pull_samr_SamArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sam));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_entries);
		}
		_mem_save_num_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_entries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_EnumDomainAliases(struct ndr_print *ndr, const char *name, int flags, const struct samr_EnumDomainAliases *r)
{
	ndr_print_struct(ndr, name, "samr_EnumDomainAliases");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_EnumDomainAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_size", r->in.max_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_EnumDomainAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sam", r->out.sam);
		ndr->depth++;
		ndr_print_ptr(ndr, "sam", *r->out.sam);
		ndr->depth++;
		if (*r->out.sam) {
			ndr_print_samr_SamArray(ndr, "sam", *r->out.sam);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "num_entries", r->out.num_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_entries", *r->out.num_entries);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetAliasMembership(struct ndr_push *ndr, int flags, const struct samr_GetAliasMembership *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetAliasMembership(struct ndr_pull *ndr, int flags, struct samr_GetAliasMembership *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_rids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetAliasMembership(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetAliasMembership *r)
{
	ndr_print_struct(ndr, name, "samr_GetAliasMembership");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetAliasMembership");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetAliasMembership");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_samr_Ids(ndr, "rids", r->out.rids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_LookupNames(struct ndr_push *ndr, int flags, const struct samr_LookupNames *r)
{
	uint32_t cntr_names_0;
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_names));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1000));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_names));
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < r->in.num_names; cntr_names_0++) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rids));
		if (r->out.types == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.types));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_LookupNames(struct ndr_pull *ndr, int flags, struct samr_LookupNames *r)
{
	uint32_t cntr_names_0;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_types_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_names));
		if (r->in.num_names > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.names));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.names));
		if (ndr_get_array_length(ndr, &r->in.names) > ndr_get_array_size(ndr, &r->in.names)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.names), ndr_get_array_length(ndr, &r->in.names));
		}
		NDR_PULL_ALLOC_N(ndr, r->in.names, ndr_get_array_size(ndr, &r->in.names));
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.names, 0);
		for (cntr_names_0 = 0; cntr_names_0 < ndr_get_array_length(ndr, &r->in.names); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->in.names[cntr_names_0]));
		}
		for (cntr_names_0 = 0; cntr_names_0 < ndr_get_array_length(ndr, &r->in.names); cntr_names_0++) {
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->in.names[cntr_names_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		ZERO_STRUCTP(r->out.rids);
		NDR_PULL_ALLOC(ndr, r->out.types);
		ZERO_STRUCTP(r->out.types);
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.names, 1000));
		}
		if (r->in.names) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.names, r->in.num_names));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.types);
		}
		_mem_save_types_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.types, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.types));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_types_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_LookupNames(struct ndr_print *ndr, const char *name, int flags, const struct samr_LookupNames *r)
{
	uint32_t cntr_names_0;
	ndr_print_struct(ndr, name, "samr_LookupNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_names", r->in.num_names);
		ndr->print(ndr, "%s: ARRAY(%d)", "names", (int)r->in.num_names);
		ndr->depth++;
		for (cntr_names_0=0;cntr_names_0<r->in.num_names;cntr_names_0++) {
			ndr_print_lsa_String(ndr, "names", &r->in.names[cntr_names_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_LookupNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_samr_Ids(ndr, "rids", r->out.rids);
		ndr->depth--;
		ndr_print_ptr(ndr, "types", r->out.types);
		ndr->depth++;
		ndr_print_samr_Ids(ndr, "types", r->out.types);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_LookupRids(struct ndr_push *ndr, int flags, const struct samr_LookupRids *r)
{
	uint32_t cntr_rids_0;
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_rids));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 1000));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_rids));
		for (cntr_rids_0 = 0; cntr_rids_0 < r->in.num_rids; cntr_rids_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rids[cntr_rids_0]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_Strings(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		if (r->out.types == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.types));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_LookupRids(struct ndr_pull *ndr, int flags, struct samr_LookupRids *r)
{
	uint32_t cntr_rids_0;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_types_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_rids));
		if (r->in.num_rids > 1000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rids));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rids));
		if (ndr_get_array_length(ndr, &r->in.rids) > ndr_get_array_size(ndr, &r->in.rids)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.rids), ndr_get_array_length(ndr, &r->in.rids));
		}
		NDR_PULL_ALLOC_N(ndr, r->in.rids, ndr_get_array_size(ndr, &r->in.rids));
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rids, 0);
		for (cntr_rids_0 = 0; cntr_rids_0 < ndr_get_array_length(ndr, &r->in.rids); cntr_rids_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rids[cntr_rids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		NDR_PULL_ALLOC(ndr, r->out.names);
		ZERO_STRUCTP(r->out.names);
		NDR_PULL_ALLOC(ndr, r->out.types);
		ZERO_STRUCTP(r->out.types);
		if (r->in.rids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.rids, 1000));
		}
		if (r->in.rids) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.rids, r->in.num_rids));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_Strings(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.types);
		}
		_mem_save_types_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.types, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Ids(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.types));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_types_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_LookupRids(struct ndr_print *ndr, const char *name, int flags, const struct samr_LookupRids *r)
{
	uint32_t cntr_rids_0;
	ndr_print_struct(ndr, name, "samr_LookupRids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_rids", r->in.num_rids);
		ndr->print(ndr, "%s: ARRAY(%d)", "rids", (int)r->in.num_rids);
		ndr->depth++;
		for (cntr_rids_0=0;cntr_rids_0<r->in.num_rids;cntr_rids_0++) {
			ndr_print_uint32(ndr, "rids", r->in.rids[cntr_rids_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_Strings(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_ptr(ndr, "types", r->out.types);
		ndr->depth++;
		ndr_print_samr_Ids(ndr, "types", r->out.types);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_OpenGroup(struct ndr_push *ndr, int flags, const struct samr_OpenGroup *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_GroupAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
	}
	if (flags & NDR_OUT) {
		if (r->out.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_OpenGroup(struct ndr_pull *ndr, int flags, struct samr_OpenGroup *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_group_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_GroupAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
		NDR_PULL_ALLOC(ndr, r->out.group_handle);
		ZERO_STRUCTP(r->out.group_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_OpenGroup(struct ndr_print *ndr, const char *name, int flags, const struct samr_OpenGroup *r)
{
	ndr_print_struct(ndr, name, "samr_OpenGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_OpenGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_GroupAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_OpenGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->out.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->out.group_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryGroupInfo(struct ndr_push *ndr, int flags, const struct samr_QueryGroupInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_CHECK(ndr_push_samr_GroupInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_GroupInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryGroupInfo(struct ndr_pull *ndr, int flags, struct samr_QueryGroupInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_group_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_GroupInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_GroupInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryGroupInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryGroupInfo *r)
{
	ndr_print_struct(ndr, name, "samr_QueryGroupInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryGroupInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr_print_samr_GroupInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryGroupInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_GroupInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetGroupInfo(struct ndr_push *ndr, int flags, const struct samr_SetGroupInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_CHECK(ndr_push_samr_GroupInfoEnum(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_samr_GroupInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetGroupInfo(struct ndr_pull *ndr, int flags, struct samr_SetGroupInfo *r)
{
	TALLOC_CTX *_mem_save_group_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_GroupInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_GroupInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetGroupInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetGroupInfo *r)
{
	ndr_print_struct(ndr, name, "samr_SetGroupInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetGroupInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr_print_samr_GroupInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_samr_GroupInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetGroupInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AddGroupMember(struct ndr_push *ndr, int flags, const struct samr_AddGroupMember *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AddGroupMember(struct ndr_pull *ndr, int flags, struct samr_AddGroupMember *r)
{
	TALLOC_CTX *_mem_save_group_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AddGroupMember(struct ndr_print *ndr, const char *name, int flags, const struct samr_AddGroupMember *r)
{
	ndr_print_struct(ndr, name, "samr_AddGroupMember");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_AddGroupMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_AddGroupMember");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DeleteDomainGroup(struct ndr_push *ndr, int flags, const struct samr_DeleteDomainGroup *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DeleteDomainGroup(struct ndr_pull *ndr, int flags, struct samr_DeleteDomainGroup *r)
{
	TALLOC_CTX *_mem_save_group_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.group_handle);
		*r->out.group_handle = *r->in.group_handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DeleteDomainGroup(struct ndr_print *ndr, const char *name, int flags, const struct samr_DeleteDomainGroup *r)
{
	ndr_print_struct(ndr, name, "samr_DeleteDomainGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_DeleteDomainGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_DeleteDomainGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->out.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->out.group_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DeleteGroupMember(struct ndr_push *ndr, int flags, const struct samr_DeleteGroupMember *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DeleteGroupMember(struct ndr_pull *ndr, int flags, struct samr_DeleteGroupMember *r)
{
	TALLOC_CTX *_mem_save_group_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DeleteGroupMember(struct ndr_print *ndr, const char *name, int flags, const struct samr_DeleteGroupMember *r)
{
	ndr_print_struct(ndr, name, "samr_DeleteGroupMember");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_DeleteGroupMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_DeleteGroupMember");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryGroupMember(struct ndr_push *ndr, int flags, const struct samr_QueryGroupMember *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.rids));
		if (*r->out.rids) {
			NDR_CHECK(ndr_push_samr_RidAttrArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rids));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryGroupMember(struct ndr_pull *ndr, int flags, struct samr_QueryGroupMember *r)
{
	uint32_t _ptr_rids;
	TALLOC_CTX *_mem_save_group_handle_0;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_rids_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rids));
		if (_ptr_rids) {
			NDR_PULL_ALLOC(ndr, *r->out.rids);
		} else {
			*r->out.rids = NULL;
		}
		if (*r->out.rids) {
			_mem_save_rids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.rids, 0);
			NDR_CHECK(ndr_pull_samr_RidAttrArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rids));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryGroupMember(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryGroupMember *r)
{
	ndr_print_struct(ndr, name, "samr_QueryGroupMember");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryGroupMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryGroupMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", *r->out.rids);
		ndr->depth++;
		if (*r->out.rids) {
			ndr_print_samr_RidAttrArray(ndr, "rids", *r->out.rids);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetMemberAttributesOfGroup(struct ndr_push *ndr, int flags, const struct samr_SetMemberAttributesOfGroup *r)
{
	if (flags & NDR_IN) {
		if (r->in.group_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetMemberAttributesOfGroup(struct ndr_pull *ndr, int flags, struct samr_SetMemberAttributesOfGroup *r)
{
	TALLOC_CTX *_mem_save_group_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.group_handle);
		}
		_mem_save_group_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.group_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.group_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetMemberAttributesOfGroup(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetMemberAttributesOfGroup *r)
{
	ndr_print_struct(ndr, name, "samr_SetMemberAttributesOfGroup");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetMemberAttributesOfGroup");
		ndr->depth++;
		ndr_print_ptr(ndr, "group_handle", r->in.group_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "group_handle", r->in.group_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetMemberAttributesOfGroup");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_OpenAlias(struct ndr_push *ndr, int flags, const struct samr_OpenAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_AliasAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
	}
	if (flags & NDR_OUT) {
		if (r->out.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_OpenAlias(struct ndr_pull *ndr, int flags, struct samr_OpenAlias *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_alias_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AliasAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
		NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		ZERO_STRUCTP(r->out.alias_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_OpenAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_OpenAlias *r)
{
	ndr_print_struct(ndr, name, "samr_OpenAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_OpenAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_AliasAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_OpenAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryAliasInfo(struct ndr_push *ndr, int flags, const struct samr_QueryAliasInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_CHECK(ndr_push_samr_AliasInfoEnum(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_AliasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryAliasInfo(struct ndr_pull *ndr, int flags, struct samr_QueryAliasInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AliasInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_AliasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryAliasInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryAliasInfo *r)
{
	ndr_print_struct(ndr, name, "samr_QueryAliasInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryAliasInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_samr_AliasInfoEnum(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryAliasInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_AliasInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetAliasInfo(struct ndr_push *ndr, int flags, const struct samr_SetAliasInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_CHECK(ndr_push_samr_AliasInfoEnum(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_samr_AliasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetAliasInfo(struct ndr_pull *ndr, int flags, struct samr_SetAliasInfo *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AliasInfoEnum(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_AliasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetAliasInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetAliasInfo *r)
{
	ndr_print_struct(ndr, name, "samr_SetAliasInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetAliasInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_samr_AliasInfoEnum(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_samr_AliasInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetAliasInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DeleteDomAlias(struct ndr_push *ndr, int flags, const struct samr_DeleteDomAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DeleteDomAlias(struct ndr_pull *ndr, int flags, struct samr_DeleteDomAlias *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		*r->out.alias_handle = *r->in.alias_handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DeleteDomAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_DeleteDomAlias *r)
{
	ndr_print_struct(ndr, name, "samr_DeleteDomAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_DeleteDomAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_DeleteDomAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->out.alias_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AddAliasMember(struct ndr_push *ndr, int flags, const struct samr_AddAliasMember *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AddAliasMember(struct ndr_pull *ndr, int flags, struct samr_AddAliasMember *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AddAliasMember(struct ndr_print *ndr, const char *name, int flags, const struct samr_AddAliasMember *r)
{
	ndr_print_struct(ndr, name, "samr_AddAliasMember");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_AddAliasMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_AddAliasMember");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DeleteAliasMember(struct ndr_push *ndr, int flags, const struct samr_DeleteAliasMember *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DeleteAliasMember(struct ndr_pull *ndr, int flags, struct samr_DeleteAliasMember *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DeleteAliasMember(struct ndr_print *ndr, const char *name, int flags, const struct samr_DeleteAliasMember *r)
{
	ndr_print_struct(ndr, name, "samr_DeleteAliasMember");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_DeleteAliasMember");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_DeleteAliasMember");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetMembersInAlias(struct ndr_push *ndr, int flags, const struct samr_GetMembersInAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetMembersInAlias(struct ndr_pull *ndr, int flags, struct samr_GetMembersInAlias *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetMembersInAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetMembersInAlias *r)
{
	ndr_print_struct(ndr, name, "samr_GetMembersInAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetMembersInAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetMembersInAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_OpenUser(struct ndr_push *ndr, int flags, const struct samr_OpenUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_UserAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
	}
	if (flags & NDR_OUT) {
		if (r->out.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_OpenUser(struct ndr_pull *ndr, int flags, struct samr_OpenUser *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_user_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
		NDR_PULL_ALLOC(ndr, r->out.user_handle);
		ZERO_STRUCTP(r->out.user_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_OpenUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_OpenUser *r)
{
	ndr_print_struct(ndr, name, "samr_OpenUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_OpenUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_UserAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_OpenUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->out.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->out.user_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_DeleteUser(struct ndr_push *ndr, int flags, const struct samr_DeleteUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_DeleteUser(struct ndr_pull *ndr, int flags, struct samr_DeleteUser *r)
{
	TALLOC_CTX *_mem_save_user_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.user_handle);
		*r->out.user_handle = *r->in.user_handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_DeleteUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_DeleteUser *r)
{
	ndr_print_struct(ndr, name, "samr_DeleteUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_DeleteUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_DeleteUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->out.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->out.user_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_QueryUserInfo(struct ndr_push *ndr, int flags, const struct samr_QueryUserInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_CHECK(ndr_push_samr_UserInfoLevel(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_QueryUserInfo(struct ndr_pull *ndr, int flags, struct samr_QueryUserInfo *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryUserInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryUserInfo *r)
{
	ndr_print_struct(ndr, name, "samr_QueryUserInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryUserInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr_print_samr_UserInfoLevel(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryUserInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_UserInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_SetUserInfo(struct ndr_push *ndr, int flags, const struct samr_SetUserInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_CHECK(ndr_push_samr_UserInfoLevel(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_SetUserInfo(struct ndr_pull *ndr, int flags, struct samr_SetUserInfo *r)
{
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetUserInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetUserInfo *r)
{
	ndr_print_struct(ndr, name, "samr_SetUserInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetUserInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr_print_samr_UserInfoLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_samr_UserInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetUserInfo");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ChangePasswordUser(struct ndr_push *ndr, int flags, const struct samr_ChangePasswordUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.lm_present));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_lm_crypted));
		if (r->in.old_lm_crypted) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.old_lm_crypted));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_lm_crypted));
		if (r->in.new_lm_crypted) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.new_lm_crypted));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.nt_present));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.old_nt_crypted));
		if (r->in.old_nt_crypted) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.old_nt_crypted));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.new_nt_crypted));
		if (r->in.new_nt_crypted) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.new_nt_crypted));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.cross1_present));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.nt_cross));
		if (r->in.nt_cross) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.nt_cross));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.cross2_present));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lm_cross));
		if (r->in.lm_cross) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.lm_cross));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ChangePasswordUser(struct ndr_pull *ndr, int flags, struct samr_ChangePasswordUser *r)
{
	uint32_t _ptr_old_lm_crypted;
	uint32_t _ptr_new_lm_crypted;
	uint32_t _ptr_old_nt_crypted;
	uint32_t _ptr_new_nt_crypted;
	uint32_t _ptr_nt_cross;
	uint32_t _ptr_lm_cross;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_old_lm_crypted_0;
	TALLOC_CTX *_mem_save_new_lm_crypted_0;
	TALLOC_CTX *_mem_save_old_nt_crypted_0;
	TALLOC_CTX *_mem_save_new_nt_crypted_0;
	TALLOC_CTX *_mem_save_nt_cross_0;
	TALLOC_CTX *_mem_save_lm_cross_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.lm_present));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_lm_crypted));
		if (_ptr_old_lm_crypted) {
			NDR_PULL_ALLOC(ndr, r->in.old_lm_crypted);
		} else {
			r->in.old_lm_crypted = NULL;
		}
		if (r->in.old_lm_crypted) {
			_mem_save_old_lm_crypted_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_lm_crypted, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.old_lm_crypted));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_lm_crypted_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_lm_crypted));
		if (_ptr_new_lm_crypted) {
			NDR_PULL_ALLOC(ndr, r->in.new_lm_crypted);
		} else {
			r->in.new_lm_crypted = NULL;
		}
		if (r->in.new_lm_crypted) {
			_mem_save_new_lm_crypted_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_lm_crypted, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.new_lm_crypted));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_lm_crypted_0, 0);
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.nt_present));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_old_nt_crypted));
		if (_ptr_old_nt_crypted) {
			NDR_PULL_ALLOC(ndr, r->in.old_nt_crypted);
		} else {
			r->in.old_nt_crypted = NULL;
		}
		if (r->in.old_nt_crypted) {
			_mem_save_old_nt_crypted_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.old_nt_crypted, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.old_nt_crypted));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_nt_crypted_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_new_nt_crypted));
		if (_ptr_new_nt_crypted) {
			NDR_PULL_ALLOC(ndr, r->in.new_nt_crypted);
		} else {
			r->in.new_nt_crypted = NULL;
		}
		if (r->in.new_nt_crypted) {
			_mem_save_new_nt_crypted_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.new_nt_crypted, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.new_nt_crypted));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_nt_crypted_0, 0);
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.cross1_present));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nt_cross));
		if (_ptr_nt_cross) {
			NDR_PULL_ALLOC(ndr, r->in.nt_cross);
		} else {
			r->in.nt_cross = NULL;
		}
		if (r->in.nt_cross) {
			_mem_save_nt_cross_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.nt_cross, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.nt_cross));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nt_cross_0, 0);
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.cross2_present));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lm_cross));
		if (_ptr_lm_cross) {
			NDR_PULL_ALLOC(ndr, r->in.lm_cross);
		} else {
			r->in.lm_cross = NULL;
		}
		if (r->in.lm_cross) {
			_mem_save_lm_cross_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lm_cross, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.lm_cross));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lm_cross_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ChangePasswordUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_ChangePasswordUser *r)
{
	ndr_print_struct(ndr, name, "samr_ChangePasswordUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_ChangePasswordUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr_print_uint8(ndr, "lm_present", r->in.lm_present);
		ndr_print_ptr(ndr, "old_lm_crypted", r->in.old_lm_crypted);
		ndr->depth++;
		if (r->in.old_lm_crypted) {
			ndr_print_samr_Password(ndr, "old_lm_crypted", r->in.old_lm_crypted);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_lm_crypted", r->in.new_lm_crypted);
		ndr->depth++;
		if (r->in.new_lm_crypted) {
			ndr_print_samr_Password(ndr, "new_lm_crypted", r->in.new_lm_crypted);
		}
		ndr->depth--;
		ndr_print_uint8(ndr, "nt_present", r->in.nt_present);
		ndr_print_ptr(ndr, "old_nt_crypted", r->in.old_nt_crypted);
		ndr->depth++;
		if (r->in.old_nt_crypted) {
			ndr_print_samr_Password(ndr, "old_nt_crypted", r->in.old_nt_crypted);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "new_nt_crypted", r->in.new_nt_crypted);
		ndr->depth++;
		if (r->in.new_nt_crypted) {
			ndr_print_samr_Password(ndr, "new_nt_crypted", r->in.new_nt_crypted);
		}
		ndr->depth--;
		ndr_print_uint8(ndr, "cross1_present", r->in.cross1_present);
		ndr_print_ptr(ndr, "nt_cross", r->in.nt_cross);
		ndr->depth++;
		if (r->in.nt_cross) {
			ndr_print_samr_Password(ndr, "nt_cross", r->in.nt_cross);
		}
		ndr->depth--;
		ndr_print_uint8(ndr, "cross2_present", r->in.cross2_present);
		ndr_print_ptr(ndr, "lm_cross", r->in.lm_cross);
		ndr->depth++;
		if (r->in.lm_cross) {
			ndr_print_samr_Password(ndr, "lm_cross", r->in.lm_cross);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_ChangePasswordUser");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetGroupsForUser(struct ndr_push *ndr, int flags, const struct samr_GetGroupsForUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.rids));
		if (*r->out.rids) {
			NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rids));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetGroupsForUser(struct ndr_pull *ndr, int flags, struct samr_GetGroupsForUser *r)
{
	uint32_t _ptr_rids;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_rids_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rids));
		if (_ptr_rids) {
			NDR_PULL_ALLOC(ndr, *r->out.rids);
		} else {
			*r->out.rids = NULL;
		}
		if (*r->out.rids) {
			_mem_save_rids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.rids, 0);
			NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rids));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetGroupsForUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetGroupsForUser *r)
{
	ndr_print_struct(ndr, name, "samr_GetGroupsForUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetGroupsForUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetGroupsForUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", *r->out.rids);
		ndr->depth++;
		if (*r->out.rids) {
			ndr_print_samr_RidWithAttributeArray(ndr, "rids", *r->out.rids);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryDisplayInfo(struct ndr_push *ndr, int flags, const struct samr_QueryDisplayInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start_idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_entries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.total_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_size));
		if (r->out.returned_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.returned_size));
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryDisplayInfo(struct ndr_pull *ndr, int flags, struct samr_QueryDisplayInfo *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_total_size_0;
	TALLOC_CTX *_mem_save_returned_size_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start_idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_entries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.total_size);
		ZERO_STRUCTP(r->out.total_size);
		NDR_PULL_ALLOC(ndr, r->out.returned_size);
		ZERO_STRUCTP(r->out.returned_size);
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_size);
		}
		_mem_save_total_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.returned_size);
		}
		_mem_save_returned_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.returned_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.returned_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_returned_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryDisplayInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryDisplayInfo *r)
{
	ndr_print_struct(ndr, name, "samr_QueryDisplayInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryDisplayInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "start_idx", r->in.start_idx);
		ndr_print_uint32(ndr, "max_entries", r->in.max_entries);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryDisplayInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "total_size", r->out.total_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_size", *r->out.total_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "returned_size", r->out.returned_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "returned_size", *r->out.returned_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_samr_DispInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetDisplayEnumerationIndex(struct ndr_push *ndr, int flags, const struct samr_GetDisplayEnumerationIndex *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
	}
	if (flags & NDR_OUT) {
		if (r->out.idx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.idx));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetDisplayEnumerationIndex(struct ndr_pull *ndr, int flags, struct samr_GetDisplayEnumerationIndex *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_idx_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.idx);
		ZERO_STRUCTP(r->out.idx);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.idx);
		}
		_mem_save_idx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.idx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.idx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_idx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetDisplayEnumerationIndex(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetDisplayEnumerationIndex *r)
{
	ndr_print_struct(ndr, name, "samr_GetDisplayEnumerationIndex");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetDisplayEnumerationIndex");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetDisplayEnumerationIndex");
		ndr->depth++;
		ndr_print_ptr(ndr, "idx", r->out.idx);
		ndr->depth++;
		ndr_print_uint32(ndr, "idx", *r->out.idx);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_TestPrivateFunctionsDomain(struct ndr_push *ndr, int flags, const struct samr_TestPrivateFunctionsDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_TestPrivateFunctionsDomain(struct ndr_pull *ndr, int flags, struct samr_TestPrivateFunctionsDomain *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_TestPrivateFunctionsDomain(struct ndr_print *ndr, const char *name, int flags, const struct samr_TestPrivateFunctionsDomain *r)
{
	ndr_print_struct(ndr, name, "samr_TestPrivateFunctionsDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_TestPrivateFunctionsDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_TestPrivateFunctionsDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_TestPrivateFunctionsUser(struct ndr_push *ndr, int flags, const struct samr_TestPrivateFunctionsUser *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_TestPrivateFunctionsUser(struct ndr_pull *ndr, int flags, struct samr_TestPrivateFunctionsUser *r)
{
	TALLOC_CTX *_mem_save_user_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_TestPrivateFunctionsUser(struct ndr_print *ndr, const char *name, int flags, const struct samr_TestPrivateFunctionsUser *r)
{
	ndr_print_struct(ndr, name, "samr_TestPrivateFunctionsUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_TestPrivateFunctionsUser");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_TestPrivateFunctionsUser");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_GetUserPwInfo(struct ndr_push *ndr, int flags, const struct samr_GetUserPwInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_PwInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_GetUserPwInfo(struct ndr_pull *ndr, int flags, struct samr_GetUserPwInfo *r)
{
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_PwInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetUserPwInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetUserPwInfo *r)
{
	ndr_print_struct(ndr, name, "samr_GetUserPwInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetUserPwInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetUserPwInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_samr_PwInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_RemoveMemberFromForeignDomain(struct ndr_push *ndr, int flags, const struct samr_RemoveMemberFromForeignDomain *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_RemoveMemberFromForeignDomain(struct ndr_pull *ndr, int flags, struct samr_RemoveMemberFromForeignDomain *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RemoveMemberFromForeignDomain(struct ndr_print *ndr, const char *name, int flags, const struct samr_RemoveMemberFromForeignDomain *r)
{
	ndr_print_struct(ndr, name, "samr_RemoveMemberFromForeignDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_RemoveMemberFromForeignDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid2(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_RemoveMemberFromForeignDomain");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryDomainInfo2(struct ndr_push *ndr, int flags, const struct samr_QueryDomainInfo2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_samr_DomainInfoClass(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryDomainInfo2(struct ndr_pull *ndr, int flags, struct samr_QueryDomainInfo2 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_DomainInfoClass(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryDomainInfo2(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryDomainInfo2 *r)
{
	ndr_print_struct(ndr, name, "samr_QueryDomainInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryDomainInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_samr_DomainInfoClass(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryDomainInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_DomainInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryUserInfo2(struct ndr_push *ndr, int flags, const struct samr_QueryUserInfo2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_CHECK(ndr_push_samr_UserInfoLevel(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_push_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryUserInfo2(struct ndr_pull *ndr, int flags, struct samr_QueryUserInfo2 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.info, r->in.level));
			NDR_CHECK(ndr_pull_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryUserInfo2(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryUserInfo2 *r)
{
	ndr_print_struct(ndr, name, "samr_QueryUserInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryUserInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr_print_samr_UserInfoLevel(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryUserInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_set_switch_value(ndr, *r->out.info, r->in.level);
			ndr_print_samr_UserInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryDisplayInfo2(struct ndr_push *ndr, int flags, const struct samr_QueryDisplayInfo2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start_idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_entries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.total_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_size));
		if (r->out.returned_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.returned_size));
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryDisplayInfo2(struct ndr_pull *ndr, int flags, struct samr_QueryDisplayInfo2 *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_total_size_0;
	TALLOC_CTX *_mem_save_returned_size_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start_idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_entries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.total_size);
		ZERO_STRUCTP(r->out.total_size);
		NDR_PULL_ALLOC(ndr, r->out.returned_size);
		ZERO_STRUCTP(r->out.returned_size);
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_size);
		}
		_mem_save_total_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.returned_size);
		}
		_mem_save_returned_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.returned_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.returned_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_returned_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryDisplayInfo2(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryDisplayInfo2 *r)
{
	ndr_print_struct(ndr, name, "samr_QueryDisplayInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryDisplayInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "start_idx", r->in.start_idx);
		ndr_print_uint32(ndr, "max_entries", r->in.max_entries);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryDisplayInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "total_size", r->out.total_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_size", *r->out.total_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "returned_size", r->out.returned_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "returned_size", *r->out.returned_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_samr_DispInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetDisplayEnumerationIndex2(struct ndr_push *ndr, int flags, const struct samr_GetDisplayEnumerationIndex2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
	}
	if (flags & NDR_OUT) {
		if (r->out.idx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.idx));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetDisplayEnumerationIndex2(struct ndr_pull *ndr, int flags, struct samr_GetDisplayEnumerationIndex2 *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_idx_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.idx);
		ZERO_STRUCTP(r->out.idx);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.idx);
		}
		_mem_save_idx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.idx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.idx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_idx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetDisplayEnumerationIndex2(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetDisplayEnumerationIndex2 *r)
{
	ndr_print_struct(ndr, name, "samr_GetDisplayEnumerationIndex2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetDisplayEnumerationIndex2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "name", r->in.name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetDisplayEnumerationIndex2");
		ndr->depth++;
		ndr_print_ptr(ndr, "idx", r->out.idx);
		ndr->depth++;
		ndr_print_uint32(ndr, "idx", *r->out.idx);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_CreateUser2(struct ndr_push *ndr, int flags, const struct samr_CreateUser2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->in.acct_flags));
		NDR_CHECK(ndr_push_samr_UserAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		if (r->out.access_granted == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.access_granted));
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_CreateUser2(struct ndr_pull *ndr, int flags, struct samr_CreateUser2 *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_account_name_0;
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_access_granted_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account_name);
		}
		_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->in.acct_flags));
		NDR_CHECK(ndr_pull_samr_UserAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.user_handle);
		ZERO_STRUCTP(r->out.user_handle);
		NDR_PULL_ALLOC(ndr, r->out.access_granted);
		ZERO_STRUCTP(r->out.access_granted);
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.access_granted);
		}
		_mem_save_access_granted_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.access_granted, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.access_granted));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_access_granted_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_CreateUser2(struct ndr_print *ndr, const char *name, int flags, const struct samr_CreateUser2 *r)
{
	ndr_print_struct(ndr, name, "samr_CreateUser2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_CreateUser2");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_samr_AcctFlags(ndr, "acct_flags", r->in.acct_flags);
		ndr_print_samr_UserAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_CreateUser2");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->out.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->out.user_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "access_granted", r->out.access_granted);
		ndr->depth++;
		ndr_print_uint32(ndr, "access_granted", *r->out.access_granted);
		ndr->depth--;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_QueryDisplayInfo3(struct ndr_push *ndr, int flags, const struct samr_QueryDisplayInfo3 *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start_idx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_entries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.total_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_size));
		if (r->out.returned_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.returned_size));
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_QueryDisplayInfo3(struct ndr_pull *ndr, int flags, struct samr_QueryDisplayInfo3 *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_total_size_0;
	TALLOC_CTX *_mem_save_returned_size_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start_idx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_entries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.total_size);
		ZERO_STRUCTP(r->out.total_size);
		NDR_PULL_ALLOC(ndr, r->out.returned_size);
		ZERO_STRUCTP(r->out.returned_size);
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_size);
		}
		_mem_save_total_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.returned_size);
		}
		_mem_save_returned_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.returned_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.returned_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_returned_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_DispInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_QueryDisplayInfo3(struct ndr_print *ndr, const char *name, int flags, const struct samr_QueryDisplayInfo3 *r)
{
	ndr_print_struct(ndr, name, "samr_QueryDisplayInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_QueryDisplayInfo3");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "start_idx", r->in.start_idx);
		ndr_print_uint32(ndr, "max_entries", r->in.max_entries);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_QueryDisplayInfo3");
		ndr->depth++;
		ndr_print_ptr(ndr, "total_size", r->out.total_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_size", *r->out.total_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "returned_size", r->out.returned_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "returned_size", *r->out.returned_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_samr_DispInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_AddMultipleMembersToAlias(struct ndr_push *ndr, int flags, const struct samr_AddMultipleMembersToAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_AddMultipleMembersToAlias(struct ndr_pull *ndr, int flags, struct samr_AddMultipleMembersToAlias *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_AddMultipleMembersToAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_AddMultipleMembersToAlias *r)
{
	ndr_print_struct(ndr, name, "samr_AddMultipleMembersToAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_AddMultipleMembersToAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_AddMultipleMembersToAlias");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_RemoveMultipleMembersFromAlias(struct ndr_push *ndr, int flags, const struct samr_RemoveMultipleMembersFromAlias *r)
{
	if (flags & NDR_IN) {
		if (r->in.alias_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_RemoveMultipleMembersFromAlias(struct ndr_pull *ndr, int flags, struct samr_RemoveMultipleMembersFromAlias *r)
{
	TALLOC_CTX *_mem_save_alias_handle_0;
	TALLOC_CTX *_mem_save_sids_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.alias_handle);
		}
		_mem_save_alias_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.alias_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.alias_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RemoveMultipleMembersFromAlias(struct ndr_print *ndr, const char *name, int flags, const struct samr_RemoveMultipleMembersFromAlias *r)
{
	ndr_print_struct(ndr, name, "samr_RemoveMultipleMembersFromAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_RemoveMultipleMembersFromAlias");
		ndr->depth++;
		ndr_print_ptr(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "alias_handle", r->in.alias_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_RemoveMultipleMembersFromAlias");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_OemChangePasswordUser2(struct ndr_push *ndr, int flags, const struct samr_OemChangePasswordUser2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_lsa_AsciiString(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
		}
		if (r->in.account == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_AsciiString(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.password));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.hash));
		if (r->in.hash) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.hash));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_OemChangePasswordUser2(struct ndr_pull *ndr, int flags, struct samr_OemChangePasswordUser2 *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_password;
	uint32_t _ptr_hash;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_account_0;
	TALLOC_CTX *_mem_save_password_0;
	TALLOC_CTX *_mem_save_hash_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_lsa_AsciiString(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account);
		}
		_mem_save_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_AsciiString(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hash));
		if (_ptr_hash) {
			NDR_PULL_ALLOC(ndr, r->in.hash);
		} else {
			r->in.hash = NULL;
		}
		if (r->in.hash) {
			_mem_save_hash_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.hash, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.hash));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hash_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_OemChangePasswordUser2(struct ndr_print *ndr, const char *name, int flags, const struct samr_OemChangePasswordUser2 *r)
{
	ndr_print_struct(ndr, name, "samr_OemChangePasswordUser2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_OemChangePasswordUser2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_lsa_AsciiString(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		ndr_print_lsa_AsciiString(ndr, "account", r->in.account);
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_samr_CryptPassword(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "hash", r->in.hash);
		ndr->depth++;
		if (r->in.hash) {
			ndr_print_samr_Password(ndr, "hash", r->in.hash);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_OemChangePasswordUser2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ChangePasswordUser2(struct ndr_push *ndr, int flags, const struct samr_ChangePasswordUser2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
		}
		if (r->in.account == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.nt_password));
		if (r->in.nt_password) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.nt_password));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.nt_verifier));
		if (r->in.nt_verifier) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.nt_verifier));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.lm_change));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lm_password));
		if (r->in.lm_password) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.lm_password));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lm_verifier));
		if (r->in.lm_verifier) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.lm_verifier));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ChangePasswordUser2(struct ndr_pull *ndr, int flags, struct samr_ChangePasswordUser2 *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_nt_password;
	uint32_t _ptr_nt_verifier;
	uint32_t _ptr_lm_password;
	uint32_t _ptr_lm_verifier;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_account_0;
	TALLOC_CTX *_mem_save_nt_password_0;
	TALLOC_CTX *_mem_save_nt_verifier_0;
	TALLOC_CTX *_mem_save_lm_password_0;
	TALLOC_CTX *_mem_save_lm_verifier_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account);
		}
		_mem_save_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nt_password));
		if (_ptr_nt_password) {
			NDR_PULL_ALLOC(ndr, r->in.nt_password);
		} else {
			r->in.nt_password = NULL;
		}
		if (r->in.nt_password) {
			_mem_save_nt_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.nt_password, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.nt_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nt_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nt_verifier));
		if (_ptr_nt_verifier) {
			NDR_PULL_ALLOC(ndr, r->in.nt_verifier);
		} else {
			r->in.nt_verifier = NULL;
		}
		if (r->in.nt_verifier) {
			_mem_save_nt_verifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.nt_verifier, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.nt_verifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nt_verifier_0, 0);
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.lm_change));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lm_password));
		if (_ptr_lm_password) {
			NDR_PULL_ALLOC(ndr, r->in.lm_password);
		} else {
			r->in.lm_password = NULL;
		}
		if (r->in.lm_password) {
			_mem_save_lm_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lm_password, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.lm_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lm_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lm_verifier));
		if (_ptr_lm_verifier) {
			NDR_PULL_ALLOC(ndr, r->in.lm_verifier);
		} else {
			r->in.lm_verifier = NULL;
		}
		if (r->in.lm_verifier) {
			_mem_save_lm_verifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lm_verifier, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.lm_verifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lm_verifier_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ChangePasswordUser2(struct ndr_print *ndr, const char *name, int flags, const struct samr_ChangePasswordUser2 *r)
{
	ndr_print_struct(ndr, name, "samr_ChangePasswordUser2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_ChangePasswordUser2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_lsa_String(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "account", r->in.account);
		ndr->depth--;
		ndr_print_ptr(ndr, "nt_password", r->in.nt_password);
		ndr->depth++;
		if (r->in.nt_password) {
			ndr_print_samr_CryptPassword(ndr, "nt_password", r->in.nt_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "nt_verifier", r->in.nt_verifier);
		ndr->depth++;
		if (r->in.nt_verifier) {
			ndr_print_samr_Password(ndr, "nt_verifier", r->in.nt_verifier);
		}
		ndr->depth--;
		ndr_print_uint8(ndr, "lm_change", r->in.lm_change);
		ndr_print_ptr(ndr, "lm_password", r->in.lm_password);
		ndr->depth++;
		if (r->in.lm_password) {
			ndr_print_samr_CryptPassword(ndr, "lm_password", r->in.lm_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lm_verifier", r->in.lm_verifier);
		ndr->depth++;
		if (r->in.lm_verifier) {
			ndr_print_samr_Password(ndr, "lm_verifier", r->in.lm_verifier);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_ChangePasswordUser2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetDomPwInfo(struct ndr_push *ndr, int flags, const struct samr_GetDomPwInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_name));
		if (r->in.domain_name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_name));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_PwInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetDomPwInfo(struct ndr_pull *ndr, int flags, struct samr_GetDomPwInfo *r)
{
	uint32_t _ptr_domain_name;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		} else {
			r->in.domain_name = NULL;
		}
		if (r->in.domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_PwInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetDomPwInfo(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetDomPwInfo *r)
{
	ndr_print_struct(ndr, name, "samr_GetDomPwInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetDomPwInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_lsa_String(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetDomPwInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_samr_PwInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_Connect2(struct ndr_push *ndr, int flags, const struct samr_Connect2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_samr_ConnectAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Connect2(struct ndr_pull *ndr, int flags, struct samr_Connect2 *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_ConnectAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		ZERO_STRUCTP(r->out.connect_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Connect2(struct ndr_print *ndr, const char *name, int flags, const struct samr_Connect2 *r)
{
	ndr_print_struct(ndr, name, "samr_Connect2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Connect2");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_samr_ConnectAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Connect2");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_SetUserInfo2(struct ndr_push *ndr, int flags, const struct samr_SetUserInfo2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.user_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_CHECK(ndr_push_samr_UserInfoLevel(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_SetUserInfo2(struct ndr_pull *ndr, int flags, struct samr_SetUserInfo2 *r)
{
	TALLOC_CTX *_mem_save_user_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.user_handle);
		}
		_mem_save_user_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.user_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.user_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_UserInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_samr_UserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetUserInfo2(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetUserInfo2 *r)
{
	ndr_print_struct(ndr, name, "samr_SetUserInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetUserInfo2");
		ndr->depth++;
		ndr_print_ptr(ndr, "user_handle", r->in.user_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "user_handle", r->in.user_handle);
		ndr->depth--;
		ndr_print_samr_UserInfoLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_samr_UserInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetUserInfo2");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetBootKeyInformation(struct ndr_push *ndr, int flags, const struct samr_SetBootKeyInformation *r)
{
	if (flags & NDR_IN) {
		if (r->in.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown3));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetBootKeyInformation(struct ndr_pull *ndr, int flags, struct samr_SetBootKeyInformation *r)
{
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown3));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetBootKeyInformation(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetBootKeyInformation *r)
{
	ndr_print_struct(ndr, name, "samr_SetBootKeyInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetBootKeyInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->in.connect_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr_print_uint32(ndr, "unknown3", r->in.unknown3);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetBootKeyInformation");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_GetBootKeyInformation(struct ndr_push *ndr, int flags, const struct samr_GetBootKeyInformation *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.unknown == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.unknown));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_GetBootKeyInformation(struct ndr_pull *ndr, int flags, struct samr_GetBootKeyInformation *r)
{
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_unknown_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.unknown);
		ZERO_STRUCTP(r->out.unknown);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.unknown);
		}
		_mem_save_unknown_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.unknown));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_GetBootKeyInformation(struct ndr_print *ndr, const char *name, int flags, const struct samr_GetBootKeyInformation *r)
{
	ndr_print_struct(ndr, name, "samr_GetBootKeyInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_GetBootKeyInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_GetBootKeyInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown", r->out.unknown);
		ndr->depth++;
		ndr_print_uint32(ndr, "unknown", *r->out.unknown);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_Connect3(struct ndr_push *ndr, int flags, const struct samr_Connect3 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_samr_ConnectAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Connect3(struct ndr_pull *ndr, int flags, struct samr_Connect3 *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_samr_ConnectAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		ZERO_STRUCTP(r->out.connect_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Connect3(struct ndr_print *ndr, const char *name, int flags, const struct samr_Connect3 *r)
{
	ndr_print_struct(ndr, name, "samr_Connect3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Connect3");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_samr_ConnectAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Connect3");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_Connect4(struct ndr_push *ndr, int flags, const struct samr_Connect4 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_samr_ConnectVersion(ndr, NDR_SCALARS, r->in.client_version));
		NDR_CHECK(ndr_push_samr_ConnectAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_Connect4(struct ndr_pull *ndr, int flags, struct samr_Connect4 *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_ConnectVersion(ndr, NDR_SCALARS, &r->in.client_version));
		NDR_CHECK(ndr_pull_samr_ConnectAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		ZERO_STRUCTP(r->out.connect_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Connect4(struct ndr_print *ndr, const char *name, int flags, const struct samr_Connect4 *r)
{
	ndr_print_struct(ndr, name, "samr_Connect4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Connect4");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_samr_ConnectVersion(ndr, "client_version", r->in.client_version);
		ndr_print_samr_ConnectAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Connect4");
		ndr->depth++;
		ndr_print_ptr(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_ChangePasswordUser3(struct ndr_push *ndr, int flags, const struct samr_ChangePasswordUser3 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
		}
		if (r->in.account == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.nt_password));
		if (r->in.nt_password) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.nt_password));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.nt_verifier));
		if (r->in.nt_verifier) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.nt_verifier));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.lm_change));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lm_password));
		if (r->in.lm_password) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.lm_password));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lm_verifier));
		if (r->in.lm_verifier) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.lm_verifier));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password3));
		if (r->in.password3) {
			NDR_CHECK(ndr_push_samr_CryptPassword(ndr, NDR_SCALARS, r->in.password3));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.dominfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dominfo));
		if (*r->out.dominfo) {
			NDR_CHECK(ndr_push_samr_DomInfo1(ndr, NDR_SCALARS, *r->out.dominfo));
		}
		if (r->out.reject == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.reject));
		if (*r->out.reject) {
			NDR_CHECK(ndr_push_userPwdChangeFailureInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.reject));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_ChangePasswordUser3(struct ndr_pull *ndr, int flags, struct samr_ChangePasswordUser3 *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_nt_password;
	uint32_t _ptr_nt_verifier;
	uint32_t _ptr_lm_password;
	uint32_t _ptr_lm_verifier;
	uint32_t _ptr_password3;
	uint32_t _ptr_dominfo;
	uint32_t _ptr_reject;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_account_0;
	TALLOC_CTX *_mem_save_nt_password_0;
	TALLOC_CTX *_mem_save_nt_verifier_0;
	TALLOC_CTX *_mem_save_lm_password_0;
	TALLOC_CTX *_mem_save_lm_verifier_0;
	TALLOC_CTX *_mem_save_password3_0;
	TALLOC_CTX *_mem_save_dominfo_0;
	TALLOC_CTX *_mem_save_dominfo_1;
	TALLOC_CTX *_mem_save_reject_0;
	TALLOC_CTX *_mem_save_reject_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.server));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.account);
		}
		_mem_save_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.account, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.account));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nt_password));
		if (_ptr_nt_password) {
			NDR_PULL_ALLOC(ndr, r->in.nt_password);
		} else {
			r->in.nt_password = NULL;
		}
		if (r->in.nt_password) {
			_mem_save_nt_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.nt_password, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.nt_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nt_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nt_verifier));
		if (_ptr_nt_verifier) {
			NDR_PULL_ALLOC(ndr, r->in.nt_verifier);
		} else {
			r->in.nt_verifier = NULL;
		}
		if (r->in.nt_verifier) {
			_mem_save_nt_verifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.nt_verifier, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.nt_verifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nt_verifier_0, 0);
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.lm_change));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lm_password));
		if (_ptr_lm_password) {
			NDR_PULL_ALLOC(ndr, r->in.lm_password);
		} else {
			r->in.lm_password = NULL;
		}
		if (r->in.lm_password) {
			_mem_save_lm_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lm_password, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.lm_password));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lm_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lm_verifier));
		if (_ptr_lm_verifier) {
			NDR_PULL_ALLOC(ndr, r->in.lm_verifier);
		} else {
			r->in.lm_verifier = NULL;
		}
		if (r->in.lm_verifier) {
			_mem_save_lm_verifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lm_verifier, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.lm_verifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lm_verifier_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password3));
		if (_ptr_password3) {
			NDR_PULL_ALLOC(ndr, r->in.password3);
		} else {
			r->in.password3 = NULL;
		}
		if (r->in.password3) {
			_mem_save_password3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password3, 0);
			NDR_CHECK(ndr_pull_samr_CryptPassword(ndr, NDR_SCALARS, r->in.password3));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password3_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.dominfo);
		ZERO_STRUCTP(r->out.dominfo);
		NDR_PULL_ALLOC(ndr, r->out.reject);
		ZERO_STRUCTP(r->out.reject);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dominfo);
		}
		_mem_save_dominfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dominfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dominfo));
		if (_ptr_dominfo) {
			NDR_PULL_ALLOC(ndr, *r->out.dominfo);
		} else {
			*r->out.dominfo = NULL;
		}
		if (*r->out.dominfo) {
			_mem_save_dominfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dominfo, 0);
			NDR_CHECK(ndr_pull_samr_DomInfo1(ndr, NDR_SCALARS, *r->out.dominfo));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dominfo_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dominfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.reject);
		}
		_mem_save_reject_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.reject, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_reject));
		if (_ptr_reject) {
			NDR_PULL_ALLOC(ndr, *r->out.reject);
		} else {
			*r->out.reject = NULL;
		}
		if (*r->out.reject) {
			_mem_save_reject_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.reject, 0);
			NDR_CHECK(ndr_pull_userPwdChangeFailureInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.reject));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reject_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reject_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ChangePasswordUser3(struct ndr_print *ndr, const char *name, int flags, const struct samr_ChangePasswordUser3 *r)
{
	ndr_print_struct(ndr, name, "samr_ChangePasswordUser3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_ChangePasswordUser3");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_lsa_String(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "account", r->in.account);
		ndr->depth--;
		ndr_print_ptr(ndr, "nt_password", r->in.nt_password);
		ndr->depth++;
		if (r->in.nt_password) {
			ndr_print_samr_CryptPassword(ndr, "nt_password", r->in.nt_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "nt_verifier", r->in.nt_verifier);
		ndr->depth++;
		if (r->in.nt_verifier) {
			ndr_print_samr_Password(ndr, "nt_verifier", r->in.nt_verifier);
		}
		ndr->depth--;
		ndr_print_uint8(ndr, "lm_change", r->in.lm_change);
		ndr_print_ptr(ndr, "lm_password", r->in.lm_password);
		ndr->depth++;
		if (r->in.lm_password) {
			ndr_print_samr_CryptPassword(ndr, "lm_password", r->in.lm_password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lm_verifier", r->in.lm_verifier);
		ndr->depth++;
		if (r->in.lm_verifier) {
			ndr_print_samr_Password(ndr, "lm_verifier", r->in.lm_verifier);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password3", r->in.password3);
		ndr->depth++;
		if (r->in.password3) {
			ndr_print_samr_CryptPassword(ndr, "password3", r->in.password3);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_ChangePasswordUser3");
		ndr->depth++;
		ndr_print_ptr(ndr, "dominfo", r->out.dominfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "dominfo", *r->out.dominfo);
		ndr->depth++;
		if (*r->out.dominfo) {
			ndr_print_samr_DomInfo1(ndr, "dominfo", *r->out.dominfo);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "reject", r->out.reject);
		ndr->depth++;
		ndr_print_ptr(ndr, "reject", *r->out.reject);
		ndr->depth++;
		if (*r->out.reject) {
			ndr_print_userPwdChangeFailureInformation(ndr, "reject", *r->out.reject);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_samr_Connect5(struct ndr_push *ndr, int flags, const struct samr_Connect5 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.system_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.system_name, ndr_charset_length(r->in.system_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_samr_ConnectAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level_in));
		if (r->in.info_in == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info_in, r->in.level_in));
		NDR_CHECK(ndr_push_samr_ConnectInfo(ndr, NDR_SCALARS, r->in.info_in));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		if (r->out.info_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info_out, *r->out.level_out));
		NDR_CHECK(ndr_push_samr_ConnectInfo(ndr, NDR_SCALARS, r->out.info_out));
		if (r->out.connect_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_samr_Connect5(struct ndr_pull *ndr, int flags, struct samr_Connect5 *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_info_in_0;
	TALLOC_CTX *_mem_save_level_out_0;
	TALLOC_CTX *_mem_save_info_out_0;
	TALLOC_CTX *_mem_save_connect_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.system_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.system_name));
			if (ndr_get_array_length(ndr, &r->in.system_name) > ndr_get_array_size(ndr, &r->in.system_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.system_name), ndr_get_array_length(ndr, &r->in.system_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.system_name, ndr_get_array_length(ndr, &r->in.system_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_ConnectAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level_in));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_in);
		}
		_mem_save_info_in_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_in, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info_in, r->in.level_in));
		NDR_CHECK(ndr_pull_samr_ConnectInfo(ndr, NDR_SCALARS, r->in.info_in));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_in_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.info_out);
		ZERO_STRUCTP(r->out.info_out);
		NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		ZERO_STRUCTP(r->out.connect_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_out);
		}
		_mem_save_info_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info_out, *r->out.level_out));
		NDR_CHECK(ndr_pull_samr_ConnectInfo(ndr, NDR_SCALARS, r->out.info_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.connect_handle);
		}
		_mem_save_connect_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.connect_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.connect_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connect_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_Connect5(struct ndr_print *ndr, const char *name, int flags, const struct samr_Connect5 *r)
{
	ndr_print_struct(ndr, name, "samr_Connect5");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_Connect5");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_string(ndr, "system_name", r->in.system_name);
		}
		ndr->depth--;
		ndr_print_samr_ConnectAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "level_in", r->in.level_in);
		ndr_print_ptr(ndr, "info_in", r->in.info_in);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info_in, r->in.level_in);
		ndr_print_samr_ConnectInfo(ndr, "info_in", r->in.info_in);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_Connect5");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "info_out", r->out.info_out);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info_out, *r->out.level_out);
		ndr_print_samr_ConnectInfo(ndr, "info_out", r->out.info_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "connect_handle", r->out.connect_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_RidToSid(struct ndr_push *ndr, int flags, const struct samr_RidToSid *r)
{
	if (flags & NDR_IN) {
		if (r->in.domain_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rid));
	}
	if (flags & NDR_OUT) {
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.sid));
		if (*r->out.sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sid));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_RidToSid(struct ndr_pull *ndr, int flags, struct samr_RidToSid *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_domain_handle_0;
	TALLOC_CTX *_mem_save_sid_0;
	TALLOC_CTX *_mem_save_sid_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_handle);
		}
		_mem_save_domain_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.domain_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rid));
		NDR_PULL_ALLOC(ndr, r->out.sid);
		ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, *r->out.sid);
		} else {
			*r->out.sid = NULL;
		}
		if (*r->out.sid) {
			_mem_save_sid_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_RidToSid(struct ndr_print *ndr, const char *name, int flags, const struct samr_RidToSid *r)
{
	ndr_print_struct(ndr, name, "samr_RidToSid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_RidToSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "domain_handle", r->in.domain_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "rid", r->in.rid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_RidToSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", *r->out.sid);
		ndr->depth++;
		if (*r->out.sid) {
			ndr_print_dom_sid2(ndr, "sid", *r->out.sid);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_SetDsrmPassword(struct ndr_push *ndr, int flags, const struct samr_SetDsrmPassword *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.name));
		if (r->in.name) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.hash));
		if (r->in.hash) {
			NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.hash));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_SetDsrmPassword(struct ndr_pull *ndr, int flags, struct samr_SetDsrmPassword *r)
{
	uint32_t _ptr_name;
	uint32_t _ptr_hash;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_hash_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		} else {
			r->in.name = NULL;
		}
		if (r->in.name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.name, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hash));
		if (_ptr_hash) {
			NDR_PULL_ALLOC(ndr, r->in.hash);
		} else {
			r->in.hash = NULL;
		}
		if (r->in.hash) {
			_mem_save_hash_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.hash, 0);
			NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.hash));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hash_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_SetDsrmPassword(struct ndr_print *ndr, const char *name, int flags, const struct samr_SetDsrmPassword *r)
{
	ndr_print_struct(ndr, name, "samr_SetDsrmPassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_SetDsrmPassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		if (r->in.name) {
			ndr_print_lsa_String(ndr, "name", r->in.name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_ptr(ndr, "hash", r->in.hash);
		ndr->depth++;
		if (r->in.hash) {
			ndr_print_samr_Password(ndr, "hash", r->in.hash);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_SetDsrmPassword");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_samr_ValidatePassword(struct ndr_push *ndr, int flags, const struct samr_ValidatePassword *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_samr_ValidatePasswordLevel(ndr, NDR_SCALARS, r->in.level));
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_samr_ValidatePasswordReq(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.rep == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.rep));
		if (*r->out.rep) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, *r->out.rep, r->in.level));
			NDR_CHECK(ndr_push_samr_ValidatePasswordRep(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rep));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_samr_ValidatePassword(struct ndr_pull *ndr, int flags, struct samr_ValidatePassword *r)
{
	uint32_t _ptr_rep;
	TALLOC_CTX *_mem_save_req_0;
	TALLOC_CTX *_mem_save_rep_0;
	TALLOC_CTX *_mem_save_rep_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_samr_ValidatePasswordLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_samr_ValidatePasswordReq(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rep);
		ZERO_STRUCTP(r->out.rep);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rep);
		}
		_mem_save_rep_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rep, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rep));
		if (_ptr_rep) {
			NDR_PULL_ALLOC(ndr, *r->out.rep);
		} else {
			*r->out.rep = NULL;
		}
		if (*r->out.rep) {
			_mem_save_rep_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.rep, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, *r->out.rep, r->in.level));
			NDR_CHECK(ndr_pull_samr_ValidatePasswordRep(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.rep));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rep_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rep_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_samr_ValidatePassword(struct ndr_print *ndr, const char *name, int flags, const struct samr_ValidatePassword *r)
{
	ndr_print_struct(ndr, name, "samr_ValidatePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "samr_ValidatePassword");
		ndr->depth++;
		ndr_print_samr_ValidatePasswordLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_samr_ValidatePasswordReq(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "samr_ValidatePassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "rep", r->out.rep);
		ndr->depth++;
		ndr_print_ptr(ndr, "rep", *r->out.rep);
		ndr->depth++;
		if (*r->out.rep) {
			ndr_print_set_switch_value(ndr, *r->out.rep, r->in.level);
			ndr_print_samr_ValidatePasswordRep(ndr, "rep", *r->out.rep);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call samr_calls[] = {
	{
		"samr_Connect",
		sizeof(struct samr_Connect),
		(ndr_push_flags_fn_t) ndr_push_samr_Connect,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Connect,
		(ndr_print_function_t) ndr_print_samr_Connect,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Close",
		sizeof(struct samr_Close),
		(ndr_push_flags_fn_t) ndr_push_samr_Close,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Close,
		(ndr_print_function_t) ndr_print_samr_Close,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetSecurity",
		sizeof(struct samr_SetSecurity),
		(ndr_push_flags_fn_t) ndr_push_samr_SetSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetSecurity,
		(ndr_print_function_t) ndr_print_samr_SetSecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QuerySecurity",
		sizeof(struct samr_QuerySecurity),
		(ndr_push_flags_fn_t) ndr_push_samr_QuerySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QuerySecurity,
		(ndr_print_function_t) ndr_print_samr_QuerySecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Shutdown",
		sizeof(struct samr_Shutdown),
		(ndr_push_flags_fn_t) ndr_push_samr_Shutdown,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Shutdown,
		(ndr_print_function_t) ndr_print_samr_Shutdown,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_LookupDomain",
		sizeof(struct samr_LookupDomain),
		(ndr_push_flags_fn_t) ndr_push_samr_LookupDomain,
		(ndr_pull_flags_fn_t) ndr_pull_samr_LookupDomain,
		(ndr_print_function_t) ndr_print_samr_LookupDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_EnumDomains",
		sizeof(struct samr_EnumDomains),
		(ndr_push_flags_fn_t) ndr_push_samr_EnumDomains,
		(ndr_pull_flags_fn_t) ndr_pull_samr_EnumDomains,
		(ndr_print_function_t) ndr_print_samr_EnumDomains,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_OpenDomain",
		sizeof(struct samr_OpenDomain),
		(ndr_push_flags_fn_t) ndr_push_samr_OpenDomain,
		(ndr_pull_flags_fn_t) ndr_pull_samr_OpenDomain,
		(ndr_print_function_t) ndr_print_samr_OpenDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryDomainInfo",
		sizeof(struct samr_QueryDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryDomainInfo,
		(ndr_print_function_t) ndr_print_samr_QueryDomainInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetDomainInfo",
		sizeof(struct samr_SetDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_SetDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetDomainInfo,
		(ndr_print_function_t) ndr_print_samr_SetDomainInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_CreateDomainGroup",
		sizeof(struct samr_CreateDomainGroup),
		(ndr_push_flags_fn_t) ndr_push_samr_CreateDomainGroup,
		(ndr_pull_flags_fn_t) ndr_pull_samr_CreateDomainGroup,
		(ndr_print_function_t) ndr_print_samr_CreateDomainGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_EnumDomainGroups",
		sizeof(struct samr_EnumDomainGroups),
		(ndr_push_flags_fn_t) ndr_push_samr_EnumDomainGroups,
		(ndr_pull_flags_fn_t) ndr_pull_samr_EnumDomainGroups,
		(ndr_print_function_t) ndr_print_samr_EnumDomainGroups,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_CreateUser",
		sizeof(struct samr_CreateUser),
		(ndr_push_flags_fn_t) ndr_push_samr_CreateUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_CreateUser,
		(ndr_print_function_t) ndr_print_samr_CreateUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_EnumDomainUsers",
		sizeof(struct samr_EnumDomainUsers),
		(ndr_push_flags_fn_t) ndr_push_samr_EnumDomainUsers,
		(ndr_pull_flags_fn_t) ndr_pull_samr_EnumDomainUsers,
		(ndr_print_function_t) ndr_print_samr_EnumDomainUsers,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_CreateDomAlias",
		sizeof(struct samr_CreateDomAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_CreateDomAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_CreateDomAlias,
		(ndr_print_function_t) ndr_print_samr_CreateDomAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_EnumDomainAliases",
		sizeof(struct samr_EnumDomainAliases),
		(ndr_push_flags_fn_t) ndr_push_samr_EnumDomainAliases,
		(ndr_pull_flags_fn_t) ndr_pull_samr_EnumDomainAliases,
		(ndr_print_function_t) ndr_print_samr_EnumDomainAliases,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetAliasMembership",
		sizeof(struct samr_GetAliasMembership),
		(ndr_push_flags_fn_t) ndr_push_samr_GetAliasMembership,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetAliasMembership,
		(ndr_print_function_t) ndr_print_samr_GetAliasMembership,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_LookupNames",
		sizeof(struct samr_LookupNames),
		(ndr_push_flags_fn_t) ndr_push_samr_LookupNames,
		(ndr_pull_flags_fn_t) ndr_pull_samr_LookupNames,
		(ndr_print_function_t) ndr_print_samr_LookupNames,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_LookupRids",
		sizeof(struct samr_LookupRids),
		(ndr_push_flags_fn_t) ndr_push_samr_LookupRids,
		(ndr_pull_flags_fn_t) ndr_pull_samr_LookupRids,
		(ndr_print_function_t) ndr_print_samr_LookupRids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_OpenGroup",
		sizeof(struct samr_OpenGroup),
		(ndr_push_flags_fn_t) ndr_push_samr_OpenGroup,
		(ndr_pull_flags_fn_t) ndr_pull_samr_OpenGroup,
		(ndr_print_function_t) ndr_print_samr_OpenGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryGroupInfo",
		sizeof(struct samr_QueryGroupInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryGroupInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryGroupInfo,
		(ndr_print_function_t) ndr_print_samr_QueryGroupInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetGroupInfo",
		sizeof(struct samr_SetGroupInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_SetGroupInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetGroupInfo,
		(ndr_print_function_t) ndr_print_samr_SetGroupInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_AddGroupMember",
		sizeof(struct samr_AddGroupMember),
		(ndr_push_flags_fn_t) ndr_push_samr_AddGroupMember,
		(ndr_pull_flags_fn_t) ndr_pull_samr_AddGroupMember,
		(ndr_print_function_t) ndr_print_samr_AddGroupMember,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_DeleteDomainGroup",
		sizeof(struct samr_DeleteDomainGroup),
		(ndr_push_flags_fn_t) ndr_push_samr_DeleteDomainGroup,
		(ndr_pull_flags_fn_t) ndr_pull_samr_DeleteDomainGroup,
		(ndr_print_function_t) ndr_print_samr_DeleteDomainGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_DeleteGroupMember",
		sizeof(struct samr_DeleteGroupMember),
		(ndr_push_flags_fn_t) ndr_push_samr_DeleteGroupMember,
		(ndr_pull_flags_fn_t) ndr_pull_samr_DeleteGroupMember,
		(ndr_print_function_t) ndr_print_samr_DeleteGroupMember,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryGroupMember",
		sizeof(struct samr_QueryGroupMember),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryGroupMember,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryGroupMember,
		(ndr_print_function_t) ndr_print_samr_QueryGroupMember,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetMemberAttributesOfGroup",
		sizeof(struct samr_SetMemberAttributesOfGroup),
		(ndr_push_flags_fn_t) ndr_push_samr_SetMemberAttributesOfGroup,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetMemberAttributesOfGroup,
		(ndr_print_function_t) ndr_print_samr_SetMemberAttributesOfGroup,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_OpenAlias",
		sizeof(struct samr_OpenAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_OpenAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_OpenAlias,
		(ndr_print_function_t) ndr_print_samr_OpenAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryAliasInfo",
		sizeof(struct samr_QueryAliasInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryAliasInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryAliasInfo,
		(ndr_print_function_t) ndr_print_samr_QueryAliasInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetAliasInfo",
		sizeof(struct samr_SetAliasInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_SetAliasInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetAliasInfo,
		(ndr_print_function_t) ndr_print_samr_SetAliasInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_DeleteDomAlias",
		sizeof(struct samr_DeleteDomAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_DeleteDomAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_DeleteDomAlias,
		(ndr_print_function_t) ndr_print_samr_DeleteDomAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_AddAliasMember",
		sizeof(struct samr_AddAliasMember),
		(ndr_push_flags_fn_t) ndr_push_samr_AddAliasMember,
		(ndr_pull_flags_fn_t) ndr_pull_samr_AddAliasMember,
		(ndr_print_function_t) ndr_print_samr_AddAliasMember,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_DeleteAliasMember",
		sizeof(struct samr_DeleteAliasMember),
		(ndr_push_flags_fn_t) ndr_push_samr_DeleteAliasMember,
		(ndr_pull_flags_fn_t) ndr_pull_samr_DeleteAliasMember,
		(ndr_print_function_t) ndr_print_samr_DeleteAliasMember,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetMembersInAlias",
		sizeof(struct samr_GetMembersInAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_GetMembersInAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetMembersInAlias,
		(ndr_print_function_t) ndr_print_samr_GetMembersInAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_OpenUser",
		sizeof(struct samr_OpenUser),
		(ndr_push_flags_fn_t) ndr_push_samr_OpenUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_OpenUser,
		(ndr_print_function_t) ndr_print_samr_OpenUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_DeleteUser",
		sizeof(struct samr_DeleteUser),
		(ndr_push_flags_fn_t) ndr_push_samr_DeleteUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_DeleteUser,
		(ndr_print_function_t) ndr_print_samr_DeleteUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryUserInfo",
		sizeof(struct samr_QueryUserInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryUserInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryUserInfo,
		(ndr_print_function_t) ndr_print_samr_QueryUserInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetUserInfo",
		sizeof(struct samr_SetUserInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_SetUserInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetUserInfo,
		(ndr_print_function_t) ndr_print_samr_SetUserInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_ChangePasswordUser",
		sizeof(struct samr_ChangePasswordUser),
		(ndr_push_flags_fn_t) ndr_push_samr_ChangePasswordUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_ChangePasswordUser,
		(ndr_print_function_t) ndr_print_samr_ChangePasswordUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetGroupsForUser",
		sizeof(struct samr_GetGroupsForUser),
		(ndr_push_flags_fn_t) ndr_push_samr_GetGroupsForUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetGroupsForUser,
		(ndr_print_function_t) ndr_print_samr_GetGroupsForUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryDisplayInfo",
		sizeof(struct samr_QueryDisplayInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryDisplayInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryDisplayInfo,
		(ndr_print_function_t) ndr_print_samr_QueryDisplayInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetDisplayEnumerationIndex",
		sizeof(struct samr_GetDisplayEnumerationIndex),
		(ndr_push_flags_fn_t) ndr_push_samr_GetDisplayEnumerationIndex,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetDisplayEnumerationIndex,
		(ndr_print_function_t) ndr_print_samr_GetDisplayEnumerationIndex,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_TestPrivateFunctionsDomain",
		sizeof(struct samr_TestPrivateFunctionsDomain),
		(ndr_push_flags_fn_t) ndr_push_samr_TestPrivateFunctionsDomain,
		(ndr_pull_flags_fn_t) ndr_pull_samr_TestPrivateFunctionsDomain,
		(ndr_print_function_t) ndr_print_samr_TestPrivateFunctionsDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_TestPrivateFunctionsUser",
		sizeof(struct samr_TestPrivateFunctionsUser),
		(ndr_push_flags_fn_t) ndr_push_samr_TestPrivateFunctionsUser,
		(ndr_pull_flags_fn_t) ndr_pull_samr_TestPrivateFunctionsUser,
		(ndr_print_function_t) ndr_print_samr_TestPrivateFunctionsUser,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetUserPwInfo",
		sizeof(struct samr_GetUserPwInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_GetUserPwInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetUserPwInfo,
		(ndr_print_function_t) ndr_print_samr_GetUserPwInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_RemoveMemberFromForeignDomain",
		sizeof(struct samr_RemoveMemberFromForeignDomain),
		(ndr_push_flags_fn_t) ndr_push_samr_RemoveMemberFromForeignDomain,
		(ndr_pull_flags_fn_t) ndr_pull_samr_RemoveMemberFromForeignDomain,
		(ndr_print_function_t) ndr_print_samr_RemoveMemberFromForeignDomain,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryDomainInfo2",
		sizeof(struct samr_QueryDomainInfo2),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryDomainInfo2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryDomainInfo2,
		(ndr_print_function_t) ndr_print_samr_QueryDomainInfo2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryUserInfo2",
		sizeof(struct samr_QueryUserInfo2),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryUserInfo2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryUserInfo2,
		(ndr_print_function_t) ndr_print_samr_QueryUserInfo2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryDisplayInfo2",
		sizeof(struct samr_QueryDisplayInfo2),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryDisplayInfo2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryDisplayInfo2,
		(ndr_print_function_t) ndr_print_samr_QueryDisplayInfo2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetDisplayEnumerationIndex2",
		sizeof(struct samr_GetDisplayEnumerationIndex2),
		(ndr_push_flags_fn_t) ndr_push_samr_GetDisplayEnumerationIndex2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetDisplayEnumerationIndex2,
		(ndr_print_function_t) ndr_print_samr_GetDisplayEnumerationIndex2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_CreateUser2",
		sizeof(struct samr_CreateUser2),
		(ndr_push_flags_fn_t) ndr_push_samr_CreateUser2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_CreateUser2,
		(ndr_print_function_t) ndr_print_samr_CreateUser2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_QueryDisplayInfo3",
		sizeof(struct samr_QueryDisplayInfo3),
		(ndr_push_flags_fn_t) ndr_push_samr_QueryDisplayInfo3,
		(ndr_pull_flags_fn_t) ndr_pull_samr_QueryDisplayInfo3,
		(ndr_print_function_t) ndr_print_samr_QueryDisplayInfo3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_AddMultipleMembersToAlias",
		sizeof(struct samr_AddMultipleMembersToAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_AddMultipleMembersToAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_AddMultipleMembersToAlias,
		(ndr_print_function_t) ndr_print_samr_AddMultipleMembersToAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_RemoveMultipleMembersFromAlias",
		sizeof(struct samr_RemoveMultipleMembersFromAlias),
		(ndr_push_flags_fn_t) ndr_push_samr_RemoveMultipleMembersFromAlias,
		(ndr_pull_flags_fn_t) ndr_pull_samr_RemoveMultipleMembersFromAlias,
		(ndr_print_function_t) ndr_print_samr_RemoveMultipleMembersFromAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_OemChangePasswordUser2",
		sizeof(struct samr_OemChangePasswordUser2),
		(ndr_push_flags_fn_t) ndr_push_samr_OemChangePasswordUser2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_OemChangePasswordUser2,
		(ndr_print_function_t) ndr_print_samr_OemChangePasswordUser2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_ChangePasswordUser2",
		sizeof(struct samr_ChangePasswordUser2),
		(ndr_push_flags_fn_t) ndr_push_samr_ChangePasswordUser2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_ChangePasswordUser2,
		(ndr_print_function_t) ndr_print_samr_ChangePasswordUser2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetDomPwInfo",
		sizeof(struct samr_GetDomPwInfo),
		(ndr_push_flags_fn_t) ndr_push_samr_GetDomPwInfo,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetDomPwInfo,
		(ndr_print_function_t) ndr_print_samr_GetDomPwInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Connect2",
		sizeof(struct samr_Connect2),
		(ndr_push_flags_fn_t) ndr_push_samr_Connect2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Connect2,
		(ndr_print_function_t) ndr_print_samr_Connect2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetUserInfo2",
		sizeof(struct samr_SetUserInfo2),
		(ndr_push_flags_fn_t) ndr_push_samr_SetUserInfo2,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetUserInfo2,
		(ndr_print_function_t) ndr_print_samr_SetUserInfo2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetBootKeyInformation",
		sizeof(struct samr_SetBootKeyInformation),
		(ndr_push_flags_fn_t) ndr_push_samr_SetBootKeyInformation,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetBootKeyInformation,
		(ndr_print_function_t) ndr_print_samr_SetBootKeyInformation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_GetBootKeyInformation",
		sizeof(struct samr_GetBootKeyInformation),
		(ndr_push_flags_fn_t) ndr_push_samr_GetBootKeyInformation,
		(ndr_pull_flags_fn_t) ndr_pull_samr_GetBootKeyInformation,
		(ndr_print_function_t) ndr_print_samr_GetBootKeyInformation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Connect3",
		sizeof(struct samr_Connect3),
		(ndr_push_flags_fn_t) ndr_push_samr_Connect3,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Connect3,
		(ndr_print_function_t) ndr_print_samr_Connect3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Connect4",
		sizeof(struct samr_Connect4),
		(ndr_push_flags_fn_t) ndr_push_samr_Connect4,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Connect4,
		(ndr_print_function_t) ndr_print_samr_Connect4,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_ChangePasswordUser3",
		sizeof(struct samr_ChangePasswordUser3),
		(ndr_push_flags_fn_t) ndr_push_samr_ChangePasswordUser3,
		(ndr_pull_flags_fn_t) ndr_pull_samr_ChangePasswordUser3,
		(ndr_print_function_t) ndr_print_samr_ChangePasswordUser3,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_Connect5",
		sizeof(struct samr_Connect5),
		(ndr_push_flags_fn_t) ndr_push_samr_Connect5,
		(ndr_pull_flags_fn_t) ndr_pull_samr_Connect5,
		(ndr_print_function_t) ndr_print_samr_Connect5,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_RidToSid",
		sizeof(struct samr_RidToSid),
		(ndr_push_flags_fn_t) ndr_push_samr_RidToSid,
		(ndr_pull_flags_fn_t) ndr_pull_samr_RidToSid,
		(ndr_print_function_t) ndr_print_samr_RidToSid,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_SetDsrmPassword",
		sizeof(struct samr_SetDsrmPassword),
		(ndr_push_flags_fn_t) ndr_push_samr_SetDsrmPassword,
		(ndr_pull_flags_fn_t) ndr_pull_samr_SetDsrmPassword,
		(ndr_print_function_t) ndr_print_samr_SetDsrmPassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"samr_ValidatePassword",
		sizeof(struct samr_ValidatePassword),
		(ndr_push_flags_fn_t) ndr_push_samr_ValidatePassword,
		(ndr_pull_flags_fn_t) ndr_pull_samr_ValidatePassword,
		(ndr_print_function_t) ndr_print_samr_ValidatePassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const samr_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\samr]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array samr_endpoints = {
	.count	= 3,
	.names	= samr_endpoint_strings
};

static const char * const samr_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array samr_authservices = {
	.count	= 1,
	.names	= samr_authservice_strings
};


const struct ndr_interface_table ndr_table_samr = {
	.name		= "samr",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xac}},
		NDR_SAMR_VERSION
	},
	.helpstring	= NDR_SAMR_HELPSTRING,
	.num_calls	= 68,
	.calls		= samr_calls,
	.endpoints	= &samr_endpoints,
	.authservices	= &samr_authservices
};

