/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019, Mellanox Technologies. All rights reserved.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef __RSHIM_REGS_H__
#define __RSHIM_REGS_H__

#ifdef __ASSEMBLER__
#define _64bit(x) x
#else /* __ASSEMBLER__ */
#define _64bit(x) x ## ULL
#endif /* __ASSEMBLER */

#include <linux/types.h>

#define RSH_BOOT_FIFO_DATA 0x0408

#define RSH_BOOT_FIFO_COUNT 0x0488
#define RSH_BOOT_FIFO_COUNT__LENGTH 0x0001

#define RSH_BOOT_FIFO_COUNT__BOOT_FIFO_COUNT_SHIFT 0
#define RSH_BOOT_FIFO_COUNT__BOOT_FIFO_COUNT_WIDTH 10
#define RSH_BOOT_FIFO_COUNT__BOOT_FIFO_COUNT_RESET_VAL 0
#define RSH_BOOT_FIFO_COUNT__BOOT_FIFO_COUNT_RMASK 0x3ff
#define RSH_BOOT_FIFO_COUNT__BOOT_FIFO_COUNT_MASK  0x3ff

#define RSH_BOOT_CONTROL 0x0528
#define RSH_BOOT_CONTROL__LENGTH 0x0001

#define RSH_BOOT_CONTROL__BOOT_MODE_SHIFT 0
#define RSH_BOOT_CONTROL__BOOT_MODE_WIDTH 2
#define RSH_BOOT_CONTROL__BOOT_MODE_RMASK 0x3
#define RSH_BOOT_CONTROL__BOOT_MODE_MASK  0x3
#define RSH_BOOT_CONTROL__BOOT_MODE_VAL_NONE 0x0
#define RSH_BOOT_CONTROL__BOOT_MODE_VAL_EMMC 0x1
#define RSH_BOOT_CONTROL__BOOT_MODE_VAL_RSVD 0x2
#define RSH_BOOT_CONTROL__BOOT_MODE_VAL_EMMC_LEGACY 0x3

#define RSH_RESET_CONTROL 0x0500
#define RSH_RESET_CONTROL__LENGTH 0x0001

#define RSH_RESET_CONTROL__RESET_CHIP_SHIFT 0
#define RSH_RESET_CONTROL__RESET_CHIP_WIDTH 32
#define RSH_RESET_CONTROL__RESET_CHIP_RESET_VAL 0
#define RSH_RESET_CONTROL__RESET_CHIP_RMASK 0xffffffff
#define RSH_RESET_CONTROL__RESET_CHIP_MASK  0xffffffff
#define RSH_RESET_CONTROL__RESET_CHIP_VAL_KEY 0xca710001

#define RSH_RESET_CONTROL__DISABLE_SHIFT 32
#define RSH_RESET_CONTROL__DISABLE_WIDTH 1
#define RSH_RESET_CONTROL__DISABLE_RESET_VAL 0
#define RSH_RESET_CONTROL__DISABLE_RMASK 0x1
#define RSH_RESET_CONTROL__DISABLE_MASK  _64bit(0x100000000)

#define RSH_RESET_CONTROL__REQ_PND_SHIFT 33
#define RSH_RESET_CONTROL__REQ_PND_WIDTH 1
#define RSH_RESET_CONTROL__REQ_PND_RESET_VAL 0
#define RSH_RESET_CONTROL__REQ_PND_RMASK 0x1
#define RSH_RESET_CONTROL__REQ_PND_MASK  _64bit(0x200000000)

#define RSH_SCRATCHPAD1 0x0c20

#define RSH_SCRATCH_BUF_CTL 0x0600

#define RSH_SCRATCH_BUF_DAT 0x0610

#define RSH_SEMAPHORE0 0x0028

#define RSH_SCRATCHPAD 0x0020

#define RSH_TM_HOST_TO_TILE_CTL 0x0a30
#define RSH_TM_HOST_TO_TILE_CTL__LENGTH 0x0001

#define RSH_TM_HOST_TO_TILE_CTL__LWM_SHIFT 0
#define RSH_TM_HOST_TO_TILE_CTL__LWM_WIDTH 8
#define RSH_TM_HOST_TO_TILE_CTL__LWM_RESET_VAL 128
#define RSH_TM_HOST_TO_TILE_CTL__LWM_RMASK 0xff
#define RSH_TM_HOST_TO_TILE_CTL__LWM_MASK  0xff

#define RSH_TM_HOST_TO_TILE_CTL__HWM_SHIFT 8
#define RSH_TM_HOST_TO_TILE_CTL__HWM_WIDTH 8
#define RSH_TM_HOST_TO_TILE_CTL__HWM_RESET_VAL 128
#define RSH_TM_HOST_TO_TILE_CTL__HWM_RMASK 0xff
#define RSH_TM_HOST_TO_TILE_CTL__HWM_MASK  0xff00

#define RSH_TM_HOST_TO_TILE_CTL__MAX_ENTRIES_SHIFT 32
#define RSH_TM_HOST_TO_TILE_CTL__MAX_ENTRIES_WIDTH 9
#define RSH_TM_HOST_TO_TILE_CTL__MAX_ENTRIES_RESET_VAL 256
#define RSH_TM_HOST_TO_TILE_CTL__MAX_ENTRIES_RMASK 0x1ff
#define RSH_TM_HOST_TO_TILE_CTL__MAX_ENTRIES_MASK  _64bit(0x1ff00000000)

#define RSH_TM_HOST_TO_TILE_STS 0x0a28
#define RSH_TM_HOST_TO_TILE_STS__LENGTH 0x0001

#define RSH_TM_HOST_TO_TILE_STS__COUNT_SHIFT 0
#define RSH_TM_HOST_TO_TILE_STS__COUNT_WIDTH 9
#define RSH_TM_HOST_TO_TILE_STS__COUNT_RESET_VAL 0
#define RSH_TM_HOST_TO_TILE_STS__COUNT_RMASK 0x1ff
#define RSH_TM_HOST_TO_TILE_STS__COUNT_MASK  0x1ff

#define RSH_TM_TILE_TO_HOST_STS 0x0a48
#define RSH_TM_TILE_TO_HOST_STS__LENGTH 0x0001

#define RSH_TM_TILE_TO_HOST_STS__COUNT_SHIFT 0
#define RSH_TM_TILE_TO_HOST_STS__COUNT_WIDTH 9
#define RSH_TM_TILE_TO_HOST_STS__COUNT_RESET_VAL 0
#define RSH_TM_TILE_TO_HOST_STS__COUNT_RMASK 0x1ff
#define RSH_TM_TILE_TO_HOST_STS__COUNT_MASK  0x1ff

#define RSH_TM_HOST_TO_TILE_DATA 0x0a20

#define RSH_TM_TILE_TO_HOST_DATA 0x0a40

#define RSH_MMIO_ADDRESS_SPACE__LAST_WORD 0xfffffffff8
#define RSH_MMIO_ADDRESS_SPACE__LENGTH 0x10000000000
#define RSH_MMIO_ADDRESS_SPACE__STRIDE 0x0008

#define RSH_MMIO_ADDRESS_SPACE__OFFSET_SHIFT 0
#define RSH_MMIO_ADDRESS_SPACE__OFFSET_WIDTH 16
#define RSH_MMIO_ADDRESS_SPACE__OFFSET_RESET_VAL 0
#define RSH_MMIO_ADDRESS_SPACE__OFFSET_RMASK 0xffff
#define RSH_MMIO_ADDRESS_SPACE__OFFSET_MASK  0xffff

#define RSH_MMIO_ADDRESS_SPACE__PROT_SHIFT 16
#define RSH_MMIO_ADDRESS_SPACE__PROT_WIDTH 3
#define RSH_MMIO_ADDRESS_SPACE__PROT_RESET_VAL 0
#define RSH_MMIO_ADDRESS_SPACE__PROT_RMASK 0x7
#define RSH_MMIO_ADDRESS_SPACE__PROT_MASK  0x70000

#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_SHIFT 23
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_WIDTH 4
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_RESET_VAL 0
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_RMASK 0xf
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_MASK  0x7800000
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_BOOT 0x0
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_RSHIM 0x1
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_UART0 0x2
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_UART1 0x3
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_DIAG_UART 0x4
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_YU 0x5
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_OOB 0x6
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_OOB_LLU 0x7
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_OOB_PLU 0x8
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_TIMER 0x9
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_USB 0xa
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_RSVD0 0xb
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_MMC 0xc
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_TIMER_EXT 0xd
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_WDOG_NS 0xe
#define RSH_MMIO_ADDRESS_SPACE__CHANNEL_VAL_WDOG_SEC 0xf

#define RSH_SWINT 0x0318

#define RSH_BYTE_ACC_CTL 0x0490

#define RSH_BYTE_ACC_WDAT 0x0498

#define RSH_BYTE_ACC_RDAT 0x04a0

#define RSH_BYTE_ACC_ADDR 0x04a8

#endif /* !defined(__RSHIM_REGS_H__) */
