// Author: Bertrand Bellenot   22/08/02

/*************************************************************************
 * Copyright (C) 1995-2002, Bertrand Bellenot.                           *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see the LICENSE file.                         *
 *************************************************************************/

#ifndef ROOTSHOWERHELPTEXT_H
#include "RSHelpText.h"
#endif

const char gPhysicsHelpText[] =
"\n                    Some physics recalls...\n\n"
"Radiation length:\n"
"High-energy electrons predominantly lose energy in matter by\n"
"bremsstrahlung, and high-energy photons by e + e - pair production.\n"
"The characteristic amount of matter traversed for these related\n"
"interactions is called the radiation length X 0, usually measured\n"
"in g cm - 2 . It is the mean distance over which a high-energy\n"
"electron loses all but 1/e of its energy by bremsstrahlung, and\n"
"the e-folding distance for pair production by a high-energy photon\n"
"is 97 X0. It is also the appropriate scale length for describing\n"
"high-energy electromagnetic cascades.\n"
"\n"
"Electromagnetic cascades:\n"
"When a high-energy electron or photon is incident on a thick absorber,\n"
"it initiates an electromagnetic cascade as pair production and\n"
"bremsstrahlung generate more electrons and photons with lower energy.\n"
"The longitudinal development is governed by the high-energy part of\n"
"the cascade, and therefore scales as the radiation length in the\n"
"material. Electron energies eventually fall below the critical energy,\n"
"and then dissipate their energy by ionization and excitation rather\n"
"than by the generation of more shower particles.\n"
"\n"
"Energy loss by electrons:\n"
"At low energies electrons and positrons primarily lose energy by\n"
"ionization, although other processes (Moller scattering, Bhabha\n"
"scattering, e + annihilation) contribute. \n"
"While ionization loss rates rise logarithmically with energy,\n"
"bremsstrahlung losses rise nearly linearly (fractional loss is\n"
"nearly independent of energy), and dominates above a few tens of\n"
"MeV in most materials Ionization loss by electrons and positrons\n"
"differs from loss by heavy particles because of the kinematics, spin,\n"
"and the identity of the incident electron with the electrons which\n"
"it ionizes.\n"
"\n"
"Muon energy loss at high energy:\n"
"At sufficiently high energies, radiative processes become more\n"
"important than ionization for all charged particles. For muons\n"
"and pions in materials such as iron, this 'critical energy' occurs\n"
"at several hundred GeV. Radiative effects dominate the energy loss\n"
"of energetic muons found in cosmic rays or produced at the newest\n"
"accelerators.\n"
"These processes are characterized by small cross sections, hard\n"
"spectra, large energy fluctuations, and the associated generation\n"
"of electromagnetic and (in the case of photonuclear interactions)\n"
"hadronic showers. As a consequence, at these energies the treatment\n"
"of energy loss as a uniform and continuous process is for many\n"
"purposes inadequate.\n";

const char gSimulationHelpText[] =
"\n                     How to use this software...\n\n"
"Choose Parameters into the menu Event to access to the parameters\n"
"setting dialog.\n"
"Into this dialog, you have access to all settable parameters of\n"
"the simulation :\n"
"    Particle :\n"
"        You can choose the primary particle with its decay:\n"
"           Photon     \n"
"           Electron   \n"
"           Positron   \n"
"           Muon-      \n"
"           Muon+      \n"
"           Tau-       \n"
"           Tau+       \n"
"           Pion0      \n"
"           Pion+      \n"
"           Pion-      \n"
"           Eta        \n"
"           Kaon+      \n"
"           Kaon-      \n"
"           Kaon Long  \n"
"           Kaon Short \n"
"           Rho0       \n"
"           Rho+       \n"
"           Rho-       \n"
"           Omega      \n"
"           Phi        \n"
"           J/Psi      \n"
"           W+         \n"
"           W-         \n"
"           Z0         \n"
"    Primary particle parameters :\n"
"        Primary particle's Energy (in GeV)\n"
"        Magnetic field (in kGauss)\n"
"Then you can start a simulation by pressing the button 'Start Simulation'\n"
"The cascade will be drawn into the first main tab ('Event Display'),\n"
"and the particles list will appear into the tree view at left. Into this\n"
"tree view, you can follow the cascade tree and on the particle branch,\n"
"a tooltip will indicate the particle energy (E0).\n"
"The track color corresponds to the particle energy, from red (highest \n"
"enery) to blue (lowest Energy). Note that photons and neutrinos tracks \n"
"are not shown.\n"
"The status bar on the bottom of the main frame indicates the simulation\n"
"status :\n"
"     Waiting to start simulation \n"
"     Done - Total particles : xxx - Waiting for next simulation \n"
"You can access informations on current event by selecting Infos into the\n"
"Event menu.\n"
"Select 3D View into this same menu to have a 3D view of the event into\n"
"a new OpenGL window. It is also possible to do this with the context menu\n"
"(by clicking with the right button).\n"
"It is possible to isolate a particle track by selecting the particle into\n"
"tree view at the left, then by clicking the 'Show Selection' button. This\n"
"will show the selected particle track into the tab 'Selected Track'.\n";

const char gRSHelpMsgBox[] =
"\nIt appears that you have changed some parameters. These include :\n"
"   - Primary Particle\n"
"   - Initial Energy\n"
"   - Magnetic Field\n"
" \"Yes\" button - save resources into file ${HOME}/.rootshowerrc, and quit\n"
" \"No\"  button - quit without saving\n";

const char gSettingsHelp[] =
"\n                  Help on Parameters Setting\n\n"
"Into this dialog, you have access to every settable parameters\n"
"of the simulation :\n"
"    Particle\n"
"        Choose the primary particle with its decay:\n"
"           Photon     \n"
"           Electron   \n"
"           Positron   \n"
"           Muon-      \n"
"           Muon+      \n"
"           Tau-       \n"
"           Tau+       \n"
"           Pion0      \n"
"           Pion+      \n"
"           Pion-      \n"
"           Eta        \n"
"           Kaon+      \n"
"           Kaon-      \n"
"           Kaon Long  \n"
"           Kaon Short \n"
"           Rho0       \n"
"           Rho+       \n"
"           Rho-       \n"
"           Omega      \n"
"           Phi        \n"
"           J/Psi      \n"
"           W+         \n"
"           W-         \n"
"           Z0         \n"
"    E0/B\n"
"        Set the magnetic field (in kGauss)\n"
"        and the primary particle's Energy (in MeV)";

const char gHelpLicense[] =
"\n"
"               RootShower Software Terms and Conditions\n"
"\n"
"The author hereby grant permission to use, copy, and distribute this\n"
"software and its documentation for any purpose, provided that existing\n"
"copyright notices are retained in all copies and that this notice is\n"
"included verbatim in any distributions. Additionally, the author grant\n"
"permission to modify this software and its documentation for any purpose,\n"
"provided that such modifications are not distributed without the explicit\n"
"consent of the author and that existing copyright notices are retained in\n"
"all copies. Users of the software are asked to feed back problems, benefits,\n"
"and/or suggestions about the software to the author (bellbert@pcsalo.cern.ch).\n"
"Support for this software - fixing of bugs, incorporation of new features - \n"
"is done on a best effort basis. All bug fixes and enhancements will be made\n"
"available under the same terms and conditions as the original software,\n"
"\n"
"\n"
"IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR\n"
"DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT\n"
"OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,\n"
"EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
"\n"
"THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,\n"
"INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,\n"
"FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS\n"
"PROVIDED ON AN \"AS IS\" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAVE NO\n"
"OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR\n"
"MODIFICATIONS.";
