/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "CMPC_QCPMain.h"
#include "CMPC_QCPDef.h"

/**************************************************************************************************
* Function Name : wxBitmapDialog                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxBitmapDialog::wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title)
: wxDialog(parent, id, title, wxDefaultPosition, wxSize(QCP_UI_WIDTH, QCP_UI_HEIGHT), 0
                  | wxFRAME_SHAPED
                  | wxSIMPLE_BORDER
                  | wxFRAME_NO_TASKBAR
                  | wxSTAY_ON_TOP),
  m_bitmap(bitmap)
{
    Init();
}

/**************************************************************************************************
* Function Name : wxBitmapDialog                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxBitmapDialog::wxBitmapDialog(wxBitmap& bitmap, wxWindow* parent, const wxString& title)
: wxDialog(parent, -1, title, wxDefaultPosition, wxDefaultSize, wxNO_BORDER),
  m_bitmap(bitmap)
{
    Init();
}

/**************************************************************************************************
* Function Name : ~wxBitmapDialog                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxBitmapDialog::~wxBitmapDialog()
{

}

BEGIN_EVENT_TABLE(wxBitmapDialog, wxDialog)

EVT_PAINT(wxBitmapDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(wxBitmapDialog::OnWindowCreate)
#endif
END_EVENT_TABLE()

/**************************************************************************************************
* Function Name : Init                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void wxBitmapDialog::Init()
{
    m_hasShape = FALSE;
    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));
#ifndef __WXGTK__
    SetWindowShape();
#endif
}

/**************************************************************************************************
* Function Name : OnEraseBkgnd                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void wxBitmapDialog::OnEraseBkgnd(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if (pDC)
    {
        if (m_bitmap.Ok())
        {
            pDC->DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if (m_bitmap.Ok())
        {
            dc.DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
}

/**************************************************************************************************
* Function Name : OnPaint                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void wxBitmapDialog::OnPaint(wxPaintEvent& WXUNUSED(event))
 {
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);
}

/**************************************************************************************************
* Function Name : SetWindowShape                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void wxBitmapDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

/**************************************************************************************************
* Function Name : OnWindowCreate                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void wxBitmapDialog::OnWindowCreate(wxWindowCreateEvent& evt)
{
    SetWindowShape();
}
