/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLImageElement.h"

#include <wtf/GetPtr.h>

#include "HTMLImageElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLImageElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "hspace", JSHTMLImageElement::HspaceAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[26] },
    { 0, 0, 0, 0, 0 },
    { "align", JSHTMLImageElement::AlignAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[19] },
    { "src", JSHTMLImageElement::SrcAttrNum, DontDelete, 0, 0 },
    { "useMap", JSHTMLImageElement::UseMapAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "complete", JSHTMLImageElement::CompleteAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "lowsrc", JSHTMLImageElement::LowsrcAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[25] },
    { 0, 0, 0, 0, 0 },
    { "alt", JSHTMLImageElement::AltAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[21] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "name", JSHTMLImageElement::NameAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[20] },
    { 0, 0, 0, 0, 0 },
    { "y", JSHTMLImageElement::YAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "isMap", JSHTMLImageElement::IsMapAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[22] },
    { "vspace", JSHTMLImageElement::VspaceAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "border", JSHTMLImageElement::BorderAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[24] },
    { "height", JSHTMLImageElement::HeightAttrNum, DontDelete, 0, 0 },
    { "longDesc", JSHTMLImageElement::LongDescAttrNum, DontDelete, 0, 0 },
    { "width", JSHTMLImageElement::WidthAttrNum, DontDelete, 0, &JSHTMLImageElementTableEntries[23] },
    { "naturalHeight", JSHTMLImageElement::NaturalHeightAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "naturalWidth", JSHTMLImageElement::NaturalWidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "x", JSHTMLImageElement::XAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSHTMLImageElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLImageElementTable = 
{
    2, 27, JSHTMLImageElementTableEntries, 19
};

/* Hash table for constructor */

static const HashEntry JSHTMLImageElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementConstructorTable = 
{
    2, 1, JSHTMLImageElementConstructorTableEntries, 1
};

class JSHTMLImageElementConstructor : public DOMObject {
public:
    JSHTMLImageElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLImageElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLImageElementConstructor::info = { "HTMLImageElementConstructor", 0, &JSHTMLImageElementConstructorTable, 0 };

bool JSHTMLImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElementConstructor, DOMObject>(exec, &JSHTMLImageElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLImageElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementPrototypeTable = 
{
    2, 1, JSHTMLImageElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLImageElementPrototype::info = { "HTMLImageElementPrototype", 0, &JSHTMLImageElementPrototypeTable, 0 };

JSObject* JSHTMLImageElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLImageElementPrototype>(exec, "[[JSHTMLImageElement.prototype]]");
}

const ClassInfo JSHTMLImageElement::info = { "HTMLImageElement", &JSHTMLElement::info, &JSHTMLImageElementTable, 0 };

JSHTMLImageElement::JSHTMLImageElement(ExecState* exec, HTMLImageElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLImageElementPrototype::self(exec));
}

bool JSHTMLImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElement, JSHTMLElement>(exec, &JSHTMLImageElementTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->name());
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->align());
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->alt());
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->border());
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->height());
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->hspace());
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsBoolean(imp->isMap());
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->longDesc());
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->src());
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->useMap());
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->vspace());
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->width());
    }
    case CompleteAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsBoolean(imp->complete());
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsString(imp->lowsrc());
    }
    case NaturalHeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->naturalHeight());
    }
    case NaturalWidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->naturalWidth());
    }
    case XAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->x());
    }
    case YAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        return jsNumber(imp->y());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLImageElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLImageElementTable, this);
}

void JSHTMLImageElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setHeight(value->toInt32(exec));
        break;
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setHspace(value->toInt32(exec));
        break;
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setIsMap(value->toBoolean(exec));
        break;
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setLongDesc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setUseMap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setVspace(value->toInt32(exec));
        break;
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setWidth(value->toInt32(exec));
        break;
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());

        imp->setLowsrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLImageElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLImageElementConstructor>(exec, "[[HTMLImageElement.constructor]]");
}

}
