#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import etk
import base

__all__ = ("ThrobberWidget", "EtkThrobber", "EdjeThrobber")


class ThrobberWidget(base.EdjeWidget):
    GREY, WHITE = xrange(2)

    def __init__(self, parent, theme, type=GREY):
        group = "throbber_grey"
        if type == ThrobberWidget.WHITE:
            group = "throbber_white"

        base.EdjeWidget.__init__(self, parent.evas, group, parent, theme)

    def start(self):
        self.signal_emit("throbber,start", "")

    def stop(self):
        self.signal_emit("throbber,stop", "")


class EtkThrobber(etk.core.Widget):
    def __init__(self, text="", **kargs):
        etk.core.Widget.__init__(self, **kargs)
        self.theme_group_set("throbber")
        self.on_realized(self._realize)
        self._text = text
        self._started = False
        self.callback_animate_hide_finished = None
        self._callback_connected = False

    def text_get(self):
        return self._text

    def text_set(self, text):
        self._text = text
        self.theme_part_text_set("etk.text.label", text)

    text = property(text_get, text_set)

    def start(self):
        if self.realized:
            self.theme_signal_emit("throbber,start", False)

        self._started = True

    def stop(self):
        self.theme_signal_emit("throbber,stop", False)
        self._started = False

    def _realize(self, obj, **kargs):
        self.text_set(self._text)

        if self._started:
            self.start()

        if not self._callback_connected:
            self._callback_connected = True
            self.smart_object.signal_callback_add("throbber,animate,hide,finished", "",
                                                  self._cb_on_animate_hide_finished)

        return True

    def _cb_on_animate_hide_finished(self, *ignored):
        if self.callback_animate_hide_finished:
            self.callback_animate_hide_finished()


class EdjeThrobber(base.EdjeWidget):

    def __init__(self, parent, theme, text="", **kargs):
        group = "edje_throbber"
        base.EdjeWidget.__init__(self, parent.evas, group, parent, theme)
        self.text_set(text)
        self._started = False
        self.callback_animate_hide_finished = None
        self.signal_callback_add("throbber,animate,hide,finished", "",
                                 self._cb_on_animate_hide_finished)

    def text_get(self):
        return self._text

    def text_set(self, text):
        self._text = text
        self.part_text_set("text.label", text)

    text = property(text_get, text_set)

    def start(self):
        self.signal_emit("throbber,start", "")
        self._started = True

    def stop(self):
        self.signal_emit("throbber,stop", "")
        self._started = False

    def _cb_on_animate_hide_finished(self, *ignored):
        if self.callback_animate_hide_finished:
            self.callback_animate_hide_finished()
