#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from ConfigParser import ConfigParser


class TerraConfig(object):
    def __init__(self, config_file):
        self.config_file = config_file
        self._load()

    def _load(self):
        cfg = ConfigParser()
        cfg.optionxform = str
        cfg.readfp(open(self.config_file))

        if not cfg.has_section("terra"):
            raise ValueError("Terra config file without 'terra' section")

        for attr_name, attr_value in cfg.items("terra"):
            setattr(self, attr_name, attr_value)
