#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

__all__ = ("Singleton",)


class SingletonMeta(type):
    def __init__(cls, name, bases, dict_):
        type.__init__(cls, name, bases, dict_)
        cls._instance = None
        cls.__copy__ = lambda self: self
        cls.__deepcopy__ = lambda self, memo=None: self

    def __call__(cls, *args, **kargs):
        if not cls._instance:
            cls._instance = type.__call__(cls, *args, **kargs)
        return cls._instance


class Singleton(object):
    __metaclass__ = SingletonMeta
    pass
