#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import evas
import ecore
import ecore.evas
import terra.ui.layout

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors_sizes = (
    ((255, 0, 0, 255), (10, 10)),
    ((0, 255, 0, 255), (10, 30)),
    ((0, 0, 255, 255), (30, 10)),
    ((255, 255, 0, 255), (40, 5)),
    ((0, 255, 255, 255), (5, 40)),
    ((255, 0, 255, 255), (40, 40))
    )

children = []
for c, s in colors_sizes:
    o = canvas.Rectangle(size=s, color=c)
    o.show()
    children.append(o)

vbox = terra.ui.layout.VBox(canvas, children=children, halign=0.5, valign=0.5)
vbox.size = canvas.size
vbox.show()
ee.data["vbox"] = vbox

def on_resize(ee):
    ee.data["bg"].size = ee.evas.size
    ee.data["vbox"].size = ee.evas.size
ee.callback_resize = on_resize

ee.show()
ecore.main_loop_begin()
