#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Copyright (C) 2009 ProFUSION embedded systems
#
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Gustavo Sverzut Barbieri <gustavo.barbieri@profusion.mobi>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import sys
import zipimport
from os.path import basename, dirname, splitext


class ModuleLoader(object):
    def __init__(self, moddir, modname):
        self._moddir = moddir
        self._modname = modname

    def load(self):
        if self._moddir.endswith(".zip"):
            path = self._moddir
            prefix = splitext(basename(self._moddir))[0]
        else:
            path = dirname(self._moddir)
            prefix = basename(self._moddir)

        name = "%s.%s" % (prefix, self._modname)

        if path not in sys.path:
            sys.path.insert(0, path)

        r = __import__(name)
        for p in self._modname.split("."):
            r = getattr(r, p)
        return r
