# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

# This modul defines errors in the bughelper suite

class LPUrlError(Exception):
    def __init__(self, error=None,url="",text=None):
        assert error or text, "LPUrlError needs at least one argument (e=%s,t=%s)" %(error,text)
        if error:
            err = {}
            err["unknown error"] = "Unknown error while loading %s" %url
            err["login failed"] = "login failed %s" %url
            err["500"] = "An internal server error occurred. Please try again later. (url: %s)" %url
            err["404"] = "Page not found (url: %s)" %url
            err["403"] = "Not allowed here (url: %s)" %url
            #more errors to add...
            if str(error) in err.keys():
                self.value = err[str(error)]
            else:
                self.value = err["unknown error"]
        elif text:
            self.value = text
        
    def __str__(self):
        return repr(self.value)
