/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: viewcontactpainthelper.cxx,v $
 * $Revision: 1.8 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/contact/viewcontactpainthelper.hxx>
#include <svx/sdr/contact/viewobjectcontactredirector.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <svx/sdr/contact/viewcontact.hxx>
#include <svx/svdobj.hxx>
#include <svx/sdr/properties/properties.hxx>
#include <svx/xfillit0.hxx>
#include <svtools/itemset.hxx>
#include <svx/xlineit0.hxx>
#include <svx/xoutx.hxx>

//////////////////////////////////////////////////////////////////////////////
// ViewContact Paint helpers

namespace sdr
{
	namespace contact
	{
		// process the BackgroundObject painting
		sal_Bool PaintBackgroundObject(
			ViewContact& rPainter,
			SdrObject& rBackgroundObject,
			DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, 
			const ViewObjectContact& rAssociatedVOC)
		{
			sal_Bool bRetval(sal_False);

			// get the correct redirector
			ViewObjectContactRedirector* pRedirector = rAssociatedVOC.GetRedirector();

			if(pRedirector)
			{
				// for historical reasons if the pPaintProc is set we need
				// to call the old paint mechanism here to get created the output
				// into the metafile(s).
				rBackgroundObject.DoPaintObject(
					*rDisplayInfo.GetExtendedOutputDevice(), 
					*rDisplayInfo.GetPaintInfoRec());

				rPaintRectangle = rPainter.GetPaintRectangle();
				bRetval = sal_True;
			}
			else
			{
				// use pFillProperties to paint a object in the size of the page
				const SfxItemSet& rFillProperties = rBackgroundObject.GetProperties().GetObjectItemSet();

				Rectangle a2ndPaintRect;
				bRetval = PaintBackgroundObjectWithItemSet(
					rPainter, rDisplayInfo, rPaintRectangle, rFillProperties);
			}

			return bRetval;
		}

		// Paint a PageBackgroundObject with the size of the page and the attributes
		// of the given FillProperties
		sal_Bool PaintBackgroundObjectWithItemSet(
			ViewContact& rPainter,
			DisplayInfo& rDisplayInfo, Rectangle& rPaintRectangle,
			const SfxItemSet& rFillProperties)
		{
			sal_Bool bRetval(sal_False);
			XOutputDevice* pXOut = rDisplayInfo.GetExtendedOutputDevice();

			if(pXOut)
			{
				XFillStyle eFillStyle = ((XFillStyleItem&)(rFillProperties.Get(XATTR_FILLSTYLE))).GetValue();

				if(XFILL_NONE != eFillStyle)
				{
					Rectangle aPaintRectangle = rPainter.GetPaintRectangle();
					SfxItemSet aEmptySet(*rFillProperties.GetPool());
					aEmptySet.Put(XLineStyleItem(XLINE_NONE));

					pXOut->SetLineAttr(aEmptySet);
					pXOut->SetFillAttr(rFillProperties);
					pXOut->DrawRect(aPaintRectangle);

					rPaintRectangle = aPaintRectangle;
					bRetval = sal_True;
				}
			}

			return bRetval;
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
