/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: pntobj3d.cxx,v $
 * $Revision: 1.13 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include "globl3d.hxx"
#include <svx/pntobj3d.hxx>

TYPEINIT1(E3dPointObj, E3dObject);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj(const basegfx::B3DPoint& rPos) 
:	aPosition(rPos),
	bTransPosValid(sal_False)
{
	aLocalBoundVol = Volume3D(aPosition, basegfx::B3DPoint(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* Leer-Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj() 
:	aPosition(basegfx::B3DPoint()),
	bTransPosValid(sal_False)
{
	aLocalBoundVol = Volume3D(aPosition, basegfx::B3DPoint(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* bei Aenderung der Transformation
|*
\************************************************************************/

void E3dPointObj::SetTransformChanged()
{
	E3dObject::SetTransformChanged();
	bTransPosValid = sal_False;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dPointObj::GetObjIdentifier() const
{
	return E3D_POINTOBJ_ID;
}

/*************************************************************************
|*
|* neue Position setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dPointObj::SetPosition(const basegfx::B3DPoint& rNewPos)
{
	if ( aPosition != rNewPos )
	{
		aPosition = rNewPos;
		bBoundVolValid = FALSE;
		bTransPosValid = sal_False;
		StructureChanged(this);
	}
}

/*************************************************************************
|*
|* Transformierte Position zurueckgeben
|*
\************************************************************************/

const basegfx::B3DPoint& E3dPointObj::GetTransPosition()
{
	if ( !bTransPosValid )
	{
		aTransPos = GetFullTransform() * aPosition;
		bTransPosValid = sal_True;
	}
	return aTransPos;
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dPointObj::operator=(const SdrObject& rObj)
{
	E3dObject::operator=(rObj);

	const E3dPointObj& r3DObj = (const E3dPointObj&) rObj;
	aPosition = r3DObj.aPosition;
	// sicher ist sicher...
	bTransPosValid = sal_False;
}

// eof
